/*
 *      Copyright (C) 1997-2001 Andrei Los.
 *      This file is part of the lSwitcher source package.
 *      lSwitcher is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published
 *      by the Free Software Foundation, in version 2 as it comes in the
 *      "COPYING" file of the lSwitcher main distribution.
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 */

#ifndef LSWITCH_H_INCLUDED
#define LSWITCH_H_INCLUDED

#define INCL_DOSDEVICES
#define INCL_DOSMODULEMGR
#define INCL_DOSMISC
#define INCL_DOSNMPIPES
#define INCL_DOSPROCESS
#define INCL_DOSSEMAPHORES
#define INCL_DOSRESOURCES
#define INCL_DOSSESMGR
#define INCL_DOSERRORS
#define INCL_VIO
#define INCL_KBD
#define INCL_WIN
#define INCL_PM

#include <os2.h>
#include <stdlib.h>
#include "api16.h"

//#define XWORKPLACE

#ifdef XWORKPLACE
  #include "center.h"
  #define WIDGETMODNAME "LSWIDGET.DLL"

//the widget DLL module handle
extern HMODULE hmodWidgetDll;
#endif

#define VERSIONMAJOR 2
#define VERSIONMINOR 60
#define REVISION 9

#define LASTINIVERMAJOROK 2
#define LASTINIVERMINOROK 60
#define LASTINIREVISIONOK 8

#define LASTHOOKVERMAJOROK 2
#define LASTHOOKVERMINOROK 60
#define LASTHOOKREVISIONOK 9

typedef APIENTRY RESVERPROC(UCHAR *NameString,USHORT usLen);

/* defines localization of the program */
#define ENGLISH 1
#define CZECH 2
#define ITALIAN 3
#define GERMAN 4
#define SPANISH 5
#define RUSSIAN 6


#define PGMNAME "lSwitcher"
#define DLL_NAME "LSWHOOK"
#define HSTFILENAME "lswrun.hst"

#define LSWPOPUPCLASS "lswPopupClass"

#define MAXRUNLISTHST 20

#define ID_POPUPWIN 1
#define ID_ICON ID_POPUPWIN
#define ID_ALTACCELTABLE 2
#define ID_CTRLACCELTABLE 3
#define ID_NOALTACCELTABLE 4

#define ID_TITLESTR 4
#define ID_BUBBLE 5
#define ID_BUBBLEFRAME 6
#define ID_HINTSTR 7
#define ID_TASKBAR 8



/* these commands must have consecutive numbers and be in this order */
#define CMD_SWITCHFROMPM 51
#define CMD_HIDE 52
#define CMD_SHOW 53
#define CMD_RESTORE 54
#define CMD_MINIMIZE 55
#define CMD_MAXIMIZE 56
#define CMD_MOVE 57
#define CMD_CLOSE 58
#define CMD_CLOSEQUIT 59
#define CMD_KILL 60
#define CMD_DEATH 61
#define CMD_PRIORITY 62
/* end consecutive commands */

#define CMD_SCROLLLEFT 70
#define CMD_SCROLLRIGHT 71
#define CMD_SCROLLUP 72
#define CMD_SCROLLDOWN 73
#define CMD_CANCELPOPUP 74
#define CMD_SWITCHFROMFS 75
#define CMD_SCROLLRIGHTFROMFS 76
#define CMD_SCROLLLEFTFROMFS 77
#define CMD_RUN 78
#define CMD_SHOWSETTINGS 79
#define CMD_CANCELPOPUP1 80
#define CMD_QUIT 81
#define CMD_XCENTERSUBMENU 82
#define CMD_ADDFILTER 83


#define CMD_FIRST CMD_SWITCHFROMPM
#define CMD_LAST  CMD_ADDFILTER


#define  STRID_HINTS ID_HINTSTR
#define  STRID_SWITCH CMD_SWITCHFROMPM
#define  STRID_CLOSE CMD_CLOSE
#define  STRID_HIDE CMD_HIDE
#define  STRID_MINIMIZE CMD_MINIMIZE
#define  STRID_RESTORE CMD_RESTORE
#define  STRID_SHOW CMD_SHOW
#define  STRID_MAXIMIZE CMD_MAXIMIZE
#define  STRID_MOVE CMD_MOVE
#define  STRID_SHOWSETTINGS CMD_SHOWSETTINGS
#define  STRID_RUN CMD_RUN
#define  STRID_KILL CMD_KILL
#define  STRID_DEATH CMD_DEATH
#define  STRID_PRIORITY CMD_PRIORITY
#define  STRID_QUIT CMD_QUIT
#define  STRID_XCENTERSUBMENU CMD_XCENTERSUBMENU
#define  STRID_CLOSEQUIT CMD_CLOSEQUIT
#define  STRID_ADDFILTER CMD_ADDFILTER

#define SEMLSWDATANAME "\\SEM32\\LSWITCH\\LSWITCH.S01"
#define SEMRUNNINGNAME "\\SEM32\\LSWITCH\\LSWITCH.S03"
#define SEMFSPOPUPNAME "\\SEM32\\LSWITCH\\LSWITCH.S04"
#define SEMSHIFTNAME "\\SEM32\\LSWITCH\\LSWITCH.S06"
#define SEMCTRLTABNAME "\\SEM32\\LSWITCH\\LSWITCH.S08"

#define SHAREMEM_NAME "\\SHAREMEM\\LSWITCH\\LSWITCH.M01"


/* pre-accelerator input hook, undocumented, */
#define HK_PREACCEL 17

/* this message is sent to WindowList when a switch entry is added,
   removed or modified; undocumented
   the first param of this msg: 0x1 or 0x10001 -- create switch entry
                                0x2 -- modify, 0x3 -- delete
   the second param is the corresponding switch handle*/
#define SH_SWITCHLIST 0x0080

/*undocumented WinDrawBorder extensions */
#define DB_RAISED 0x0400
#define DB_DEPRESSED 0x0800

#define DP_MINIICON 0x0004


#define TEXTSCRWID (UCHAR)80
#define TEXTSCRHGT (UCHAR)25
#define MENUATTR 0x7F
#define CURSORATTR 0x0F
#define MAXICONSINLINE (USHORT)9
#define ICONLINES (USHORT)3
#define MAXTEXTITEMS (USHORT)23

#define ICONSPACINGX 1/2
#define ICONSPACINGY 1/3

#define SELBOXOFFSET 1/8
#define SELBOXLINEWIDTH 2

#define DEFBACKCOLOR (ULONG)CLR_PALEGRAY
#define DEFRAISEDFRAMECOLOR (ULONG)CLR_WHITE
#define DEFSUNKENFRAMECOLOR (ULONG)CLR_DARKGRAY
#define DEFTITLECOLOR (ULONG)CLR_DARKBLUE
#define DEFHINTSCOLOR (ULONG)CLR_BLACK
#define DEFTITLEFONT3 "8.Helv"
#define DEFTITLEFONT4 "9.WarpSans"
#define DEFHINTSFONT "2.System VIO"


#define MAXITEMS 128

#define NAMELEN (MAXNAMEL+4+6)

#define POPUPWINHIDEPOSX 8192
#define POPUPWINHIDEPOSY 8192

#define LSWM_SWITCHLISTCHANGED WM_USER+1
#define LSWM_WNDSTATECHANGED WM_USER+2
#define LSWM_ACTIVEWNDCHANGED WM_USER+3
#define LSWM_WNDICONCHANGED WM_USER+4
#define LSWM_DOSEXITKILL WM_USER+5
#define LSWM_SETPRIORITY 0x6F1E
#define PRTY_MAGIC 0xF1E2

/* keyboard scan codes for particular commands */

/* these are the same for all languages */
#define SCAN_TAB 0x0f
#define SCAN_SPACE 0x39
#define SCAN_ALT 0x38
#define SCAN_CTRL 0x1d
#define SCAN_ENTER 0x1c
#define SCAN_RIGHTCTRL 0x5b
#define SCAN_RIGHTALT 0x5e
#define SCAN_ESC 0x1
#define SCAN_SETTINGS 0x1f /* letter s */
#define SCAN_UP 0x48
#define SCAN_DOWN 0x50


typedef struct _SWITEM {
  HWND hwnd;
  HSWITCH hsw;
  ULONG fl,ulType;
  HPOINTER hIcon;
  PID pid;
} SWITEM;

typedef UCHAR ENTRYNAME[MAXNAMEL];

typedef UCHAR *SKIPLIST[MAXITEMS];

typedef struct _LSWSETTINGS {
  UCHAR
    ucVerMajor,
    ucVerMinor,
    ucRevision;
  BOOL
    bShowHidden,
    bUseCtrl,
    bShowViewer,
    bPMSwitcher,
    bOldPopup,
    bDesktopMinimizes,
    bScrollItems,
    bPMPopupInFS,
    bShowInWinList,
    bShowHints,
    bChangeZOrder,
    bTaskBarOn,
    bTaskBarTopScr,
    bTaskBarAlwaysVisible,
    bTaskBarAlwaysTop,
    bStickyPopup,
    bShowHiddenTskBar,
    bShowViewerTskBar,
    bIconsOnlyInTskBar,
    bReduceDsk;
  LONG
    lBackColor,
    lRaisedFrameColor,
    lSunkenFrameColor,
    lTitleColor,
    lHintsColor,
    lTskBarRGBCol,
    lNormalBtnRGBCol,
    lActiveBtnRGBCol,
    lNormalHiddenBtnRGBCol,
    lActiveHiddenBtnRGBCol,
    lNormalBtnTitleRGBCol,
    lActiveBtnTitleRGBCol,
    lNormalHiddenBtnTitleRGBCol,
    lActiveHiddenBtnTitleRGBCol;
  UCHAR
    ucTitleFont[FACESIZE],
    ucHintsFont[FACESIZE],
    ucButtonFont[FACESIZE],
    ucSettingsKey,ucSettingsScan,
    ucLanguage;
  SHORT
    sTskBarX,
    sTskBarY,
    sTskBarCX,
    sTskBarCY;
  USHORT
    usMaxBtnWid,
    usSwitchMEvent,
    usMinMEvent,
    usCloseMEvent;

//  ENTRYNAME
//    SkipList[MAXITEMS];

  SKIPLIST
    SkipListPopup,
    SkipListTskBar;
} LSWSETTINGS;


typedef struct _LSWDATA {
  LSWSETTINGS Settings;

  BOOL
    bNowActive,
    bWidget,
    bSettingsDlgOn;

  HAB hab;
  HMQ hmq;
  HMODULE hmodHook,hmodRes;
  HWND
    hwndPopup,
    hwndPopClient,
    hwndTaskBar,
    hwndTaskBarClient,
    hwndBubble,
    hwndMenu,
    hwndParamDlg;
  HSWITCH
    hswitch;
  HACCEL
    haccAlt,
    haccCtrl,
    haccNoAlt;
  HEV
    hevRunning,
    hevCtrlTab,
    hevShift,
    hevPopup;
  HMTX
    htmxLswData;
  SHORT
    itidFSDispat,
    itidFSMon,
    iMenuAtItem;

  SWITEM TaskArr[MAXITEMS];
  USHORT
    usItems,
    usCurrItem;
  SHORT iShift;
// the following must be the last field
#ifdef XWORKPLACE
  PXCENTERWIDGET pWidget;
#else
  PVOID pDummy;
#endif
} LSWDATA;

typedef LSWDATA *PLSWDATA;


static MRESULT EXPENTRY PopupWndProc(HWND hwnd,ULONG msg,MPARAM mp1,MPARAM mp2);
static MRESULT EXPENTRY FrameWndProc(HWND hwnd,ULONG msg,MPARAM mp1,MPARAM mp2);


LONG EXPENTRY lswHookInit(LSWDATA *plswData);
VOID EXPENTRY lswHookTerm(LSWDATA *plswData);
ULONG EXPENTRY lswHookGetVersion(void);
LONG SwitcherInit(HAB hab, HMQ hmq, UCHAR *ucErrMsg, USHORT usMsgLen, PVOID *ppData, USHORT usFunc);
VOID SwitcherTerm(LSWDATA *plswData,USHORT usFunc);
VOID APIENTRY lswExitProc(VOID);


#endif
