/*
 *      Copyright (C) 1997-2001 Andrei Los.
 *      This file is part of the lSwitcher source package.
 *      lSwitcher is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published
 *      by the Free Software Foundation, in version 2 as it comes in the
 *      "COPYING" file of the lSwitcher main distribution.
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 */


#define INCL_DOSMEMMGR
#define INCL_DOSMODULEMGR
#define INCL_WIN

#include "lswitch.h"
#include "taskbar.h"

/*
   Since the hooks may be called in the context of any thead having a message
   queue, we must use shared memory to access the globals of lSwitcher daemon.
   For the same reason the shared mem must be freed upon exiting the hook procs,
   otherwise the caller will retain a reference to it and the shared mem object
   will not be destroyed when lSwitcher exits
   IMPORTANT !!! Don't use DosGetNamedSharedMed/DosFreeMem before it's REALLY
   needed, check all other conditions first. These functions turn out to be
   expensive performance wise

   With version 2.6 this DLL, if compiled with Watcom C, does not use C RTL 
   (since Watcom RTL does not support multiple processes attached to a DLL
   with a single data segment, which we need). Because of this stack overflow
   is not checked for, and we want to reduce stack usage to a minimum
*/

BOOL IsWindowClass(HWND hwnd,UCHAR *pszClassName)
{ static UCHAR ucBuf[32]; //reduce stack usage to minimum since we don't use stack probes
  USHORT k;
  BOOL bEqual;

  WinQueryClassName(hwnd,sizeof(ucBuf)-1,ucBuf);
/* equivalent of strcmp, but we don't want to use the RTL */
  for (k=0, bEqual=TRUE; ucBuf[k]!='\0' && pszClassName[k]!='\0'; k++)
    if (ucBuf[k]!=pszClassName[k]) {
       bEqual = FALSE;
       break;
    }

  return (bEqual && ucBuf[k]=='\0' && pszClassName[k]=='\0');
}


BOOL GetSharedMem(LSWDATA **plswData)
{
  return
   (DosGetNamedSharedMem((PVOID*)plswData,SHAREMEM_NAME,PAG_READ | PAG_WRITE)==0 &&
    plswData!=NULL);
}

BOOL SetPrty(ULONG pid,USHORT usPrty,USHORT usMagic)
{ SHORT sPrtyC, sPrtyD;
  BOOL bDesc;

  if (usMagic==PRTY_MAGIC) {
    bDesc = (usPrty & 0x8000); usPrty &= ~0x8000;
    sPrtyC = (usPrty+PRTYD_MAXIMUM)>>8;
    sPrtyD = usPrty-(sPrtyC<<8);
    DosSetPriority(bDesc?PRTYS_PROCESSTREE:PRTYS_PROCESS,sPrtyC,sPrtyD,pid);
    return TRUE;
  } else
    return FALSE;
}

BOOL EXPENTRY lswInputHookWidg(HAB hab, PQMSG pQmsg, ULONG fs)
{ LSWDATA *plswData;
  static HWND hwndTskBar=0,hwndBtn=0;

  if (pQmsg->msg==WM_NULL && pQmsg->hwnd==0 && GetSharedMem(&plswData)) {
    hwndTskBar = plswData->hwndTaskBarClient;
    DosFreeMem(plswData);
  }

  if (pQmsg->msg==WM_MOUSEMOVE && pQmsg->hwnd!=hwndBtn) {
    if (hwndBtn!=0) {
      WinPostMsg(hwndTskBar,LSWM_MOUSEOVERBTN,MPFROMHWND(hwndBtn),MPFROMSHORT(FALSE));
      hwndBtn = 0;
    }
    if (WinQueryWindow(pQmsg->hwnd,QW_PARENT)==hwndTskBar && IsWindowClass(pQmsg->hwnd,"#3")) {
      hwndBtn = pQmsg->hwnd;
      WinPostMsg(hwndTskBar,LSWM_MOUSEOVERBTN,MPFROMHWND(hwndBtn),MPFROMSHORT(TRUE));
    }
  } else if (pQmsg->msg==LSWM_SETPRIORITY)
    return SetPrty(LONGFROMMP(pQmsg->mp2),SHORT1FROMMP(pQmsg->mp1),SHORT2FROMMP(pQmsg->mp1));

  return FALSE;
}

BOOL EXPENTRY lswInputHook(HAB hab, PQMSG pQmsg, ULONG fs)
{ LSWDATA *plswData;
  POINTL ptl;
  static BOOL bOnTop=FALSE;
  static USHORT usOldY=0xFFFF,cyScreen=0,cyTskBar=0; // this and the previous lines need to be static
  static RECTL rcl; //reduce stack usage to minimum since we don't use stack probes

  if (cyScreen==0 || pQmsg->msg==WM_SYSVALUECHANGED)
    cyScreen=WinQuerySysValue(HWND_DESKTOP,SV_CYSCREEN);

  if (pQmsg->msg==WM_MOUSEMOVE && (WinQueryPointerPos(HWND_DESKTOP,&ptl),ptl.y!=usOldY)) {
    usOldY=ptl.y;
    if ((!bOnTop && (ptl.y==0 || ptl.y==cyScreen-1)) ||
        (bOnTop && ptl.y>2*cyTskBar && ptl.y<cyScreen-2*cyTskBar)) {

      if (!GetSharedMem(&plswData)) return FALSE;

      if ((!bOnTop && plswData->Settings.bTaskBarTopScr ^ ptl.y==0) ||
          (bOnTop && !WinIsWindowVisible(plswData->hwndMenu))) {
        if (!bOnTop) {
          WinQueryWindowRect(plswData->hwndTaskBar,&rcl);
          cyTskBar = rcl.yTop;
        }
        WinSetWindowPos(plswData->hwndTaskBar,bOnTop?HWND_BOTTOM:HWND_TOP,0,0,0,0,
                        SWP_ZORDER|(plswData->Settings.bTaskBarAlwaysVisible?0:
                                    (bOnTop?SWP_HIDE:SWP_SHOW)));
        bOnTop^=TRUE;
      }
      DosFreeMem(plswData);
    }
  } else if (pQmsg->msg==LSWM_SETPRIORITY)
    return SetPrty(LONGFROMMP(pQmsg->mp2),SHORT1FROMMP(pQmsg->mp1),SHORT2FROMMP(pQmsg->mp1));

  return FALSE;
}


/* we install this function as a pre-accelerator hook (undocumented). This hook
 is called even before an application accelerator table is translated, which helps
 to avoid compatibility problems with Ctrl-Tab hotkey */
BOOL EXPENTRY lswPreAccHook(HAB hab, PQMSG pQmsg, ULONG fs)
{ USHORT usFlags;
  UCHAR ucScan;
  LSWDATA *plswData;
  BOOL bRet;

  if (pQmsg->msg!=WM_CHAR ||
      (usFlags=SHORT1FROMMP(pQmsg->mp1), ucScan=CHAR4FROMMP(pQmsg->mp1),
       (usFlags & KC_SCANCODE))==0)
    return FALSE;

  bRet = FALSE;
/* tab w/ left Ctrl down. Trap the key either it's pressed or released,
 so that it does not reach other applications and trigger something*/
/* Alt-Tab might work in alternative shells */
  if (ucScan==SCAN_TAB &&
      ((usFlags & (KC_CTRL|KC_ALT))==KC_ALT || (usFlags & (KC_CTRL|KC_ALT))==KC_CTRL) &&
      GetSharedMem(&plswData)) {
    if ((plswData->Settings.bUseCtrl && (usFlags & KC_CTRL)) ||
        (!plswData->Settings.bUseCtrl && (usFlags & KC_ALT))) {
      if (usFlags & KC_KEYUP)
        WinPostMsg(plswData->hwndPopClient,WM_COMMAND,MPFROMSHORT
                   ((usFlags & KC_SHIFT) ? CMD_SCROLLLEFT : CMD_SCROLLRIGHT),
                   MPFROM2SHORT(CMDSRC_OTHER,FALSE));
      bRet = TRUE;
    }
    DosFreeMem(plswData);
  }

/* Show settings */
  if (!(usFlags & KC_KEYUP) && (usFlags & KC_ALT) && (usFlags & KC_CTRL) && GetSharedMem(&plswData)) {
    if (ucScan == plswData->Settings.ucSettingsScan) {
      WinPostMsg(plswData->hwndPopClient,WM_COMMAND,MPFROMSHORT(CMD_SHOWSETTINGS),MPFROM2SHORT(CMDSRC_OTHER,FALSE));
      bRet = TRUE;
    }
    DosFreeMem(plswData);
  }

  return bRet;
}


VOID EXPENTRY lswSendHook(HAB hab, PSMHSTRUCT psmh, BOOL fInterTask)
{ LSWDATA *plswData;
  HSWITCH hsw;
  static SWCNTRL swctl; //reduce stack usage to minimum since we don't use stack probes
  static SWP swp;
  ULONG ulFlags;

  if (psmh->msg==WM_MINMAXFRAME &&
      (ulFlags=((PSWP)PVOIDFROMMP(psmh->mp1))->fl, ulFlags & SWP_MAXIMIZE) &&
      WinQueryWindow(psmh->hwnd,QW_PARENT)==WinQueryDesktopWindow(0,0) &&
      GetSharedMem(&plswData)) {

    if (!plswData->bWidget && plswData->Settings.bTaskBarOn && plswData->Settings.bReduceDsk &&
        plswData->Settings.bTaskBarAlwaysVisible) {
      SHORT sHgt,sY,sCY,sCYScr;

      sCYScr=WinQuerySysValue(HWND_DESKTOP,SV_CYSCREEN);

      WinQueryWindowPos(plswData->hwndTaskBar, &swp);
      sHgt=(plswData->Settings.bTaskBarTopScr?sCYScr-swp.y:swp.y+swp.cy)-1;

      sY=((PSWP)PVOIDFROMMP(psmh->mp1))->y; sCY=((PSWP)PVOIDFROMMP(psmh->mp1))->cy;

      if ((plswData->Settings.bTaskBarTopScr && sY+sCY > sCYScr-sHgt) ||
          (!plswData->Settings.bTaskBarTopScr && sY < sHgt)) {
        ((PSWP)PVOIDFROMMP(psmh->mp1))->cy-=plswData->Settings.bTaskBarTopScr?sY+sCY-(sCYScr-sHgt):sHgt-sY;
        ((PSWP)PVOIDFROMMP(psmh->mp1))->y=plswData->Settings.bTaskBarTopScr?sY:sHgt;
      }
    }
    DosFreeMem(plswData);
    return;
  }

  if (psmh->msg==WM_ACTIVATE && GetSharedMem(&plswData)) {
    if (plswData->Settings.bTaskBarOn)
      WinPostMsg(plswData->hwndTaskBarClient,LSWM_ACTIVEWNDCHANGED,psmh->mp1,MPFROMHWND(psmh->hwnd));
    DosFreeMem(plswData);
    return;
  }

  if (psmh->msg==WM_WINDOWPOSCHANGED &&
      (ulFlags=((PSWP)PVOIDFROMMP(psmh->mp1))->fl,
       ulFlags & (SWP_HIDE|SWP_SHOW|SWP_MINIMIZE|SWP_MAXIMIZE|SWP_RESTORE)) &&
      (hsw=WinQuerySwitchHandle(psmh->hwnd,0))!=0 &&
      (WinQuerySwitchEntry(hsw,&swctl),swctl.hwnd==psmh->hwnd) &&
      GetSharedMem(&plswData)) {

      if (plswData->Settings.bTaskBarOn)
        WinPostMsg(plswData->hwndTaskBarClient, LSWM_WNDSTATECHANGED,
                   MPFROM2SHORT(hsw&0xFFFF,(SHORT)(ulFlags&0xFFFF)), MPFROMHWND(psmh->hwnd));

      if (plswData->bNowActive)
        WinPostMsg(plswData->hwndPopClient, LSWM_WNDSTATECHANGED,
                   MPFROM2SHORT(hsw&0xFFFF,(SHORT)(ulFlags&0xFFFF)), MPFROMHWND(psmh->hwnd));

    DosFreeMem(plswData);
    return;
  }

  if ((psmh->msg==WM_SETICON || (psmh->msg==SH_SWITCHLIST &&
        (((LONG)psmh->mp1>=1&&(LONG)psmh->mp1<=3)||(LONG)psmh->mp1==0x10001))) &&
      GetSharedMem(&plswData)) {

    if (plswData->bNowActive)
      WinPostMsg(plswData->hwndPopClient,
        psmh->msg==WM_SETICON?LSWM_WNDICONCHANGED:LSWM_SWITCHLISTCHANGED,
        psmh->mp1, psmh->msg==WM_SETICON?MPFROMHWND(psmh->hwnd):psmh->mp2);

    if (plswData->Settings.bTaskBarOn)
      WinPostMsg(plswData->hwndTaskBarClient,
        psmh->msg==WM_SETICON?LSWM_WNDICONCHANGED:LSWM_SWITCHLISTCHANGED,
        psmh->mp1, psmh->msg==WM_SETICON?MPFROMHWND(psmh->hwnd):psmh->mp2);

    DosFreeMem(plswData);
    return;
  }

  /* make the just minimized or hidden window appear after the current one in
   the switch list */
  if (psmh->msg==WM_ADJUSTWINDOWPOS &&
      (((PSWP)PVOIDFROMMP(psmh->mp1))->fl & (SWP_HIDE|SWP_MINIMIZE)) &&
      !(WinGetPhysKeyState(HWND_DESKTOP,0x38) & 0x8000) &&
      (hsw=WinQuerySwitchHandle(psmh->hwnd,0))!=0 &&
      IsWindowClass(psmh->hwnd,"#1") && GetSharedMem(&plswData)) {

    if (plswData->Settings.bChangeZOrder)
      ((PSWP)PVOIDFROMMP(psmh->mp1))->hwndInsertBehind = HWND_TOP;

    DosFreeMem(plswData);
    return;
  }

  if (psmh->msg==WM_COMMAND && IsWindowClass(psmh->hwnd,"AltTabWindow") &&
      (WinGetPhysKeyState(HWND_DESKTOP,0x5e) & 0x8000)==0 && // right Alt up
      GetSharedMem(&plswData)) {

    BOOL bShift;

    if (!plswData->Settings.bUseCtrl && plswData->Settings.bPMSwitcher) {
      bShift = (WinGetPhysKeyState(HWND_DESKTOP,0x2a) & 0x8000) || // either Shift down
               (WinGetPhysKeyState(HWND_DESKTOP,0x36) & 0x8000);
      WinPostMsg(plswData->hwndPopClient,WM_COMMAND,MPFROMSHORT
                 (bShift ? CMD_SCROLLLEFT : CMD_SCROLLRIGHT),
                 MPFROM2SHORT(CMDSRC_OTHER,FALSE));
      psmh->msg = WM_NULL;
    }
    DosFreeMem(plswData);
  }
}

LONG EXPENTRY lswHookInit(LSWDATA *plswData)
{
  if (DosQueryModuleHandle(DLL_NAME,&plswData->hmodHook)) return -1;

  if (!WinSetHook(plswData->hab,NULLHANDLE,HK_SENDMSG,(PFN)lswSendHook,plswData->hmodHook)) return -2;
  if (!WinSetHook(plswData->hab,NULLHANDLE,HK_PREACCEL,(PFN)lswPreAccHook,plswData->hmodHook)) return -3;
  if (!WinSetHook(plswData->hab,NULLHANDLE,HK_INPUT,plswData->bWidget?(PFN)lswInputHookWidg:(PFN)lswInputHook,plswData->hmodHook)) return -4;

  if (plswData->bWidget) WinPostMsg(0,WM_NULL,0,0); //reset the hook

  return MAKEULONG(MAKEUSHORT(VERSIONMAJOR,VERSIONMINOR),MAKEUSHORT(REVISION,0));
}

//-------------------------------------------------------------------------
// This function releases hooks and broadcasts a WM_NULL message to all top
// level windows so that they will release the DLL.  If we don't do this,
// the DLL will remain locked and we'll have to reboot in order to recompile.
VOID EXPENTRY lswHookTerm(LSWDATA *plswData)
{
  WinReleaseHook(plswData->hab,NULLHANDLE,HK_INPUT,plswData->bWidget?(PFN)lswInputHookWidg:(PFN)lswInputHook,plswData->hmodHook);
  WinReleaseHook(plswData->hab,NULLHANDLE,HK_PREACCEL,(PFN)lswPreAccHook,plswData->hmodHook);
  WinReleaseHook(plswData->hab,NULLHANDLE,HK_SENDMSG,(PFN)lswSendHook,plswData->hmodHook);

  WinBroadcastMsg(HWND_DESKTOP,WM_NULL,0,0,BMSG_POST | BMSG_DESCENDANTS);
}


