/*
 *      Copyright (C) 1997-2001 Andrei Los.
 *      This file is part of the lSwitcher source package.
 *      lSwitcher is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published
 *      by the Free Software Foundation, in version 2 as it comes in the
 *      "COPYING" file of the lSwitcher main distribution.
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 */

#ifndef LSWRES_H_INCLUDED
#define LSWRES_H_INCLUDED

 
#if LANGUAGE==ENGLISH
  #define LANGUAGESTR "English"
#elif LANGUAGE==RUSSIAN
  #define LANGUAGESTR "᪨"
#endif

#if LANGUAGE==RUSSIAN
  #define SCAN_PRIORITY 0x23  /*㪢  */
#else
  #define SCAN_PRIORITY 0x19  /*letter p */
#endif

#if LANGUAGE==RUSSIAN
  #define SCAN_FILTER 0x1e  /*㪢  */
#else
  #define SCAN_FILTER 0x21  /*letter f */
#endif


#if LANGUAGE==CZECH
  #define SCAN_CLOSE 0x2c   /*letter z */
#elif LANGUAGE==RUSSIAN
  #define SCAN_CLOSE 0x19  /*㪢  */
#else
  #define SCAN_CLOSE 0x2e  /*letter c */
#endif


#if LANGUAGE==CZECH
  #define SCAN_HIDE 0x25 /*letter k */
#elif LANGUAGE==SPANISH
  #define SCAN_HIDE 0x18 /*letter o */
#elif LANGUAGE==ITALIAN
  #define SCAN_HIDE 0x31 /* letter n */
#elif LANGUAGE==RUSSIAN
  #define SCAN_HIDE 0x31 /* 㪢  */
#elif LANGUAGE==GERMAN
  #define SCAN_HIDE 0x20 /* letter d */
#else
  #define SCAN_HIDE 0x23 /* letter h */
#endif

#if LANGUAGE==CZECH
  #define SCAN_MINIMIZE 0x32 /* letter m */
#elif LANGUAGE==ITALIAN
  #define SCAN_MINIMIZE 0x13 /* letter r */
#elif LANGUAGE==RUSSIAN
  #define SCAN_MINIMIZE 0x15 /* 㪢  */
#elif LANGUAGE==GERMAN
  #define SCAN_MINIMIZE 0x2c /* letter y on German kbd */
#else
  #define SCAN_MINIMIZE 0x31 /* letter n */
#endif

#if LANGUAGE==CZECH
  #define SCAN_RESTORE 0x18 /* letter o */
#elif LANGUAGE==ITALIAN
  #define SCAN_RESTORE 0x19 /* letter p */
#elif LANGUAGE==RUSSIAN
  #define SCAN_RESTORE 0x20 /* 㪢  */
#elif LANGUAGE==GERMAN
  #define SCAN_RESTORE 0x11 /* letter w */
#else
  #define SCAN_RESTORE 0x13 /* letter r */
#endif

#if LANGUAGE==CZECH
  #define SCAN_SHOW 0x30 /* letter b */
#elif LANGUAGE==SPANISH
  #define SCAN_SHOW 0x32 /* letter m */
#elif LANGUAGE==ITALIAN
  #define SCAN_SHOW 0x32 /* letter m */
#elif LANGUAGE==RUSSIAN
  #define SCAN_SHOW 0x24 /* 㪢  */
#elif LANGUAGE==GERMAN
  #define SCAN_SHOW 0x1e /* letter a */
#else
  #define SCAN_SHOW 0x1f /* letter s */
#endif

#if LANGUAGE==ITALIAN
  #define SCAN_MAXIMIZE 0x17 /* letter i */
#elif LANGUAGE==RUSSIAN
  #define SCAN_MAXIMIZE 0x13 /* 㪢  */
#elif LANGUAGE==GERMAN
  #define SCAN_MAXIMIZE 0x32 /* letter m */
#else
  #define SCAN_MAXIMIZE 0x2d /* letter x */
#endif

#endif
