/***********************************************************************/
/* Installation program for BubblePad                                  */
/* (C) Chris Wohlgemuth                                                */
/*                                                                     */
/* E-Mail: chris.wohlgemuth@cityweb.de                                 */
/*     or  christopher.wohlgemuth@bch.siemens.de                       */
/*                                                                     */
/* Released under the GNU Public Licence                               */
/* See file COPYING for further information                            */
/*                                                                     */
/* 20.06.98 V1.00:  First public version                               */
/* 16.08.98 V1.00a: Corrected bug which prevented accepting of default */
/*                  installation directory on some systems             */
/*                                                                     */
/***********************************************************************/
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#define INCL_WINWORKPLACE
#define INCL_WINSHELLDATA
#define INCL_DOSMISC       /* DOS Miscellaneous values */
#define INCL_DOSERRORS     /* DOS Error values         */
#define INCL_DOSMODULEMGR
#define INCL_DOSFILEMGR
#define INCL_DOS

#include <os2.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <sys/video.h>

#define MAXLANGUAGES 5    //Num of possible languages
#define USEDLANGUAGES 2   //Num of used Languages. Translate strings and increase

#define NUMERRORS 18 // Num of error msgs
#define MAXERRORS MAXLANGUAGES*NUMERRORS

#define NUMACTIONS 3 //Install, deinstall, exit

#define NUMMSG 24
#define MAXMSG MAXLANGUAGES*NUMMSG


APIRET APIENTRY DosReplaceModule(PSZ old, PSZ newdll, PSZ backup);

void main(int argc, char *argv[])
{
	APIRET rc;
	ULONG   aulSysInfo[QSV_MAX] = {0};       /* System Information Data Buffer */
	char buffer[CCHMAXPATH];
	char buffer2[CCHMAXPATH];
	char drive;
	char bootDrive;
	HMODULE hmodule;
	PSZ dllName=(UCHAR*)"BUBBLEPD";
	PSZ helpName=(UCHAR*)"BUBBLEPD.HLP";
	PSZ dllSource;	
	PSZ helpSource;
	
	char error[CCHMAXPATH];
	int attrib;
	int x,wahl;
	int lang;
	
	int offset;
	int width;
	int height;
	int loop;
	int start;//cursor
	int end;//cursor
	FILESTATUS3 filestatus3={{0}};
	ULONG ulBufferSize=sizeof(FILESTATUS3);
	ULONG ulDriveMap;
	PSZ 	envString;
	
	const selectColor=B_BLUE|F_WHITE;
	const normalColor=B_BLACK|F_WHITE;
	
	int select[MAXLANGUAGES*2]={selectColor,normalColor,normalColor,normalColor};
	
	char fileName[MAXLANGUAGES*2][50]={
		"Deutsch\\BUBBLEPD",
		"English\\BUBBLEPD",
		"Language_3\\BUBBLEPD",
		"Language_4\\BUBBLEPD",
		"Language_5\\BUBBLEPD",

		"Deutsch\\BUBBLEPD.hlp",
		"English\\BUBBLEPD.hlp",
		"Language_3\\BUBBLEPD.hlp",
		"Language_4\\BUBBLEPD.hlp",
		"Language_5\\BUBBLEPD.hlp"
	};
	
	
	char errstr[MAXERRORS][100]= {
		//Deutsch
		"Fehler!! DosQuerySysInfo: return code =",
		"Kann Verzeichnis nicht finden. Lege Verzeichnis an...",
		"Fehler: Can't create directory. Perhaps wrong name specified.     Exiting...",
		"Fehler! DosQueryCurrentDisk rc =",
		"Kann aktuelles Laufwerk nicht finden.  Ende...\n",
		"Kann aktuelles Verzeichnis nicht finden.  Ende...\n",
		"Fehler! DosCopy error #",
		"Kann DLL nicht kopieren.  Ende...\n",
		"WPLaunchPad-Klasse konnte nicht ersetzt werden!\n",
		"Fehler whrend WinDeregisterObjectClass(). Nicht Deregistriert.    Ende...\n",
		"Kann Klasse WPLnchCW nicht registrieren!\n",
		"Kann Hilfe Verzeichnis nicht finden! 'Bubblepd.hlp' von Hand kopieren.\n\n",
		"Kann Hilfedatei nicht kopieren!\n'Bubblepd.hlp' von Hand kopieren.\n\n",
		"Fehler - Kann vorherige WPLaunchPad-Klasse nicht aktivieren!\n\n",
		"Kann Hilfe Verzeichnis nicht finden! Datei 'BUBBLEPD.HLP' von Hand lschen.\n\n", 
		"Kann Hilfedatei nicht lschen!\n'Bubblepd.hlp' von Hand lschen.\n\n",
		"Kann Klassen-DLL %s nicht lschen!\n\n",
		"Kann Eintrge in user-ini nicht lschen!\n\n",

		//English
		"DosQuerySysInfo error: return code =",
		"Can't find directory. Creating Directory...",
		"Error: Can't create directory. Perhaps wrong name specified.      Exiting...",
		"DosQueryCurrentDisk error:",
		"Can't get current drive.  Exiting...\n",
		"Can't get current directory.  Exiting...\n",
		"DosCopy error #",
		"Can't copy classfile.     Exiting...\n",
		"Can't replace WPLaunchPad!\n",
		"WinDeregisterObjectClass() error.  Can't deregister Objectclass.  Exiting...\n",
		"Can't register class WPLnchCW!\n",
		"Can't find help-directory! Please copy file 'BUBBLEPD.HLP' by hand.\n\n",
		"Can't copy helpfile!\nPlease copy file 'BUBBLEPD.HLP' by hand.\n\n", 
		"Error - Can't activate previous class!\n\n",
		"Error - Can't find help-directory! Please delete file 'BUBBLEPD.HLP' by hand.\n\n", 
		"Can't delete helpfile!\nPlease delete file 'BUBBLEPD.HLP' by hand.\n\n",
		"Can't delete classfile %s.\n",
		"Can't delete user-ini entries!\n\n",
		
		//Language 3
		"DosQuerySysInfo error: return code =",
		"Can't find directory. Creating Directory...",
		"Error: Can't create directory. Perhaps wrong name specified.      Exiting...",
		"DosQueryCurrentDisk error:",
		"Can't get current drive.  Exiting...\n",
		"Can't get current directory.  Exiting...\n",
		"DosCopy error #",
		"Can't copy classfile.     Exiting...\n",
		"Can't replace WPLaunchPad!\n",
		"WinDeregisterObjectClass() error.  Can't deregister Objectclass.           Exiting...\n",
		"Can't register class WPLnchCW!\n",
		"Can't find help-directory! Please copy file 'BUBBLEPD.HLP' by hand.\n\n",
		"Can't copy helpfile!\nPlease copy file 'BUBBLEPD.HLP' by hand.\n\n", 
		"Error - Can't activate previous class!\n\n",
		"Error - Can't find help-directory! Please delete file 'BUBBLEPD.HLP' by hand.\n\n", 
		"Can't delete helpfile!\nPlease delete file 'BUBBLEPD.HLP' by hand.\n\n",
		"Can't delete classfile %s.\n",
		"Can't delete user-ini entries!\n\n",

		//Language 4
		"DosQuerySysInfo error: return code =",
		"Can't find directory. Creating Directory...",
		"Error: Can't create directory. Perhaps wrong name specified.      Exiting...",
		"DosQueryCurrentDisk error:",
		"Can't get current drive.  Exiting...\n",
		"Can't get current directory.  Exiting...\n",
		"DosCopy error #",
		" Can't copy classfile.    Exiting...\n",
		"Can't replace WPLaunchPad!\n",
		"WinDeregisterObjectClass() error.  Can't deregister Objectclass.  Exiting...\n",
		"Can't register class WPLnchCW!\n",
		"Can't find help-directory! Please copy file 'BUBBLEPD.HLP' by hand.\n\n",
		"Can't copy helpfile!\nPlease copy file 'BUBBLEPD.HLP' by hand.\n\n", 
		"Error - Can't activate previous class!\n\n",
		"Error - Can't find help-directory! Please delete file 'BUBBLEPD.HLP' by hand.\n\n", 
		"Can't delete helpfile!\nPlease delete file 'BUBBLEPD.HLP' by hand.\n\n",
		"Can't delete classfile %s.\n",
		"Can't delete user-ini entries!\n\n",

		//Language 5
		"DosQuerySysInfo error: return code =",
		"Can't find directory. Creating Directory...",
		"Error: Can't create directory. Perhaps wrong name specified.      Exiting...",
		"DosQueryCurrentDisk error:",
		"Can't get current drive.  Exiting...\n",
		"Can't get current directory.  Exiting...\n",
		"DosCopy error #",
		"Can't copy classfile.           Exiting...\n"
		"Can't replace WPLaunchPad!\n",
		"WinDeregisterObjectClass() error.  Can't deregister Objectclass.  Exiting...\n",
		"Can't register class WPLnchCW!\n",
		"Can't find help-directory! Please copy file 'BUBBLEPD.HLP' by hand.\n\n",
		"Can't copy helpfile!\nPlease copy file 'BUBBLEPD.HLP' by hand.\n\n", 
		"Error - Can't activate previous class!\n\n",
		"Error - Can't find help-directory! Please delete file 'BUBBLEPD.HLP' by hand.\n\n", 
		"Can't delete helpfile!\nPlease delete file 'BUBBLEPD.HLP' by hand.\n\n",
		"Can't delete classfile %s.\n",
		"Can't delete user-ini entries!\n\n"
	};
	
	char language[MAXLANGUAGES*2][100]={
		"Deutsch",//lang=0
		"English",//lang=1
		"Language 3",//lang=2
		"Language 4",//lang=3
		"Language 5",//lang=4

		"Pfeiltasten zum Auswhlen, anschlieend eine beliebige Taste drcken.",
		"Use arrow keys to select then press any Key.",
		"Translate it to language 3",
		"Translate it to language 4",
		"Translate it to language 5"
	};

	char action[MAXLANGUAGES*(NUMACTIONS+1)][100]={
		//Deutsch
		"Installieren",
		"Deinstallieren",
		"Ende",
		"Pfeiltasten zum Auswhlen, anschlieend <EINGABE>",
		
		//Englisch
		"Install",
		"Deinstall",
		"Exit",
		"Use arrow keys to select then press <RETURN>.",

		//Language 3
		"Install",
		"Deinstall",
		"Exit",
		"Use arrow keys to select then press <RETURN>.",

		//Language 4
		"Install",
		"Deinstall",
		"Exit",
		"Use arrow keys to select then press <RETURN>.",

		//Language 5
		"Install",
		"Deinstall",
		"Exit",
		"Use arrow keys to select then press <RETURN>."
	};
	
	char msg[MAXMSG][100]= {
		//Deutsch
		"Installation von Bubblepad beginnt...",
		"Suche Bootlaufwerk...",
		"Installationsverzeichnis ist ",
		"<EINGABE> drcken oder ein anderes Verzeichnis angeben (kein Backslash am Ende)\n--> ",
		"berprfe Verzeichnis...",
		"Kopiere Klassen-DLL...\n\n",
		"Registriere neue Objektklasse WPLnchCW...\n",
		"WPLnchCW  wurde registriert.\n\n",
		"Ersetze alte Launchpad-Klasse...\n",
		"Vorherige Launchpadklasse wurde ersetzt.\n\n",
		"Deregistriere Klasse WPLnchCW...\n",
		"Suche Verzeichnis fr Hilfe-Dateien...\n",
		"Lsche Klassen-DLL.         Breche ab...\n\n",
		"Kopiere Hilfe-Datei.\n\n",
		"Die zustzliche Funktionalitt steht nach einem Reboot zur Verfgung.",
		"Aktiviere vorherige Launchpad-Klasse...\n",
		"Vorherige Klasse wurde wieder aktiviert.\n\n",
		"Lsche Klassen-DLL %s...\n",
		"Fertig - WPLnchCW  wurde deregistriert.\n\n",
		"Bei einem Neustart wird die Klasse endgltig aus dem Speicher entfernt.\n\n",
		"--- Unbenutzt ---\n",
		"<STRG-c> zum Abbrechen oder <Eingabe>.\n\n",
		"Installation von Bubblepad (c) Chris Wohlgemuth 1997-98",
		"Vor der Installation die Datei COPYING lesen!!",
		
		//English
		"Starting installation...",		
		"Quering bootdrive...",
		"Installation directory is ",
		"Press <ENTER> or type in another directory \n--> ",
		"Checking directory...",
		"Copying Class-dll...\n\n",
		"Registering new objectclass WPLnchCW...\n",
		"Ready.\n\n",
		"Replacing old Launchpad-class...\n",
		"Ready.\n\n",
		"Deregistering class WPLnchCW...\n",
		"Querying help-directory...\n",
		"Deleting class-file.    Exiting...\n\n",
		"Copying help-file.\n\n",
		"Reboot to activate the enhancement.",
		"Activating previous Launchpad-class...\n",
		"Previous class is activated.\n\n",
		"Deleting class-file %s...\n",
		"Ready - Deregistered objectclass WPLnchCW.\n\n",
		"The class will be deleted from memory after a reboot.\n\n",
		"---unused ---\n",
		"Press <CTRL-c> to abort or <Return> to continue.\n\n",
		"Installation of Bubblepad (c) Chris Wohlgemuth 1997-98",
		"Read the file COPYING before installation!!",

		//Language 3
		"Starting installation...",
		"Quering bootdrive...",
		"Installation directory is ",
		"Press <ENTER> or type in another directory \n--> ",
		"Checking directory...",
		"Copying Class-dll...\n\n",
		"Registering new objectclass WPLnchCW...\n",
		"Ready.\n\n",
		"Replacing old Launchpad-class...\n",
		"Ready.\n\n",
		"Deregistering class WPLnchCW...\n",
		"Querying help-directory...\n",
		"Deleting class-file.    Exiting...\n\n",
		"Copying help-file.\n\n",
		"Reboot to activate the enhancement.",
		"Activating previous Launchpad-class...\n",
		"Previous class is activated.\n\n",
		"Deleting class-file %s...\n",
		"Ready - Deregistered objectclass WPLnchCW.\n\n",
		"The class will be deleted from memory after a reboot.\n\n",
		"---unused ---\n",
		"Press <CTRL-c> to abort or <Return> to continue.\n\n",
		"Installation of Bubblepad (c) Chris Wohlgemuth 1997-98",
		"Read the file COPYING before installation!!",

		//Language 4			
		"Starting installation...",
		"Quering bootdrive...",
		"Installation directory is ",
		"Press <ENTER> or type in another directory \n--> ",
		"Checking directory...",
		"Copying Class-dll...\n\n",
		"Registering new objectclass WPLnchCW...\n",
		"Ready.\n\n",
		"Replacing old Launchpad-class...\n",
		"Ready.\n\n",
		"Deregistering class WPLnchCW...\n",
		"Querying help-directory...\n",
		"Deleting class-file.    Exiting...\n\n",
		"Copying help-file.\n\n",
		"Reboot to activate the enhancement.",
		"Activating previous Launchpad-class...\n",
		"Previous class is activated.\n\n",
		"Deleting class-file %s.",
		"Ready - Deregistered objectclass WPLnchCW.\n\n",
		"The class will be deleted from memory after a reboot.\n\n",
		"---unused ---\n",
		"Press <CTRL-c> to abort or <Return> to continue.\n\n",
		"Installation of Bubblepad (c) Chris Wohlgemuth 1997-98",
		"Read the file COPYING before installation!!",
			
		//Language 5
		"Starting installation...",
		"Quering bootdrive...",
		"Installation directory is ",
		"Press <ENTER> or type in another directory \n--> ",
		"Checking directory...",
		"Copying Class-dll...\n\n",
		"Registering new objectclass WPLnchCW...\n",
		"Ready.\n\n"
		"Replacing old Launchpad-class...\n",
		"Ready.\n\n",
		"Deregistering class WPLnchCW...\n",
		"Querying help-directory...\n",
		"Deleting class-file.    Exiting...\n\n",
		"Copying help-file.\n\n"
		"Reboot to activate the enhancement.",	
		"Activating previous Launchpad-class...\n",
		"Previous class is activated.\n\n",
		"Deleting class-file %s.",
		"Ready - Deregistered objectclass WPLnchCW.\n\n",
		"The class will be deleted from memory after a reboot.\n\n",
		"---unused ---\n",
		"Press <CTRL-c> to abort or <Return> to continue.\n\n",
		"Installation of Bubblepad (c) Chris Wohlgemuth 1997-98",
		"Read the file COPYING before installation!!"

	};
	
	for(x=0;x<MAXLANGUAGES*2;x++) {
		select[x]=normalColor;
	}
	
	offset=0;
	x=0;
	wahl=0;
	select[0]=selectColor;

	v_init();
	v_clear();
	v_dimen(&width,&height);
	v_getctype(&start,&end);
	
	v_hidecursor();

	/*****************************************************************************/
	/* Language selection                                                        */
	/*****************************************************************************/	
	while(!wahl) {
		for(loop=0;loop<USEDLANGUAGES;loop++) {
			/*  Items																																	   */
			v_gotoxy((width-strlen(language[0+loop]))/2,5+loop);
			v_attrib(select[0+loop]);
			v_printf("%s\n",language[0+loop]);
			/*  Explanation									   */
			v_attrib(select[0+MAXLANGUAGES+loop]);
			v_gotoxy((width-strlen(language[0+MAXLANGUAGES+loop]))/2,height-1-MAXLANGUAGES+loop);
			v_printf(language[0+MAXLANGUAGES+loop]);
		}
		rc=_read_kbd(0,1,1);
		wahl=1;
		if(!rc){
			rc=_read_kbd(0,1,1);
			if(rc==72||rc==80) {
				select[x]=normalColor;
				if(rc==72){
					x--;
					if(x<0)x=USEDLANGUAGES-1;
				}
				else{
					x++;
					if(x==USEDLANGUAGES)x=0;
				}
				select[x]=selectColor;
			}
			wahl=0;
		}
	}
	lang=x;

	dllSource=(UCHAR *)fileName[lang];
	helpSource=(UCHAR *)fileName[MAXLANGUAGES+lang];
	
	/*****************************/
	/* Show Copyright            */
	/*****************************/	
	v_clear();
	v_gotoxy((width-strlen(msg[lang*NUMMSG+22]))/2,2);	
	v_attrib(selectColor);
	v_printf(msg[lang*NUMMSG+22]);//show copyright
	v_attrib(B_RED|F_WHITE);	 
	v_gotoxy((width-strlen(msg[lang*NUMMSG+23]))/2,4);	
	v_printf(msg[lang*NUMMSG+23]);//show licence msg
	v_attrib(normalColor);
	v_gotoxy((width-strlen(msg[lang*NUMMSG+21]))/2,15);
	v_printf(msg[lang*NUMMSG+21]);
	rc=_read_kbd(0,1,1);

	/*****************************************************************************/
	/* Select action                                                             */
	/*****************************************************************************/	
	v_clear();
	offset=lang*(NUMACTIONS+1);
	wahl=0;
	x=offset;
	select[x]=selectColor;

	/* Selection */	
	while(!wahl) {
		for(loop=0;loop<NUMACTIONS;loop++) {
			/*  Items																																	   */
			v_gotoxy((width-strlen(action[offset+loop]))/2,5+loop);
			v_attrib(select[offset+loop]);
			v_printf("%s\n",action[offset+loop]);
		}
		/*  Explanation									   */
		v_attrib(normalColor);
		v_gotoxy((width-strlen(action[offset+NUMACTIONS]))/2,height-1-NUMACTIONS);
		v_printf(action[offset+NUMACTIONS]);						
		rc=_read_kbd(0,1,1);
		wahl=1;
		if(!rc){
			rc=_read_kbd(0,1,1);
			if(rc==72||rc==80) {
				select[x]=normalColor;
				if(rc==72){
					x--;
					if(x<0)x=NUMACTIONS-1;
				}
				else{
					x++;
					if(x==NUMACTIONS)x=0;
				}
				select[x]=selectColor;
			}
			wahl=0;
		}
	}
	if(x==offset+NUMACTIONS-1) {
		v_clear();
		exit(0);//Exit choosen
	}
	
	/*****************************************************************************/
	/* Start Deinstallation                                                      */
	/*****************************************************************************/	
	if(x==offset+NUMACTIONS-2) {
		v_clear();//Clear Screen
		/*---------------  Query bootdrive	-----------------------------*/
		offset=lang*NUMMSG+1;
		rc = DosQuerySysInfo(1L,                 /* Request all available system   */
												 QSV_MAX,            /* information                    */
												 (PVOID)aulSysInfo,
												 sizeof(ULONG)*QSV_MAX);
		
		if (rc != NO_ERROR) {//Error!!
			v_attrib(B_RED|F_WHITE);
			v_gotoxy((width-strlen(msg[offset]))/2,10);
			sprintf(buffer2,"%s %u",errstr[lang*NUMERRORS],rc);
			v_printf(buffer2);
			exit(1);
		} else {
			drive='A';
			drive+=aulSysInfo[QSV_BOOT_DRIVE-1]-1;//Found driveletter
		} /* endif */
		bootDrive=drive;		

		HMODULE handle;
		char dll[CCHMAXPATH];
		/* find class-dll */		
		rc=DosLoadModule((PSZ) error,sizeof(error),(PSZ)dllName,&handle);	
		if (rc==NO_ERROR){
			DosQueryModuleName(handle,sizeof(dll),dll);
			DosFreeModule(handle);
		}
		
		v_gotoxy(0,2);
		v_printf("%s",msg[lang*NUMMSG+15]);//Show message: unreplacing launchpad-class
		/* Dereplace LaunchPad */
		if(WinReplaceObjectClass((UCHAR*)"WPLaunchPad",(UCHAR*)"WPLnchCW",FALSE))
			v_printf(msg[lang*NUMMSG+16]);//Show message: Activated previous class
		else {
			v_gotoxy(0,height-4);
			v_attrib(B_RED|F_WHITE);
			v_printf(errstr[lang*NUMERRORS+13]);//Error: Can't activate previous class
			v_attrib(normalColor);
			DosBeep(100,500);
			exit(1);
		}
		/* Deregister objectclass */
		v_printf("%s",msg[lang*NUMMSG+10]);//Show message: Deregistering WPLnchCW-class
		if(WinDeregisterObjectClass((UCHAR*)"WPLnchCW"))//printf("WPLnchCW-Klasse wurde deregistriert.\n");
			v_printf(msg[lang*NUMMSG+18]);//Show message: WPLnchCW-class is deregistered
		else{
			v_gotoxy(0,height-4);
			v_attrib(B_RED|F_WHITE);
			v_printf(errstr[lang*NUMERRORS+9]);//Error: Can't deregister class
			v_attrib(normalColor);
			DosBeep(100,500);
			exit(1);
		}

		/* Clear user.ini entries */
		if(!PrfWriteProfileData(HINI_USERPROFILE,(UCHAR *)"WPLnchCW",NULL,NULL,0)) {
			v_gotoxy(0,height-4);
			v_attrib(B_RED|F_WHITE);
			v_printf(errstr[lang*NUMERRORS+17]);// Error DosDelete()
			DosBeep(100,500);
			v_attrib(normalColor);
			DosSleep(2000);
			v_printf("\n\n\n\n");			
		}
		
		/* Delete class-dll */
		PFN procAddr;
		
		rc=DosLoadModule((PSZ) error,sizeof(error),(PSZ)"DOSCALLS.DLL",&handle);
		if (rc!=NO_ERROR){
			printf("DosLoadModule(DOSCALLS.DLL)-Error");
			v_gotoxy(0,height-4);
			v_attrib(B_RED|F_WHITE);
			sprintf(buffer2,errstr[lang*NUMERRORS+16],dll);// Error
			v_printf(buffer2);
			DosBeep(100,500);
			v_attrib(normalColor);
			DosSleep(2000);
			v_printf("\n\n\n\n");
		}
		else {
			rc=DosQueryProcAddr(handle,417,(PSZ)"",&procAddr);
			if (rc!=NO_ERROR)printf("DosQueryProcAddr-Error");
			else{
				sprintf(buffer2,msg[lang*NUMMSG+17],dll);// Show message: Deleting classfile
				v_printf(buffer2);
				rc=procAddr((PSZ) dll,(PSZ) NULL,(PSZ) NULL);//Unlock DLL
				rc=DosDelete((UCHAR*)dll);//Delete DLL
				if (rc){
					v_gotoxy(0,height-4);
					v_attrib(B_RED|F_WHITE);
					sprintf(buffer2,errstr[lang*NUMERRORS+16],dll);// Error DosDelete()
					v_printf(buffer2);
					DosBeep(100,500);
					v_attrib(normalColor);
					DosSleep(2000);
					v_printf("\n\n\n\n");
				}			
			}
			if(handle)DosFreeModule(handle);
		}
		
		/* Delete help file */ 
		
		/* Build helpdirectory name	(destination)																								   */
		sprintf(buffer2,"%c:\\os2\\help",bootDrive);
		/* Check helpdirectory for existance */
		ulBufferSize=sizeof(FILESTATUS3);	 
		rc=DosQueryPathInfo((UCHAR*)buffer2,FIL_STANDARD,&filestatus3,ulBufferSize);
		if(rc!=NO_ERROR) {
			v_gotoxy(0,height-4);
			v_attrib(B_RED|F_WHITE);
			v_printf(errstr[lang*NUMERRORS+14]);
			v_attrib(normalColor);
			DosBeep(100,500);
			exit(1);
		}
	 
		/* Build helpfile name	(destination)																								   */
		sprintf(buffer2,"%c:\\os2\\help\\%s",bootDrive,helpName);
		rc=DosDelete((UCHAR*)buffer2);
		if(rc) {
			v_gotoxy(0,height-4);
			v_attrib(B_RED|F_WHITE);
			v_printf(errstr[lang*NUMERRORS+15]);//Error: Can't delete help file	
			v_attrib(normalColor);
			DosBeep(100,500);
			exit(1);
		}
		v_printf(msg[lang*NUMMSG+19]);
		exit(0);//Exit
	}
	

	/*****************************************************************************/
	/* Start installation                                                        */
	/*****************************************************************************/	
 	v_clear();//Clear Screen
	
	offset=lang*NUMMSG;
	
	v_gotoxy((width-strlen(msg[offset]))/2,1);
	v_attrib(normalColor);
	v_printf("%s\n",msg[offset]);
	
	/*---------------  Query bootdrive	-----------------------------*/
	offset=lang*NUMMSG+1;
	v_gotoxy((width-strlen(msg[offset]))/2,10);
	v_attrib(normalColor);
	v_printf("%s\n",msg[offset]);//Show message "Quering bootdrive..."
	DosSleep(200);
	
	rc = DosQuerySysInfo(1L,                 /* Request all available system   */
											 QSV_MAX,            /* information                    */
											 (PVOID)aulSysInfo,
											 sizeof(ULONG)*QSV_MAX);
	
	if (rc != NO_ERROR) {//Error!!
		v_attrib(B_RED|F_WHITE);
		v_gotoxy((width-strlen(msg[offset]))/2,10);
		sprintf(buffer2,"%s %u",errstr[lang*NUMERRORS],rc);
		v_printf(buffer2);
		exit(1);
	} else {
		drive='A';
		drive+=aulSysInfo[QSV_BOOT_DRIVE-1]-1;//Found driveletter
	} /* endif */
	bootDrive=drive;
	
	v_gotoxy(0,10);
	 v_attrib(normalColor);
	 v_clreol();//Clear message
 
	 /* Show the destination directory name:	<bootdrive>:\os2\dll\					   */
	 offset=lang*NUMMSG+2;//next string: 		"Installation directory is "
	 sprintf(buffer2,"%c:\\os2\\dll",drive);
	 v_gotoxy(0,height-5);
	 v_printf(msg[offset]);
	 v_attrib(selectColor);//directoryname
	 v_printf(buffer2);
	 
	 /* Ask for another directory																						   */
	 offset=lang*NUMMSG+3;//next string
	 v_attrib(normalColor);
	 v_gotoxy(0,height-4);
	 v_printf(msg[offset]);//"Press <ENTER> or type in another directory: ",
	 v_ctype(start,end);
	 fgets(error,sizeof(error),stdin);
	 if(strlen(error)!=1)//1=Newline that is <ENTER>
		 sscanf(error,"%s",buffer);
	 else

		 /*v_gotoxy(0,height-4);
			 v_attrib(normalColor);
			 v_clreol();//clear directory question
			 v_printf("Stringlength: %d  %s\n",strlen(buffer),buffer);
			 DosSleep(5000);*/
	 
		 //if(strlen(buffer)==0)
		 strcpy(buffer,buffer2);//put directoryname in buffer
	 v_gotoxy(0,height-4);
	 v_attrib(normalColor);
	 v_clreol();//clear directory question
	 v_gotoxy(0,height-3);
	 v_attrib(normalColor);
	 v_clreol();//clear prompt
	 v_gotoxy(0,height-5);
	 v_clreol();//clear previous directory name
	 v_printf(msg[offset-1]);
	 v_attrib(selectColor);
	 v_printf(buffer);//Show the directory name

	 /* Check existance of destination directory     												   */
	 v_gotoxy(0,height-4);
	 v_attrib(normalColor);
	 offset=lang*NUMMSG+4;
	 v_printf(msg[offset]);//show message what we are doing: "Checking directory..."

	 rc=DosQueryPathInfo((UCHAR*)buffer,FIL_STANDARD,&filestatus3,ulBufferSize);
	 DosSleep(1000);

	 if(rc!=NO_ERROR){//Error with the chosen directory
		 v_gotoxy(0,height-4);
		 v_clreol();
		 v_printf(errstr[lang*NUMERRORS+1]);
		 /*  Create directory																											   */ 
		 rc=DosCreateDir((UCHAR*)buffer,NULL);		 		 
		 if(rc!=NO_ERROR) {
			 DosSleep(1000);			 
			 v_gotoxy(0,height-4);
			 v_clreol();
			 v_attrib(B_RED|F_WHITE);
			 v_gotoxy(0,height-4);
			 v_printf(errstr[lang*NUMERRORS+2]);
			 DosBeep(100,500);
			 exit(1);
		 }		 
	 };

	 sprintf(buffer2,"%s\\%s.dll",buffer,dllName);//Build full destinationpathname
	 /*------- Get current disk	-----------------------------------------*/
	 ulBufferSize=0;
	 drive='A';
	 rc=DosQueryCurrentDisk(&ulBufferSize,&ulDriveMap);
	 if(rc!=NO_ERROR) {
		 v_gotoxy(0,height-4);
		 v_attrib(B_RED|F_WHITE);
		 sprintf(buffer2,"%s %u. %s",errstr[lang*NUMERRORS+3],rc,errstr[lang*NUMERRORS+4]);
		 v_printf(buffer2);
		 DosBeep(100,500);
		 exit(1);
	 }
	 drive+=ulBufferSize-1;
	 /*------------- get current dir	---------------------------------*/
	 ulBufferSize=sizeof(error);
	 rc=DosQueryCurrentDir(0,(UCHAR*)error,&ulBufferSize);	 
	 if(rc!=NO_ERROR) {
		 v_gotoxy(0,height-4);
		 v_attrib(B_RED|F_WHITE);
		 sprintf(buffer2,"%s %u. %s",errstr[lang*NUMERRORS+3],rc,errstr[lang*NUMERRORS+5]);
		 v_printf(buffer2);
		 DosBeep(100,500);
		 exit(1);
	 }
	 /* Build source path */
	 sprintf(buffer,"%c:\\%s\\%s.dll",drive,error,dllSource);	 
	 offset=lang*NUMMSG+5;
	 v_clear(); 
	 v_gotoxy(0,2);
	 v_printf(msg[offset]);//say what we are doing: "Copy Class-dll..."
	 
	 /* copy classfile to destination */
	 rc=DosCopy((UCHAR*)buffer,(UCHAR*)buffer2,DCPY_EXISTING);
	 if(rc!=NO_ERROR) {
		 v_gotoxy(0,height-4);
		 v_attrib(B_RED|F_WHITE);
		 sprintf(buffer2,"%s%u. %s",errstr[lang*NUMERRORS+6],rc,errstr[lang*NUMERRORS+7]);
		 v_printf(buffer2);
		 DosBeep(100,500);
		 exit(1);
	 }

	 /* Register objectclass																								   */
	 v_printf(msg[lang*NUMMSG+6]);//say what we are doing: register Objectclass
	 if(WinRegisterObjectClass((UCHAR*)"WPLnchCW",(UCHAR*)buffer2)) {
		 v_printf(msg[lang*NUMMSG+7]);//say what we have done: registered Objectclass
		 v_printf(msg[lang*NUMMSG+8]);//say what we are doing: replacing WPLaunchPad
		 if(WinReplaceObjectClass((UCHAR*)"WPLaunchPad",(UCHAR*)"WPLnchCW",TRUE)){
			 v_printf(msg[lang*NUMMSG+9]);//say what we have done: replaced WPLaunchPad
		 }
		 else{//Can't replace LaunchPad
			 v_attrib(B_RED|F_WHITE);
			 v_printf(errstr[lang*NUMERRORS+8]);
			 v_attrib(normalColor);			 
			 v_printf(msg[lang*NUMMSG+10]);//say what we are doing: deregister Objectclass
			 if(!WinDeregisterObjectClass((UCHAR*)"WPLnchCW")){
				 v_gotoxy(0,height-4);
				 v_attrib(B_RED|F_WHITE);
				 v_printf(errstr[lang*NUMERRORS+9]);
				 DosBeep(100,500);
			 }
			 exit(1);				
		 }
	 }//end of if(WinRegisterObjectClass((UCHAR*)"WPLnchCW",(UCHAR*)buffer2))
	 else {//Can't register WPLnchCW-class
		 v_gotoxy(0,height-4);
		 v_attrib(B_RED|F_WHITE);
		 v_printf(errstr[lang*NUMERRORS+10]);
		 DosBeep(100,500);
		 v_attrib(normalColor);
		 v_printf(msg[lang*NUMMSG+12]);
		 rc=DosDelete((UCHAR*)buffer2);
		 exit(1);
	 }		 

	 v_printf(msg[lang*NUMMSG+11]);//say what we are doing: Search help-Directory
	 /* Build helpfile name	(source)																								   */
	 sprintf(buffer,"%c:\\%s\\%s",drive,error,helpSource);
	 /* Build helpdirectory name	(destination)																								   */
	 sprintf(buffer2,"%c:\\os2\\help",bootDrive);
	 /* Check helpdirectory for existance */
	 ulBufferSize=sizeof(FILESTATUS3);	 
	 rc=DosQueryPathInfo((UCHAR*)buffer2,FIL_STANDARD,&filestatus3,ulBufferSize);
	 if(rc!=NO_ERROR) {
		 v_gotoxy(0,height-4);
		 v_attrib(B_RED|F_WHITE);
		 v_printf(errstr[lang*NUMERRORS+11]);
		 v_attrib(normalColor);
		 exit(1);
	 }
	 
	 /* Build helpfile name	(destination)																								   */
	 sprintf(buffer2,"%c:\\os2\\help\\%s",bootDrive,helpName);
	 /*  Copy help-file																												   */
	 v_printf(msg[lang*NUMMSG+13]);//say what we are doing: copy help-file

	 rc=DosCopy((UCHAR*)buffer,(UCHAR*)buffer2,DCPY_EXISTING);
	 rc=0;
	 	 
	 if(rc!=NO_ERROR) {
		 v_gotoxy(0,height-4);
		 v_attrib(B_RED|F_WHITE);
		 sprintf(buffer2,"%s %u. %s",errstr[lang*NUMERRORS+6],rc,errstr[lang*NUMERRORS+12]);
		 v_printf(buffer2);
		 //		 v_printf("DosCopy error #%u: Can't copy helpfile.           Exiting...\n",rc);
		 v_attrib(normalColor);
		 DosBeep(100,500);
		 exit(1);
	 }	
	 v_attrib(selectColor);
	 v_printf(msg[lang*NUMMSG+14]);//say please reboot	 
	 v_attrib(normalColor);
	 v_printf("\n\n");		
	 exit(0);	 	 
}
