/* Qu2 Info */

BarInfo='<BAR_INFO>'  /* Object ID */
programname='Qu/2'
pipename='\pipe\qu2'


if RxFuncQuery('SysLoadFuncs') then do
  call RxFuncAdd 'SysLoadFuncs','RexxUtil','SysLoadFuncs'
  call SysLoadFuncs
end

do forever
    call stream pipename, 'c', 'open'
    call lineout pipename, 'info'
    info=linein(pipename)
    if info='' then do
        call lineout pipename, 'filename'
        filename=linein(pipename)
        if filename='' then
            info='silence'
        else
        do
            longname=QueryLongName(filename)
            if longname='' then
                info=substr(filename, lastpos('\', filename)+1)
            else
                info=longname
        end
    end
    if info<>oldinfo then
    do
      oldinfo=info
      call lineout pipename, 'filename'
      filename=linein(pipename)
      if filename='' then
          longname=''
      else
      do
          longname=QueryLongName(filename)
          if longname='' then
              longname=substr(filename, lastpos('\', filename)+1)
      end
      say programname' is playing 'info' - 'longname
      if info='' then
        info='~~~Clear~~~'
      if longname='' then
        longname='~~~Clear~~~'
      call SysSetObjectData BarInfo, "INFOBUBBLEHELP="longname";INFOTEXT="info
    end
    call stream pipename, 'c', 'close'
    call SysSleep 1
end
return

QueryLongName: procedure
    parse arg filename
    EAT_ASCII='fdff'x  /* The type of '.LONGNAME' EA is ASCII */
    if SysGetEA(filename, '.longname', 'longname')\=0 then
        return ''
    parse var longname type 3 len 5 longname
    if type=EAT_ASCII then
    do
        len=c2d(reverse(len))
        return left(longname, len)
    end
return ''
