/****************************************************************************
 *                             S Y S T R A Y / 2                            *
 *                                                                          *
 * (C) 2001-2, OS2.Ru DevTeam              http://devcenter.os2.ru/systray  *
 * Written by Dmitry Zaharov                                 madint@os2.ru  *
 ****************************************************************************/

// NOTE this file best edit in editor with 100 columns

#include "sampplug.h"

// Globals (external)

extern HMODULE	hmod;
extern HAB	hab;

HPOINTER	hptrClock;

/*
 DigitalClockPlugin for SysTray II
 by Yaroslav Komarov (2:5093/7)
 */

SEGMENTINFO Segments[16] =
  {
  { {0,8,4,8}, {+1, 0,-1, 0} , TRUE,  {+1,-1,-1,-1} , FALSE, { 0, 0, 0, 0} },		//0 
  { {4,4,4,8}, { 0,+1, 0,-1} , TRUE,  {-1,+1,-1,-1} , FALSE, { 0, 0, 0, 0} },		//1
  { {4,0,4,4}, { 0,+1, 0,-1} , TRUE,  {-1,+1,-1,-1} , FALSE, { 0, 0, 0, 0} },		//2
  { {0,0,4,0}, {+1, 0,-1, 0} , TRUE,  {+1,+1,-1,+1} , FALSE, { 0, 0, 0, 0} },		//3
  { {0,0,0,4}, { 0,+1, 0,-1} , TRUE,  {+1,+1,+1,-1} , FALSE, { 0, 0, 0, 0} },		//4
  { {0,4,0,8}, { 0,+1, 0,-1} , TRUE,  {+1,+1,+1,-1} , FALSE, { 0, 0, 0, 0} },		//5
  { {0,4,4,4}, {+1, 0,-1, 0} , TRUE,  {+1,+1,-1,+1} , TRUE,  {+1,-1,-1,-1} },		//6
  { {2,2,2,3}, { 0, 0, 0, 0} , TRUE,  {+1,+1,+1,-1} , TRUE,  {-1,+1,-1,-1} },		//7
  { {2,5,2,6}, { 0, 0, 0, 0} , TRUE,  {+1,+1,+1,-1} , TRUE,  {-1,+1,-1,-1} },		//8
  { {0,0,0,0}, { 0, 0, 0, 0} , FALSE, { 0, 0, 0, 0} , FALSE, { 0, 0, 0, 0} },		//9
  { {0,0,0,0}, { 0, 0, 0, 0} , FALSE, { 0, 0, 0, 0} , FALSE, { 0, 0, 0, 0} },		//10
  { {0,0,0,0}, { 0, 0, 0, 0} , FALSE, { 0, 0, 0, 0} , FALSE, { 0, 0, 0, 0} },		//11
  { {0,0,0,0}, { 0, 0, 0, 0} , FALSE, { 0, 0, 0, 0} , FALSE, { 0, 0, 0, 0} },		//12
  { {0,0,0,0}, { 0, 0, 0, 0} , FALSE, { 0, 0, 0, 0} , FALSE, { 0, 0, 0, 0} },		//13
  { {0,0,0,0}, { 0, 0, 0, 0} , FALSE, { 0, 0, 0, 0} , FALSE, { 0, 0, 0, 0} },		//14
  { {0,0,0,0}, { 0, 0, 0, 0} , FALSE, { 0, 0, 0, 0} , FALSE, { 0, 0, 0, 0} }		//15
  };

int Digits[11] = {0x003F,0x0006,0x005B,0x004F,0x0066,0x006D,0x007D,0x0007,0x007F,0x006F,0x0180};

/* Draw scaled line-delta */

void LineDelta (HPS hps, PPOINTL base, float scale, PPOINTL coord, PPOINTL interval, int intervalwidth, int width, PPOINTL delta)
{
POINTL newcoord;
newcoord.x = base->x + interval->x*intervalwidth + delta->x * width+coord->x * scale;
newcoord.y = base->y + interval->y*intervalwidth + delta->y * width+coord->y * scale;
GpiLine (hps, &newcoord);
}

/* Draw scaled line */

void Line (HPS hps, PPOINTL base, float scale, PPOINTL coord, PPOINTL interval, int intervalwidth)
{
POINTL newcoord;
newcoord.x = base->x + interval->x*intervalwidth + coord->x*scale;
newcoord.y = base->y + interval->y*intervalwidth + coord->y*scale;
GpiLine (hps, &newcoord);
}

/* Move scaled pointer */

void Move(HPS hps, PPOINTL base, float scale, PPOINTL coord, PPOINTL interval, int intervalwidth)
{
POINTL newcoord;
newcoord.x = base->x + interval->x*intervalwidth + coord->x*scale;
newcoord.y = base->y + interval->y*intervalwidth + coord->y*scale;
GpiMove (hps, &newcoord);
}

/* Draw digit's segment */

void Segment (HPS hps, PPOINTL base, float scale, int segment, int intervalwidth)
{
int width;
width = scale;
width -= width%2;
if (Segments[segment].pdelta1 && Segments[segment].pdelta2)
  width /= 2;
GpiBeginPath(hps, 1L);
Move (hps, base, scale, (PPOINTL)&Segments[segment].line.xLeft, (PPOINTL)&Segments[segment].interval.xLeft, intervalwidth);
if (Segments[segment].pdelta1)
  {
  LineDelta (hps, base, scale, (PPOINTL)&Segments[segment].line.xLeft , (PPOINTL)&Segments[segment].interval.xLeft , intervalwidth, width, (PPOINTL)&Segments[segment].delta1.xLeft );
  LineDelta (hps, base, scale, (PPOINTL)&Segments[segment].line.xRight, (PPOINTL)&Segments[segment].interval.xRight, intervalwidth, width, (PPOINTL)&Segments[segment].delta1.xRight);
  }
Line (hps, base, scale, (PPOINTL)&Segments[segment].line.xRight, (PPOINTL)&Segments[segment].interval.xRight, intervalwidth);
if (Segments[segment].pdelta2)
  {
  LineDelta (hps, base, scale, (PPOINTL)&Segments[segment].line.xRight, (PPOINTL)&Segments[segment].interval.xRight, intervalwidth, width, (PPOINTL)&Segments[segment].delta2.xRight);
  LineDelta (hps, base, scale, (PPOINTL)&Segments[segment].line.xLeft , (PPOINTL)&Segments[segment].interval.xLeft , intervalwidth, width, (PPOINTL)&Segments[segment].delta2.xLeft );
  }
Line (hps, base, scale, (PPOINTL)&Segments[segment].line.xLeft , (PPOINTL)&Segments[segment].interval.xLeft, intervalwidth);
GpiEndPath (hps);
GpiFillPath (hps, 1L, FPATH_ALTERNATE);
}

/* Draw digit */

void Digit(HPS hps, PPOINTL base, float scale, int digit, int intervalwidth)
{
int mask;
int i;
mask = Digits[digit];
for (i=0;i<16;i++,mask>>=1)
  if (mask & 1)
    Segment (hps, base, scale, i, intervalwidth);
}

/* Lets Show time? */

void Time(HWND hwnd, HPS hps, PUNITDC pUnit, PRECTL prcl)
{
POINTL      base;
float       scale;
DATETIME dt;

DosGetDateTime(&dt); 

WinQueryWindowRect(hwnd, prcl);
WinFillRect(hps, prcl, pUnit->fcInfo.lBackColor);
GpiSetColor(hps, pUnit->fcInfo.lTextColor);

prcl->yTop--;
prcl->xRight--;

if(!(pUnit->ulFlags & DCF_SHOWSECONDS))
  scale = min((float)(prcl->xRight - prcl->xLeft)/Clock_X_NoSec,
              (float)(prcl->yTop - prcl->yBottom)/Clock_Y);
else
  scale = min((float)(prcl->xRight - prcl->xLeft)/Clock_X ,
              (float)(prcl->yTop - prcl->yBottom)/Clock_Y);

//gettime(&ctime);

base.y = prcl->yBottom + (prcl->yTop - prcl->yBottom - (int)(Clock_Y * scale))/2;
base.x = prcl->xLeft;
Digit(hps, &base, scale  , dt.hours/10, scale/2);
base.x = prcl->xLeft + (6)*scale;
Digit(hps, &base, scale  , dt.hours%10, scale/2);

base.x = prcl->xLeft + (4+6)*scale;
if(dt.seconds & 1)
  Digit(hps, &base, scale  , 10              , scale/2);

base.x = prcl->xLeft + (4+4+6)*scale;
Digit(hps, &base, scale  , dt.minutes/10 , scale/2);
base.x = prcl->xLeft + (6+4+4+6)*scale;
Digit(hps, &base, scale  , dt.minutes%10 , scale/2);

if(pUnit->ulFlags & DCF_SHOWSECONDS)
  {
  base.x = prcl->xLeft + (6+6+4+4+6)*scale;
  Digit(hps, &base, scale/2, dt.seconds/10 , scale/2);
  base.x = prcl->xLeft + (3+6+6+4+4+6)*scale;
  Digit(hps, &base, scale/2, dt.seconds%10 , scale/2);
  }
}

// Notebook page dialog procedure

MRESULT	EXPENTRY DigitalClockDlgProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
PUNITDC pUnit = (PUNITDC)WinQueryWindowULong(hwnd, QWL_USER); // get instance
ULONG ulNumCPUs = 1L;
static ULONG ulFlagsU;

switch(msg)
  {
  case WM_INITDLG:

  pUnit = (PUNITDC)mp2;
  WinSetWindowULong(hwnd, QWL_USER, (ULONG)mp2); // set instance
  ulFlagsU = pUnit->ulFlags;

  WinCheckButton(hwnd, IDR_SHOWSECONDS, 
                 ((pUnit->ulFlags & DCF_SHOWSECONDS) != 0));
  break;

  case WM_COMMAND:
  switch((SHORT)mp1)
    {
    case IDC_UNDO:
    pUnit->ulFlags = ulFlagsU;
    break;

    case IDC_DEFAULT:
    pUnit->ulFlags = DCF_SHOWSECONDS;
    break;
    }

  WinCheckButton(hwnd, IDR_SHOWSECONDS, 
                 ((pUnit->ulFlags & DCF_SHOWSECONDS) != 0));

  return (MRESULT)0L;

  case WM_DESTROY:

  pUnit->ulFlags = 0L;

  if(WinQueryButtonCheckstate(hwnd, IDR_SHOWSECONDS))
    pUnit->ulFlags |= DCF_SHOWSECONDS;

  WinSendMsg(pUnit->Unit.hwnd, USTM_RESIZE, // resize unit
             MPFROMLONG((pUnit->ulFlags & DCF_SHOWSECONDS) ? 70 : 60L),
             (MPARAM)0L);
  break;
  }

return WinDefDlgProc(hwnd, msg, mp1, mp2);
}

BOOL	DigitalClockPaint(HWND hwnd, PUNITDC pUnit)
{
HPS hps;
RECTL rcl, rclReg;
CHAR szText[40];
INT i, n, cxIcon = WinQuerySysValue(HWND_DESKTOP, SV_CXICON)/2;

//GetItemFont(hwnd, pUnit->fcInfo.szFont);
//pUnit->fcInfo.lTextColor = GetItemTextColor(hwnd);
//pUnit->fcInfo.lBackColor = GetItemBackColor(hwnd);

WinQueryWindowRect(hwnd, &rcl);

hps = WinBeginPaint(hwnd, 0L, 0L);

GpiCreateLogColorTable(hps, 0L, LCOLF_RGB, 0L, 0L, (PLONG) NULL); // turn RGB on

Time(hwnd, hps, pUnit, &rcl); // draw digital clock

WinEndPaint(hps);

return TRUE;
}

MRESULT	DigitalClockPresParam(HWND hwnd, INT idAttr, PUNITDC pUnit)
{
BOOL fRepaint = TRUE;

switch(idAttr)
  {
  case 0: // Scheme palette dropped
//  GetItemFont(hwnd, pUnit->fcInfo[0].szFont);
  pUnit->fcInfo.lTextColor = GetItemTextColor(hwnd);
  pUnit->fcInfo.lBackColor = GetItemBackColor(hwnd);
  break;

  case PP_FOREGROUNDCOLOR:
  pUnit->fcInfo.lTextColor = GetItemTextColor(hwnd);
  break;

  case PP_BACKGROUNDCOLOR:
  pUnit->fcInfo.lBackColor = GetItemBackColor(hwnd);
  break;

//  case PP_FONTNAMESIZE:
//  GetItemFont(hwnd, pUnit->fcInfo[0].szFont);
//  break;

  default: fRepaint = FALSE;
  }

if(fRepaint)
  {
  RECTL rcl;
  WinQueryWindowRect(hwnd, &rcl);
  WinInvalidateRect(hwnd, &rcl, FALSE);
  }

return (MRESULT)fRepaint;
}

MRESULT	EXPENTRY DigitalClockWndProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
RECTL rcl;
PUNITDC pUnit;
pUnit = (PUNITDC)WinQueryWindowULong(hwnd, 0L); // get instance

switch(msg)
  {
  case WM_CREATE:
  // Setup Unit instance data
  pUnit = (PUNITDC)mp1;
  pUnit->Unit.ulRefresh = 1L;
  pUnit->Unit.ulCounter = 0L;
  WinSetWindowULong(hwnd, 0L, (ULONG)pUnit); // set instance

  if(pUnit->Unit.fJustCreated) // new unit
    {
    pUnit->fcInfo.lTextColor = WinQuerySysColor(HWND_DESKTOP, SYSCLR_WINDOWSTATICTEXT, 0L);
    pUnit->fcInfo.lBackColor = WinQuerySysColor(HWND_DESKTOP, SYSCLR_BUTTONMIDDLE, 0L);

    strcpy(pUnit->fcInfo.szFont, "---"); // no font, but colors

    pUnit->Unit.fJustCreated = FALSE;
    pUnit->ulFlags = DCF_SHOWSECONDS;
    }

  SetItemTextColor(hwnd, pUnit->fcInfo.lTextColor);
  SetItemBackColor(hwnd, pUnit->fcInfo.lBackColor);
  break;

  case USTM_REFRESHTIMER:  
  WinQueryWindowRect(hwnd, &rcl);
  WinInvalidateRect(hwnd, &rcl, FALSE);
  break;

  case USTM_QUERYWIDTH:
  // Return default unit width
  return (MRESULT)((pUnit->ulFlags & DCF_SHOWSECONDS) ? 70 : 57L);

  case USTM_QUERYICON:
  return (MRESULT)hptrClock;

  case USTM_QUERYNBINFO:
    {
    PUNITNBINFO punbInfo = (PUNITNBINFO)mp1;
    static PSZ ppszfcInfo[] = {"Digital Clock"};
    static UNITPGINFO upgInfo;
    upgInfo.pszTabText = "Clock";
    upgInfo.pszStatusText = "Digital Clock";
    upgInfo.res = hmod; // module
    upgInfo.id = IDR_CLOCKDLG; // dialog id
    upgInfo.mp2InsertFlags =  MPFROM2SHORT((BKA_STATUSTEXTON |
                                            BKA_AUTOPAGESIZE |
                                            BKA_MAJOR), BKA_FIRST);
    upgInfo.pfnDlgProc = (PFNWP)DigitalClockDlgProc; // dialog proc
    upgInfo.pCreateParams = (PVOID)pUnit; // instance
    upgInfo.hwnd = NULLHANDLE;
    upgInfo.pupgInfoNext = NULL; // one page only
    upgInfo.ulPageFlags = NPF_ALL; // all flags
    punbInfo->sNumfcInfo = 1;
    punbInfo->ppszfcInfo = (PSZ*)ppszfcInfo; // presentation headers
    punbInfo->pfcInfo = &pUnit->fcInfo; // presentation parameters
    punbInfo->pupgInfo = &upgInfo; // first page
    punbInfo->idTurnTo = IDR_CLOCKDLG; // page dialog id to turn on
    punbInfo->hptrWindowIcon = hptrClock; // dialog icon
    return (MRESULT) TRUE;
    }

  case WM_PAINT:
  DigitalClockPaint(hwnd, pUnit);
  return (MRESULT)TRUE;

  case WM_BUTTON1DBLCLK:
    {
    HOBJECT hobjClock = WinQueryObject("<WP_CLOCK>");
    if(hobjClock) WinOpenObject(hobjClock, 2, TRUE);
    return (MRESULT)1L;
    }

  case WM_PRESPARAMCHANGED:
//  WinQueryWindowRect(hwnd, &rcl);
//  WinInvalidateRect(hwnd, &rcl, FALSE);
//  break;
  return DigitalClockPresParam(hwnd, (INT)mp1, pUnit);
  }

return WinDefWindowProc(hwnd, msg, mp1, mp2);
}

BOOL	DigitalClockRegister(HAB _hab, HMODULE _hmod, PWCLASS _pwc)
{
_pwc->pszName = "SPLG_DigitalClock"; // window class name
_pwc->pszViewName = "Digital Clock"; // class title
_pwc->pszHelpFileName = "sampplug.hlp"; // help file
_pwc->ulHelpPanelID = 100; // help panel

_pwc->usMaxUnits = 1; // unit limit for this class
_pwc->usFlags = STUF_STATIC | STUF_FIXED; // "static" and fixed in size

_pwc->ulFix = sizeof(UNITDC); // stucture fixed size
_pwc->ulSafeAlloc = sizeof(UNITDC); // memory to allocate for unit

WinRegisterClass(_hab, _pwc->pszName, (PFNWP)DigitalClockWndProc, CS_SIZEREDRAW, sizeof(PVOID));

hptrClock = WinLoadPointer(HWND_DESKTOP, _hmod, IDR_CLOCKICON);

return TRUE;
}

BOOL	DigitalClockDeregister(HAB _hab, HMODULE _hmod)
{

if(hptrClock)
  WinDestroyPointer(hptrClock);

return TRUE;
}
