/*
 *  This file was generated by the SOM Compiler and Emitter Framework.
 *  Generated using: 
 *      SOM Emitter emitctm: 2.42
 */

#ifndef SOM_Module_wpsexts_Source
#define SOM_Module_wpsexts_Source
#endif
#define WPSAgentSam_Class_Source

#include "WPSExtS.ih"

/* only to get a couple more OPEN constants */
#include <wpfolder.h>
#include <wpdisk.h>

/* to query shadows */
#include <wpshadow.h>

#define AGENTQUE     "\\QUEUES\\WPSAGENTSAM\\MAIN.QUE"
#define SWITCHTOQUE  "\\QUEUES\\WPSAGENTSAM\\SWITCHTO.QUE"
#define GETHANDLEQUE "\\QUEUES\\WPSAGENTSAM\\GETHANDLE.QUE"
#define GETNAMEQUE   "\\QUEUES\\WPSAGENTSAM\\GETNAME.QUE"
#define SWITCHTO     1
#define GETHANDLE    2
#define GETNAME      3

struct switchToData {
                       HOBJECT hobj;
                       ULONG view;
                       ULONG timeout;
                    };

HSWITCH APIENTRY16 WINHSWITCHFROMHAPP(HAPP happ);
void agent(void *cls);

void SOMLINK wpsagent_AgentInit(SOMClass *cls)
{
   _beginthread(agent, NULL, 8192, cls);
}

void agent(void *cls)
{
   /* for the queues */
   HQUEUE que,
          quereturn;
   REQUESTDATA request;
   ULONG size;
   void *pointer;
   BYTE dummyprio;
   PID serverpid;

   /* for the PM message queue */
   HAB hab;
   HMQ hmq;

   if ((hab = WinInitialize(0)) && (hmq = WinCreateMsgQueue(hab,0)))
   {
   WinCancelShutdown(hmq, TRUE);
   if (!DosCreateQueue(&que, QUE_FIFO | QUE_CONVERT_ADDRESS, AGENTQUE))
      while(1) /* forever */
      {
         DosReadQueue(que, &request, &size, &pointer, 0, DCWW_WAIT, &dummyprio, 0);

         switch(request.ulData)
         {
            /* in-use list switcher */
            case SWITCHTO:
            {
               WPObject *obj; /* object pointer found from the provided object handle */
               int times; /* stores how many times trying each 100 ms */
               int i;  /* for loop counter */
               VIEWITEM *viewItem, goodview;
               SWCNTRL switchData;
               HSWITCH hswitch;
               BOOL success = FALSE;
               struct switchToData *data = (struct switchToData *) pointer;

               obj = _wpclsQueryObject(_WPObject,data->hobj);

               if (data->view == OPEN_DEFAULT)
               {
                  data->view = _wpQueryDefaultView(obj);

          /* found this by hasard... it seems that the objects
             don't know their default view when it is the class
             default, and it reports 0x1000, must be a bug, this
             isn't documented */

                  if (data->view == 0x1000)
                      data->view =_wpclsQueryDefaultView(_somGetClass(obj));
               }

          /* Unless you can tell me what the hell is
             #define OPEN_AUTO            120
             in WPDISK.H and how to effectively use it, I'll just
             convert it to OPEN_TREE */

               if (data->view == OPEN_AUTO) data->view = OPEN_TREE;

               times = (int) (data->timeout*10 + 0.5);

          /* retry 'times' times each 100 ms */

               for(i=0;i<times;i++,DosSleep(100))
               {
                  goodview.handle = 0;

                  for (viewItem = _wpFindViewItem(obj, VIEW_ANY, NULL);
                       viewItem;
                       viewItem = _wpFindViewItem(obj, VIEW_ANY, viewItem))

               /* if the view is good, keep it.  we want the LAST view
                  that matches as it's most probably the newest opened */

                       if (viewItem->view == data->view) goodview = *viewItem;

               /* if the a view is found, it will switch to the handle if
                  it is a frame handle, if not it will find the switch handle,
                  check if the program view is visible and switch using it */

                  if (goodview.handle)
                  {
                     if ( WinSetActiveWindow(HWND_DESKTOP,goodview.handle) )
                        { success = TRUE; goto end; }
                     else
                     {
                        hswitch = WINHSWITCHFROMHAPP(goodview.handle);
                        if (   !WinQuerySwitchEntry(hswitch, &switchData) &&
                               (switchData.uchVisibility == SWL_VISIBLE)  &&
                               !WinSwitchToProgram(hswitch)         )
                           { success = TRUE; goto end; }
                     }
                  } /* if we found something */
               } /* until timeout each 100 ms */

            /* send back success if return queue exists */

               end : DosFreeMem(data);
                     if(!DosOpenQueue(&serverpid,&quereturn,SWITCHTOQUE))
                        DosWriteQueue(quereturn,0,success,NULL,0);
                     break;
      
            } /* end case SWITCHTO */

            case GETHANDLE:
            {
            /* ulItemID has been placed in size, and shadowresolve in the pointer */
               WPObject *obj = OBJECT_FROM_PREC(size);
               if (!DosOpenQueue(&serverpid,&quereturn,GETHANDLEQUE))
               {
                  if (pointer && _somIsA(obj,_WPShadow) )
                        obj = _wpQueryShadowedObject(obj,FALSE);

                  DosWriteQueue(quereturn,0,_wpQueryHandle(obj),NULL,0);
               }
               break;
            }

            case GETNAME:
            {
            /* HOBJECT has been placed in size, shadowresolve in fullpath[0] and
               realname in fullpath[1] */
               WPObject *obj = _wpclsQueryObject(_WPObject,size);
               char *fullpath = (char *) pointer;
               ULONG maxpath = CCHMAXPATH;

               if(!DosOpenQueue(&serverpid,&quereturn,GETNAMEQUE))
               {
                  if(obj)
                  {

                     if (fullpath[0] && _somIsA(obj,_WPShadow) )
                        obj = _wpQueryShadowedObject(obj,FALSE);

                     if (fullpath[1])
                        _wpQueryRealName(obj,fullpath,&maxpath,TRUE);
                     else if(_wpQueryRealName(_wpQueryFolder(obj),fullpath,&maxpath,TRUE))
                     {
                        strcat(fullpath,"\\");
                        strcat(fullpath,_wpQueryTitle(obj));
                     }
                  }
                  else
                     fullpath[0] = '\0';

                  DosWriteQueue(quereturn,0,0,fullpath,0);
                  DosFreeMem(fullpath);
               }
               break;
            }

         } /* end switch(request.uldata) */

      } /* while forever after creating queue */
   } /* if hmq */
}

BOOL _System SwitchToObject(HOBJECT hobj, ULONG view, ULONG timeout, BOOL wait)
{
   HQUEUE que = 0, quereturn = 0;
   PID serverpid;
   REQUESTDATA request;
   void *dummypointer;
   BYTE dummyprio;

   struct switchToData *data;
   BOOL rc = FALSE;

   if(!DosAllocSharedMem((void**)&data,NULL,sizeof(struct switchToData),PAG_COMMIT|OBJ_GETTABLE|OBJ_GIVEABLE|PAG_WRITE))
   {
      data->hobj = hobj;
      data->view = view;
      data->timeout = timeout;

      if(wait) DosCreateQueue(&quereturn, QUE_FIFO | QUE_CONVERT_ADDRESS, SWITCHTOQUE);

      if(  !DosOpenQueue(&serverpid,&que,AGENTQUE)                         &&
           !DosGiveSharedMem(data,serverpid,PAG_WRITE)                     &&
           !DosWriteQueue(que,SWITCHTO,sizeof(struct switchToData),data,0)   )
    /* wait till switch is finished if wanted */
         if(wait && quereturn)
         {
            DosReadQueue(quereturn, &request, &rc, &dummypointer, 0, DCWW_WAIT, &dummyprio, 0);
            DosCloseQueue(quereturn);
         }

      DosFreeMem(data);
   }

   return rc;
}

HOBJECT _System HObjectFromID(ULONG ulItemID, BOOL shadowresolve)
{
   HQUEUE que = 0, quereturn = 0;
   PID serverpid;
   REQUESTDATA request;
   void *dummypointer;
   BYTE dummyprio;
   HOBJECT rc = 0;

   if(shadowresolve) dummypointer = &dummypointer; else dummypointer = NULL;

   if(  !DosOpenQueue(&serverpid,&que,AGENTQUE)                                   &&
        !DosCreateQueue(&quereturn, QUE_FIFO | QUE_CONVERT_ADDRESS, GETHANDLEQUE) &&
        !DosWriteQueue(que,GETHANDLE,ulItemID,dummypointer,0)            )
      {
         DosReadQueue(quereturn, &request, &rc, &dummypointer, 0, DCWW_WAIT, &dummyprio, 0);
         DosCloseQueue(quereturn);
      }

   return rc;
}

BOOL _System QueryPathTitle(HOBJECT hobj, BOOL shadowresolve, BOOL truename, char path[])
{
   HQUEUE que = 0, quereturn = 0;
   PID serverpid;
   REQUESTDATA request;
   char *fullpath;
   BYTE dummyprio;
   ULONG dummy;
   BOOL rc = FALSE;

   if(!DosAllocSharedMem((void**)&fullpath,NULL,sizeof(2*CCHMAXPATH),PAG_COMMIT|OBJ_GETTABLE|OBJ_GIVEABLE|PAG_WRITE))
   {
      if(shadowresolve)   fullpath[0] = 1; else fullpath[0] = 0;
      if(truename) fullpath[1] = 1; else fullpath[1] = 0;

      if(  !DosOpenQueue(&serverpid,&que,AGENTQUE)                                   &&
           !DosCreateQueue(&quereturn, QUE_FIFO | QUE_CONVERT_ADDRESS, GETNAMEQUE)   &&
           !DosGiveSharedMem(fullpath,serverpid,PAG_WRITE)                           &&
           !DosWriteQueue(que,GETNAME,hobj,fullpath,0)                     )
      {
         DosReadQueue(quereturn, &request, &dummy, (void**)&fullpath, 0, DCWW_WAIT, &dummyprio, 0);
         DosCloseQueue(quereturn);
         strcpy(path,fullpath);
         rc = TRUE;
      } else fullpath[0] = '\0';

      DosFreeMem(fullpath);
   }

   return rc;
}

SOM_Scope void  SOMLINK ffolder_wpInitData(FFolder *somSelf)
{
    FFolderData *somThis = FFolderGetData(somSelf);
    FFolderMethodDebug("FFolder","ffolder_wpInitData");

    __set_filter(somSelf,somGetGlobalEnvironment(),NULL);
    __set_filtered(somSelf,somGetGlobalEnvironment(),TRUE);

    FFolder_parent_WPFolder_wpInitData(somSelf);
}

SOM_Scope HWND  SOMLINK ffolder_wpViewObject(FFolder *somSelf, 
                                             HWND hwndCnr, ULONG ulView, 
                                             ULONG param)
{
    FFolderData *somThis = FFolderGetData(somSelf);
    FFolderMethodDebug("FFolder","ffolder_wpViewObject");

    if (!__get_filtered(somSelf,somGetGlobalEnvironment()))
       _wpPopulate(somSelf,NULLHANDLE,NULL,FALSE);

    return (FFolder_parent_WPFolder_wpViewObject(somSelf, hwndCnr, 
                                                 ulView, param));
}

SOM_Scope BOOL  SOMLINK ffolder_wpPopulate(FFolder *somSelf, 
                                           ULONG ulReserved, 
                                           PSZ pszPath, BOOL fFoldersOnly)
{
   char *filter;
   Environment *env = somGetGlobalEnvironment();

   FFolderData *somThis = FFolderGetData(somSelf);
   FFolderMethodDebug("FFolder","ffolder_wpPopulate");

   if (filter = __get_filter(somSelf,env))
   {
      HFIND findhandle;
      OBJECT objbuf[10];
      ULONG objnum;
      int i;
      BOOL rc;

      _wpSetFldrFlags(somSelf,_wpQueryFldrFlags(somSelf) & ~FOI_POPULATEDWITHALL & ~FOI_POPULATEDWITHFOLDERS);
      rc = FFolder_parent_WPFolder_wpPopulate(somSelf, ulReserved, pszPath, fFoldersOnly);

      _wpclsSetError(_WPObject,0);

      objnum = 10;
      _wpclsFindObjectFirst(_WPObject,NULL,&findhandle,NULL,somSelf,FALSE,NULL,objbuf,&objnum);

      while (_wpclsQueryError(_WPObject) != WPERR_OBJECT_NOT_FOUND)
      {
         for(i = 0; i<objnum; i++)
            if (fnmatch(filter,_wpQueryTitle(objbuf[i]),_FNM_OS2|_FNM_IGNORECASE))
               _wpDeleteFromContent(somSelf,objbuf[i]);

         objnum = 10;
         _wpclsFindObjectNext(_WPObject,findhandle,objbuf,&objnum);
      }

      _wpclsFindObjectEnd(_WPObject,findhandle);
      __set_filtered(somSelf,somGetGlobalEnvironment(),TRUE);

      return rc;
   }
   return (FFolder_parent_WPFolder_wpPopulate(somSelf, ulReserved,
                                              pszPath, fFoldersOnly));
}

SOM_Scope BOOL  SOMLINK ffolder_wpSetup(FFolder *somSelf, PSZ pszSetupString)
{
   char filter[CCHMAXPATH+1];
   ULONG length = CCHMAXPATH;

   FFolderData *somThis = FFolderGetData(somSelf);
   FFolderMethodDebug("FFolder","ffolder_wpSetup");

   if (_wpScanSetupString(somSelf,pszSetupString,"FILTER",filter,&length))
   {

      __set_filter(somSelf,somGetGlobalEnvironment(),filter);
      __set_filtered(somSelf,somGetGlobalEnvironment(),FALSE);
   }

   return (FFolder_parent_WPFolder_wpSetup(somSelf, pszSetupString));
}

SOM_Scope BOOL  SOMLINK ffolder_wpDeleteFromObjUseList(FFolder *somSelf, 
                                                       PUSEITEM pUseItem)
{
    BOOL rc;
    USEITEM *wasopened;

    FFolderData *somThis = FFolderGetData(somSelf);
    FFolderMethodDebug("FFolder","ffolder_wpDeleteFromObjUseList");

    /* need to check if there is an actual view, because the WPS always
       calls this method on open _and_ close */

    wasopened = _wpFindUseItem(somSelf, USAGE_OPENVIEW, NULL);

    rc = FFolder_parent_WPFolder_wpDeleteFromObjUseList(somSelf, pUseItem);

    /* if was opened, but not anymore and if a filter was used, trash it */

    if (  wasopened &&
        !_wpFindUseItem(somSelf, USAGE_OPENVIEW, NULL) &&
         __get_filter(somSelf,somGetGlobalEnvironment()))
    {
       __set_filter(somSelf,somGetGlobalEnvironment(),NULL);
       __set_filtered(somSelf,somGetGlobalEnvironment(),FALSE);
       _wpSetFldrFlags(somSelf,_wpQueryFldrFlags(somSelf) & ~FOI_POPULATEDWITHALL & ~FOI_POPULATEDWITHFOLDERS);
    }

    return (rc);
}
