/* Install script for the DDIcon WPS class */
Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
Call SysLoadFuncs

Parse Source . . Path

Class = 'DDIcon'
RepClass = 'WPIcon'
DLL   = FileSpec('d', Path) || FileSpec('p', Path) || 'DDICON.DLL'

If \QueryDLLExist(DLL) then
	Exit

If \QueryClassExist(Class) then
 	If \RegClass(Class DLL) then
		Exit

RepClasses = SysIni('USER', 'PM_Workplace:ReplaceList', RepClass)

If \QueryRepClassExist(RepClasses Class) then
	Call ReplaceClass RepClasses RepClass Class

Exit

/* ------------------------------------------------------------------------ */

QueryDLLExist: Procedure
	Parse Arg DLL
	rc = 1
	If Stream(DLL, 'C', 'Query Exist') = '' then
	Do
		Say 'File not found: "'DLL'"'
		rc = 0
	End
Return rc;

QueryClassExist: Procedure
	Parse Arg Class
	Call SysQueryClassList "ClassList."
	rc = 0
	Do i = 1 to ClassList.0
		If SubWord(ClassList.i, 1, 1) = Class then
		Do
			rc = 1
			Say "Class '"Class"' already registered!"
		End
	End
Return rc;

RegClass: Procedure
 	Parse Arg Class DLL
	If SysRegisterObjectClass(Class, DLL) then
	Do
		Say "Class '"Class"' successfully registered!"
		rc = 1
	End
	Else
	Do
		Say "Registration of class '"Class"' failed!"
		rc = 0
	End
Return rc;

QueryRepClassExist: Procedure
	Parse Arg RepClasses Class
	rc = 0
	If RepClasses \= 'ERROR:' then
	Do
		RepClasses = Space(Translate(RepClasses, ' ', D2C(0)))
		Do i = 1 to Words(RepClasses)
			If Subword(RepClasses, i, 1) = Class then
			Do
				Say "Class '"WPIcon"' already replaced with '"Class"'!"
				rc = 1
				Leave
			End
		End
	End
Return rc;

ReplaceClass: Procedure
	Parse Arg RepClasses RepClass Class
	If RepClasses = 'ERROR:' then
		rc = SysIni('USER', 'PM_Workplace:ReplaceList', RepClass, Class || D2C(0) || D2C(0))
	Else
	Do
		ClassData = Left(RepClasses, Length(RepClasses) - 1) || Class || D2C(0) || D2C(0)
		rc = SysIni('USER', 'PM_Workplace:ReplaceList', RepClass, ClassData)
	End

	If rc = 'ERROR:' then
		Say "Class replacement of '"RepClass"' -> '"Class"' failed!"
	Else
	Do
		Say "Class replacement of '"RepClass"' -> '"Class"' successful!"
		Say "You should reboot OS/2 or restart the WPS to invoke the changes."
	End
Return;

