/* */

call RxFuncAdd "SysLoadFuncs", "REXXUTIL", "SysLoadFuncs"
call SysLoadFuncs

call SysCls

say 'Dumb little Rexx Installer for mINI'
say '-----------------------------------'
say
say '   Installation...'
say
say '   ... will create folder and objects on desktop'
say '   ... will create associations of *.INI files with mINI'
say '   ... will NOT modify your config.sys and *.ini files'
say '       so stay cool :-)'
say

say 'Associate *.INI files with mINI (Y/N)?'
PARSE UPPER PULL Assoc
IF Assoc="" THEN
 Assoc="N"

say 'Use FastINI instead of RexxUtil (Y/N)?'
PARSE UPPER PULL Fast
IF Fast="" THEN
 Fast="N"

InstDir=directory()

/* Make icons */
say
say '--------------------------------------------'
say 'creating icons...'
say '--------------------------------------------'

mydir=Directory()

classname='WPFolder'
title='mINI'
location='<WP_DESKTOP>'
folderid='<mINI_FOLDER>'
setup='OBJECTID='||folderid||';ICONVIEW=FLOWED'
rc=SysCreateObject(classname, title, location, setup, 'U')

classname='WPProgram'
title='mINI'
title2='mINI Association'
location='<mINI_FOLDER>'
icon='ICONFILE='mydir||'\mINI.ico'
icon2='ICONFILE='mydir||'\mINIdata.ico'
exename='EXENAME='||InstDir||'\mINI.exe'
WorkDir=InstDir

IF Assoc="Y" THEN
 DO
  /* Create associations */
  say
  say '--------------------------------------------'
  say 'creating associations...'
  say '--------------------------------------------'
  setup='OBJECTID=<mINI_ASSOC>;STARTUPDIR='||Workdir||';'||icon2||';'||exename||';ASSOCFILTER=*.INI,*.ini'
  IF Fast<>"N" THEN
   setup=setup||';PARAMETERS=-FASTINI'
  rc=SysCreateObject(classname, title2, location, setup, 'U')
  setup='OBJECTID=<mINI_PROGRAM>;STARTUPDIR='||Workdir||';'||icon||';'||exename
  IF Fast<>"N" THEN
   setup=setup||';PARAMETERS=-FASTINI'
 END
ELSE
 DO
  setup='OBJECTID=<mINI_PROGRAM>;STARTUPDIR='||Workdir||';'||icon||';'||exename
  IF Fast<>"N" THEN
   setup=setup||';PARAMETERS=-FASTINI'
 END

rc=SysCreateObject(classname, title, location, setup, 'U')

say
say 'Done.'
say

"@pause"

EXIT