/*
   PPREXX - a simple preprocessor for REXX
   20/06/03: V1.0 - Initial version (gjarvis@ieee.org)
*/
'@echo off'
prgver = '1.0'
parse upper source pmgsrc
parse value value('PATH',,'OS2ENVIRONMENT') with . ":\OS2;" -1 bootPath +3 .
creatednum = 0

line = 'PPREXX' prgver 'on' date() time()
say line

parse arg infile outfile key val .
if infile='' | outfile='' | infile==outfile then do
   say "Usage:PPREXX infile outfile [key value]"
   say " infile      name of input file"
   say " outfile     name of output file"
   say " key         key"
   say " val         value"
   exit 3
end /* do */
incs.0 = 0

/* read list file */
if \fileExists(infile) then do
   say "missing main file" infile
   exit  1;
end /* do */
say "reading file" infile

do while lines(infile)
   line = linein(infile)
   parse var line verb incfile .
   if verb == "#include" then call includeTest incfile".cmd"
end
call close infile

/* write file, list source files */
call stream outfile, 'c', "open write replace"
call lineout outfile, "/* Don't edit this file, as it is generated by 'PPREXX' version" prgver "from the ..\src directory. */"
call lineout outfile, "/* Please edit the following:"
call lineout outfile, "    ..\src\" || infile
do i=1 to incs.0
   call lineout outfile, "    ..\src\" || incs.i
end /* do */
call lineout outfile, "*/"

/* insert main file */
do while lines(infile)
   line = linein(infile)
   parse var line verb .
   if verb == "#include" then iterate
   if key<>'' then line = changestr(key, line, val)
   call lineout outfile, line
end
call close infile

/* list source files */
do i=1 to incs.0
   call includefile incs.i
end /* do */
call close outfile

say "pprexx created:" outfile
exit 0;


/* includeTest */
includeTest: procedure   expose outfile incs.
   parse arg incfile
   /* check for duplicates */
   if incs.0>0 then do i=1 to incs.0
      if incs.i == incfile then return
   end /* do */
   i = incs.0 + 1
   incs.i = incfile
   incs.0 = i
   /* check for file */
   if \fileExists(incfile) then do
      say "missing include file" incfile
      exit  1
   end /* do */
   return


/* includefile */
includefile: procedure   expose outfile incs.
   parse arg incfile
   say "inserting include file" incfile
   /* skip until two consecutive lines */
   blank1st = 0
   blank2nd = 0
   do while lines(incfile) & \blank2nd
      blank2nd = blank1st
      blank1st = linein(incfile)=''
      if \blank1st then blank2nd = 0
   end
   /* copy rest of file */
   do while lines(incfile)
      call lineout outfile, linein(incfile)
   end
   call close incfile
   return


/* return true if file succesfully closed */
close: procedure
    ret = stream(arg(1),'C','CLOSE')
    if ret='READY:' then return 1
    say 'error closing file stream' arg(1) ret
    exit -1
    return 0


/* return true if file exists */
fileExists: procedure
   ret = stream(arg(1),'C','QUERY EXISTS')
   if ret='' then return 0
   else return 1


