/* Don't edit this file, as it is generated by 'PPREXX' version 1.0 from the ..\src directory. */
/* Please edit the following:
    ..\src\getwps.cmd
    ..\src\lib.cmd
*/
/*  ͻ
      GETWPS gets selected desktop and startup objects and their decedents 
      with multiple drive support.                                         
                                                                           
      15/09/03: V1.3 - map datapath                      (gjarvis@ieee.org)
      19/05/03: V1.2 - for shadows missing OBJECTID (gjarvis@ieee.org)     
      23/03/03: V1.1 - (ALL command line option                            
                     - (WPDATA command line option                         
                     - OBJ verb                      (gjarvis@ieee.org)    
      17/06/02: V1.0 - Initial version (gjarvis@ieee.org)                  
    ͼ */


'@echo off'
prgver = '1.3'
call rxfuncadd sysloadfuncs, rexxutil, sysloadfuncs
call sysloadfuncs
call RxFuncAdd 'WPToolsLoadFuncs', 'WPTOOLS', 'WPToolsLoadFuncs'
call WPToolsLoadFuncs
listFile = 'getwps.lst'
datFile = 'getwps.din'
newnum = 0
creatednum = 0
_d_ = '"'

prgver = prgver 'with WPTOOLS.DLL' WPToolsVersion()
call getosver prgver, os.
say os.0line

parse arg parm '(' opt
opt = translate(opt)
allFlag = wordpos("ALL",opt)>0
wpdataFlag = wordpos("WPDATA",opt)>0
if allFlag then datFile = "getwps.all"

/* read list file */
lists.0 = 0
if \allFlag then do
   if fileExists(listfile) then do
      call vback listfile 'backing existing'
      i =   0
      do while lines(listFile)
         i = i + 1
         parse value linein(listfile) with verb rest
         lists.i = translate(verb) rest
      end
      lists.0 = i
      call closefile listfile
   end /* do */
end

call vback datfile "backing existing"
call stream datfile, 'c', "open write replace"
call lineout datfile, 'from' os.0line

tops.1 = '<WP_DESKTOP>'
tops.2 = '<WP_START>'
tops.0 = 2


/* main loop */
do j = 1 to tops.0
    if \WPToolsFolderContent(tops.j, "objs.", 'F') Then iterate
    do i = 1 to objs.0
        obj = objs.i
        if \WPToolsQueryObject(obj, "class", "title", , "loc") Then iterate
        if allFlag then do
           call getfldchk obj
           iterate
        end /* do */
        f = inlist(class, title, loc)
        if f>0 then do
           if pos('INC',lists.f)=1 then call getfldchk obj
        end /* do */
        else do
            call lineout listFile,'EXC' '"'class'"' '"'title'"' '"'loc'"'
            newnum = newnum + 1
        end /* do */
    end
end
call getwps "<WP_DESKTOP>"

/* OBJ */
if \allFLag then do
    do i = 1 to lists.0
       parse var lists.i lverb rest
       if lverb<>"OBJ" then iterate
       parse var rest (_d_) obj (_d_) .
       call getfldchk obj
    end /* do */
end

if newnum>0 then call closefile listfile
call closefile datFile
call vback datfile "backing new"
say os.0prgname 'read:' lists.0 'new:' newnum 'created:' creatednum
exit 0;




/* return index to lists. with matching obj & class else returns 0 if nothing matches */
inlist: procedure expose lists. _d_
    parse arg class, title, loc
    /*say '"'obj'"' '"'class'"' '"'title'"' '"'setup'"' '"'loc'"'*/
    do i = 1 to lists.0
       parse var lists.i lverb (_d_) lclass (_d_) (_d_) ltitle (_d_) (_d_) lloc (_d_) rest
       if class<>lclass then iterate
       if title<>ltitle then iterate
       if loc<>lloc then iterate
       return i
    end /* do */
    return 0



/* get all objects from obj including subfolders */
getfldchk: procedure expose datfile creatednum os. wpdataFlag allFlag lists.
    parse arg obj, class
    if \WPToolsQueryObject(obj, "class", , , ) Then return
    if \getwps(obj) then return
    if class='WPFolder' then do
        if \WPToolsFolderContent(obj, "objs.", 'F') Then return
        do i = 1 to objs.0
            call getfldchk objs.i
        end
    end
    return



/* get class, title, setup, loc for obj and write it to datfile */
getwps: procedure expose datfile creatednum os. wpdataFlag allFlag lists.
    parse arg obj
    if \WPToolsQueryObject(obj, "class", "title", "setup", "loc") then return 0
    setup = changestr(os.0bootpath, setup, 'C:\')
    setup = changestr(os.0datapath, setup, 'D:\')
    loc = changestr(os.0bootpath, loc, 'C:\')
    loc = changestr(os.0datapath, loc, 'D:\')
    if class='WPShadow' then setup = subsetup('SHADOWID=', setup) || subsetup('OBJECTID=', setup)
    if (wpdataFlag) & (class='WPDataFile') then return 0
    call lineout datfile, '"'class'"' '"'title'"' '"'loc'"' '"'setup'"'
    creatednum = creatednum + 1
    return 1


/* return substr of setup */
subsetup: procedure
    parse arg sub, setup
    b = pos(sub, setup)
    if b=0 then return ''
    e = pos(';', setup, b)
    return substr(setup, b, e-b+1)


getosver:procedure expose delimit.
   use arg prgver, os.
   call createdelimiters
   /* program invoked */
   parse upper source . . os.0prgname
   /* bootpath */
   parse value value('PATH',,'OS2ENVIRONMENT') with . ":\OS2;" -1 os.0bootPath +3
   /* datapath */
   parse var os.0prgname os.0datapath +3
   /* version - note sysos2ver() returns version of C: rather than actual bootdrive */
   /*4502.*/
   os.0ver = strip(translate("31524",c2x(charin(os.0bootpath"OS2\INSTALL\SYSLEVEL.OS2",41,2))'.',"12345"),,0)
   call stream bootpath"OS2\INSTALL\SYSLEVEL.OS2", 'c', 'close'
   curpath = directory()
   ecspath = directory(os.0bootpath'ecs')
   select
      when os.0ver<4.51 then os.0ver = 'WARP' os.0ver
      when  translate(ecspath)=os.0bootpath'ECS' then os.0ver = 'eCS' os.0ver
   otherwise os.0ver = 'SWC' os.0ver
   end  /* select */
   call directory(curpath)
   /* program name */
   i = lastpos('\', os.0prgname) + 1
   parse var os.0prgname =(i) os.0prg "."
   /* program running line */
   os.0line = os.0prg prgver 'running' '"'os.0bootpath'"' os.0ver 'on' date() time()
   return



/* wildcard match */
wildcardmatch: procedure
   parse arg wstr, str
   w = pos('*',wstr)
   if w<2 then m = str==wstr
   else m = left(str,w-1)==left(wstr,w-1)
   return m


/*  return true if file succesfully closed */
closeFile:   procedure
   ret = stream(arg(1),'C','CLOSE')
   if ret='READY:' then return 1
   say 'error closing file stream' arg(1) ret
   exit -1
   return 0


/*  return true if file exists */
fileExists:  procedure
   ret = stream(arg(1),'C','QUERY EXISTS')
   if ret='' then return 0
   return 1


/* ͸
     parse options                                                        
        stem    global  delimit.
        string  in      option string to parse (any case)
        stem    out     option stem
   ;  */
ParseOpt: procedure expose delimit.
  use arg sop, option.
  dq = '"'
  quote = translate(sop,delimit.asciiless,delimit.ascii,dq)
  option.KEY = ""
  option.0 = 0
  do forever
    if sop='' then leave
    pdq = pos(dq,quote)
    if pdq>0 then do
      parse var sop keys =(pdq) d +1  str (d) sop
      quote = right(quote,length(sop))
    end
    else do
       keys = sop
       str = ''
       sop = ''
    end
    option.KEY = option.KEY keys
    w = words(keys)
    if w>1 then
      do i  = option.0+1 to option.0+w-1
         option.i = ''
      end /* do */
    i = option.0 + w
    option.i = str
    option.0 = i
  end
  option.key = translate(strip(option.key,'L'))
   return

/* ͸
     true if name exists in option                                        
        string  in      key string to test (upper case)
        stem    in/out  option stem
        bool    ret     if string is a option
   ;  */
GetOpt: procedure
   use arg skey, gopt.
   gopt.pos = wordpos(skey, gopt.KEY)
   return gopt.pos>0
   

/* ͸
     gets option string of key from last GETOPT call, 
    which may be optional and may have a default     

string  in      default string 
        stem    in      option stem
        string  ret     option string or default string or null
   ;  */
GetStrOpt: procedure
   use arg default, gsopt.
   found = gsopt.[gsopt.pos]
   if length(found)=0 then found = default
   return found


/**
CreateDelimiters
create global dynamic delimit stem
stem global delimit.
*/
CreateDelimiters: procedure expose delimit.
delimit.STR = '"' || "'`!@#$%^&"
delimit.asciiless = ''
do i = 32 to 126
   if pos(d2c(i),delimit.Str)=0 then delimit.asciiless = delimit.asciiless || d2c(i)
end /* do */
delimit.ascii = delimit.asciiless || delimit.str
return


/**
WHENSELECTED Make and when test.
    make    in  string  make words (may be empty)
    mwhen   in  string  when words (may be '*')
    return  flag    if okay
    */
whenselected: procedure
   parse arg make, mwhen
   if mwhen='*' then return 1
   if words(make)>0 then do i=1 to words(make)
      if wordpos(word(Make,i),MWhen)>0 then return 1
   end /* do */
   return 0
   


