/* Don't edit this file, as it is generated by 'PPREXX' version 1.0 from the ..\src directory. */
/* Please edit the following:
    ..\src\getclass.cmd
    ..\src\lib.cmd
*/
/*  ͻ
      GETClass gets selected Object Classes                                  
                                                                           
      15/09/03: V1.1 - map datapath                      (gjarvis@ieee.org)
      02/06/03: V1.0 - Initial version (gjarvis@ieee.org)                  
    ͼ */


'@echo off'
prgver = '1.1'
call rxfuncadd sysloadfuncs, rexxutil, sysloadfuncs
call sysloadfuncs
listFile = 'getclass.lst'
datFile = 'getclass.din'

/* statistics */
num.0rd = 0
num.0new = 0
num.0create = 0

_d_ = '"'

call getosver prgver, os.
say os.0line

parse arg parm . '(' opt
opt = translate(opt)
allFlag = wordpos("ALL",opt)>0
if allFlag then datFile = "getclass.all"

/* read list file */
lists.0 = 0
if \allFlag then do
   if fileExists(listfile) then do
      call vback listfile 'backing existing'
      i =   0
      do while lines(listFile)
         i = i + 1
         parse value linein(listfile) with verb rest
         lists.i = translate(verb) rest
      end
      lists.0 = i
      call closeFile listfile
   end /* do */
end

call vback datfile "backing existing"
call stream datfile, 'c', "open write replace"
call lineout datfile, 'from' os.0line



/* Type the list of object classes */
call SysQueryClassList "class."
do i = 1 to class.0
   if allflag then call create class.i
   else do
      parse var class.i name .
      in = inlist(name)
      if in>0 then do
         if pos("INC",lists.in)=1 then call create class.i
         num.0rd = num.0rd + 1
      end /* do */
      else do
         call lineout listfile, "EXC" name
         num.0new = num.0new + 1
      end /* do */
   end /* do */
end

if num.0new>0 then call closeFile listfile
call closeFile datFile
call vback datfile "backing new"
say os.0prgname 'read:' num.0rd 'new:' num.0new 'created:' num.0create
exit 0;




/* return index to lists. with matching -name else returns 0 if nothing matches */
inlist: procedure expose lists. _d_
   parse arg name
   do i = 1 to lists.0
      parse var lists.i lverb lname .
      select
         when lverb='' then iterate
         when pos('*',lverb)=1 then iterate
         otherwise
            if wildcardmatch(lname,name) then return i
      end
   end /* do */
   return 0



/*    create class - write it to datfile */
create:    procedure expose datfile num. os. allFlag lists.
   parse arg class
   class = changestr(os.0bootpath,class,'C:\')
   class = changestr(os.0datapath,class,'D:\')
   call lineout datfile, class
   num.0create = num.0create + 1
   return 1


getosver:procedure expose delimit.
   use arg prgver, os.
   call createdelimiters
   /* program invoked */
   parse upper source . . os.0prgname
   /* bootpath */
   parse value value('PATH',,'OS2ENVIRONMENT') with . ":\OS2;" -1 os.0bootPath +3
   /* datapath */
   parse var os.0prgname os.0datapath +3
   /* version - note sysos2ver() returns version of C: rather than actual bootdrive */
   /*4502.*/
   os.0ver = strip(translate("31524",c2x(charin(os.0bootpath"OS2\INSTALL\SYSLEVEL.OS2",41,2))'.',"12345"),,0)
   call stream bootpath"OS2\INSTALL\SYSLEVEL.OS2", 'c', 'close'
   curpath = directory()
   ecspath = directory(os.0bootpath'ecs')
   select
      when os.0ver<4.51 then os.0ver = 'WARP' os.0ver
      when  translate(ecspath)=os.0bootpath'ECS' then os.0ver = 'eCS' os.0ver
   otherwise os.0ver = 'SWC' os.0ver
   end  /* select */
   call directory(curpath)
   /* program name */
   i = lastpos('\', os.0prgname) + 1
   parse var os.0prgname =(i) os.0prg "."
   /* program running line */
   os.0line = os.0prg prgver 'running' '"'os.0bootpath'"' os.0ver 'on' date() time()
   return



/* wildcard match */
wildcardmatch: procedure
   parse arg wstr, str
   w = pos('*',wstr)
   if w<2 then m = str==wstr
   else m = left(str,w-1)==left(wstr,w-1)
   return m


/*  return true if file succesfully closed */
closeFile:   procedure
   ret = stream(arg(1),'C','CLOSE')
   if ret='READY:' then return 1
   say 'error closing file stream' arg(1) ret
   exit -1
   return 0


/*  return true if file exists */
fileExists:  procedure
   ret = stream(arg(1),'C','QUERY EXISTS')
   if ret='' then return 0
   return 1


/* ͸
     parse options                                                        
        stem    global  delimit.
        string  in      option string to parse (any case)
        stem    out     option stem
   ;  */
ParseOpt: procedure expose delimit.
  use arg sop, option.
  dq = '"'
  quote = translate(sop,delimit.asciiless,delimit.ascii,dq)
  option.KEY = ""
  option.0 = 0
  do forever
    if sop='' then leave
    pdq = pos(dq,quote)
    if pdq>0 then do
      parse var sop keys =(pdq) d +1  str (d) sop
      quote = right(quote,length(sop))
    end
    else do
       keys = sop
       str = ''
       sop = ''
    end
    option.KEY = option.KEY keys
    w = words(keys)
    if w>1 then
      do i  = option.0+1 to option.0+w-1
         option.i = ''
      end /* do */
    i = option.0 + w
    option.i = str
    option.0 = i
  end
  option.key = translate(strip(option.key,'L'))
   return

/* ͸
     true if name exists in option                                        
        string  in      key string to test (upper case)
        stem    in/out  option stem
        bool    ret     if string is a option
   ;  */
GetOpt: procedure
   use arg skey, gopt.
   gopt.pos = wordpos(skey, gopt.KEY)
   return gopt.pos>0
   

/* ͸
     gets option string of key from last GETOPT call, 
    which may be optional and may have a default     

string  in      default string 
        stem    in      option stem
        string  ret     option string or default string or null
   ;  */
GetStrOpt: procedure
   use arg default, gsopt.
   found = gsopt.[gsopt.pos]
   if length(found)=0 then found = default
   return found


/**
CreateDelimiters
create global dynamic delimit stem
stem global delimit.
*/
CreateDelimiters: procedure expose delimit.
delimit.STR = '"' || "'`!@#$%^&"
delimit.asciiless = ''
do i = 32 to 126
   if pos(d2c(i),delimit.Str)=0 then delimit.asciiless = delimit.asciiless || d2c(i)
end /* do */
delimit.ascii = delimit.asciiless || delimit.str
return


/**
WHENSELECTED Make and when test.
    make    in  string  make words (may be empty)
    mwhen   in  string  when words (may be '*')
    return  flag    if okay
    */
whenselected: procedure
   parse arg make, mwhen
   if mwhen='*' then return 1
   if words(make)>0 then do i=1 to words(make)
      if wordpos(word(Make,i),MWhen)>0 then return 1
   end /* do */
   return 0
   


