/* STOPAPP.CMD 

      REXX Program to stop KAT and start STARTAPP.CMD at a particular time.
      This program can be modified to control any OS/2 PM application.
      This program requires REXXUTIL.DLL and APMT 3.5, (Automated PM Tester/Driver version 3.5), a REXX add-on.
      Press Q or q to stop this program.

      Released to Public Domain - feel free to use and modify this code to your content.

      Author: A. Schwarz 
      Date: 4-28-97 
*/


Trace off
call APMT_INIT

IF LoadRexxUtil() THEN
  EXIT

StopTime = '10:00'     /* This is the stop time of the application. Use military time and fill */
                       /* in a zero for single digit hour, i.e 1:00am = 01:00 */

AppName = 'Kat'        /* This is the application to be stopped. This name must match exactly */
                       /* what appears in the window title of the application, upper/lowercase sensitive! */

SAY 'Scheduler Program to stop ' || AppName
SAY 'Stop Time: ' || StopTime
SAY ''
SAY 'Press Q to quit program.'
SAY ''

OldTime = LEFT(TIME(), 5)
SAY "Current Time: " || OldTime

Loop:

CurrTime = LEFT(TIME(), 5)
IF CurrTime <> OldTime THEN
   DO
     SAY "Current Time: " || CurrTime   /* display current time once every minute */
     OldTime = CurrTime
   END

IF StopTime = CurrTime THEN
   DO
     CloseTry = 0
     rc = SELECT_WINDOW(AppName,"10")    /* this checks the window title of the application to be stopped */
     if rc > 0 then
       DO
         say AppName || " not found..."
       END
     else

TryClose:
       DO
          say "Stopping " || AppName || "..."
          /* All done; If the program was started, terminate it */
          rc = SELECT_WINDOW(AppName)
          SAY 'Select to close ' || AppName || ', rc = ' || rc
          rc = SYSMENU_SELECT("Close")

          SAY 'Waiting 30 seconds. Press Q to quit...'
          count = 0
          DO WHILE count < 30
            CALL SysSleep 1           /* wait 30 seconds for program to close, then check again if it is closed */
            count = count + 1
            IF CHARS() <> 0 THEN      /* check if there is a keyboard entry and get key if any */
              DO
                key = SysGetKey('NOECHO')
                IF key = 'q' | key = 'Q' THEN
                EXIT
              END
          END

          rc = SELECT_WINDOW(AppName,"10")   /* make certain application is closed, try no more than 3 times if it does not close */
          if rc > 0 | CloseTry > 3 then
            DO  
              'start STARTAPP.CMD'    /* KAT has been terminated, start STARTAPP.CMD and close this program */
              'exit'
            END
          else
            DO
                /* AppName is still open, attempting to close it... */
               CloseTry = CloseTry + 1
               Signal TryClose
            END

        END

     /******************************************************************/
     /* Part 3: common suffix for all APMT programs                    */
     /******************************************************************/
     APMT_CLOSE:
     rc = END_SESSION();
     /******************************************************************/
     errorexit:
     exit

   END

ELSE

   count = 0
   DO WHILE count < 10
      CALL SysSleep 1           /* wait 10 seconds */
      count = count + 1

      IF CHARS() <> 0 THEN   /* check if there is a keyboard entry and get key if any */
        DO
          key = SysGetKey('NOECHO')
          IF key = 'q' | key = 'Q' THEN
             EXIT
        END
   END

SIGNAL Loop

EXIT

/* Load the RexxUtil library */
LoadRexxUtil:
 IF RxFuncQuery('SysLoadFuncs') THEN
   DO
    IF RxFuncAdd('SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs') THEN
       DO
         SAY "Error: Couldn't load RexxUtil library."
         RETURN 1
       END
       CALL SysLoadFuncs
   END
RETURN 0

DropFUNC:
 call APMTDropFuncs;
 call rxfuncdrop(APMTDropFuncs)
return

APMT_INIT:
call rxfuncadd  'APMTLoadFuncs',  'apmtext', 'APMTLoadFuncs'  /* entry points from the DLL    */
call APMTLoadFuncs;
rc = INIT_SESSION();
if rc \= 0
   then do
     say apmtmsg
     exit
   end

signal on error name  APMT_CLOSE
if apmtver.client \= apmtver.server then
   say 'WARNING: Version mismatch. Client ='apmtver.client 'Server ='apmtver.server
   else say 'Running APMT version 'apmtver.client
signal on halt name APMT_CLOSE
return

