/*
 * Headerfile zu getopt.c
 *
 * Verarbeitung einer rudiment"aren Optionsliste, vor allem der "Ubergabeparameter
 * an eine Applikation.
 *
 * T.J. Domsalla, dommi@rz.tu-clausthal.de T. Schwerdtfeger,
 * apts@rz.tu-clausthal.de
 * Version 1.03, Clausthal, 1991, 1993
 */

#ifndef __GETOPT_H
#define __GETOPT_H

#define GOPT_MAXOPTIONS         64       /* Standardwert f"ur gopt_MAXOPTIONS;
                                          * kann vom Anwender in seinem
                                          * Programm neu gesetzt werden (s.
                                          * gopt_MAXOPTIONS) */
/* WARNUNG: sollte getopt.c mit einem ANSI C Compiler "ubersetzt werden, der
 * keine gr"o"senvariable Arrays zul"a"st, darf gopt_MAXOPTIONS dort nicht ver-
 * wendet werden, stattdessen mu"s HIER GOPT_MAXOPTIONS auf einen entsprech-
 * enden Wert gesetzt und getopt.c mit der Option -DANSIC compiliert werden.
 */

/* m"ogliche R"uckgabewerte von getopt() */
#define GOPT_NO_OPTION          0        /* Keine Option gefunden */
#define GOPT_SIMPLE_OPTION      1        /* einfache Option */
#define GOPT_SARG_OPTION        2        /* Option mit Zeichenargument */
#define GOPT_ARG_OPTION         3        /* Option mit Stringargument */
#define GOPT_IS_SIMPLE_STRING   4        /* keine Option, sondern String */
#define GOPT_ERROR              ( (unsigned char)254)    /* Fehler */
#define GOPT_FINISHED           ( (unsigned char)255)    /* FERTIG! */

#if !defined(NULL)
#define NULL    ((void *) 0)
#endif

/* Argument einer Option (Zeichen oder String) */
union gopt_Arg
  {
    char     c;                          /* Optionsargument ist Zeichen */
    char    *s;                          /* Optionsargument ist String */
  };

#endif

extern int gopt_MAXOPTIONS;              /* Maximalzahl der von getopt_env()
                                          * einzulesenden Optionen */
extern char *goptVektor;                 /* Vektor der m"oglichen Optionen */

char     getopt (int argc, char **argv, char *program_name);
char     getopt_env (char *name, char *program_name);

