
/*+
    Name:       pcx.h
    Author:     Kent J. Quirk
    Abstract:   This file contains information required when handling
                PCX files.
-*/

/********************
    Need these to handle the PCX data below.
*********************/
typedef unsigned char BYTE;
typedef unsigned int  WORD;

/********************
    This is the definition of the PCX header.
*********************/
typedef struct {
    BYTE pcx_id;                        /* Always 0x0A for PCX files */
    BYTE version;                       /* Version of the PCX format */
    BYTE encoding;                      /* 1 = RLE (RLL) compression */
    BYTE bpp;                           /* Number of bits per pixel */
    WORD upleftx, uplefty;              /* position of upper left corner */
    WORD lorightx, lorighty;            /* lower right corner (inclusive) */
    WORD display_xres, display_yres;    /* resolution in dpi of display */
    BYTE palette[48];                   /* palette data if it fits */
    BYTE reserved;
    BYTE nplanes;                       /* number of bit planes of data */
    WORD bytesperline;                  /* # bytes in an uncompressed line */
    WORD palletteinfo;
    BYTE reserved2[58];
} PCX_HDR;

/********************
   These two definitions are used to decompress data in the PCX file.
   (The compressed count byte has the top two bits set).
*********************/
#define PCX_COMPRESSED 0xC0
#define PCX_MASK 0x3F

/********************
    These prototypes declare the PCX read subroutines.
*********************/
PCX_HDR *pcx_read_header(PCX_HDR *hdr, FILE *f);
BYTE *pcx_alloc_line(PCX_HDR *hdr);
BYTE *pcx_next_line(PCX_HDR *hdr, BYTE *line, FILE *f);
void pcx_print_header(PCX_HDR *hdr, FILE *f);


