# include <stdio.h>
# include <sys/types.h>

# ifndef lint
static char *rcs_id =
	"@(#) $Header: mp_file.c,v 2.4 89/05/25 08:58:18 mark Exp $";
# endif

# include "mp_head.h"

/*
 * mpage:	a program to reduce pages of print so that several pages
 * 	  	of output appear on one printed page.
 *
 * Written by:
 *   ...!uunet!\                       Mark Hahn, Sr Systems Engineer
 *              >pyrdc!mark            Pyramid Technology Corporation
 * ...!pyramid!/                       Vienna, Va    (703)848-2050
 *
 *
 * Copyright (c) 1988 Mark P. Hahn, Herndon, Virginia
 *  
 *     Permission is granted to anyone to make or distribute verbatim
 *     copies of this document as received, in any medium, provided
 *     that this copyright notice notice is preserved, and that the
 *     distributor grants the recipient permission for further
 *     redistribution as permitted by this notice.
 *
 */

/* $Log:	mp_file.c,v $
 * Revision 2.4  89/05/25  08:58:18  mark
 * rearranged the rcs header keywords for better readability.
 * 
 * Revision 2.3  89/05/22  14:40:59  mark
 * Fixed the type-o in the rcs identification string
 * 
 * Revision 2.2  89/05/22  14:38:02  mark
 * Added rcs identification usable with the "what" program
 * 
 * Revision 2.1  89/05/22  14:31:24  mark
 * New Major Revision
 * 
 * Revision 1.1  89/05/22  14:23:34  mark
 * Initial revision
 *  */

/*
 * do_file converts one file into postscript for output.  The file type is
 * determined then the proper conversion routine is selected.
 */
do_file(fname, asheet, outfd)
 char *fname;
 struct sheet *asheet;
 FILE *outfd;
{
	FILE *fd;
	int firstchr;

	/*
	 * if we have the pr option, then we have to assume it's a text file
	 */
	if (opt_pr) {
		do_pr_file(fname, asheet, outfd);
		return;
	}
	/*
	 * if not using pr(1), open fname and try to figure out what type of
	 * file it is
	 */
	if ((fd = fopen(fname, "r")) == NULL) {
		fprintf(stderr, "%s: cannot open %s\n",
			MPAGE, fname);
		perror(MPAGE);
		return;
	}
	/*
	 * check for the cutomary characters that flag a postscript file
	 */
	if (ps_check(fd)) {
		/*
		 * found the flag signaling PS input
		 */
		do_ps_doc(fd, asheet, outfd);
	} else {
		/*
		 * no postscript flag, print the ascii text
		 */
		do_text_doc(fd, asheet, outfd);
	}
	(void)fclose(fd);
}

/*
 * do_file processes one text file into postscript, but first runs the file
 * through pr(1).
 */
do_pr_file(fname, asheet, outfd)
 char *fname;
 struct sheet *asheet;
 FILE *outfd;
{
	FILE *fd;
	char command[LINESIZE];

	/*
	 * build the proper command based upon a specified
	 * header or not
	 */
	if (opt_doheader) {
		(void)sprintf(command, "pr -l%d -w%d -h \"%s\" %s",
			      asheet->sh_plength, asheet->sh_cwidth,
			      opt_header, fname);
	} else {
		(void)sprintf(command, "pr -l%d -w%d %s",
			      asheet->sh_plength, asheet->sh_cwidth,
			      fname);
	}
	/*
	 * open a pipe to the proper pr(1) command, and pr provides
	 * us with the input
	 */
	if ((fd = popen(command, "r")) == NULL) {
		fprintf(stderr, "%s: cannot create pipe for '%s'\n",
			command);
		perror(MPAGE);
	} else {
		do_text_doc(fd, asheet, outfd);
		(void)pclose(fd);
	}
}

/*
 * do_stdin uses do_????_doc to process the standard input
 */
do_stdin(asheet, outfd)
 struct sheet *asheet;
 FILE *outfd;
{
	FILE *fd;
	char command[LINESIZE];
	char tmpfile[LINESIZE];
	char buffer[LINESIZE];
	int incnt, outcnt;

	if (opt_pr) {
		Debug(DB_STDIN, "%%do_stdin: pr option selects text\n", 0);
		/*
		 * if pr(1) is to be used we need to read the input
		 * and pass it to a pr(1) command which will write
		 * a temporary file; this temporary file will then
		 * be used as input to the do_doc routine
		 */
		(void)strcpy(tmpfile, "/usr/tmp/mpageXXXXXX");
		(void)mktemp(tmpfile);
		if (opt_doheader) {
			(void)sprintf(command, "pr -l%d -w%d -h \"%s\"> %s",
				      asheet->sh_plength, asheet->sh_cwidth,
				      opt_header, tmpfile);
		} else {
			(void)sprintf(command, "pr -l%d -w%d > %s",
				      asheet->sh_plength, asheet->sh_cwidth,
				      tmpfile);
		}
		/*
		 * open a pipe to the pr(1) command which will create a
		 * temporary file for convertin into PS
		 */
		if ((fd = popen(command, "w")) == NULL) {
			fprintf(stderr, "%s: cannot create pipe for '%s'\n",
				command);
			perror(MPAGE);
			return;
		}
#ifdef DEBUG
		errno = 0;
		Debug(DB_STDIN, "%% sizeof buffer == %d\n", sizeof buffer);
#endif
		/*
		 * read input to mpage and pass it onto the pr(1) command
		 */
		do {
			incnt = fread(buffer, 1, sizeof buffer, stdin);
			outcnt = fwrite(buffer, 1, incnt, fd);
			Debug(DB_STDIN, "%% incnt == %d,", incnt);
			Debug(DB_STDIN, " outcnt == %d,", outcnt);
			Debug(DB_STDIN, " errno == %d\n", errno);
		} while (incnt && outcnt);
		Debug(DB_STDIN, "%% Done with while\n", 0);
		(void)pclose(fd);
		Debug(DB_STDIN, "%% closed pipe, looking for tmpfile\n", 0);
		/*
		 * now open the temporary file and use do_doc to
		 * convert it to PS
		 */
		if ((fd = fopen(tmpfile, "r")) == NULL) {
			fprintf(stderr, "%s: cannot open %s\n",
				MPAGE, tmpfile);
			perror(MPAGE);
		} else {
			Debug(DB_STDIN, "%% got tmpfile, now do_doc\n", 0);
			do_text_doc(fd, asheet, outfd);
			(void)fclose(fd);
		}
		/*
		 * tidy up by removing our temp file
		 */
		Debug(DB_STDIN, "%% now remove '%s'\n", tmpfile);
		(void)unlink(tmpfile);
	} else {
		/*
		 * check for the cutomary flag at the start of postscript files
		 */
		if (ps_check(stdin)) {
			/*
			 * found the flag signaling PS input
			 */
			Debug(DB_STDIN, "%%do_stdin: is postscript\n", 0);
			do_ps_doc(stdin, asheet, outfd);
		} else {
			/*
			 * no postscript flag, print the ascii text
			 */
			Debug(DB_STDIN, "%%do_stdin: not postscript\n", 0);
			do_text_doc(stdin, asheet, outfd);
		}
	}
}



