#define INCL_WINFRAMEMGR
#define INCL_WINMENUS
#define INCL_WINMESSAGEMGR
#define INCL_WINSYS
#include <os2.h>

#include "dlgsup.h"


/*********************************************************************/
/*                                                                   */
/*  FUNCTION : CenterDlgBox                                          */
/*                                                                   */
/*  Positions the dialog box in the center of the screen             */
/*                                                                   */
/*********************************************************************/

VOID CenterDlgBox( HWND hwnd )
{
  SHORT ix, iy;
  SHORT iwidth, idepth;
  SWP   swp;

  /* Query width and depth of screen device                          */
  iwidth = (SHORT)WinQuerySysValue( HWND_DESKTOP, SV_CXSCREEN );
  idepth = (SHORT)WinQuerySysValue( HWND_DESKTOP, SV_CYSCREEN );

  /* Query width and depth of dialog box                             */
  WinQueryWindowPos( hwnd, (PSWP)&swp );

  /* Center dialog box within the screen                             */
  ix = ( iwidth  - swp.cx ) / 2;
  iy = ( idepth  - swp.cy ) / 2;
  WinSetWindowPos( hwnd, HWND_TOP, ix, iy, 0, 0, SWP_MOVE );
}




/*********************************************************************/
/*                                                                   */
/* FUNCTION: SetSystemMenu                                           */
/*                                                                   */
/* Edit items in the system menu to leave "Move", "Close", and       */
/* "Switch to Task Manager".                                         */
/*                                                                   */
/*********************************************************************/
VOID SetSystemMenu( HWND hwndDlg )
{
  HWND     hwndSysMenu;                 /* sys menu pull-down handle */
  MENUITEM miTemp;                      /* menu item template        */
  SHORT    sItemId;                     /* system menu item ID       */
  SHORT    sItemIndex;                  /* system menu item index    */

  /*******************************************************************/
  /* Get the handle of the system menu pull-down.                    */
  /*******************************************************************/
  hwndSysMenu = WinWindowFromID( hwndDlg, FID_SYSMENU );
  WinSendMsg( hwndSysMenu,
              MM_QUERYITEM,
              MPFROM2SHORT( SC_SYSMENU, FALSE ),
              MPFROMP( (PSZ)&miTemp ));
  hwndSysMenu = miTemp.hwndSubMenu;

  /*******************************************************************/
  /* Remove all items from the system menu pull-down that are no     */
  /* longer wanted.                                                  */
  /*******************************************************************/
  for ( sItemIndex = 0, sItemId = 0; sItemId != MIT_ERROR; sItemIndex++)
  {
    sItemId = SHORT1FROMMR (WinSendMsg( hwndSysMenu,
                                 MM_ITEMIDFROMPOSITION,
                                 MPFROMSHORT( sItemIndex ),
				(MPARAM) 0 ));
    if ( sItemId != MIT_ERROR &&
         sItemId != SC_MOVE   &&
         sItemId != SC_CLOSE  &&
         sItemId != SC_TASKMANAGER )
    {
      WinSendMsg( hwndSysMenu,
                  MM_DELETEITEM,
                  MPFROM2SHORT( sItemId, FALSE ),
                 (MPARAM)NULL );
      sItemIndex--;
    }
  }
}
