/*  
        MAKEPAT 1.0 -=- by Marcus Grber 1992

        Utility for creating OS/2 2.0 patch files for use
        with the system's "PATCH" command.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

FILE *old,*new;
char *newname;

#define BUFSIZE 4096
#define MAXDELTAS 1024
#define MAXLOC 16       /* This is a limit of PATCH */
#define MAXEQUAL 6

unsigned char bufo[BUFSIZE],bufn[BUFSIZE];
struct {
   long loc;
   unsigned len;
} delta[MAXDELTAS+1];
int deltas;

int CompareFiles()
{
        unsigned n1,n2,i,len,equal;
        long loc;

        delta[deltas=0].loc=-1;         /* No patches found yet */
        loc=0;                          /* Beginning of file */
        do {
          n1=fread(bufo,1,BUFSIZE,old); /* Read a mouthfull of both files */
          n2=fread(bufn,1,BUFSIZE,new);
          if(n1!=n2) break;             /* One of the files ran out of data? */
          for(i=0;i<n1 && deltas<MAXDELTAS;i++,loc++)
                                        /* Check entire buffer */
            if(bufo[i]!=bufn[i])        /* Difference found? */
              if(delta[deltas].loc==-1 || delta[deltas].len+equal>MAXLOC-1) {
                                        /* No open location? */
                if(delta[deltas].loc!=-1)
                                        /* Open location too long? */
                  deltas++;             /* Close it */
                delta[deltas].len=1;    /* Start a new one here */
                delta[deltas].loc=loc;
                equal=0;                /* No unchanged bytes inside yet */
              }
              else {                    /* Add difference to open location */
                delta[deltas].len+=equal+1;
                                        /* Add byte (plus unchanged ones) */
                equal=0;                /* Unchanged data has been included */
              }
            else                        /* Data is identical */
              if(delta[deltas].loc!=-1 && ++equal>MAXEQUAL)
                                        /* Worth closing the location? */
                delta[++deltas].loc=-1; /* Close location */
        } while (n1 && n2 && deltas<MAXDELTAS);
                                        /* While still data in both files */
 
        if(n1 || n2) {                  /* Still data left? */
          fputs("MAKEPAT: Files are different sizes or contain too many modifications.\n",stderr);
          return 1;                     /* Must have been an error */
        }
        if(delta[deltas].loc!=-1)       /* Still an open location? */
          deltas++;                     /* Close it */
        return 0;
}

void Locations(char *prefix,FILE *f)
{
        int i,j;

        for(i=0;i<deltas;i++) {         /* Read all locations */
          printf("%s %08lX ",prefix,delta[i].loc);
          fseek(f,delta[i].loc,SEEK_SET);
                                        /* Go to location */
          fread(bufn,delta[i].len,1,f); /* Get location data */
          for(j=0;j<delta[i].len;j++) printf("%02X",bufn[j]);
                                        /* Display hex data */
          puts("");                     /* New line */
        }
        puts("");                       /* Empty line */
}

void CreatePatch()
{
        fseek(old,0,SEEK_END);          /* Seek to end of old file */
 
        printf("; Patch for %s (%ld bytes)\n"
               "FILE %s\n\n",newname,ftell(old),newname);
        Locations("VER",old);           /* Display locations from old file */
        Locations("CHA",new);           /* Display locations from new file */
}

int main(int argc,char *argv[])
{
        if(argc<3) {
           fputs(  "MakePatch 1.0 -=- by Marcus Grber, " __DATE__ "\n"
                 "\nUsage: MAKEPAT oldfile newfile [>patch]\n",stderr);
           return 255;
        }
        if(!(old=fopen(argv[1],"rb")) || !(new=fopen(argv[2],"rb"))) {
           fputs("MAKEPAT: One of the input files cannot be opened.\n",stderr);
           return 1;
        }
        if(CompareFiles()) return 2;
        if(deltas==0) {
           fputs("MAKEPAT: The two files are identical.\n",stderr);
           return 3;
        }
        if((newname=strrchr(argv[2],'\\'))==NULL &&
           (newname=strrchr(argv[2],':'))==NULL)
          newname=argv[2];              /* Pointer to new filename */
        else
          newname++;                    /* Skip separator */
        CreatePatch();
        fclose(new);
        fclose(old);
        return 0;
}
