#define INCL_DOSDEVIOCTL
#define INCL_DOS
#include <os2.h>
#include <stdio.h>
#include <stdlib.h>
#include <memory.h>

#ifndef CDROMDISK_EXECMD 
#define CDROMDISK_EXECMD 0X007A
#endif

#define EX_DIRECTION_IN     0x0001
#define EX_PLAYING_CHK      0x0002

#pragma pack(1)
struct ExecCMD
{ ULONG        ID_code;         // 'CD01'
  USHORT       data_length;     // length of the Data Packet
  USHORT       cmd_length;      // length of the Command Buffer
  USHORT       flags;           // flags
  UCHAR        cmd_buffer[16];  // Command Buffer for SCSI command
};

void apichk(APIRET rc, const char* msg)
{ if (rc)
  { fprintf(stderr, "Error %lu(0x%x) at %s\n", rc, rc, msg);
    exit(rc);
  }
}

int main(int argc, char** argv)
{
  if (argc < 3)
  { puts("Usage: cdspeed2 <drive:> <speed>\n"
         "  Use -1 to set maximum speed.\n"
         "Example: cdspeed2 h: 20\n"
         "Note: requires disk in drive. (OS/2 restriction)");
    return -1;
  }
  int speed = atoi(argv[2]);

  HFILE hf = 0;
  ULONG action = 0;
  APIRET rc = DosOpen(argv[1], &hf, &action, 0, 0, OPEN_ACTION_OPEN_IF_EXISTS,
    OPEN_FLAGS_DASD|OPEN_FLAGS_NOINHERIT|OPEN_SHARE_DENYNONE|OPEN_ACCESS_READWRITE, NULL);
  apichk(rc, "DosOpen");

  printf("Setting spindle speed of drive %s to %i x.\n", argv[1], speed);

  // SET CD-ROM SPEED 12
  static const char ID_code_tmpl[4] = {'C','D','0','1'};
  ExecCMD cmd = { *(ULONG*)ID_code_tmpl };
  ULONG clen;
  speed *= 176;
  cmd.cmd_length = 12;
  cmd.cmd_buffer[0] = 0xbb;
  cmd.cmd_buffer[2] = (UCHAR)(speed >> 8);
  cmd.cmd_buffer[3] = (UCHAR)speed;
  clen = sizeof cmd;
  rc = DosDevIOCtl(hf, IOCTL_CDROMDISK, CDROMDISK_EXECMD, &cmd, sizeof cmd, &clen, NULL, 0, NULL);
  //printf("cmd_len = %u, data_len = %u, clen = %lu, dlen = %lu\n", cmd.cmd_length, cmd.data_length, clen, dlen);

  DosClose(hf);
  apichk(rc, "DosDevIOCtl");
  puts("Done.");
  return 0;  
}
