//
// tcpleds -- TCP trafic monitor on your keyboard LEDs
// started on 13.01.98
// by Oleg Titov [oleg.titov@bigfoot.com]
//
#pragma comment (copyright ,"(c) 1998 by Oleg Titov; June 14, 1998.")
#pragma comment (compiler)
#pragma comment (date)
#pragma comment (timestamp)
//
// Definitions
//
#define INCL_DOSDEVICES   // Device values 
#define INCL_DOSDEVIOCTL  //
#define INCL_DOSERRORS    // Error values 
#define INCL_DOSPROCESS   // for DosSleep
#define TCPV40HDRS        // all magic is her :)
#define NumLock    0x0002 // Key definitions (NumLock)
#define CapsLock   0x0004 // Key definitions (CapsLock)
#define ScrollLock 0x0001 // Key definitions (ScrollLock)
//
// Header files
//
#include <os2.h>
#include <stdio.h>
#include <stdlib.h>
//
// TCP/IP stuff starts here
//
#include <types.h>       // socket related
#include <sys/socket.h>
#include <sys/ioctl.h>   // ioctl related
#include <netinet/tcp.h>
//
// Prototypes
//
VOID APIENTRY CloseAll(ULONG ulTermCode);
//
// some experiments goes here
// i was playing around with some undoc functions
//
//APIRET16 APIENTRY16 WinSetTitle(PSZ String);
//#pragma import (WinSetTitle, , "pmshapi", 93)
//APIRET16 APIENTRY16 WinSetTitleAndIcon(PSZ szTitle, PSZ szIconPath);
//#pragma import (WinSetTitleAndIcon, , "pmshapi", 97)
//
// Usefull variables
//
USHORT keystate = 0x00;
ULONG  keystate_size = sizeof(keystate);

HFILE hf;
ULONG ulAction;
ULONG ulLength;
SHIFTSTATE ss;	// ShiftState, i will use it to get CapsLock state 
		// and to restore LEDs to right state on exit 
		// (the last one is not implemented yet)
int stat;

	ULONG	sleep	= 100; // default sleep time (in ms)
	
	ULONG
		step	=   0; // by default we will see all traffic

	ULONG 
		tcpsend	=   0, 
		tcprcvd	=   0;

	int speed;

	int rc;

	struct tcpstat mystat;
//
// Main()
//
int main(int argc, char *argv[]) {

	// some undoc features os OS/2 :)
	// WinSetTitle("tcp LEDs");

	// needs more work :(
	// WinSetTitleAndIcon("tcp LEDs test", "D:\\Development\\TCPIP\\tcpleds\\green.ico");

	stat = socket(PF_INET, SOCK_RAW, 0); // i need a socket 
					     // (even non-connected)
	// handler for keyboard
	rc = DosOpen("KBD$",
               &hf,
               &ulAction,
               0L,
               0,
               FILE_OPEN,
               OPEN_ACCESS_READONLY|OPEN_SHARE_DENYNONE,
               0);

	// prepare the exit
	DosExitList(EXLST_ADD,(PFNEXITLIST) CloseAll);


	// let's rock that joint
	if(argc > 1) {
	 speed = atoi(argv[1]);
	 if(argc == 3) sleep = atoi(argv[2]);
	 if(sleep < 10) sleep = 10;		// sleep time was too small
	 step = speed * sleep / 1000;		// recalculation of speed
	}
	 
	// from here till friday midnight
	for(;;) {

	// getting statistics for interface
	rc = ioctl(stat, SIOSTATTCP, (caddr_t) &mystat, sizeof(struct tcpstat));

	if(mystat.tcps_sndbyte - step > tcpsend)
		keystate |= ScrollLock;
	else 
		keystate &= ~ScrollLock;

	tcpsend = mystat.tcps_sndbyte;

	if(mystat.tcps_rcvbyte - step > tcprcvd) 
		keystate |= NumLock;
	else 
		keystate &= ~NumLock;

	tcprcvd = mystat.tcps_rcvbyte;

	//check for CapsLock
	ulLength = sizeof(ss);

	rc = DosDevIOCtl(hf,
                   IOCTL_KEYBOARD,
                   KBD_GETSHIFTSTATE,
                   0,
                   0,
                   &ulAction,
                   &ss,
                   sizeof(ss),
                   &ulLength);

	if(ss.fsState & 64) 
		keystate |= CapsLock;
	else 
		keystate &= ~CapsLock;

	//update LEDs

	rc = DosDevIOCtl(hf,            // Handle to device
                    IOCTL_KEYBOARD,     // Category of request
                    KBD_ALTERKBDLED,    // Function being requested
                    (PVOID)&keystate,   // Input/Output parameter list
                    sizeof(keystate),   // Maximum output parameter size
                    &keystate_size,     // Input:  size of parameter list
                                        // Output: size of parameters returned
                    NULL,               // Input/Output data area
                    0,                  // Maximum output data size
                    0);                 // Input:  size of input data area
                                        // Output: size of data returned

	// time to take some rest... whoaaa....
	DosSleep(sleep);

	}// end of for()

	// we will never get here. pitty.
	return 1;
} // end of main()

VOID APIENTRY CloseAll(ULONG ulTermCode){
	// closing keyboard
	DosClose(hf);
	// closing socket
	soclose(stat);

	DosExitList(EXLST_EXIT,0);

}// end of CloseAll()

