/* Rexx by: David DuPre */
/* INSTALL.CMD */
/* Recreate the Weather Robo Icon if it is accidentally deleted */

parse source one two w3
current=directory()      /* Thanks to:Duane A. Chamblee 1/17/96 */
tgtdrv = substr(w3,1,2)

option = "update"
 
call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

address CMD
'@echo off'
call setlocal
target_dir   = ''
szVideoMode = ''
parse arg target_dir szVideoMode

folder_title = 'Element.ary '||'0a'x||'Weather for '||'0a'x||'serious enthusiasts.'

if( target_dir = '' )then
    target_dir = directory()
else do
    if( lastpos( "\", target_dir ) = length( target_dir ) ) then do
        target_dir = left( target_dir, length( target_dir ) - 1 )
    end
end

target_dir = directory( target_dir )
bldDemo = 0

/* Create main folder object */
say 'Building Workplace Shell Element.ary! (was called PM-Weather) Objects...'
classname = 'WPFolder'
title     = folder_title
location  = '<WP_DESKTOP>'
iconparm  = 'ICONFILE=' || target_dir || '\PMWEATHR.ICO;'
setup     = 'OBJECTID=<ELEMENT_ARY_FOLDER>;' || iconparm

call SysCreateObject classname, title, location, setup, 'r'

/* Create the Readme program object */

/* Create a Color Palette */

classname = 'WPColorPalette'
title     = 'Color Palette'
location  = '<ELEMENT_ARY_FOLDER>'
setup =''

call SysCreateObject classname, title, location, setup, 'r'

/* Create a Font Palette */


classname = 'WPFontPalette'
title     = 'Font Palette'
location  = '<ELEMENT_ARY_FOLDER>'
setup =''

call SysCreateObject classname, title, location, setup, 'r'

/* Create the Element-ary program object */

classname = 'WPProgram'
title     = 'Element.ary! for OS/2'||'0a'x||'was PM-WEATHER'
STARTUPDIR= 'current'
location  = '<ELEMENT_ARY_FOLDER>'
setup     = 'EXENAME=' || target_dir || '\pmweathr.exe;' ||,
	    'PROGTYPE=PM;'

call SysCreateObject classname, title, location, setup, 'r'

/* Create Shadows. */

classname = 'WPShadow'
title     = 'Element-ary files'
location  = '<ELEMENT_ARY_FOLDER>'
setup     = 'SHADOWID='|| current||';OBJECTID=<ELEMENT_ARY_FILES>'

call SysCreateObject classname, title, location, setup, 'r'

classname = 'WPShadow'
title     = 'Element-ary Readme.txt'
location  = '<ELEMENT_ARY_FOLDER>'
setup     = 'SHADOWID='|| current||'\Element.txt;OBJECTID=<ELEMENT_ARY_EREADME>'

call SysCreateObject classname, title, location, setup, 'r'

classname = 'WPShadow'
title     = 'Element-ary Order Form'
location  = '<ELEMENT_ARY_FOLDER>'
setup     = 'SHADOWID='|| current||'\Order.txt;OBJECTID=<ELEMENT_ARY_ORDER>'

call SysCreateObject classname, title, location, setup, 'r'

classname = 'WPShadow'
title     = 'Element-ary Legal Issues'
location  = '<ELEMENT_ARY_FOLDER>'
setup     = 'SHADOWID='|| current||'\legal.txt;OBJECTID=<ELEMENT_ARY_LEGAL>'

call SysCreateObject classname, title, location, setup, 'r'

classname = 'WPShadow'
title     = 'Element-ary MPEG License'
location  = '<ELEMENT_ARY_FOLDER>'
setup     = 'SHADOWID='|| current||'\mpeg_lic.txt;OBJECTID=<ELEMENT_ARY_MPEG_LIC>'

call SysCreateObject classname, title, location, setup, 'r'

classname = 'WPShadow'
title     = 'Element-ary Documentation'
location  = '<ELEMENT_ARY_FOLDER>'
setup     = 'SHADOWID='|| current||'\pmweathr.txt;OBJECTID=<ELEMENT_ARY_DOCUMENTATION>'

call SysCreateObject classname, title, location, setup, 'r'

Say 'Installing extra Utilities included with Element.ary! for OS/2'

'unzip htm2txt1'

   f_name = '<ELEMENT_ARY_FOLDER>'
   p_name = '<HTM2TXT>'

   call SysCreateObject 'WPProgram','HTML to Text',f_name,'OBJECTID='p_name, 'r'
   call SysSetObjectData p_name,'EXENAME=htm2txt.cmd'
   call SysSetObjectData p_name,'PROGTYPE=PM'
   call SysSetObjectData p_name,'ICONFILE='directory()'\htm2txt.ico'

'call makeobj.cmd'

say 'Setup is complete'


exit

/*
 * FileExists
 */
    
FileExists:

return( stream( arg(1), 'c', 'query exists' ) <> '' )

/* add the Weather Robo ICON */
Classname= 'WPProgram'
Title =   'WEATHER from the Internet'
Location =  '<WP_DESKTOP>'
Setup = 'EXENAME='current'\PMWEATHR.EXE;OBJECTID=<PMWTHR>;STARTUPDIR='current';ICONFILE='current'\PMWEATHR.ICO'
result=SysCreateObject(classname,Title,Location,Setup,option)

/*   Turned off for now.  11-96
Classname= 'WPProgram'
Title =   'Weather Robot'
Location =  '<WP_DESKTOP>'
Setup = 'EXENAME='current'\Wthrrobo.EXE;OBJECTID=<WthrRobo>;STARTUPDIR='current';ICONFILE='current'\WthrRobo.ICO'
result=SysCreateObject(classname,Title,Location,Setup,option)
*/


RETURN 0
