#define LINT_ARGS                     /* argument checking enabled          */

#define  INCL_DOS
#define  INCL_GPI
#undef   INCL_GPI
#define  INCL_DEV
#define  INCL_DOSMEMMGR                /* Include standard OS/2 support      */
#define  INCL_DOSMODULEMGR             /* For DosLoadModule                  */
#define  INCL_DOSPROCESS
#define  INCL_GPILCIDS
#define  INCL_WINCOMMON                /* Include Window Management support  */
#define  INCL_WINDOWMGR
#define  INCL_WINSWITCHLIST
#define  INCL_WINPROGRAMLIST
#define  INCL_WINMENUS
#define  INCL_WINWINDOWMGR
#define  INCL_WINMESSAGEMGR
#define  INCL_WINDIALOGS
#define  INCL_WINSTATICS
#define  INCL_WINLISTBOXES
#define  INCL_WINMENUS
#define  INCL_WINSYS
#define  INCL_WINFRAMEMGR
#define  INCL_INCLWINACCELERATORS
#define  INCL_WINPOINTERS
#define  INCL_WINERRORS
#define  INCL_WINSHELLDATA

#define  INCL_WINTYPES
#define  INCL_WINACCELERATORS
#define  INCL_WINBUTTONS
#define  INCL_WINENTRYFIELDS
#define  INCL_WINRECTANGLES
#define  INCL_WINTIMER
#define  INCL_WINSCROLLBARS
#define  INCL_WINHEAP
#define  INCL_SHLERRORS
#define  INCL_WININPUT
#define  INCL_WINHELP
#define  INCL_WINSTDSPIN

#define  INCL_SPL
#define  INCL_SPLP
#define  INCL_SPLERRORS
#define  INCL_SHLERRORS
#define  INCL_DOSERRORS
#define  INCL_WINHOOKS

#include    <os2.h>

#include    <ctype.h>
#include    <stdarg.h>
#include    <stdio.h>
#include    <stdlib.h>
#include    <string.h>
#include    <process.h>
#include    "lpr32.h"

CHAR  szDefaultPortDrvPath[] = { PATH_LPR32_PDR };

BOOL GetPortDescription ( HAB hab,
                          HMODULE hModule,
                          PSZ pszPortName,
                          PSZ pszPortDesc )
{
   USHORT usID;
   CHAR   chBuf[STR_LEN_PORTDESC] = {0};

   for (usID = PORT_ID_FIRST; usID <= PORT_ID_LAST; usID += 2)
   {
      WinLoadString(hab, hModule, usID, STR_LEN_PORTNAME, chBuf);
      if (!strcmp (pszPortName, chBuf))
      {
         if ( WinLoadString(hab, hModule, usID+1, STR_LEN_PORTDESC, chBuf) ) {
            strcpy (pszPortDesc, chBuf);
            return(TRUE);
         }
         break;
      }
   }
   return(FALSE);
}

BOOL  GenerateUniquePortName( PSZ pszPortName )
{
    BOOL   fPortExists;
    PSZ    pszEndPortName;
    USHORT i;
    CHAR   chPortData[STR_LEN_PORTNAME];

    /*
    ** Generate a unique port name by adding numbers to the
    **   end of pszPortName
    */
    pszEndPortName = pszPortName + strlen( pszPortName );
    i = 1;
    fPortExists = TRUE;
    while ( (i < MAX_PORTS) && fPortExists )
    {
       _itoa( i, pszEndPortName, 4);
       fPortExists = PrfQueryProfileString (HINI_SYSTEMPROFILE,
                                            APPNAME_PM_SPOOLER_PORT,
                                            pszPortName,
                                            NULL,
                                            chPortData,
                                            sizeof(chPortData) - 1);
       i++;
    }
    return(!fPortExists);
}

APIRET APIENTRY SplPdInstallPort ( HAB hab,
                                   PSZ pszPortName )
{
   CHAR    chBuf[STR_LEN_PORTNAME];
   CHAR    chPortDesc[STR_LEN_PORTDESC];
   ULONG   ulBootDrive;
   HMODULE hModule;
   CHAR    szPathName[260];    /* will contain full path to this port driver */

   if (!pszPortName)
   {
      return(ERROR_INVALID_PARAMETER);
   }
   strcpy(szDefaultPortDrvPath,PATH_LPR32_PDR);
   DosQuerySysInfo (QSV_BOOT_DRIVE, QSV_BOOT_DRIVE, &ulBootDrive,
                    sizeof (ULONG));
   szDefaultPortDrvPath[0] = (CHAR)(ulBootDrive + 'A' - 1);
   strcpy( szPathName, szDefaultPortDrvPath );

   /* Make sure the port driver itself is installed */
   PrfWriteProfileString (HINI_SYSTEMPROFILE,
                          "PM_PORT_DRIVER",
                          "LPR32",
                          szDefaultPortDrvPath);

   /* Generate appname for "PM_LPRx" */
   strcpy (chBuf, APPNAME_LEAD_STR);
   strcat (chBuf, pszPortName);

   /*
   ** Check for this being our default Port Name to install.
   ** If so(pszPortName == "LPR") then generate a unique
   **   port name so that we can install multiple LPR32 printers.
   */
   if (!strcmp(pszPortName, DEF_PORTNAME))
   {
      /*
      ** Use chBuf to store the new portname to install
      ** Must first increment past "PM_" in chBuf
      */
      pszPortName = chBuf + 3;
      if (!GenerateUniquePortName( pszPortName )) return 1;
   }

   /* Get port description (fall back to portname if unavailable) */
   hModule = 0L ;                             /* Init module handle to null */
   DosLoadModule (NULL, 0, szPathName, &hModule);
   if (!GetPortDescription (hab, hModule, pszPortName, chPortDesc))
   {
      strcpy( chPortDesc, pszPortName );
   }
   DosFreeModule (hModule);

   if (!PrfWriteProfileString (HINI_SYSTEMPROFILE,
                               chBuf,
                               KEY_DESCRIPTION,
                               chPortDesc))
   {
      return (WinGetLastError (hab));
   }

   if (!PrfWriteProfileString (HINI_SYSTEMPROFILE,
                               chBuf,
                               KEY_INITIALIZATION,
                               DEF_INITIALIZATION))
   {
      return (WinGetLastError (hab));
   }

   if (!PrfWriteProfileString (HINI_SYSTEMPROFILE,
                               chBuf,
                               KEY_TERMINATION,
                               DEF_TERMINATION))
   {
      return (WinGetLastError (hab));
   }

   if (!PrfWriteProfileString (HINI_SYSTEMPROFILE,
                               chBuf,
                               KEY_PORTDRIVER,
                               DEF_PORTDRIVER))
   {
      return (WinGetLastError (hab));
   }

   if (!PrfWriteProfileString (HINI_SYSTEMPROFILE,
                               chBuf,
                               KEY_TIMEOUT,
                               DEF_TIMEOUT))
   {
      return (WinGetLastError (hab));
   }
   if (!PrfWriteProfileString (HINI_SYSTEMPROFILE,
                               APPNAME_PM_SPOOLER_PORT,
                               pszPortName,
                               DEF_INITIALIZATION))
   {
      return (WinGetLastError (hab));
   }
   return(NO_ERROR);
}

int main(int argc,char **argv)
{
  APIRET rc;
  HMQ    hmq;
  HAB    hab;
  USHORT i;
  SHORT  j;
  UCHAR  port[256];
  ULONG  ulPType;
  PPIB   ppib;
  PTIB   ptib;

  if ((argc != 2) || (strnicmp(argv[1], "/?", 2) == 0 ))
    {
       printf("Usage: LPRINST x\nWhere x is the number of ports to install (1..64)\n\r");
       exit(-1);
    }

  j = atoi(argv[1]);
  if (j < 1 || j > 64)
    {
       printf("Invalid param must be 1..64\n\r");
       exit(-1);
    }

  /* Initalize PM */
  DosGetInfoBlocks( &ptib, &ppib );
  ulPType = ppib->pib_ultype;
  ppib->pib_ultype = 3;
  hab = WinInitialize(0);
  hmq = WinCreateMsgQueue( hab , 0);

  for(i=1;i<=j;i++)
    {
      rc = SplPdInstallPort ( hab,"LPR");
    }

  WinDestroyMsgQueue(hmq);
  WinTerminate( hab );
  ppib->pib_ultype = ulPType;
  return 0;
}
