/*
inetsmp.cmd
Copyright 2000 by Chuck McKinnis,  Sandia Park, NM (USA) 04 Feb 2000
mckinnis@attglobal.net

REXX Program to set sample data for inetcfg.cmd, inetlog.cmd, and ijoylog.cmd
*/
Trace 'N'
Parse Upper Arg type

data_queue = Rxqueue('Create')
old_queue = Rxqueue('Set', data_queue)

Do While queued()
   Parse Pull .
End

Select
   When type = 'CONFIG' Then
      Do
         Queue ';Inetlog configuration file'
         Queue ';   This file is read at startup to provide parameters'
         Queue ';   for the inetlog.cmd and the ijoylog.cmd'
         Queue '[COMMON]'
         Queue '; process IBM dialer logs (1 = yes, 0 = no)'
         Queue 'ibm_dialer ='
         Queue '; process InJoy dialer logs (1 = yes, 0 = no)'
         Queue 'injoy_dialer ='
         Queue '; path to data files - normally x:\inetlog\data'
         Queue 'data_path ='
         Queue '; display daily reports (1 = yes, 0 = no)'
         Queue 'daily_report = 0'
         Queue '; pause as the screen fills (1 = yes, 0 = no)'
         Queue 'one_screen_at_a_time = 1'
         Queue '; warn if the IBM dialer log exceeds this percentage of the size'
         Queue 'warn_pct = 85'
         Queue '; Leading digits for connects, minutes, hours per day or month'
         Queue ';    You should not need to change these.  If you exceed 9,999'
         Queue ';    connects, 9,999,999 minutes, or 999,999 hours per period'
         Queue ';    you will crash, but then I think you have other problems'
         Queue '; significant digits for connects/day or conects/month'
         Queue 'sig_x = 4'
         Queue '; ... for minutes/day or minutes/month'
         Queue 'sig_min = 7'
         Queue '; ... for hours/day or hours/month'
         Queue 'sig_hr = 6'
         Queue '[INETLOG]'
         Queue '; name of the IBM dialer ini file'
         Queue 'ibm_dialer_ini_file ='
         Queue '; output file for IBM dialer detail report'
         Queue 'ibm_output_file = inetlog.log'
         Queue '; output file for IBM dialer summary report'
         Queue 'ibm_summary_file = inetsum.log'
         Queue '; time stamp for last processed record of IBM dialer log'
         Queue 'ibm_last_time_stamp = T00000000000000'
         Queue '[IJOYLOG]'
         Queue '; path(s) to the InJoy dialer log file(s)'
         Queue 'injoy_logs ='
         Queue '; account(s) for the InJoy dialer log file(s)'
         Queue 'injoy_accts ='
         Queue '; users(s) for the InJoy dialer log file(s)'
         Queue 'injoy_users ='
         Queue '; time stamp(s) for the InJoy dialer log file(s)'
         Queue 'injoy_times ='
         Queue '; output file for InJoy dialer detail report'
         Queue 'injoy_output_file = ijoylog.log'
         Queue '; output file for InJoy dialer summary report'
         Queue 'injoy_summary_file = ijoysum.log'
      End
   When type = 'SUMMARY' Then
      Do
         Queue '* The purpose of this file is to maintain monthly summaries across'
         Queue '* pruning of the connection log'
         Queue '*'
         Queue '* The format of the file is:'
         Queue '*'
         Queue '*     account userid * year month time-stamp sessions minutes'
         Queue '*     for example: usinet chmckin * 1995 01 T19950131235959 1 1.00'
         Queue '*        (the time-stamp is in the form'
         Queue '*         year || month || day || hour || minute || second'
         Queue '*         prefixed by a "T" to'
         Queue '*         force character compares)'
         Queue '*'
         Queue '* An "*" in column 1 indicates a comment. Comments and blank lines will'
         Queue '* not be processed'
         Queue '*'
         Queue '* If your first run of INETLOG does not provide the monthly summaries that'
         Queue '* you want, you may want to re-format monthly entries from the old'
         Queue '* inetlog file, normally called inetlog.$$$, into this file.  If the'
         Queue '* month has ended set the time stamp to the highest possible timestamp'
         Queue '* value for that month as shown below.'
         Queue '*'
         Queue '* 1995 Dec   15X     131.63 mins        2:11:37      2.19 hrs - Ave =  9 mins'
         Queue '* unknown unknown * 1995 12 T19951231235959 15 131.63'
         Queue '* 1996 Jan  178X    2341.83 mins       39:01:49     39.03 hrs - Ave = 13 mins'
         Queue '* unknown unknown * 1996 01 T19960131235959 178 2342.83'
      End
   Otherwise Nop
End

Return data_queue
