INETD(8)         UNIX System Manager's Manual, OS/2 Edition          INETD(8)

NAME
     inetd - internet ``super-server''

SYNOPSIS
     inetd [-d] [configuration file]

DESCRIPTION
     Inetd should be run at boot time by the TCP/IP startup script.  It then
     listens for connections on certain internet sockets.  When a connection
     is found on one of its sockets, it decides what service the socket corre-
     sponds to, and invokes a program to service the request.  After the pro-
     gram is finished, it continues to listen on the socket (except in some
     cases which will be described below).  Essentially, inetd allows running
     one daemon to invoke several others, reducing load on the system.

     The option available for inetd:

     -d      Turns on debugging.

     Upon execution, inetd reads its configuration information from a configu-
     ration file which, by default, is /etc/inetd.cnf. There must be an entry
     for each field of the configuration file, with entries for each field
     separated by a tab or a space.  Comments are denoted by a ``#'' at the
     beginning of a line.  There must be an entry for each field.  The fields
     of the configuration file are as follows:

           service name
           socket type
           protocol
           wait/nowait
           user
           server program
           server program arguments

     The service-name entry is the name of a valid service in the file
     /etc/services. For ``internal'' services (discussed below), the service
     name must be the official name of the service (that is, the first entry
     in /etc/services).

     The socket-type should be of ``stream'' or ``dgram'', depending on 
     whether the socket is a stream or datagram socket.

     The protocol must be a valid protocol as given in /etc/protocols. OS/2
     only supports ``tcp''.

     The wait/nowait entry is applicable to datagram sockets only (other sock-
     ets should have a ``nowait'' entry in this space).  If a datagram server
     connects to its peer, freeing the socket so inetd can received further
     messages on the socket, it is said to be a ``multi-threaded'' server, and
     should use the ``nowait'' entry.  For datagram servers which process all
     incoming datagrams on a socket and eventually time out, the server is
     said to be ``single-threaded'' and should use a ``wait'' entry.  Com-
     sat(8) (biff(1))  and talkd(8) are both examples of the latter type of
     datagram server.  Tftpd(8) is an exception; it is a datagram server that
     establishes pseudo-connections.  It must be listed as ``wait'' in order
     to avoid a race; the server reads the first packet, creates a new socket,
     and then forks and exits to allow inetd to check for new service requests
     to spawn new servers.

     The user entry should contain the user name of the user as whom the serv-
     er should run.  This allows for servers to be given less permission than
     root. On OS/2, this parameter only looks up the working directory from
     /etc/passwd and sets the environment variable ``LOGNAME''.

     The server-program entry should contain the pathname of the program which
     is to be executed by inetd when a request is found on its socket.  If
     inetd provides this service internally, this entry should be
     ``internal''.

     The serverprogram arguments should be just as arguments normally are,
     starting with argv[0], which is the name of the program.  If the service
     is provided internally, the word ``internal'' should take the place of
     this entry. On OS/2, sockets are not represented as file handles but must
     be passed on to the child application in the command line. The string
     ``%s'' is replaced by the actual socket number.

     Inetd provides several ``trivial'' services internally by use of routines
     within itself.  These services are ``echo'', ``discard'', ``chargen''
     (character generator), ``daytime'' (human readable time), and ``time''
     (machine readable time, in the form of the number of seconds since mid-
     night, January 1, 1900).  All of these services are tcp based.  For de-
     tails of these services, consult the appropriate RFC from the Network In-
     formation Center.

     Inetd rereads its configuration file when it receives an interrupt
     signal. Services may be added, deleted or modified when the configuration
     file is reread.  Inetd creates a file /etc/inetd.pid that contains its
     process identifier.

SEE ALSO
     comsat(8),  fingerd(8),  ftpd(8),  rexecd(8),  rlogind(8),  rshd(8),
     telnetd(8),  tftpd(8)

HISTORY
     The inetd command appeared in 4.3BSD.

4.3 Berkeley Distribution       March 16, 1991                               2
