/*************************************************************************/
/*  CARRIE R. LUST installation file - Creates a wps-object for C.R.L.   */
/*  To run this file, just type "install" on the OS/2 command line.      */
/*************************************************************************/

PARSE SOURCE operSystem . sourceFile

IF \(operSystem = "OS/2") THEN DO
    SAY "Please use only with IBM-OS/2 Operating system!"
    EXIT
    END

/*************************************************************************/

'@ECHO OFF'

CALL rxfuncadd 'sysloadfuncs', 'rexxutil', 'sysloadfuncs'
CALL sysloadfuncs

/*************************************************************************/

ClustDir = FILESPEC("drive", sourceFile)FILESPEC("path", sourceFile)

CALL SysFileTree ClustDir"CLUST.EXE",'file','F'
IF file.0 = 0 THEN DO
    SAY "CLUST.EXE was not found in the same directory as ",
    FILESPEC("name",sourceFile)

    DO UNTIL \(file.0 = 0)
        SAY ""
        SAY "Please give the full path to the file CLUST.EXE."
        SAY "(Press ENTER/RETURN alone to exit)"
        PULL ClustDir
        IF ClustDir = "" THEN EXIT
        IF (FILESPEC("drive",ClustDir) = "") | (FILESPEC("path",ClustDir) = "")
        THEN SAY 'You must give a full path in format "d:\path\"'
        ELSE DO
            IF \(SUBSTR(ClustDir,length(ClustDir),1) = "\" )
            THEN ClustDir = ClustDir"\"
            CALL SysFileTree ClustDir"CLUST.EXE",'file','F'
            IF file.0 = 0
            THEN SAY "Can not find" ClustDir"CLUST.EXE there - please give the right directory"
            END
        END
    SAY ""
    END

/*************************************************************************/

setup = 'PROGTYPE=OS2;EXENAME='ClustDir'CLUST.EXE;STARTUPDIR='ClustDir';'
setup = setup'ICONFILE 'ClustDir'CLUST.ICO;'

SAY "* Creating Carrie R. Lust wps-object ..."
check = SysCreateObject('WPProgram', 'Carrie R. Lust 0.73b1', '<WP_DESKTOP>', setup)

IF check = 0 THEN DO
    SAY "* Could not create wps-object!"
    SAY "  (Does perhaps an object for Carrie already exist?)"
    CALL CHAROUT , "* Do you want to update the existing object [Y/N] ? "
    PULL answer
    IF \(SUBSTR(answer,1,1) = "Y") THEN EXIT

    SAY "* Updating Carrie wps-object ..."
    check = SysCreateObject('WPProgram','Carrie R. Lust 0.73b1','<WP_DESKTOP>',setup,"update")

    IF check = 0 THEN DO
        SAY ""
        SAY "* Sorry, object-creation failed again. Aborting ..."
        EXIT
        END
    ELSE DO
        SAY ""
        SAY "* Carrie R. Lust wps-object updated successfully!"
        END
    END
ELSE DO
    SAY ""
    SAY "* Carrie R. Lust wps-object created successfully!"
    END

CALL SysFileTree ClustDir"CLUST.ICO",'file','F'
IF file.0 = 0 THEN DO
    SAY "* CLUST.ICO not found!"
    SAY "  Please set the Carrie R. Lust icon manually."
    SAY ""
    END

/*************************************************************************/

EXIT
