/* bind for OS/2
 * bjorn@mork.no
 */
#define INCL_DOSPROCESS
#include <os2.h>

#define PRIO_PROCESS	0
#define PRIO_PGRP	1
#define PRIO_USER	2

int setpriority(int which, int who, int priority)
{
  return DosSetPriority(PRTYS_PROCESSTREE, PRTYC_NOCHANGE, -(priority*31/20), who) ? -1 : 0;
}

int getpriority(int which, int who)
{
  PTIB ptib;
  PPIB ppib;

  DosGetInfoBlocks(&ptib, &ppib);
  return -(((ptib -> tib_ptib2 -> tib2_ulpri) & 0x00FF)*20/31);
}

int nice(int increment)
{
  int old = getpriority (PRIO_PROCESS, 0);
  setpriority (PRIO_PROCESS, 0, old + increment);
  return old + increment;
}

