/* ndc.c
   A C version of the ReXX version of ndc for the OS/2 port of bind
   using emxkill to send signals to syslogd
*/
#include <stdio.h>
#include <io.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>
#include <process.h>

#if !defined(SIGWINCH)
#define SIGWINCH 20
#endif

#define KILL_PGM "emxkill"

char sys_cmd[1024];

void usage(char *name)
{
  fprintf(stdout, "\nUsage: %s (status|reload|start|stop [ETC]\n\n",
	  name);
  exit(1);
}

void etcnotset(char *name)
{
  fprintf(stdout, "\n%s: getenv(ETC) failed. Cannot continue.\n\n",
	  name);
  exit(1);
}

void notfound(char *pid_file)
{
  fprintf(stdout, "\nPID file '%s' not found. Is syslogd running?\n\n", 
	  pid_file);
  exit(1);
}

void alreadyrunning(char *name, int pid)
{
  fprintf(stdout, "\n%s: start: syslogd (pid %d) already running\n\n", 
	  name, pid);
  exit(1);
}

void send_signal(int sig, int pid, char *text)
{
  int rc;
#if      defined(USE_SYSTEM)
  sprintf(sys_cmd, "%s %d %d", 
	  KILL_PGM, sig, pid);
  rc = system(sys_cmd);
  /*
    fprintf(stdout, "%s\n", sys_cmd);
    */
#else  /*defined(USE_SYSTEM)*/
#if      defined(USE_SPAWN)
  char sig_str[10], pid_str[10];
  sprintf(sig_str, "%d", sig);  
  sprintf(pid_str, "%d", pid);  
  rc = spawnl(P_WAIT, KILL_PGM, KILL_PGM, sig_str, pid_str, (char *)NULL);
  /*
    fprintf(stdout, "spawnl(%d, %s, %s, %s, %s)->%d\n",
    P_WAIT, KILL_PGM, KILL_PGM,sig_str, pid_str, rc);
    */
#else  /*defined(USE_SPAWN)*/
  rc = kill(pid, sig);
#endif /*defined(USE_SPAWN)*/
#endif /*defined(USE_SYSTEM)*/
  if (rc)
    perror("Strange rc from kill");

  fprintf(stdout, "%s(rc=%d)\n", text, rc);
}

int main (int argc, char *argv[])
{
  int pid_no=-1, rc=0;
  FILE *pid;
  char *etc, pid_file[_MAX_PATH];
  
  if ((etc = getenv("ETC")) == NULL)
    {
      if (argc < 3)
	etcnotset(argv[0]);
      else
	etc = argv[2];
    }
  
  strcpy(pid_file, etc);
  strcat(pid_file, "/syslog.pid");
  
  if (argc < 2)
    usage(argv[0]);
  
  if (stricmp(argv[1], "HELP") == 0)
    usage(argv[0]);
  
  if ((pid = fopen(pid_file, "r")) != NULL)
    {
      fscanf(pid, "%d", &pid_no);
      fclose(pid);
    }
  
  if (stricmp(argv[1], "START") == 0) 
    {
      if (pid_no<1)
	{
	  sprintf(sys_cmd, "start /c /win /min syslogd -f %s/syslog.cnf", 
		  etc);
	  rc = system(sys_cmd);
	  fprintf(stdout, "syslogd started(rc=%d)\n", rc);
	  return 0;
	}
      else
	alreadyrunning(argv[0], pid_no);
      return 0;
    }
  
  if (stricmp(argv[1], "STATUS") == 0)
    {
      if (pid_no<1)
	fprintf(stdout, "syslogd is not running\n");
      else
	fprintf(stdout, "syslogd is running (PID %d)\n", 
		pid_no);
      return 0;
    }
  
  if (pid_no < 1)
    notfound(pid_file);
  
  if (stricmp(argv[1], "STOP") == 0)
    { 
      send_signal(SIGKILL, pid_no, "syslogd stopped");
      sleep(5);
      unlink(pid_file);
    }
      
  else if (stricmp(argv[1], "RELOAD") == 0)
    send_signal(SIGHUP, pid_no, "Reloading configuration");
    
  else
    usage(argv[0]);
  
  return 0;
}

