/*
------------------------
Test Quicklist routines
------------------------
*/

parse arg TEMPFILE action ask

if (TEMPFILE = '') then
   TEMPFILE = "quicklst.txt"

if (action = 'replace' && stream('quicklst.dat', 'c', 'query exists') \= '') then do
   if (ask <> "dontask") then do
      say "-------------------------------------------------------------"
      say "|                       W A R N I N G                       |"
      say "-------------------------------------------------------------"
      say "|                                                           |"
      say "|           Current quicklist will be LOST !!!              |"
      say "|                                                           |"
      say "| Are you sure you want to replace the quicklist database ? |"
      say "-------------------------------------------------------------"
      parse upper pull answer .

      if left(answer, 1) \= 'Y' then do
         say "Import aborted - quicklist database not replaced"
         exit
      end
   end

   'del quicklst.dat quicklst.ix*'
end


say "Trying to load/register Internet Adventurer REXX API"
if RxFuncQuery("IARX_Register") <> 0 then do
   rc = RxFuncAdd("IARX_Register","IA_UTILS","IARX_Register")
   if rc <> 0 then do
      say "-------------------------------------"
      say "Error loading Internet Adventurer API"
      say "-------------------------------------"
      exit(1)
   end
end

rc = IARX_Register();
if rc then do
   say "-------------------------------------"
   say "Error loading Internet Adventurer API"
   say "-------------------------------------"
   exit(1)
end

say "Opening database"
ptr = IARX_QOpenDatabase();
if length(ptr) > 0 then do
   say "-------------------------------------"
   say "Opening database gave this:" ptr
   say "-------------------------------------"
   exit(1)
end

say "Database opened"

signal on novalue name handlenovalue
signal on error   name handleerror
signal on syntax  name handleerror

say "-- Importing from" TEMPFILE || "..."
level = 0
parent = 0;
gotstring = 0

parentid.1 = 0

do until lines(tempfile) = 0
   if gotstring = 0 then
      str = linein(TEMPFILE)

   gotstring = 0

   ok = 0

   do until ok = 1 | lines(TEMPFILE) = 0
      if pos('"', str) = 0 then
         ok = 1
      else do
         if right(str, 1) <> '"' then do
            str1 = linein(TEMPFILE)
            str = str || D2C(13) || D2C(10) || str1
         end
         else
            ok = 1
      end
   end

   titlepos = pos("Title:", str)
   if (titlepos <> 0) then do
/*      say "Level" titlepos substr(str, titlepos+8, length(str)-titlepos-8) */

      str1 = linein(TEMPFILE)

      titlepos1 = pos("Title:", str1)

      if titlepos1 <> 0 then do
         /* If we found a title here - then it's because this is a folder */

         q.id = 0
         q.parent = parentid.titlepos
         q.children = 0
         q.type = 0
         q.title = substr(str, titlepos+8, length(str)-titlepos-8)
         q.nick = ""
         q.url = ""

         rc = IARX_QCreate("q");

         if (rc = 0) then do
            say 'The group "' || q.title || '" was created ok' 
         end
         else do
            say 'Error' rc 'creating group "' || q.title || '"' 
         end

         titlepos = titlepos + 1
         parentid.titlepos = q.id

         str = str1;
         gotstring = 1
      end
      else do
         urlpos = pos("URL  :", str1)
         if (titlepos <> 0) then do
/*            say "URL:" substr(str1, urlpos+8, length(str1)-urlpos-8) */

            /* Now, read the nickname */
            str2 = linein(TEMPFILE)

            nickpos = pos("Nick :", str2)

            q.id = 0
            q.parent = parentid.titlepos
            q.children = 0
            q.type = 1
            q.title = substr(str, titlepos+8, length(str)-titlepos-8)
            q.nick = substr(str2, nickpos+8, length(str2)-nickpos-8)
            q.url = substr(str1, urlpos+8, length(str1)-urlpos-8)
   
            rc = IARX_QCreate("q");
            if (rc = 0) then do
               say 'The item "' || q.title || '" was created ok' 
            end
            else do
               say 'Error' rc 'creating item "' || q.title || '"' 
            end

         end
      end
   end
end

say "-- Importing finished"

say "Closing database"
rc = IARX_QCloseDatabase()

rc = lineout(TEMPFILE)

say "Importing completed"
exit(0)

/*
-------------
Handle errors
-------------
Upon entry to this function, the contents of the variables are:
rc   - Error code
sigl - Line number, error occured in.

Now we just display the error code and text followed by the
source-line with the problem
*/

handleerror:

say "REXX Error" rc "in line" sigl ":" errortext(rc);
say "-----";
say "-----" sourceline(sigl);
say "-----";
rc = IARX_QCloseDatabase();
exit;

/*
------------------------------
Handle variables without value
------------------------------
*/
handlenovalue:

say "REXX Error, trying to reference variable with no value in line" sigl;
say "-----";
say "-----" sourceline(sigl);
say "-----";
rc = IARX_QCloseDatabase();
exit;
