/* OS/2 REXX                            */
/* Steve Sharrad, 04/08/96              */
/* INSTALL routine for DASD Utilities.  */
/* Version 1.00                         */

signal on error name no_rexx
call rxfuncadd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
call sysloadfuncs
signal on error name unknown

'cls'
say ' '
say "The HENLEY College IT Services Unit"
say "Steve Sharrad's DASD Utilities - Install 1.00"
say ' ' 
say ' '
say 'The HENLEY College - Committed to excellence in education'
say 'and teaching.'
say ' '
say 'Visit us at http://www.henleycol.ac.uk'
"pause"

'cls'
say ' '
say "The HENLEY College IT Services Unit"
say "Steve Sharrad's DASD Utilities - Install 1.00"
say ' '
say 'These utilities are designed to help network administrators'
say 'manage their disk space on their IBM OS/2 LAN Servers. The'
say 'utilities automate functions and APIs supplied with IBM OS/2'
say 'LAN and Warp Servers and greatly improve the ease of use of'
say 'the IBM DASD (direct access storage device) facilities.'
say ' '
say 'This software is copyright, and is also used at users own risk.'
say 'For more information, see the file README.NOW.'
say ' '
"pause"
say 'You must be running OS/2 2.1 or above.'
say 'You must be running IBM OS/2 Lan Server 4.0'
say 'or IBM Warp Server 4.0 or above.'
say ' '

signal start

start:
say ' '
say 'Which drive does OS/2 reside on ?'
pull os2drive
os2drive=translate(os2drive)
if length(os2drive) \= '1' then do
	say 'You must enter a single drive letter !'
	signal start
	end
signal next2

/*
next1:
say ' '
say 'Which drive does the IBMLAN tree reside on ?'
pull ibmlandrive
ibmlandrive=translate(ibmlandrive)
if length(ibmlandrive) \= '1' then do
	say 'You must enter a single drive letter !'
	signal next1
	end
signal next2

*/

next2:
say ' '
say 'Continue with Install ?'
pull yesno
yesno=translate(yesno)

if yesno \= 'Y' then signal abort

say ' '

os2path=os2drive':\OS2'
/* ibmlanpath=ibmlandrive':\IBMLAN' */

ibmlanpath=os2path
dasdpath=os2path

call sysfiletree os2path,'tree','D'
if tree.0 = 0 then do
	say 'OS/2 path on 'os2drive' not found. Run Install again.'
	signal end
	end

call sysfiletree ibmlanpath,'tree','D'
if tree.0 = 0 then do
	say ibmlanpath 'path not found on 'ibmlandrive'. Run Install again.'
	signal end
	end

say 'Copying Install...'
'@echo off'
cline='copy install.cmd 'dasdpath'\install.cmd >nul'
cline
cline='copy lsrxinst.cmd 'dasdpath'\lsrxinst.cmd >nul'
cline
say 'Copying desktop files...'
cline='copy backdasd.ico 'dasdpath'\backdasd.ico >nul'
cline
cline='copy restdasd.ico 'dasdpath'\restdasd.ico >nul'
cline
cline='copy setdasd.ico 'dasdpath'\setdasd.ico >nul'
cline
cline='copy dasd.ico 'dasdpath'\dasd.ico >nul'
cline
cline='copy anim.ico 'dasdpath'\anim.ico >nul'
cline
say 'Copying program files...'
cline='copy backdasd.cmd 'dasdpath'\backdasd.cmd >nul'
cline
cline='copy restdasd.cmd 'dasdpath'\restdasd.cmd >nul'
cline
cline='copy setdasd.cmd 'dasdpath'\setdasd.cmd >nul'
cline
say 'Copying help files...'
cline='copy backdasd.txt 'dasdpath'\backdasd.txt >nul'
cline
cline='copy restdasd.txt 'dasdpath'\restdasd.txt >nul'
cline
cline='copy setdasd.txt 'dasdpath'\setdasd.txt >nul'
cline
say 'Updating PM desktop...'
param1='OBJECTID=<STEVEDASD>;ICONFILE='dasdpath'\DASD.ICO;ICONNFILE=1,'dasdpath'\ANIM.ICO'
param2='EXENAME='os2path'\E.EXE;PARAMETERS='dasdpath'\BACKDASD.TXT; MINIMIZED=NO; PROGTYPE=PM;ICONFILE='dasdpath'\BACKDASD.ICO;ICONNFILE=1,'dasdpath'\anim.ico'
param3='EXENAME='os2path'\E.EXE;PARAMETERS='dasdpath'\RESTDASD.TXT; MINIMIZED=NO; PROGTYPE=PM;ICONFILE='dasdpath'\RESTDASD.ICO;ICONNFILE=1,'dasdpath'\anim.ico'
param4='EXENAME='os2path'\E.EXE;PARAMETERS='dasdpath'\SETDASD.TXT; MINIMIZED=NO; PROGTYPE=PM;ICONFILE='dasdpath'\SETDASD.ICO;ICONNFILE=1,'dasdpath'\anim.ico'

if SysCreateObject("WPFolder","Steve's DASD Utilities","<WP_DESKTOP>", param1) = '0' then say 'Not updated or desktop already updated.'
if SysCreateObject("WPProgram","BACKDASD Utility", "<STEVEDASD>",param2) = '0' then say 'Not updated or desktop already updated.'
if SysCreateObject("WPProgram","RESTDASD Utility", "<STEVEDASD>",param3) = '0' then say 'Not updated or desktop already updated.'
if SysCreateObject("WPProgram","SETDASD Utility", "<STEVEDASD>",param4) = '0' then say 'Not updated or desktop already updated.'

say 'IMPORTANT NOTE:'
say ' '
say 'Before you can use the DASD utilities, you must install the REXX'
say 'LAN API modules supplied as part of the productivity aids.'
say '(If they are not already installed on your system).'
say ' '
say 'You can either run LSRXINST.CMD (which has just been installed)'
say 'or you may install the file as per the instructions supplied'
say 'on the Lan Server productivity aid disk.'
say ' '
say 'The REXX API file, LSRXUT.DLL, is a productivity'
say 'aid supplied with Lan Server and is copyright IBM.'
say ' '
say 'Completed. Remove the disk from the diskette drive, and'
say 'run LSRXINST off your harddisk, to continue.'
signal end

unknown:
say 'An unkown error has occurred. Try install again. Check all'
say 'locations that you have given are correct. If the problem'
say 'still occurs, then you may copy the files manually.'
signal end

no_rexx:
say 'Could not initialise REXX libraries. Check that you have all OS/2'
say "files installed. These utilities won't work on old versions of OS/2"
say 'which do not have the Extended Sevices built in.'
signal end

abort:
say 'Install aborted by user.'
signal end

end:
