/**********************************************************************/
/* OBJECTIVE: Query remaining space on servers of a given domain      */
/* Date: 22 Aug 1996                                                  */
/* Revision: 8 Jan 1997 : Error handling enhanced. With no parameters,*/ 
/*                        default domain is current  domain.          */
/*           28 Aug 1996: handles nonformatted drives properly        */ 
/*           8 Oct 1996: bug fix                                      */ 
/*           12 Nov 1996: introduced color                            */ 
/*           13 Nov 1996 : new command line arguments                 */      
/*           14 Nov 1996 : handles CD-ROM                             */        
/*           19 Nov 1996 : performs check on libraries                */
/* Version: 1.09                                                      */
/* Author:Daniel Szmulewicz                                           */
/**********************************************************************/

Signal on halt

        /****************Load library files***********************/

If RxFuncQuery('SYSLOADFUNCS') \= 0 Then
  Do
    rc = RxFuncAdd('SYSLOADFUNCS', 'REXXUTIL', 'SYSLOADFUNCS')
    If rc <> 0  then
      Do
        say 'Cannot register library REXXUTIL... Exiting...'
        say 'Please make sure the file REXXUTIL.DLL is in your libpath.'
        exit
      End
    Else
      Call SYSLOADFUNCS
  End

if Rxfuncquery('RxLoadFuncs') \= 0 then
  Do
 rc =  RxFuncAdd('RxLoadFuncs', 'RXUTILS', 'RXLOADFUNCS')
    If rc <> 0  then
      Do
        say 'Cannot register library RXUTILS.. Exiting...'
        say 'Please make sure the file RXUTILS.DLL is in your libpath.'
        exit
      End
    Else
     call RxLoadFuncs('QUIET')
End

    rc = RxFuncAdd('LOADLSRXUTFUNCS', 'LSRXUT', 'LOADLSRXUTFUNCS')
    If rc <> 0  then
      Do
        say 'Cannot register library LSRXUT... Exiting...'
        say 'Please make sure the file LSRXUTIL.DLL is in your libpath.'
        exit
      End
    Else
      Call LOADLSRXUTFUNCS

        /**************Empty queue ****************************************/    

'@rxqueue /clear'

        /***************Initialize color***********************/
'@ansi on 1>nul 2>&1'
redonblue = '1B'x || '[37;44m'
othergreen = '1B'x || '[46;43m'
whiteongreen = '1B'x || '[37;46m'
normal = '1B'x || '[0m'
bright = '1B'x || '[1m'

        /********* Intro ********************/

arg domain server drive

domain = strip(domain)
server = strip(server)
drive = strip(drive)
SELECT
        WHEN domain = '' then
           do
                say 'Please enter domain name, or press ENTER to query current domain.'
                say 'For help, type SrvInfo /help at the command prompt.'    
                pull domain .
           end        
        WHEN pos('?', domain) > 0 | pos('H', domain) > 0 | pos('/', domain) > 0 then
                call usage
        WHEN domain <> '' & server <> '' & drive <> '' then
            do
                Serverlist.number = server
                NETSERVERDISK = 150
                Srvname = '\\'||Serverlist.number
                myRc = NetEnumerate(NETSERVERDISK, 'srvDiskInfo', Srvname)
            
                If myRc <> '0' then do
                    say 'Could not find server' server 'on domain' domain'.'
                    say  'Error ' myRc'.' 
                    call DropLsRxutFuncs
                    exit 9
                end

                If srvDiskInfo.0 = 0 then do
                  say 'No server disk drives'
                  call DropLsRxutFuncs
                  exit 0
                 end

                if length(drive) > 2 then call usage
                if length(drive) = 2 & substr(drive, 2,1) <> ':' then call usage 
                if length(drive) = 2 & substr(drive, 2,1) = ':' then drive = left(drive,1)
                Srvname = '\\'||server
                parse value Sysdrivemap(,'free') with freedrive .
                '@net use 'freedrive Srvname'\'drive||'$ 2>&1 | rxqueue'
                parse pull NetError ':' .
                if left(NetError, 3) = 'NET' then
                    do
                        call lineout, ''
                        call lineout, 'Drive'||bright drive ||normal 'is a back-up tape, is non-formatted, or doesn''t exist...' 
                        '@ECHO Y 2>&1 | net use 'freedrive '/d 1>NUL 2>NUL'
                        exit
                    end
                '@rxqueue /clear'           
                parse value SysDriveInfo(freedrive) with . freespace totalspace driveid
                say 
                if freespace == 0 then
                    do
                        call lineout, 'Drive'||bright drive||normal 'is a CD-ROM.' 
                       '@ECHO Y 2>&1 | net use 'freedrive '/d 1>NUL 2>NUL'    
                        exit
                    end
                if freespace <> '' then 
                    call lineout, 'Drive'||bright drive||normal 'has in total'|| bright Right(Format(totalspace/1048576,,0),5) normal|| 'MB, of which' bright Right(Format(freespace/1048576,,0),4) normal || 'MB is free.'
                else call lineout, 'Drive 't 'is not a valid drive.'
               '@ECHO Y 2>&1 | net use 'freedrive '/d 1>NUL 2>NUL'
                exit    
            end
        WHEN domain <> '' & server <> '' then
            do
                Serverlist.number = server
                NETSERVERDISK = 150
                Srvname = '\\'||Serverlist.number
                myRc = NetEnumerate(NETSERVERDISK, 'srvDiskInfo', Srvname)
            
                If myRc <> '0' then do
                    say 'Could not find server' server 'on domain' domain'. Error 'myRc'.' 
                    call DropLsRxutFuncs
                    exit 9
                end

                If srvDiskInfo.0 = 0 then do
                  say 'No server disk drives'
                  call DropLsRxutFuncs
                  exit 0
                 end

                call WhereOutput
                call shebang
                if output <> 'CON:' then
                call lineout, ''
                exit
            end    
        OTHERWISE nop
END

        /********Get number and names of servers in the domain specified**************/

GetServers:
NETSERVER = 160
SrvType = -1
if domain = '' then
     do
        Parse value Rxuserinfo() with . . domain
        if domain = '' then do
             say 'Can''t query domain. Try manually.'
             exit 
           end 
        myrc = NetEnumerate(NETSERVER, 'serverlist')    /*Get domain controller name*/
        if myrc <> 0 then
              do
                        say 'Error. Domain:' domain||':' myrc
                        say 'Exiting...'
                        exit
              end
        SrvName = '\\'||Serverlist.1
     end
else
     do
        Srvname = RxDCName(domain)        /*Get domain controller name of other domain*/
        if pos('ERROR', Srvname) > 0 then do
                say 'Please make sure the domain you entered is valid:' domain 
                say 'Will exit for now...'
                exit
            end
     end

myrc = NetEnumerate(NETSERVER, 'serverlist', SrvName, SrvType, domain) /*Enumerate servers on domain*/
if myrc <> 0 then
      do
        say 'Error:' myrc
        say 'Exiting...'
        exit
      end
say Serverlist.0 'server(s) were found on specified domain' '('domain').'
say
do i=1 to ServerList.0
        say '       'bright||i||normal||',' Serverlist.i
end


       /**********Get number of disks and drive letters on servers found************/
DO FOREVER
        say
        say 'Please enter the number of the server you want to query,'
        say 'or type "'bright'a'normal'" for all, "'bright'c'normal'" for cancel.'
        number = Sysgetkey(NOECHO)
        number = translate(number)
        SELECT
                WHEN Datatype(number) = 'NUM' & number <= Serverlist.0 then
                     do
                        call WhereOutput
                        call shebang
                        leave
                     end
                WHEN Datatype(number) = 'CHAR' & number = 'A' then
                     do
                        call WhereOutput
                        totalspacedomain = 0
                        totalfreespacedomain = 0
                        do number = 1 to Serverlist.0
                        call shebang
                        totalspacedomain = totalspacedomain + totalspace
                        totalfreespacedomain = totalfreespacedomain + freespace
                         end
                         if output = 'CON:' then 
                                do
                         call lineout output, bright||'Total'||normal' occupied space on domain'||bright domain ||normal' is'bright Right(Format(totalspacedomain/1048576,,0),8)||normal 'MB.'
                         call lineout output, bright||'Total'||normal' free space on domain'||bright domain ||normal' is    'bright||othergreen Right(Format(totalfreespacedomain/1048576,,0),8)||normal 'MB.'
                                end    
                         else   
                                do
                         call lineout output, 'Total occupied space on domain' domain 'is' Right(Format(totalspacedomain/1048576,,0),8) 'MB.'
                         call lineout output, 'Total free space on domain' domain 'is    ' Right(Format(totalfreespacedomain/1048576,,0),8) 'MB.'
                                end    
                         leave
                      end
                WHEN Datatype(number) = 'CHAR' & number ='C' then
                      exit
                OTHERWISE
                   do
                        say 'You did not type valid input.'
                        say 'Come again...'
                        flag = 1
                        ITERATE
                  end
        END
END

rc =lineout(output)
if output <> 'CON:' then
    call lineout, ''
call DropLsRxutFuncs
call RxFuncDrop 'LoadLsRxutFuncs'
'@rxqueue /clear'
exit

shebang:
NETSERVERDISK = 150
Srvname = '\\'||Serverlist.number
myRc = NetEnumerate(NETSERVERDISK, 'srvDiskInfo', Srvname)

If myRc <> '0' then do
  say 'Got error from NetEnumerate() ' myRc
  call DropLsRxutFuncs
  exit 9
 end

If srvDiskInfo.0 = 0 then do
  say 'No server disk drives'
  call DropLsRxutFuncs
  exit 0
 end

call lineout output, ''
if output = 'CON:' then
    call lineout output, '        Server' bright||Serverlist.number||normal 'has' bright||(srvDiskInfo.0 - 2)||normal 'disk drives:'
else
    call lineout output, '        Server' Serverlist.number 'has' (srvDiskInfo.0 - 2) 'disk drives:'
call lineout output, ''

 do i=1 to srvDiskInfo.0
        /*say srvDiskInfo.i*/
        srvdiskletter.i = left(SrvDiskinfo.i, 1)
 end

        /************Calculate Free Space*************/
/*trace '?i'*/
parse value Sysdrivemap(,'free') with freedrive .
do i=3 to SrvDiskInfo.0
        '@rxqueue /clear'
        '@net use 'freedrive Srvname'\'SrvDiskletter.i||'$ 2>&1 | rxqueue'
        parse pull NetError ':' .
        if left(NetError, 3) = 'NET' then
          do
            if output = 'CON:' then
            call lineout output, 'Drive'||bright SrvDiskletter.i||normal 'is unknown (back-up tape, non-formatted HD...).' 
            else
                do
                    call lineout output, 'Drive' SrvDiskletter.i 'is unknown( back-up tape, non-formatted...).'
                    call Statuscursor
                end    
            totalspace.i = 0
            freespace.i = 0 
            ITERATE i
          end
        parse value SysDriveInfo(freedrive) with . freespace.i totalspace.i driveid
        if freespace.i == 0 then
            do
                totalspace.i = 0    
                if output = 'CON:' then do
                    call lineout output, 'Drive'||bright SrvDiskletter.i||normal 'is a CD-ROM.' 
                   '@ECHO Y 2>&1 | net use 'freedrive '/d 1>NUL 2>NUL'
                    end
                    else
                        do
                            call lineout output, 'Drive' SrvDiskletter.i 'is a CD-ROM.'
                            '@ECHO Y 2>&1 | net use 'freedrive '/d 1>NUL 2>NUL'      
                            call Statuscursor
                        end    
                iterate i                    
            end
        if output   = 'CON:' then
        call lineout output, 'Drive'||bright SrvDiskletter.i||normal 'has in total'|| bright Right(Format(totalspace.i/1048576,,0),5) normal|| 'MB, of which' bright Right(Format(freespace.i/1048576,,0),4) normal || 'MB is free.'
        else
            do
                call lineout output, 'Drive' SrvDiskletter.i 'has in total' Right(Format(totalspace.i/1048576,,0),5) 'MB, of which' Right(Format(freespace.i/1048576,,0),4) 'MB is free.'
                call StatusCursor
            end
        '@ECHO Y 2>&1 | net use 'freedrive '/d 1>NUL 2>NUL'
end
freespace = 0
totalspace = 0

do i=3 to SrvDiskInfo.0
        totalspace = totalspace + totalspace.i
        freespace = freespace + freespace.i
end
call lineout output, ''
if output   = 'CON:' then
    do
call lineout output, '    Total absolute space is' bright Right(Format(totalspace/1048576,,0),6)|| normal 'MB.'
call lineout output, '    Total free space is    ' bright || whiteongreen Right(Format(freespace/1048576,,0),6)||normal 'MB.' 
    end
else
    do
call lineout output, '    Total absolute space is' Right(Format(totalspace/1048576,,0),6) 'MB.'
call lineout output, '    Total free space is    ' Right(Format(freespace/1048576,,0),6) 'MB.'
    end
call lineout output, ''
call lineout output, Copies('*',59)
return

        /***************** Unload library files ***********************/

WhereOutput:
DO FOREVER
say 'Where do you want the output to be displayed?'
say '('bright'F'normal')ile, default ('bright'P'normal')rinter, or just press 'bright'ENTER'normal' for screen output'
output = Sysgetkey(NOECHO)
output = translate(output)
SELECT
        WHEN output = 'F' then
          do
                output = 'srvinfo.logfile'
                rc = Sysfiledelete(output)
                say
                call charout, ' Writing '||bright'"srvinfo.logfile"'||normal' in current directory...'
                parse value syscurpos() with row col              
                call lineout output, Copies('*',59)
                call lineout output, 'Logfile by SrvInfo'
                call lineout output, Copies('*',59)
                return
          end
        WHEN output = 'P' then
          do
                output = 'PRN:'
                say
                call charout, '  'bright'Sending output to LPT1'||normal||'...'
                parse value syscurpos() with row col              
                call lineout output, Copies('*',59)
                call lineout output, 'Print-out from SrvInfo'
                call lineout output, Copies('*',59)
                return
          end
        WHEN output = '0D'x then
          do
                output = 'CON:'
                call SysCls
                return
          end
        OTHERWISE
          do
                Say 'You did not enter valid input.'
                Say 'Try again...'
               ITERATE
          end
END
END

                /***************************/
Statuscursor:                                     
/*trace 'i'*/                                     
if h = 'H' then
    h = col - 1
else nop
h = h + 1
pos = syscurpos(row, h)
call charout, '.' 
return                                            

            /*********************************/
usage:
                say
                say '  'bright'SrvInfo.cmd version 1.07'normal
                say
                say  
                say '      Purpose: Queries free space on server drives.' 
                say
                say '      Usage:'
                say
                say '                'redonblue||bright'SrvInfo [Domain] [Server] [Drive]'normal
                say 
                say          
                say '                 Examples:'
                say '                                SrvInfo'               
                say '                       or:'
                say '                                SrvInfo M024D001'   
                say '                       or:'        
                say '                                SrvInfo M024D001 M024S001'
                say '                       or:'                
                say '                                SrvInfo M024D001 M024S001 E:'
                say 
                say '   Note: If you don''t specify any option, SrvInfo'
                say '           will assist you in the parameter specification.'
                say 
                say 'Enjoy!'
                exit

            /*****************************/

Halt:
'@ECHO Y 2>&1 | net use 'freedrive '/d 1>NUL 2>NUL'
'@rxqueue /clear'
say
say 'Program interrupted by user, exiting...'
exit

