/*-----------------------------------------------------------------*/
/* This program assumes that a connection to TCP/IP has already    */
/* been established before its execution.                          */
/*-----------------------------------------------------------------*/

FROM_NAME = 'Gary L. Robinson <grobin@erinet.com>'
fileout = 'ipadr.doc'

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'; call SysLoadFuncs

'@hostname.exe | RxQueue'   /* The command whose output is being trapped. */
Do While Queued() > 0
  Parse Pull hostname
  End
say 'My hostname is' hostname
'@set hostname=' || hostname

'@netstat -a | RxQueue'   /* The command whose output is being trapped. */
Do While Queued() > 0
  Parse Pull ifdef
  parse var ifdef 'addr' ipaddr 'interface' ifnum . 'broadcast' ipdest
  if ifnum>9 then do
    ipaddr = strip(ipaddr)
    ipdest = strip(ipdest)
    say 'For interface' ifnum', my address is' ipaddr
    say '         destination address is' ipdest
    end
  end
 

call LINEOUT fileout, 'From:' FROM_NAME, 1
call LINEOUT fileout, 'Subject: Ping! This is my current I.P. address'
call LINEOUT fileout, 'X-Mailer: Send IP address Utility'
call LINEOUT fileout, ''
call LINEOUT fileout, 'Ping! Ping! Ping! Ping! Ping! Ping! Ping!'
call LINEOUT fileout, 'If you are on the net call me on Intercom .....'
call LINEOUT fileout, ''
call LINEOUT fileout, 'my IP address is : 'ipaddr
call LINEOUT fileout

call SysDropFuncs

 Call READ_DEFAULTS_FILE "defaults.txt"

 ret_code     = 0
 defserver    = def.SMTP_SERVER
 defuser      = def.TARGET_ADDRESS
 deffile      = def.NOTE_FILE

 port         = def.SMTP_PORT
 reconnect    = def.RECONNECT_AFTER
 timezone     = def.TIME_ZONE
 connecttime  = def.CONNECT_TIME
 downloadtime = def.DOWNLOAD_TIME
 idletime     = def.IDLE_TIME

 Parse Arg args

 /*----------------------------------------------------------*/
 /* load the needed functions and check the input parameters */
 /*----------------------------------------------------------*/
 ret_code = Init_Cmd(args) 
 if ret_code = 0 then do
   /*----------------------------------*/
   /* Call a routine to connect to the */
   /* SMTP mail server                 */
   /*----------------------------------*/
   socket = CONNECT_TO_SMTP(server,port,connecttime,idletime)
   if socket > 0 then do
     /*----------------------------------------------------------*/
     /* the connection (socket) number must be saved and used    */
     /* each time you wish to issue a command to the TCP/IP host */
     /*----------------------------------------------------------*/
  
     /*-----------------------------------------*/
     /* determine how many "send to"s there are */
     /* i.e. is the submitted value an id or a  */
     /* list of userids.                        */
     /*-----------------------------------------*/
     if GET_SEND_TO_LIST(userid) > 0 then do
       /*----------------------------------------*/
       /* Read the note text file plucking out   */
       /* the "From:" address and assigning      */
       /* the note date value.                   */
       /*----------------------------------------*/
       if READ_NOTE_FILE(appfile,timezone) > 0 then do
         /*-------------------------------------------------*/
         /* loop thru the sendto userids and send the notes */
         /*-------------------------------------------------*/
         do i = 1 to sendto.0
           userid = sendto.i

           Call RxIpConsSay 'Working on ('i' of 'sendto.0')...'userid

           /*---------------------------------------*/
           /* call a rexx function to send the note */
           /*---------------------------------------*/
           ret_code = SEND_NOTE(socket,userid,idletime)

           if ret_code <> 0 | i // reconnect = 0 then do
             /*-----------------------------------------*/
             /* close the current socket and re-connect */
             /* to avoid SMTP problems                  */
             /*-----------------------------------------*/
             socket = CONNECT_TO_SMTP(server,port,connecttime,idletime)
             if socket <= 0 then LEAVE
           end
         end /* do */
       end /* if */
     end /* if */
     else do
       Say 'No valid "send to" userids were found.'
     end

     /*-------------------------------*/
     /* quit the mail server session. */
     /*-------------------------------*/
     Say
     Call RxIpPutStr socket,"QUIT"
     str = RxIpGetStrWait(socket,idletime)
     if datatype(str) <> 'NUM' then say str

     say
     say 'SMTP Mail process completed...'
     
     /*--------------------------------------*/
     /* close the open TCP/IP connection.    */
     /* This does not disconnect your modem  */
     /* connection                           */
     /*--------------------------------------*/
     if socket > 0 then ret_code = RxIpClose(socket)
   end /* if */
 end
 Say ''
 Say 'Press any key .....'
 CharIn()
 Exit(ret_code)

/*--------------------------------------------------------------------*/
/* Load some of the external functions                                */
/*--------------------------------------------------------------------*/
Init_Cmd:Procedure Expose server userid appfile,
                   defserver deffile defuser 
 Parse Arg args

 ret_code = 0

 Say '------------------------------------------------------------'
 Say 'SENDNOTE - Send an SMTP note to a user or list of users'
 Say
 Say 'format: SENDNOTE <server> <note file> <userid/list>'
 Say '------------------------------------------------------------'
 if args = '?' | translate(args) = '/H' | translate(args) = '-H' then
   ret_code = 1

 if ret_code = 0 then do
   Say 'Initializing library functions...'

   If RxFuncQuery('SysLoadFuncs') then do
     /*----------------------------------*/
     /* load extended REXX functions     */
     /*----------------------------------*/
     If RxFuncAdd('SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs') then do
       ret_code = 1
       say "Error: Couldn't load RexxUtil library"
     end
     call SysLoadFuncs
   end
 end

 if ret_code = 0 then do
   if RxFuncQuery('RxIpInit') then do
     /*------------------------------------*/
     /* Load the SurfRexx TCP/IP functions */
     /*------------------------------------*/
     if RxFuncAdd('RxIpInit','SurfRexx','RxIpInit') then do
       say "Error: Couln't load SurfRexx library"
       ret_code = 1
     end
     Call RxIpInit
   end
 end

 if ret_code = 0 then do
   Say RxIpVersion()

   /*--------------------------------------------*/
   /* check input parameters and assign defaults */
   /*--------------------------------------------*/
   Say 'Checking input values...'
   Say

   Parse Var args server appfile userid

   if server = '.' then do
     server = defserver
   end
   else if server = '' then do
     Say 'Please enter an SMTP mail server: (default = 'defserver')'
     parse pull server
     if strip(server) = '' then server = defserver
   end

   if appfile = '.' then do
     appfile = deffile
   end
   else if appfile = '' then do
     Say 'Please enter your note text filename: (default = 'deffile')'
     parse pull appfile
     if strip(appfile) = '' then appfile = deffile
   end

   if userid = '.' then do
     userid = defuser
   end
   else if userid = '' then do
     Say 'Please enter a target userid/list of ids: (default = 'defuser')'
     parse pull userid
     if strip(userid) = '' then userid = defuser
   end

   if server = '' | userid = '' | appfile = '' then ret_code = 1
   Say
 end

 return(ret_code)

/*-----------------------------------------------------------------------*/
/* Connect to the given SMTP server                                      */
/*-----------------------------------------------------------------------*/
CONNECT_TO_SMTP:Procedure 
  Parse Arg server,port,connecttime,idletime

  /*----------------------------------*/
  /* connect to the SMTP mail server  */
  /*----------------------------------*/
  say 'Connecting to SMTP mail server....'server
  say '                          port....('port')'

  /*------------------------------------------------------*/
  /* the function RxIpConnectWait establishes a TCP/IP    */
  /* connection (socket) with the given host at the given */
  /* port number or gives up after x seconds of trying.   */
  /*------------------------------------------------------*/
  socket = RxIpConnectWait(server,port,connecttime)
  if socket > 0 then do
    str = RxIpGetStrWait(socket,idletime)
    if datatype(str) <> 'NUM' then do
      if pos('220',str) = 1 then do
        Say str
        Say 'Connection was successfully...'server

        /*----------------------------------*/
        /* the HELO command is a requirment */
        /* of most SMTP servers.            */
        /*----------------------------------*/
        rc = RxIpPutStr(socket,'HELO 'server)
        if rc <> 0 then do
          Say 'SurfRexx Error('rc') sending information to the server.'
          Say RxIpErrorText(rc)
        end
 
        /*-------------------------------------------------*/
        /* retrieve any other logon messages that the SMTP */
        /* site may have for us.                           */
        /*-------------------------------------------------*/
        rc = ""
        do while datatype(rc) <> 'NUM'
          rc = RxIpGetStrWait(socket,5)
          if datatype(rc) <> 'NUM' then say rc
        end
      end
      else do
        Say 'SMTP Error connecting to the server.'
        RxIpClose(socket);
        socket = 0
      end
    end
    else do
      Say 'SurfRexx Error('str') reading information from the server.'
      Say RxIpErrorText(str)
    end
  end
  else do
    /*--------------------*/
    /* connection failed  */
    /*--------------------*/
    say 'SurfRexx Error('socket') connecting to mail server.'
    say RxIpErrorText(socket)
  end

  RETURN(socket)

/*------------------------------------------------------------------------*/
/* Create a list of send to userids                                       */
/*------------------------------------------------------------------------*/
GET_SEND_TO_LIST:Procedure Expose sendto.
  Parse Arg userid

  sendto. = 0
  cnt     = 0

  if pos('@',userid) > 0 & pos('.',userid) > 0 & length(userid) > 12 then do
    cnt        = cnt + 1
    sendto.cnt = userid
  end
  else do
    /*-----------------------------------*/
    /* Must be a file so read its values */
    /*-----------------------------------*/
    file = userid
    Do While Lines(file) > 0
      line = LineIn(file)
      /*---------------------------------------------*/
      /* anything after an asterisk '*' is a comment */
      /* and can be ignored.                         */
      /*---------------------------------------------*/
      Parse Var line userid'*'.
      if strip(userid) <> '' then do
        cnt        = cnt + 1
        sendto.cnt = userid
      end  
    end /* do */
    /*-----------------------------------*/
    /* Make sure that the file is closed */
    /*-----------------------------------*/
    Call LineOut file
  end /* else */

  sendto.0 = cnt

  RETURN(sendto.0)

/*-------------------------------------------------------------------------*/
/* Read the file to be sent as the note text                               */
/*-------------------------------------------------------------------------*/
READ_NOTE_FILE:Procedure Expose note.
  Parse Arg file,timezone

  Say 'Reading note file...'file

  note. = 0
  Do While Lines(file) > 0
    line     = LineIn(file)

    if pos('FROM:',translate(line)) = 1 & note.FROM = 0 then do
      note.FROM = strip(delstr(line,1,5))
    end

    note.0   = note.0 + 1
    tot      = note.0
    note.tot = line
  end

  if note.0 = 0 then do
    Say '*********'
    Say 'Error *** Reading note file ('file') ***'
    Say '*********'
  end
  else if note.FROM = 0 then do
    Say '*********'
    Say 'Error *** No "From:" line was found in the note file ('file') ***'
    Say '*********'
    note. = 0
  end
  else do
    /*--------------------------------------*/
    /* Assign a date to the current note(s) */
    /*--------------------------------------*/
    note.DATE = GET_INTERNET_DATE(timezone)
  end

  RETURN(note.0)

/*------------------------------------------------------------------------*/
/* Return the current date in internet format                             */
/*------------------------------------------------------------------------*/
GET_INTERNET_DATE:Procedure
  Parse Arg timezone

  days.  = 0

  mons.  = 0
  mons.1 = "Jan";mons.2  = "Feb";mons.3  = "Mar";mons.4  = "Apr"
  mons.5 = "May";mons.6  = "Jun";mons.7  = "Jul";mons.8  = "Aug"
  mons.9 = "Sep";mons.10 = "Oct";mons.11 = "Nov";mons.12 = "Dec"

  Parse Value date('SORTED') With 1 yr 5 mm 7 dd

  dd = dd + 1
  mm = mm + 1

  date = substr(date('WEEKDAY'),1,3)',' dd mons.mm yr time() timezone

  RETURN(date)

/*------------------------------------------------------------------------*/
/* Send the current note text to the given user                           */
/*------------------------------------------------------------------------*/
SEND_NOTE:Procedure Expose note.
  Parse Arg socket,tuserid,idletime

  ret_code = 0

  tuser = tuserid
  if pos('<',tuser) > 0 then do
    Parse Var tuser tname '<'tuser'>'
  end
  else tname = ''
  tname = strip(tname)
  tuser = strip(tuser)

  fuserid  = note.FROM
  fuser    = fuserid
  if pos('<',fuser) > 0 then do
    Parse Var fuser fname '<'fuser'>'
  end
  else fname = ''
  fname = strip(fname)
  fuser = strip(fuser)

  /*-------------------------------*/
  /* Tell SMTP to start a new note */
  /*-------------------------------*/
  rc = RxIpPutStr(socket,'MAIL FROM:<'fuser'>');
  if rc = 0 then do
    str = RxIpGetStrWait(socket,idletime)
    if datatype(str) <> 'NUM' then do
      if pos('250',str) <> 1 then do
        ret_code = 1
        Say 'SMTP Error sending note to ('tuserid')'
        Say str
      end
    end
    else do
      ret_code = 1
      Say 'SurfRexx Error('str') reading information from the server.'
      Say RxIpErrorText(str)
    end
  end
  else do
    ret_code = 1
    Say 'SurfRexx Error('rc') sending information to the server.'
    Say RxIpErrorText(rc)
  end

  if ret_code = 0 then do
    /*------------------------------------*/
    /* Tell SMTP who the note is going to */
    /*------------------------------------*/
    rc = RxIpPutStr(socket,'RCPT TO:<'tuser'>');
    if rc = 0 then do
      str = RxIpGetStrWait(socket,idletime)
      if datatype(str) <> 'NUM' then do
        if pos('250',str) <> 1 then do
          ret_code = 1
          Say 'SMTP Error sending note to ('tuserid')'
          Say str
        end
      end
      else do
        ret_code = 1
        Say 'SurfRexx Error('str') reading information from the server.'
        Say RxIpErrorText(str)
      end
    end
    else do
      ret_code = 1
      Say 'SurfRexx Error('rc') sending information to the server.'
      Say RxIpErrorText(rc)
    end
  end

  if ret_code = 0 then do
    /*-----------------------------------------------*/
    /* Tell SMTP that the note body is being entered */
    /*-----------------------------------------------*/
    rc = RxIpPutStr(socket,'DATA');
    if rc = 0 then do
      str = RxIpGetStrWait(socket,idletime)
      if datatype(str) <> 'NUM' then do
        if pos('354',str) <> 1 then do
          ret_code = 1
          Say 'SMTP Error sending note to ('tuserid')'
          Say str
        end
      end
      else do
        ret_code = 1
        Say 'SurfRexx Error('str') reading information from the server.'
        Say RxIpErrorText(str)
      end
    end
    else do
      ret_code = 1
      Say 'SurfRexx Error('rc') sending information to the server.'
      Say RxIpErrorText(rc)
    end
  end

  if ret_code = 0 then do
    /*---------------------*/
    /* enter the note body */
    /*---------------------*/
    do i = -2 to note.0
      Select
        When i = -2 then line = "X-Mailer: InnoVal's Surf'n Rexx"
        When i = -1 then line = "To: "tuserid
        When i =  0 then line = "Date: "note.DATE
        Otherwise        line = note.i
      end /* select */

      if line = '.' then line = '..'

      rc = RxIpPutStr(socket,line);
      if rc <> 0 then do
        ret_code = 1
        Say 'SurfRexx Error('rc') sending information to the server.'
        Say RxIpErrorText(rc)
        LEAVE
      end /* if */
    end /* do...i */
  end

  if ret_code = 0 then do
    /*--------------*/
    /* end the note */
    /*--------------*/
    rc = RxIpPutStr(socket,'.')
    if rc = 0 then do
      str = RxIpGetStrWait(socket,idletime)
      if datatype(str) <> 'NUM' then do
        if pos('250',str) <> 1 then do
          ret_code = 1
          Say 'SMTP Error sending note to ('tuserid')'
          Say str
        end
      end
      else do
        ret_code = 1
        Say 'SurfRexx Error('str') reading information from the server.'
        Say RxIpErrorText(str)
      end
    end
    else do
      ret_code = 1
      Say 'SurfRexx Error('rc') sending information to the server.'
      Say RxIpErrorText(rc)
    end
  end
  RETURN(ret_code)

/**************************************************************************/
/* Read a set of defaults from a file                                     */
/**************************************************************************/
READ_DEFAULTS_FILE:Procedure Expose def.
  Parse Arg file

  def. = 0

  if Lines(file) > 0 then do
    do while Lines(file) > 0
      line = strip(LineIn(file))
      if line <> '' & substr(line,1,1) <> '*' then do
        Parse Var line ':'term'.'value
        term  = strip(translate(term))
        value = strip(value)
        if value <> '' then def.term = value
      end
    end /* do...while */
    /*------------------------------*/
    /* Make sure the file is closed */
    /*------------------------------*/
    Call LineOut file
  end 
  else do
    Say '******************************'
    Say 'Error reading defaults file...'file
    Say '******************************'
  end
  RETURN
