/*  Config.CMD
 *  ----------
 *  Copyright (c) Cornelis Bockemuehl, 1998
 *
 *  Configure InjoyPB
 */

'@echo off'

if RxFuncQuery("SysLoadFuncs") then do
   call RxFuncAdd "SysLoadFuncs", "RexxUtil", "SysLoadFuncs"
   call SysLoadFuncs
end
crlf=d2c(13)||d2c(10)
ijpbdir=directory()

/* Introduction */
rc=SysCls()
say ""
say "*********************************"
say "Configuration of Injoy Phone Bill"
say "*********************************"
say ""
say "This script helps you adding a new host definition or overwriting"
say "an existing, but it is not a full blown configuration program."
say "Specifically, it doesn't do any error checking of your input; just"
say "everything is accepted!"
say "However, you get some explanations about what you are supposed to"
say "enter and once you are running InjoyPB it will try to check all"
say "input for consistency and show you any lines it doesn't like. You"
say "may then start the manual configuration (i.e., edit the injoypb.cfg"
say "file with an editor) and make any changes necessary."
say ""
do until (aa="Y") | (aa="N")
  say "Do you want to go on configuring a host definition? (y/n)"
  pull aa .
end
if aa="N" then exit

/* Get host name from user */
rc=SysCls()
say ""
say "Injoy can handle several 'hosts'; you find their names in the upper"
say "right corner of the main Injoy window. Each one of them can have"
say "different settings and each one produces an own log file with the"
say "name '<hostname>.log'. These contain the connection data used by"
say "InjoyPB and it can also handle different settings for every host."
say "Remark: If you want to add more than one host definition, just run"
say "this configuration script several times."
say ""
say "Press RETURN to continue"
parse pull .
rc=SysCls()
say ""
say "The following log files were found:"
rc=SysFileTree("..\*.log",logf,"FO")
if 0=logf.0 then
  say "  (none)"
else do ff=1 to logf.0
  say "  "||substr(logf.ff,lastpos("\",logf.ff)+1)
end
say "The following hosts are already defined:"
rc=SysFileSearch("[","InjoyPB.CFG",hostf)
if 0=hostf.0 then
  say "  (none)"
else do ff=1 to hostf.0
  if "["=substr(hostf.ff,1,1) then
    say "  "||substr(hostf.ff,2,pos("]",hostf.ff)-2)
end
say "Enter one of the names (without the '.log' extension) or any other"
say "host name you intend to use:"
parse pull hostname .
bhostname="["||hostname||"]"
parse upper var bhostname uhostname

/* Create program object for new host */
found=0
ff=1
do until (found=1) | (ff>hostf.0)
  parse upper var hostf.ff uhf
  if uhf=uhostname then
    found=1
  ff=ff+1
end
if 0=found then do
  say "Host "hostname" isn't defined yet:"
  do until (aa="Y") | (aa="N")
    say "Create a program object for it? (y/n)"
    pull aa .
  end
  if aa="Y" then
    call SysCreateObject "WPProgram", ,
                         "Injoy Phone Bill"||crlf||hostname, ,
                         "<INJOYPBFOLDER>", ,
                         "OBJECTID=<INJOYPBPROGRAM_"hostname">;"|| ,
                         "ICONFILE="||ijpbdir||"\InjoyPB.ICO;"|| ,
                         "EXENAME="||ijpbdir||"\InjoyPB.EXE;"|| ,
                         "STARTUPDIR="||ijpbdir||";"|| ,
                         "PARAMETERS="hostname" [month (1-12)];"|| ,
                         "NOAUTOCLOSE=YES", ,
                         "REPLACE"
end

/* Read explanations from configuration file */
exn=0
do while lines("InjoyPB.CFG")
  buf=linein("InjoyPB.CFG")
  if "-"=substr(buf,1,1) then do
    exn=exn+1
    exline.0=exn
    exline.exn=buf
  end
end

/* Read new configuration lines from user */
cfn=0
exn=1
do until exn > exline.0
  ch=substr(exline.exn,2,1)
  rc=SysCls()
  say ""
  do while ch = substr(exline.exn,2,1)
    say substr(exline.exn,3)
    exn=exn+1
  end
  say ""
  inp="INP"
  do while inp <> ""
    say "Enter line (or RETURN for next group):"
    inp = linein()
    if inp <> "" then do
      cfn=cfn+1
      cfline.0=cfn
      cfline.cfn=ch||" "||inp
    end
  end
end

/* Ask once more */
rc=SysCls()
say ""
do until (aa="Y") | (aa="N")
  say "Do you want to save your new configuration? (y/n)"
  say "Answer 'n' to cancel configuration and leave InjoyPB.CFG untouched."
  say "If you answer 'y' the old InjoyPB.CFG is saved as InjoyPB.BAK; any"
  say "existing InjoyPB.BAK file will be lost."
  pull aa .
end
if aa="N" then do
  say ""
  say "Host definition cancelled"
  exit
end

/* Copy all lines of existing config file
   except any old definition with the same host name */
rc=SysCls()
say ""
say "Copying old data..."
rc=lineout("InjoyPB.CFG",,1)  /* Reset file pointer */
do while lines("InjoyPB.CFG")
  buf=linein("InjoyPB.CFG")
  parse upper var buf ubuf
  if substr(ubuf,1,length(uhostname)) = uhostname then do
    rc=lineout("InjoyPB.$$$","."||buf||" (old definition)")
    do forever
      buf=linein("InjoyPB.CFG")
      if "[" = substr(buf,1,1) then do
        rc=lineout("InjoyPB.$$$",buf)
        leave
      end
      if "" = buf then
        rc=lineout("InjoyPB.$$$","")
      else
        rc=lineout("InjoyPB.$$$","."||buf)
      if 0 = lines("InjoyPB.CFG") then leave
    end
  end
  else
    rc=lineout("InjoyPB.$$$",buf)
end

/* Append new definition */
say "Appending new definitions..."
rc=lineout("InjoyPB.$$$","")
rc=lineout("InjoyPB.$$$",bhostname)
cfn=1
do until cfn > cfline.0
  rc=lineout("InjoyPB.$$$",cfline.cfn)
  cfn=cfn+1
end

/* Rename files */
say "Renaming files..."
rc=stream("InjoyPB.CFG","c","CLOSE")
rc=stream("InjoyPB.$$$","c","CLOSE")
"if exist InjoyPB.BAK delete InjoyPB.BAK >nul"
"rename InjoyPB.CFG InjoyPB.BAK >nul"
"rename InjoyPB.$$$ InjoyPB.CFG >nul"

say "New host defined."
