/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ISDNPMRemote
extends JFrame {
    private Isdnpm _isdnpm;
    private ProgramSettings _settings;
    private StatusThread _sThread;
    private CallByCallDialog _callByCallDialog;
    private int _popUpUserIndex;
    private User[] _users;
    private ActionListener _hangupLineButtonListener = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            ISDNPMRemote.this.hangupLineAction(actionEvent);
        }
    };
    private JMenuBar jMenuBar1;
    private JMenu mnuProgram;
    private JMenuItem miUpdate;
    private JMenuItem miDisconnect;
    private JMenuItem miReconnect;
    private JSeparator jSeparator2;
    private JMenuItem miShutdown;
    private JMenuItem miRestart;
    private JSeparator jSeparator1;
    private JMenuItem miExit;
    private JMenu mnuSettings;
    private JMenuItem miSettings;
    private JMenu mnuHelp;
    private JMenuItem miAbout;
    private JPopupMenu popAutodial;
    private JCheckBoxMenuItem miAutodial;
    private JCheckBoxMenuItem miMultilink;
    private JTabbedPane jtpChannel;
    private JPanel jPanel4;
    private JPanel jPanel1;
    private JButton btnConnect;
    private JButton btnHangup;
    private JButton btnCallByCall;
    private JLabel lblMessage;
    private JPanel jPanel2;
    private JCheckBox cbStatus;
    private JPanel jPanel3;
    private JCheckBox cbAutodial;
    private JCheckBox cbMultilink;
    private JCheckBox cbDialIn;
    private JScrollPane spnUsers;
    private JList lstUsers;

    public ISDNPMRemote() {
        this.initComponents();
        this.pack();
        this._settings = new ProgramSettings();
        ((Component)this).setLocation(this._settings.getPosition());
        if (this._settings.getStatusOnly()) {
            this.cbStatus.doClick();
        }
        this._isdnpm = new Isdnpm();
        ((Frame)this).setIconImage(new ImageIcon(this.getClass().getResource("images/icon.gif")).getImage());
        new ConnectThread(this).start();
    }

    public void disconnectISDNPM() {
        this.lblMessage.setText("Disconnecting form ISDNPM...");
        if (this._sThread != null) {
            this._sThread.terminate();
            this._sThread = null;
        }
        try {
            this._isdnpm.closeSocket();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.lblMessage.setText("Disconnected!");
        this.disableControls();
    }

    private void enableControls() {
        if (!this.lstUsers.isSelectionEmpty()) {
            this.btnConnect.setEnabled(true);
            this.btnHangup.setEnabled(true);
        }
        this.miUpdate.setEnabled(true);
        this.btnCallByCall.setEnabled(true);
        this.cbAutodial.setEnabled(true);
        this.cbMultilink.setEnabled(true);
        this.miRestart.setEnabled(true);
        this.miShutdown.setEnabled(true);
        this.miDisconnect.setEnabled(true);
        this.lblMessage.setForeground(new Color(102, 102, 153));
        this.pack();
    }

    private void disableControls() {
        this.btnConnect.setEnabled(false);
        this.btnHangup.setEnabled(false);
        this.miUpdate.setEnabled(false);
        this.btnCallByCall.setEnabled(false);
        this.cbAutodial.setEnabled(false);
        this.cbMultilink.setEnabled(false);
        this.miRestart.setEnabled(false);
        this.miShutdown.setEnabled(false);
        this.miDisconnect.setEnabled(false);
        this.jtpChannel.removeAll();
        this.lstUsers.setListData(new String[0]);
        this.lblMessage.setForeground(Color.red);
        this.lblMessage.setText("Not Connected to ISDNPM!");
        this.pack();
    }

    private void retrieveUserList() {
        try {
            this._users = this._isdnpm.getUsers();
            this.lstUsers.setListData(this._users);
        }
        catch (ISDNPMCommandException iSDNPMCommandException) {
            System.err.println("Command Error while retrieving users");
            iSDNPMCommandException.printStackTrace(System.err);
        }
        catch (IOException iOException) {
            System.err.println("Socket Error retrieving users");
            iOException.printStackTrace(System.err);
        }
    }

    private void displayError() {
        int n = JOptionPane.showConfirmDialog(this, "The connection to ISDNPM is seems to be broken.\nWould you like to reconnect?", "ISDNPM Connection Error", 0);
        if (n == 0) {
            this.disconnectISDNPM();
            new ConnectThread(this).start();
        } else {
            this.disableControls();
        }
    }

    private void initComponents() {
        this.jMenuBar1 = new JMenuBar();
        this.mnuProgram = new JMenu();
        this.miUpdate = new JMenuItem();
        this.miDisconnect = new JMenuItem();
        this.miReconnect = new JMenuItem();
        this.jSeparator2 = new JSeparator();
        this.miShutdown = new JMenuItem();
        this.miRestart = new JMenuItem();
        this.jSeparator1 = new JSeparator();
        this.miExit = new JMenuItem();
        this.mnuSettings = new JMenu();
        this.miSettings = new JMenuItem();
        this.mnuHelp = new JMenu();
        this.miAbout = new JMenuItem();
        this.popAutodial = new JPopupMenu();
        this.miAutodial = new JCheckBoxMenuItem();
        this.miMultilink = new JCheckBoxMenuItem();
        this.jtpChannel = new JTabbedPane();
        this.jPanel4 = new JPanel();
        this.jPanel1 = new JPanel();
        this.btnConnect = new JButton();
        this.btnHangup = new JButton();
        this.btnCallByCall = new JButton();
        this.lblMessage = new JLabel();
        this.jPanel2 = new JPanel();
        this.cbStatus = new JCheckBox();
        this.jPanel3 = new JPanel();
        this.cbAutodial = new JCheckBox();
        this.cbMultilink = new JCheckBox();
        this.cbDialIn = new JCheckBox();
        this.spnUsers = new JScrollPane();
        this.lstUsers = new JList();
        this.mnuProgram.setText("Program");
        this.miUpdate.setText("Update User List");
        this.miUpdate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ISDNPMRemote.this.miUpdateActionPerformed(actionEvent);
            }
        });
        this.mnuProgram.add(this.miUpdate);
        this.miDisconnect.setText("Disconnect");
        this.miDisconnect.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ISDNPMRemote.this.miDisconnectActionPerformed(actionEvent);
            }
        });
        this.mnuProgram.add(this.miDisconnect);
        this.miReconnect.setText("Reconnect");
        this.miReconnect.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ISDNPMRemote.this.miReconnectActionPerformed(actionEvent);
            }
        });
        this.mnuProgram.add(this.miReconnect);
        this.mnuProgram.add(this.jSeparator2);
        this.miShutdown.setText("Shutdown ISDNPM");
        this.miShutdown.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ISDNPMRemote.this.miShutdownActionPerformed(actionEvent);
            }
        });
        this.mnuProgram.add(this.miShutdown);
        this.miRestart.setText("Restart ISDNPM");
        this.miRestart.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ISDNPMRemote.this.miRestartActionPerformed(actionEvent);
            }
        });
        this.mnuProgram.add(this.miRestart);
        this.mnuProgram.add(this.jSeparator1);
        this.miExit.setText("Exit");
        this.miExit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ISDNPMRemote.this.miExitActionPerformed(actionEvent);
            }
        });
        this.mnuProgram.add(this.miExit);
        this.jMenuBar1.add(this.mnuProgram);
        this.mnuSettings.setText("Settings");
        this.miSettings.setText("Program settings");
        this.miSettings.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ISDNPMRemote.this.miSettingsActionPerformed(actionEvent);
            }
        });
        this.mnuSettings.add(this.miSettings);
        this.jMenuBar1.add(this.mnuSettings);
        this.mnuHelp.setText("Help");
        this.miAbout.setText("About");
        this.miAbout.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ISDNPMRemote.this.miAboutActionPerformed(actionEvent);
            }
        });
        this.mnuHelp.add(this.miAbout);
        this.jMenuBar1.add(this.mnuHelp);
        this.popAutodial.setInvoker(this.lstUsers);
        this.miAutodial.setText("Autodial");
        this.miAutodial.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ISDNPMRemote.this.miAutodialActionPerformed(actionEvent);
            }
        });
        this.popAutodial.add(this.miAutodial);
        this.miMultilink.setText("Multilink");
        this.miMultilink.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ISDNPMRemote.this.miMultilinkActionPerformed(actionEvent);
            }
        });
        this.popAutodial.add(this.miMultilink);
        this.getContentPane().setLayout(new BorderLayout(5, 4));
        this.setTitle("ISDNPM Remote");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ISDNPMRemote.this.exitForm(windowEvent);
            }
        });
        this.jtpChannel.setPreferredSize(new Dimension(430, 100));
        this.jtpChannel.setMinimumSize(new Dimension(430, 100));
        this.jtpChannel.setMaximumSize(new Dimension(430, 100));
        this.getContentPane().add((Component)this.jtpChannel, "North");
        this.jPanel4.setLayout(new BorderLayout());
        this.jPanel4.setPreferredSize(new Dimension(180, 110));
        this.jPanel4.setMinimumSize(new Dimension(180, 110));
        this.jPanel1.setLayout(new GridBagLayout());
        this.jPanel1.setPreferredSize(new Dimension(180, 100));
        this.jPanel1.setMinimumSize(new Dimension(180, 80));
        this.btnConnect.setToolTipText("Make a connection with the current user");
        this.btnConnect.setFont(new Font("Dialog", 0, 10));
        this.btnConnect.setPreferredSize(new Dimension(70, 25));
        this.btnConnect.setLabel("Connect");
        this.btnConnect.setMargin(new Insets(2, 10, 2, 10));
        this.btnConnect.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ISDNPMRemote.this.jButton1ActionPerformed(actionEvent);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 5, 0, 0);
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.btnConnect, gridBagConstraints);
        this.btnHangup.setToolTipText("Hangup all Connections with the current user");
        this.btnHangup.setFont(new Font("Dialog", 0, 10));
        this.btnHangup.setPreferredSize(new Dimension(70, 25));
        this.btnHangup.setLabel("Hangup");
        this.btnHangup.setMargin(new Insets(2, 10, 2, 10));
        this.btnHangup.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ISDNPMRemote.this.btnHangupActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(11, 5, 0, 0);
        gridBagConstraints.anchor = 16;
        this.jPanel1.add((Component)this.btnHangup, gridBagConstraints);
        this.btnCallByCall.setFont(new Font("Dialog", 0, 10));
        this.btnCallByCall.setLabel("Call By Call");
        this.btnCallByCall.setMargin(new Insets(2, 10, 2, 10));
        this.btnCallByCall.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ISDNPMRemote.this.btnCallByCallActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 20, 0, 5);
        gridBagConstraints.anchor = 12;
        this.jPanel1.add((Component)this.btnCallByCall, gridBagConstraints);
        this.jPanel4.add((Component)this.jPanel1, "South");
        this.lblMessage.setText("---");
        this.lblMessage.setHorizontalAlignment(0);
        this.lblMessage.setFont(new Font("Dialog", 0, 9));
        this.jPanel4.add((Component)this.lblMessage, "North");
        this.getContentPane().add((Component)this.jPanel4, "East");
        this.jPanel2.setLayout(new BorderLayout());
        this.cbStatus.setToolTipText("show/hide the userlist");
        this.cbStatus.setFont(new Font("Dialog", 0, 10));
        this.cbStatus.setText("Status only");
        this.cbStatus.setPreferredSize(new Dimension(77, 15));
        this.cbStatus.setMaximumSize(new Dimension(77, 15));
        this.cbStatus.setMinimumSize(new Dimension(77, 15));
        this.cbStatus.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ISDNPMRemote.this.jCheckBox2ActionPerformed(actionEvent);
            }
        });
        this.jPanel2.add((Component)this.cbStatus, "West");
        this.jPanel3.setLayout(new FlowLayout(2, 5, 0));
        this.jPanel3.setPreferredSize(new Dimension(148, 15));
        this.jPanel3.setMinimumSize(new Dimension(148, 15));
        this.cbAutodial.setToolTipText("enable/disable Autodial");
        this.cbAutodial.setFont(new Font("Dialog", 0, 10));
        this.cbAutodial.setText("Autodial");
        this.cbAutodial.setPreferredSize(new Dimension(65, 15));
        this.cbAutodial.setMaximumSize(new Dimension(65, 15));
        this.cbAutodial.setMinimumSize(new Dimension(65, 15));
        this.cbAutodial.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ISDNPMRemote.this.setAutomode(actionEvent);
            }
        });
        this.jPanel3.add(this.cbAutodial);
        this.cbMultilink.setFont(new Font("Dialog", 0, 10));
        this.cbMultilink.setText(" Multilink");
        this.cbMultilink.setPreferredSize(new Dimension(68, 15));
        this.cbMultilink.setMaximumSize(new Dimension(68, 15));
        this.cbMultilink.setMinimumSize(new Dimension(68, 15));
        this.cbMultilink.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ISDNPMRemote.this.setMultimode(actionEvent);
            }
        });
        this.jPanel3.add(this.cbMultilink);
        this.cbDialIn.setFont(new Font("Dialog", 0, 10));
        this.cbDialIn.setText("Dial-In");
        this.cbDialIn.setPreferredSize(new Dimension(68, 15));
        this.cbDialIn.setMaximumSize(new Dimension(68, 15));
        this.cbDialIn.setMinimumSize(new Dimension(68, 15));
        this.cbDialIn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ISDNPMRemote.this.cbDialInActionPerformed(actionEvent);
            }
        });
        this.jPanel3.add(this.cbDialIn);
        this.jPanel2.add((Component)this.jPanel3, "Center");
        this.getContentPane().add((Component)this.jPanel2, "South");
        this.spnUsers.setPreferredSize(new Dimension(218, 110));
        this.lstUsers.setToolTipText("List of users");
        this.lstUsers.setCellRenderer(new UserListCellRenderer());
        this.lstUsers.setSelectionMode(0);
        this.lstUsers.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ISDNPMRemote.this.lstUsersValueChanged(listSelectionEvent);
            }
        });
        this.lstUsers.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                ISDNPMRemote.this.lstUsersMousePressed(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                ISDNPMRemote.this.lstUsersMousePressed(mouseEvent);
            }
        });
        this.lstUsers.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent mouseEvent) {
                ISDNPMRemote.this.lstUsersMouseMoved(mouseEvent);
            }
        });
        this.spnUsers.setViewportView(this.lstUsers);
        this.getContentPane().add((Component)this.spnUsers, "Center");
        this.setJMenuBar(this.jMenuBar1);
        this.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)this).setSize(new Dimension(430, 285));
        ((Component)this).setLocation((dimension.width - 430) / 2, (dimension.height - 285) / 2);
    }

    private void cbDialInActionPerformed(ActionEvent actionEvent) {
        try {
            this._isdnpm.setDialInmode(this.cbDialIn.isSelected());
        }
        catch (ISDNPMCommandException iSDNPMCommandException) {
            System.out.println(iSDNPMCommandException);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void setMultimode(ActionEvent actionEvent) {
        try {
            this._isdnpm.setMultimode(this.cbMultilink.isSelected());
        }
        catch (ISDNPMCommandException iSDNPMCommandException) {
            System.out.println(iSDNPMCommandException);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void miMultilinkActionPerformed(ActionEvent actionEvent) {
        try {
            this._isdnpm.setMultilink(this._users[this._popUpUserIndex].getName(), this.miMultilink.isSelected());
            this._users[this._popUpUserIndex].setMultilink(this.miMultilink.isSelected());
            this.lstUsers.repaint();
        }
        catch (ISDNPMCommandException iSDNPMCommandException) {
            System.err.println("Command Error during MultilinkUser change");
            iSDNPMCommandException.printStackTrace(System.err);
        }
        catch (IOException iOException) {
            System.err.println("Socket Error during MultilinkUser change");
            iOException.printStackTrace(System.err);
        }
    }

    private void miAutodialActionPerformed(ActionEvent actionEvent) {
        try {
            this._isdnpm.setAutodial(this._users[this._popUpUserIndex].getName(), this.miAutodial.isSelected());
            this._users[this._popUpUserIndex].setAutodial(this.miAutodial.isSelected());
            this.lstUsers.repaint();
        }
        catch (ISDNPMCommandException iSDNPMCommandException) {
            System.err.println("Command Error during AutodialUser change");
            iSDNPMCommandException.printStackTrace(System.err);
        }
        catch (IOException iOException) {
            System.err.println("Socket Error during AutodialUser change");
            iOException.printStackTrace(System.err);
        }
    }

    private void lstUsersMousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this._popUpUserIndex = this.lstUsers.locationToIndex(mouseEvent.getPoint());
            if (this._popUpUserIndex > -1) {
                User user = (User)this.lstUsers.getModel().getElementAt(this._popUpUserIndex);
                this.miAutodial.setSelected(user.getAutodial());
                this.miMultilink.setSelected(user.getMultilink());
                this.popAutodial.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    private void miUpdateActionPerformed(ActionEvent actionEvent) {
        try {
            this._isdnpm.update();
            Thread.sleep(2000L);
            this.retrieveUserList();
        }
        catch (IOException iOException) {
            System.err.println("Socket Error while updating users!");
            iOException.printStackTrace(System.err);
        }
        catch (ISDNPMCommandException iSDNPMCommandException) {
            System.err.println("Command Error while updateing!");
            iSDNPMCommandException.printStackTrace(System.err);
        }
        catch (InterruptedException interruptedException) {
            System.err.println("Thread Error while updateing!");
            interruptedException.printStackTrace(System.err);
        }
    }

    private void lstUsersMouseMoved(MouseEvent mouseEvent) {
        int n = this.lstUsers.locationToIndex(mouseEvent.getPoint());
        if (n > -1) {
            User user = (User)this.lstUsers.getModel().getElementAt(n);
            this.lstUsers.setToolTipText(user.getName() + ':' + user.getInfo());
        }
    }

    private void miDisconnectActionPerformed(ActionEvent actionEvent) {
        this.disconnectISDNPM();
    }

    private void btnCallByCallActionPerformed(ActionEvent actionEvent) {
        if (this._callByCallDialog == null) {
            this._callByCallDialog = new CallByCallDialog((Frame)this, true);
        }
        this._callByCallDialog.show();
        CallByCallEntry callByCallEntry = this._callByCallDialog.getResult();
        if (callByCallEntry != null) {
            try {
                this._isdnpm.callByCall(callByCallEntry);
            }
            catch (Exception exception) {
                System.err.println(exception);
            }
        }
    }

    private void lstUsersValueChanged(ListSelectionEvent listSelectionEvent) {
        if (!this.lstUsers.isSelectionEmpty() && this.miUpdate.isEnabled()) {
            this.btnConnect.setEnabled(true);
            this.btnHangup.setEnabled(true);
            User user = (User)this.lstUsers.getSelectedValue();
        } else {
            this.btnConnect.setEnabled(false);
            this.btnHangup.setEnabled(false);
        }
    }

    private void miReconnectActionPerformed(ActionEvent actionEvent) {
        this.disconnectISDNPM();
        new ConnectThread(this).start();
    }

    private void miRestartActionPerformed(ActionEvent actionEvent) {
        String string = JOptionPane.showInputDialog(this, (Object)"Please enter a parameter for restart:");
        if (string != null) {
            try {
                this._isdnpm.restart(Integer.parseInt(string));
                this.disconnectISDNPM();
            }
            catch (IOException iOException) {
                System.err.println("Socket Error while shutting down!");
                iOException.printStackTrace(System.err);
            }
            catch (ISDNPMCommandException iSDNPMCommandException) {
                System.err.println("Command Error while shutting down!");
                iSDNPMCommandException.printStackTrace(System.err);
                JOptionPane.showMessageDialog(this, "Restart failed!\nMaybe you don't have the rights for restarting ISDNPM.");
            }
            catch (NumberFormatException numberFormatException) {
                JOptionPane.showMessageDialog(this, "Only numbers are allowd as parameter!");
            }
        }
    }

    private void miShutdownActionPerformed(ActionEvent actionEvent) {
        int n = JOptionPane.showConfirmDialog(this, "Are you sure, you want to shut down ISDNPM?", "Attention!", 0);
        if (n == 0) {
            try {
                this._isdnpm.shutdown();
                this.disconnectISDNPM();
            }
            catch (IOException iOException) {
                System.err.println("Socket Error while shutting down!");
                iOException.printStackTrace(System.err);
            }
            catch (ISDNPMCommandException iSDNPMCommandException) {
                System.err.println("Command Error while shutting down!");
                iSDNPMCommandException.printStackTrace(System.err);
                JOptionPane.showMessageDialog(this, "Shutdown failed!\nMaybe you don't have the rights for restarting ISDNPM.");
            }
        }
    }

    private void setAutomode(ActionEvent actionEvent) {
        try {
            this._isdnpm.setAutomode(this.cbAutodial.isSelected());
        }
        catch (ISDNPMCommandException iSDNPMCommandException) {
            System.out.println(iSDNPMCommandException);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void miSettingsActionPerformed(ActionEvent actionEvent) {
        new SettingsDialog((Frame)this, this._settings).show();
        this.disconnectISDNPM();
        new ConnectThread(this).start();
    }

    private void miAboutActionPerformed(ActionEvent actionEvent) {
        new AboutWindow(this, "Version " + Version.VERSION).show();
    }

    private void miExitActionPerformed(ActionEvent actionEvent) {
        this.exit();
    }

    private void jCheckBox2ActionPerformed(ActionEvent actionEvent) {
        if (this.cbStatus.isSelected()) {
            this.spnUsers.setVisible(false);
            this.jPanel4.setVisible(false);
            this.setJMenuBar(null);
        } else {
            this.spnUsers.setVisible(true);
            this.jPanel4.setVisible(true);
            this.setJMenuBar(this.jMenuBar1);
        }
        this.pack();
    }

    private void btnHangupActionPerformed(ActionEvent actionEvent) {
        try {
            this._isdnpm.DisconnectUser((User)this.lstUsers.getSelectedValue());
            this._sThread.speedUp(this._settings.getForceInterval(), this._settings.getForceDuration());
        }
        catch (ISDNPMCommandException iSDNPMCommandException) {
            System.err.println("Command Error during User Hangup");
            iSDNPMCommandException.printStackTrace(System.err);
            JOptionPane.showMessageDialog(this, "Hangup failed!\nMaybe you don't have the rights for the hangupf function.");
        }
        catch (IOException iOException) {
            System.err.println("Socket Error during User Hangup");
            iOException.printStackTrace(System.err);
        }
    }

    private void jButton1ActionPerformed(ActionEvent actionEvent) {
        try {
            this._isdnpm.ConnectUser((User)this.lstUsers.getSelectedValue());
            this._sThread.speedUp(this._settings.getForceInterval(), this._settings.getForceDuration());
        }
        catch (ISDNPMCommandException iSDNPMCommandException) {
            System.err.println("Command Error during User Connect");
            iSDNPMCommandException.printStackTrace(System.err);
            JOptionPane.showMessageDialog(this, "Connect failed!\nMaybe you don't have the rights for connecting.");
        }
        catch (IOException iOException) {
            System.err.println("Socket Error during User Connect");
            iOException.printStackTrace(System.err);
        }
    }

    private void hangupLineAction(ActionEvent actionEvent) {
        try {
            this._isdnpm.DisconnectChannel(this.jtpChannel.getSelectedIndex() + 1);
            this._sThread.speedUp(this._settings.getForceInterval(), this._settings.getForceDuration());
        }
        catch (ISDNPMCommandException iSDNPMCommandException) {
            System.err.println("Command Error during Line Hangup");
            iSDNPMCommandException.printStackTrace(System.err);
            JOptionPane.showMessageDialog(this, "Hangup failed!\nMaybe you don't have the rights for the hangup function.");
        }
        catch (IOException iOException) {
            System.err.println("Socket Error during Line Hangup");
            iOException.printStackTrace(System.err);
        }
    }

    private void exit() {
        this._settings.setPosition(this.getLocation());
        this._settings.setStatusOnly(this.cbStatus.isSelected());
        System.exit(0);
    }

    private void updateChannelPane(int n, Status status, Status status2) {
        int n2;
        if (n == this.jtpChannel.getTabCount()) {
            this.jtpChannel.addTab("Channel " + String.valueOf(n), new Channel(this._hangupLineButtonListener));
            int n3 = this.jtpChannel.getBoundsAt((int)0).height;
            int n4 = this.jtpChannel.getTabRunCount() - 1;
            int n5 = this.jtpChannel.getSize().width;
            this.jtpChannel.setPreferredSize(new Dimension(n5, 100 + n3 * n4));
        }
        Channel channel = (Channel)this.jtpChannel.getComponent(n);
        channel.setStatus(status, status2);
        if (!status.isDown() && !this._sThread.isSpeedUpMode() && (n2 = this._settings.getForceDuration() - status.getTime()) > 0) {
            this._sThread.speedUp(this._settings.getForceInterval(), n2);
        }
    }

    private void exitForm(WindowEvent windowEvent) {
        this.exit();
    }

    public static void main(String[] stringArray) {
        try {
            new ISDNPMRemote().show();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    class StatusThread
    extends Thread {
        private Isdnpm _isdnpm;
        private int _offline = 1000;
        private int _online = 1000;
        private boolean _terminate = false;
        private boolean _willDie = false;
        private int _forceCount = 0;
        private int _forceValue;

        public StatusThread(Isdnpm isdnpm) {
            this._isdnpm = isdnpm;
            this.setDaemon(true);
        }

        public void setInterval(int n, int n2) {
            this._offline = n;
            this._online = n2;
        }

        public void speedUp(int n, int n2) {
            this._forceCount = n2 * 1000 / n;
            this._forceValue = n;
            this.interrupt();
        }

        public boolean isSpeedUpMode() {
            return this._forceCount > 0;
        }

        public void terminate() {
            this._terminate = true;
            this._forceCount = 0;
            this.interrupt();
            while (this.isAlive() && !this._willDie) {
            }
        }

        public void run() {
            Status status = new Status();
            Status status2 = new Status();
            while (!this._terminate) {
                int n = this._offline;
                try {
                    int n2 = this._isdnpm.getChannels();
                    int n3 = 0;
                    while (n3 < n2) {
                        this._isdnpm.getISDNStatus(n3 + 1, status);
                        this._isdnpm.getIPStatus(n3 + 1, status2);
                        if (!this._terminate) {
                            ISDNPMRemote.this.updateChannelPane(n3, status, status2);
                        }
                        if (!status.isDown()) {
                            n = this._online;
                        }
                        ++n3;
                    }
                    if (!this._terminate) {
                        ISDNPMRemote.this.cbAutodial.setSelected(this._isdnpm.getAutomode());
                        ISDNPMRemote.this.cbMultilink.setSelected(this._isdnpm.getMultimode());
                        ISDNPMRemote.this.cbDialIn.setSelected(this._isdnpm.getDialInmode());
                    }
                }
                catch (Exception exception) {
                    System.err.println("Exception in Status Thread");
                    exception.printStackTrace(System.err);
                    if (!this._terminate) {
                        this._willDie = true;
                        ISDNPMRemote.this.displayError();
                    }
                    return;
                }
                try {
                    if (this._forceCount != 0) {
                        --this._forceCount;
                        Thread.sleep(this._forceValue);
                        continue;
                    }
                    Thread.sleep(n);
                }
                catch (InterruptedException interruptedException) {
                    if (this._forceCount != 0 || this._terminate) continue;
                    System.err.println("Status Thread Unexpected InterruptedException");
                    interruptedException.printStackTrace(System.err);
                }
            }
            this._terminate = false;
        }
    }

    class ConnectThread
    extends Thread {
        private JFrame _parent;

        public ConnectThread(JFrame jFrame) {
            this._parent = jFrame;
        }

        public void run() {
            ISDNPMRemote.this.disableControls();
            ISDNPMRemote.this.mnuSettings.setEnabled(false);
            ISDNPMRemote.this.miReconnect.setEnabled(false);
            ISDNPMRemote.this.setCursor(3);
            ISDNPMRemote.this.lblMessage.setText("Connecting to ISDNPM...");
            try {
                ISDNPMRemote.this._isdnpm.openSocket(ISDNPMRemote.this._settings.getAddress(), ISDNPMRemote.this._settings.getPort());
            }
            catch (IOException iOException) {
                ISDNPMRemote.this.lblMessage.setText("Connection Error!!!");
                System.err.println("Socket error when connecting to ISDNPM");
                iOException.printStackTrace(System.err);
                int n = JOptionPane.showConfirmDialog(this._parent, "Can not connect to ISDNPM on " + ISDNPMRemote.this._settings.getAddress() + ':' + ISDNPMRemote.this._settings.getPort() + " !\n" + "Do you want to retry?", "Socket Error", 0, 0);
                if (n == 0) {
                    this.run();
                    return;
                }
                ISDNPMRemote.this.mnuSettings.setEnabled(true);
                ISDNPMRemote.this.miReconnect.setEnabled(true);
                ISDNPMRemote.this.setCursor(0);
                return;
            }
            ISDNPMRemote.this.lblMessage.setText("Logging on to ISDNPM...");
            try {
                ISDNPMRemote.this._isdnpm.logon(ISDNPMRemote.this._settings.getUserID(), ISDNPMRemote.this._settings.getPassword());
                ISDNPMRemote.this.lblMessage.setText(ISDNPMRemote.this._isdnpm.getVersion());
            }
            catch (ISDNPMCommandException iSDNPMCommandException) {
                System.err.println("Logon Error");
                iSDNPMCommandException.printStackTrace(System.err);
                JOptionPane.showMessageDialog(this._parent, "Could not logon to ISDNPM!\nMake sure, that the userid and password are correct and\ncheck the source rights in your ISDNPM configuration.", "ISDNPM Error", 0);
                ISDNPMRemote.this.mnuSettings.setEnabled(true);
                ISDNPMRemote.this.miReconnect.setEnabled(true);
                ISDNPMRemote.this.setCursor(0);
                return;
            }
            catch (IOException iOException) {
                System.err.println("Lost connection to ISDNPM during Logon");
                iOException.printStackTrace(System.err);
                JOptionPane.showMessageDialog(this._parent, "There was an unexpected error with the\nsocket connection to ISDNPM. Restart the\napplication and try again.", "Socket Error", 0);
                System.exit(0);
            }
            ISDNPMRemote.this.retrieveUserList();
            ISDNPMRemote.this.enableControls();
            ISDNPMRemote.this.miReconnect.setEnabled(true);
            ISDNPMRemote.this.mnuSettings.setEnabled(true);
            ISDNPMRemote.this._sThread = new StatusThread(ISDNPMRemote.this._isdnpm);
            ISDNPMRemote.this._sThread.setInterval(ISDNPMRemote.this._settings.getOfflineInt(), ISDNPMRemote.this._settings.getOnlineInt());
            ISDNPMRemote.this._sThread.start();
            ISDNPMRemote.this.setCursor(0);
        }
    }
}

