/* REXX */
/* MULTIPLE DIGITS OF Square root - Newton method */
/* a2 = (n / a1 + a1) / 2 */
/* (C) Copyright 1997 kyo */
ARG NN DGT '@' TR
IF NN = '' THEN NN = 2
IF DGT = '' THEN DGT = 10
TRACE N
/* TRACE VALUE TR */
N1.0 = 0
F1 = 10
F2 = 100
DN = DGT + 5
DC = DN + DN + 1
CALL SETUP
A1.1 = 1
DO I = 2 TO DC; A1.I = 0; END
TRACE VALUE TR

DS = 0
DO DMY = 1 TO 20 WHILE DS < DGT
    CALL DIVIDE
    CALL ADDDIV2
END
CALL ANS
EXIT

DO 20
    CALL REPEAT
END
EXIT

REPEAT:  /* REPEAT */
    SAY
    CALL MOVE
    DS = 0
    DO DMY = 1 TO 20 WHILE DS < DGT
        CALL DIVIDE
        CALL ADDDIV2
    END
    CALL ANS
    RETURN

SETUP:   /* INIT N. */
/*    TRACE N */
    IF DATATYPE(NN) <> 'NUM' THEN
        DO; SAY "'"NN"'" 'NOT NUMERIC'; EXIT; END
    DP = 1 /* DECIMAL POINT */
    NN1 = NN
    DO WHILE NN1 >= F2; NN1 = NN1 / F2; DP = DP + 1; END
    NM = 1
    DO WHILE NN1 > 0
        N.NM = TRUNC(NN1,0)
        NN1 = (NN1 - N.NM) * F1
        NM = NM + 1
    END
    NM = NM - 1
    SAY 'SQUARE ROOT OF' NN ':' DN 'DIGITS'
    TRACE VALUE TR
    RETURN

RESETN1: /* RESET N1 */
    TRACE N
    DO J = 1 TO NM; N1.J = N.J; END
    DO J = NM + 1 TO DC; N1.J = 0; END
    TRACE VALUE TR
    RETURN

DIVIDE:  /* N1 / A1 -> A2 */
    CALL RESETN1
    DO I = 1 TO DN
        A2.I = 0
        CALL COMPARE
        DO WHILE GE
            CALL SUBTRACT
            A2.I = A2.I + 1
            CALL COMPARE
        END
    END
    RETURN

COMPARE: /* COMPARE N1(I - 1 .. I + DN - 1) AND A1(1..DN) */
    GE = 1
    K = I - 1; IF N1.K * F1 + N1.I > A1.1 THEN RETURN
    K = I
    DO J = 1 TO DN
        IF N1.K > A1.J THEN LEAVE
        IF N1.K < A1.J THEN DO; GE = 0; LEAVE; END
        K = K + 1
    END
    RETURN

SUBTRACT:/* SUBTRACT A1(1 .. DN) FROM N1(I - 1 .. I + DN - 1) */
    B = 0; K = I + DN - 1
    DO J = DN TO 1 BY -1
        N1.K = N1.K - A1.J - B
        B = 0
        IF N1.K < 0 THEN DO; N1.K = N1.K + F1; B = 1; END
        K = K - 1
    END
    IF B = 1 THEN N1.K = N1.K - 1
    RETURN

ADDDIV2: /* ADD A2 TO A1 AND DIVIDE BY 2 */
    DS = 1
    DO WHILE A1.DS = A2.DS
        DS = DS + 1
    END
    JS = DS
    DS = DS - 1
    C = 0
    DO J = JS TO DN
        K = A1.J + A2.J + C * F1
        L = K % 2; C = K // 2
        A1.J = L; M = J
        DO WHILE A1.M >= F1 & M > 1
            A1.M = A1.M - F1
            M = M - 1
            A1.M = A1.M + 1
        END
    END
    RETURN

ANS:    /* PRINT ANSWER */
    TRACE N
    ANS = ''
    DO IP = 1 TO DP
        ANS = ANS||A1.IP
    END
    ANS = ANS||'.'
    DO IP = DP + 1 TO DN
        ANS = ANS ||A1.IP
    END
    SAY 'ANS =' ANS
    TRACE VALUE TR
    RETURN

MOVE:   /* MOVE RESULT */
    IF DP // 2 = 1 THEN
        DO
            DO I = 1 TO DN; N.I = A1.I; END
            NM = DN
            DP = (DP + 1) % 2
        END
    ELSE
        DO
            DO I = 2 TO DN - 1; II = I + 1; N.I = A1.II; END
            N.1 = A1.1 * F1 + A1.2; N.DN = 0
            NM = DN
            DP = DP % 2
        END
    RETURN