/* */
/*==================================================================+
|   This EXEC calls the theseus2 REXX DLLs Theseus0 and Theseus1.   |
| Theseus0 is called for the RT2FindProcesses function.             |
| Theseus1 is called for the RT2GetObjSummary function.             |
+==================================================================*/
trace o

/*==================================================================+
|   Constats for type to obtain system,shared, or private objects.  |
+==================================================================*/
p_system    = 0;
p_shared    = 1;
p_private   = 2;
Pid         = 1;
Object_type = 2;
secs        = 5;
iterations  = 1;
found       = false;
pid_num     = false;

/*==================================================================+
|   Parse the input arguements to upper case.                       |
+==================================================================*/
PARSE UPPER ARG p_pid p_type p_iterations p_secs

/*==================================================================+
|   Check to see if any operand have been passed. If Not exit.      |
+==================================================================*/
IF p_pid = '' | p_pid = '?' THEN
DO
   SAY 'CMD file GETOBJ needs at least one input operand.'
   SAY ''
   SAY '  GETOBJ pid [object_type] [num_iterations] [num_secs]'
   SAY ''
   SAY 'Optional operands require the previous operand in order to work.'
   SAY '   Where:'
   SAY '     pid  - is the aplhanumeric name of the process to get data for.'
   SAY '            If it is all decimal it will be treated as the pid.'
   SAY '     object_type - is one of the following three:'
   SAY '          private - indicates private object summary request for given pid name'
   SAY '                    which is the DEFAULT. (Minimum letter is p)'
   SAY '          shared  - indicates shared object summary request for given pid name.'
   SAY '                    (Minimum is sh)'
   SAY '          system  - indicates system object summary requested.'
   SAY '                    (Minimum is sy)'
   SAY '     num_iterations - is the number of data collections for this run.'
   SAY '                      DEFAULT is 1 iteration.'
   SAY '     num_secs       - is the number of seconds between interations.'
   SAY '                      DEFAULT is 5 seconds.'
   EXIT 999
END

/*==================================================================+
|   Check operand to see if any have been defaulted.                |
+==================================================================*/
IF p_secs \= '' THEN secs = STRIP(p_secs);
IF p_iterations \= '' THEN iterations = p_iterations
IF p_type = '' | ABBREV('PRIVATE',STRIP(p_type),1) = 1 THEN Object_type = p_private
ELSE IF ABBREV('SHARED',STRIP(p_type),2) = 1 THEN Object_type = p_shared
ELSE IF ABBREV('SYSTEM',STRIP(p_type),2) = 1 THEN Object_type = p_system

/*==================================================================+
|   If p_pid data type is numeric then set flag so that we do not   |
| scan process list.                                                |
+==================================================================*/
IF DATATYPE(p_pid) = 'NUM' THEN pid_num = true;

/*==================================================================+
|   The following loads the necessary REXX functions and Theseus2   |
| functions.                                                        |
+==================================================================*/
call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

call RxFuncAdd 'RT2LoadFuncs', 'THESEUS0', 'RT2LoadFuncs'
rc = RT2LoadFuncs()
IF rc \= 0 THEN Say 'RT2loadfuncs rc is = 'rc

call RxFuncAdd 'RT2LoadFuncs1', 'THESEUS1', 'RT2LoadFuncs1'
rc = RT2LoadFuncs1()
IF rc \= 0 THEN Say 'RT2loadfuncs1 rc is = 'rc

/*==================================================================+
|   Get the current processes running in the system.                |
| Loop through each process and find the one that we want.          |
+==================================================================*/
IF p_pid \= 'SYSTEM' THEN
DO
   IF pid_num = true THEN
   DO
      call RT2FindProcesses "pTable"

      DO i =1 TO pTable.0
         PARSE UPPER VALUE pTable.i With Pid Parent NumThrd TaskName
         IF p_pid = Pid THEN
         DO
            found = true;
            LEAVE;
         END
      END
   END
   ELSE
   DO
      DO forever
         call RT2FindProcesses "pTable"

         DO i =1 TO pTable.0
            PARSE UPPER VALUE pTable.i With Pid Parent NumThrd TaskName
            IF p_pid = TaskName THEN
            DO
               found = true;
               LEAVE;
            END
         END
         IF found = true THEN LEAVE
         Call SysSleep 1
      END
   END
END
ELSE
DO
   found = true;
   Object_type  = p_system;
END

/*==================================================================+
|   After all parms have been checked and a pid found then loop     |
| for the number of iterations for the duration of seconds between  |
| iterations.                                                       |
+==================================================================*/
if found = true THEN
DO
   DO i = 1 TO iterations BY 1
      rc = RT2GetObjSummary( Pid , Object_type )
      if rc = 0 THEN
      DO
         SAY 'Data collected for pid 'Pid' at 'time()', on 'date(Language)'.'
         SAY ''
         SAY ''
         call SysSleep secs
      END
      ELSE
      DO
         SAY 'Return code 'rc 'from RT2GetObjectSummary.'
         EXIT
      END
   END
END
SAY 'GETOBJ has terminated.  The time is 'time()', the date is 'date(Language)'.'
EXIT
