/* CPU Throttle utility for VIA 686A/B by Lesha Bogdanow. This code is free.
   NO WARRANTY. Use at your own risk.

   To be compiled with GCC/EMX 0.9d 
 */

#include <stddef.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <os2.h>
#include <sys\hw.h>

void PCICfgOpen() {
   _portaccess(0xCF8,0xCFF);
   }
unsigned long PCICfgRead(unsigned long bus, unsigned long dev,
                unsigned long fn, unsigned long reg) {
   _outp32(0xCF8,0x80000000|(bus<<16)|(dev<<11)|(fn<<8)|reg);
   return _inp32(0xCFC);
   }
void PCICfgWrite(unsigned long bus, unsigned long dev,
                unsigned long fn, unsigned long reg, unsigned long val) {
   _outp32(0xCF8,0x80000000|(bus<<16)|(dev<<11)|(fn<<8)|reg);
   _outp32(0xCFC,val);
   }
void PCICfgClose() {
   _outp32(0xCF8,0);
   }

int main(int argc, char *argv[]) {
   unsigned long dev,bus,pmbase,val;
   int ratio=-1;
   int verbose=0;
   

   printf("CPU Throttle for VIA 686A/B by Lesha Bogdanow\n");
   printf("NO WARRANTY. Use at your own risk.\n");
   if (argc>1) {
      if (!stricmp(argv[1],"OFF")) ratio=100;
      else ratio=strtol(argv[1],NULL,10);
      }
   if ((argc<1)||(ratio<0)||(ratio>100)) {
      printf("USAGE: THROTTLE {<Percentage>|OFF}\n");
      exit(1);
      }
   PCICfgOpen();
   pmbase=0;
   if (verbose) fprintf(stderr,"Searching PCI configuration space.\n");
   for (bus=0;!pmbase&&(bus<256);bus++) for(dev=0;!pmbase&&(dev<32);dev++) {
       if (PCICfgRead(bus,dev,0,0)==0x06861106)
          pmbase=PCICfgRead(bus,dev,4,0x48)&0xFF80;
       }
   if (verbose) fprintf(stderr,"Closing PCI configuration access.\n");
   PCICfgClose();
   if (!pmbase) {
      printf("No VIA 686A/B south bridge found.\n");
      exit(1);
      }
   if (verbose) fprintf(stderr,"Found VIA 686A/B at bus %X device %X.\n",bus,dev);
   _portaccess(pmbase,pmbase+0x7F);
   ratio=(ratio*15)/100+1;
   if (ratio<2) ratio=2;	// Avoid freezing.
   if (verbose) fprintf(stderr,"Converted throttle ratio: %X.\n",ratio);
   val=_inp32(pmbase+0x10);
   if (verbose) fprintf(stderr,"Old CPU and PCI PM control register value: %08X.\n",val);
   val&=0xFFFFFFE0;
   if (ratio<=15) val|=0x10|(unsigned long)ratio;
   if (verbose) fprintf(stderr,"New CPU and PCI PM control register value: %08X.\n",val);
   _outp32(pmbase+0x10,val);
   if (verbose) fprintf(stderr,"All done, exiting.");
   exit(0);
   }
