/*:VRX         Main
*/
/*  Main
*/
Main:
/*  Process the arguments.
    Get the parent window.
*/
    parse source . calledAs .
    parent = ""
    argCount = arg()
    argOff = 0
    if( calledAs \= "COMMAND" )then do
        if argCount >= 1 then do
            parent = arg(1)
            argCount = argCount - 1
            argOff = 1
        end
    end; else do
        call VROptions 'ImplicitNames'
        call VROptions 'NoEchoQuit'
    end
    InitArgs.0 = argCount
    if( argCount > 0 )then do i = 1 to argCount
        InitArgs.i = arg( i + argOff )
    end
    drop calledAs argCount argOff

/*  Load the windows
*/
    call VRInit
    parse source . . spec
    _VREPrimaryWindowPath = ,
        VRParseFileName( spec, "dpn" ) || ".VRW"
    _VREPrimaryWindow = ,
        VRLoad( parent, _VREPrimaryWindowPath )
    drop parent spec
    if( _VREPrimaryWindow == "" )then do
        call VRMessage "", "Cannot load window:" VRError(), ,
            "Error!"
        _VREReturnValue = 32000
        signal _VRELeaveMain
    end

/*  Process events
*/
    call Init
    signal on halt
    do while( \ VRGet( _VREPrimaryWindow, "Shutdown" ) )
        _VREEvent = VREvent()
        interpret _VREEvent
    end
_VREHalt:
    _VREReturnValue = Fini()
    call VRDestroy _VREPrimaryWindow
_VRELeaveMain:
    call VRFini
exit _VREReturnValue

VRLoadSecondary:
    __vrlsWait = abbrev( 'WAIT', translate(arg(2)), 1 )
    if __vrlsWait then do
        call VRFlush
    end
    __vrlsHWnd = VRLoad( VRWindow(), VRWindowPath(), arg(1) )
    if __vrlsHWnd = '' then signal __vrlsDone
    if __vrlsWait \= 1 then signal __vrlsDone
    call VRSet __vrlsHWnd, 'WindowMode', 'Modal' 
    __vrlsTmp = __vrlsWindows.0
    if( DataType(__vrlsTmp) \= 'NUM' ) then do
        __vrlsTmp = 1
    end
    else do
        __vrlsTmp = __vrlsTmp + 1
    end
    __vrlsWindows.__vrlsTmp = VRWindow( __vrlsHWnd )
    __vrlsWindows.0 = __vrlsTmp
    do while( VRIsValidObject( VRWindow() ) = 1 )
        __vrlsEvent = VREvent()
        interpret __vrlsEvent
    end
    __vrlsTmp = __vrlsWindows.0
    __vrlsWindows.0 = __vrlsTmp - 1
    call VRWindow __vrlsWindows.__vrlsTmp 
    __vrlsHWnd = ''
__vrlsDone:
return __vrlsHWnd

/*:VRX         AdjustPos
*/
/* Determines whether or not the byte at the given position is part of a 
 * double-byte character, and (if so) where that character's actual starting 
 * position is.
 */
AdjustPos: PROCEDURE EXPOSE cwidth
    PARSE ARG flags, offset, shift

    cwidth = 0
    start  = 0
    IF flags == '' THEN RETURN 1
    IF offset < 1  THEN RETURN 1
    SELECT
        WHEN SUBSTR( flags, offset, 1 ) == 1 THEN DO
            cwidth = 2
            start  = offset
        END
        WHEN SUBSTR( flags, offset, 1 ) == 2 THEN DO
            cwidth = 2
            /* Shift = 0, move to start of previous char.
             * Shift = 1, move to start of next char.
             */
            IF shift = 0 THEN start  = offset - 1
            ELSE              start  = offset + 1
        END
        OTHERWISE DO
            cwidth = 1
            start  = offset 
        END
    END

RETURN start

/*:VRX         CharAttr
*/
/* Build a sequence of attribute flags for each byte in the text:
 *   0 = single-byte character
 *   1 = first byte of a double-byte character
 *   2 = second byte of a double-byte character
 */
CharAttr: PROCEDURE 
    PARSE ARG text, offset

    flags = ''
    dbcs  = 0
    DO i = 1 TO LENGTH( text ) 
        nextbyte = C2D( SUBSTR( text, i, 1 ))

        IF ( \dbcs ) THEN DO
            IF ( nextbyte > 128 & nextbyte < 160 ) | ( nextbyte > 223 & nextbyte < 253 ) THEN DO
                flags = flags || '1'
                dbcs  = 1
            END
            ELSE 
                flags = flags || '0'
        END
        ELSE DO
            flags = flags || '2'
            dbcs  = 0
        END
    END

RETURN flags

/*:VRX         ConvertFullwidth
*/
ConvertFullwidth: 
    PARSE ARG letter

    SELECT
        WHEN letter == 'A' THEN out = '`'
        WHEN letter == 'B' THEN out = 'a'
        WHEN letter == 'C' THEN out = 'b'
        WHEN letter == 'D' THEN out = 'c'
        WHEN letter == 'E' THEN out = 'd'
        WHEN letter == 'F' THEN out = 'e'
        WHEN letter == 'G' THEN out = 'f'
        WHEN letter == 'H' THEN out = 'g'
        WHEN letter == 'I' THEN out = 'h'
        WHEN letter == 'J' THEN out = 'i'
        WHEN letter == 'K' THEN out = 'j'
        WHEN letter == 'L' THEN out = 'k'
        WHEN letter == 'M' THEN out = 'l'
        WHEN letter == 'N' THEN out = 'm'
        WHEN letter == 'O' THEN out = 'n'
        WHEN letter == 'P' THEN out = 'o'
        WHEN letter == 'Q' THEN out = 'p'
        WHEN letter == 'R' THEN out = 'q'
        WHEN letter == 'S' THEN out = 'r'
        WHEN letter == 'T' THEN out = 's'
        WHEN letter == 'U' THEN out = 't'
        WHEN letter == 'V' THEN out = 'u'
        WHEN letter == 'W' THEN out = 'v'
        WHEN letter == 'X' THEN out = 'w'
        WHEN letter == 'Y' THEN out = 'x'
        WHEN letter == 'Z' THEN out = 'y'
        WHEN letter == 'a' THEN out = ''
        WHEN letter == 'b' THEN out = ''
        WHEN letter == 'c' THEN out = ''
        WHEN letter == 'd' THEN out = ''
        WHEN letter == 'e' THEN out = ''
        WHEN letter == 'f' THEN out = ''
        WHEN letter == 'g' THEN out = ''
        WHEN letter == 'h' THEN out = ''
        WHEN letter == 'i' THEN out = ''
        WHEN letter == 'j' THEN out = ''
        WHEN letter == 'k' THEN out = ''
        WHEN letter == 'l' THEN out = ''
        WHEN letter == 'm' THEN out = ''
        WHEN letter == 'n' THEN out = ''
        WHEN letter == 'o' THEN out = ''
        WHEN letter == 'p' THEN out = ''
        WHEN letter == 'q' THEN out = ''
        WHEN letter == 'r' THEN out = ''
        WHEN letter == 's' THEN out = ''
        WHEN letter == 't' THEN out = ''
        WHEN letter == 'u' THEN out = ''
        WHEN letter == 'v' THEN out = ''
        WHEN letter == 'w' THEN out = ''
        WHEN letter == 'x' THEN out = ''
        WHEN letter == 'y' THEN out = ''
        WHEN letter == 'z' THEN out = ''
        WHEN letter == '0' THEN out = 'O'
        WHEN letter == '1' THEN out = 'P'
        WHEN letter == '2' THEN out = 'Q'
        WHEN letter == '3' THEN out = 'R'
        WHEN letter == '4' THEN out = 'S'
        WHEN letter == '5' THEN out = 'T'
        WHEN letter == '6' THEN out = 'U'
        WHEN letter == '7' THEN out = 'V'
        WHEN letter == '8' THEN out = 'W'
        WHEN letter == '9' THEN out = 'X'
        WHEN letter == '.' THEN out = 'D'
        WHEN letter == ',' THEN out = 'C'
        WHEN letter == '!' THEN out = 'I'
        WHEN letter == '@' THEN out = ''
        WHEN letter == '#' THEN out = ''
        WHEN letter == '$' THEN out = ''
        WHEN letter == '%' THEN out = ''
        WHEN letter == '^' THEN out = 'O'
        WHEN letter == '`' THEN out = 'e'
        WHEN letter == '&' THEN out = ''
        WHEN letter == '*' THEN out = ''
        WHEN letter == '(' THEN out = 'i'
        WHEN letter == ')' THEN out = 'j'
        WHEN letter == '-' THEN out = '|'
        WHEN letter == '~' THEN out = 'P'
        WHEN letter == '+' THEN out = '{'
        WHEN letter == '_' THEN out = 'Q'
        WHEN letter == '=' THEN out = ''
        WHEN letter == '[' THEN out = 'm'
        WHEN letter == ']' THEN out = 'n'
        WHEN letter == '{' THEN out = 'o'
        WHEN letter == '}' THEN out = 'p'
        WHEN letter == '\' THEN out = '_'
        WHEN letter == '/' THEN out = '^'
        WHEN letter == ':' THEN out = 'F'
        WHEN letter == ';' THEN out = 'G'
        WHEN letter == '<' THEN out = 'q'
        WHEN letter == '>' THEN out = 'r'
        WHEN letter == '?' THEN out = 'H'
        WHEN letter == "'" THEN out = 'f'
        WHEN letter == '"' THEN out = 'W'
        WHEN letter == ' ' THEN out = '@'

        WHEN letter == '' THEN out = ''
        OTHERWISE out = letter
    END

RETURN out

/*:VRX         ConvertKana
*/
ConvertKana: 
    PARSE ARG wapuro

    IF VRGet('MI_FULLWIDTH', 'Checked') THEN DO

        IF VERIFY( LEFT( wapuro, 1 ), 'ABCDEFGHIJKLMNOPQRSTUVWXYZ') == 0 THEN 
            wapuro = TRANSLATE( wapuro )

        SELECT
        /* ideographic punctuation characters */
            WHEN wapuro == ' '                      THEN out = '@'
            WHEN wapuro == ','                      THEN out = 'A'
            WHEN wapuro == '.'                      THEN out = 'B'
            WHEN wapuro == '-'                      THEN out = '['
            WHEN wapuro == '|'                      THEN out = 'E'
            WHEN wapuro == "'"                      THEN out = 'u'
            WHEN wapuro == '"'                      THEN out = 'v'

        /* hiragana */
            WHEN wapuro == 'a'                      THEN DO 
                                                        IF smallkana == 1 THEN out = '' 
                                                        ELSE                   out = '' 
                                                    END
            WHEN wapuro == 'i'                      THEN DO 
                                                        IF smallkana == 1 THEN out = '' 
                                                        ELSE                   out = ''
                                                    END
            WHEN wapuro == 'u'                      THEN DO 
                                                        IF smallkana == 1 THEN out = '' 
                                                        ELSE                   out = '' 
                                                    END
            WHEN wapuro == 'e'                      THEN DO 
                                                        IF smallkana == 1 THEN out = '' 
                                                        ELSE                   out = '' 
                                                    END
            WHEN wapuro == 'o'                      THEN DO 
                                                        IF smallkana == 1 THEN out = '' 
                                                        ELSE                   out = '' 
                                                    END
            WHEN wapuro == 'ka'                     THEN out = ''
            WHEN wapuro == 'ki'                     THEN out = ''
            WHEN wapuro == 'ku'                     THEN out = ''
            WHEN wapuro == 'ke'                     THEN out = ''
            WHEN wapuro == 'ko'                     THEN out = ''
            WHEN wapuro == 'ga'                     THEN out = ''
            WHEN wapuro == 'gi'                     THEN out = ''
            WHEN wapuro == 'gu'                     THEN out = ''
            WHEN wapuro == 'ge'                     THEN out = ''
            WHEN wapuro == 'go'                     THEN out = ''
            WHEN wapuro == 'sa'                     THEN out = ''
            WHEN wapuro == 'shi' | wapuro == 'si'   THEN out = ''
            WHEN wapuro == 'su'                     THEN out = ''
            WHEN wapuro == 'se'                     THEN out = ''
            WHEN wapuro == 'so'                     THEN out = ''
            WHEN wapuro == 'za'                     THEN out = ''
            WHEN wapuro == 'ji' | wapuro == 'zi'    THEN out = ''
            WHEN wapuro == 'zu'                     THEN out = ''
            WHEN wapuro == 'ze'                     THEN out = ''
            WHEN wapuro == 'zo'                     THEN out = ''
            WHEN wapuro == 'ta'                     THEN out = ''
            WHEN wapuro == 'chi' | wapuro == 'ti'   THEN out = ''
            WHEN wapuro == 'tsu' | wapuro == 'tu'   THEN DO 
                                                        IF smallkana == 1 THEN out = '' 
                                                        ELSE                   out = '' 
                                                    END
            WHEN wapuro == 'te'                     THEN out = ''
            WHEN wapuro == 'to'                     THEN out = ''
            WHEN wapuro == 'da'                     THEN out = ''
            WHEN wapuro == 'di' | wapuro == 'dzi'   THEN out = ''
            WHEN wapuro == 'du' | wapuro == 'dzu'   THEN out = ''
            WHEN wapuro == 'de'                     THEN out = ''
            WHEN wapuro == 'do'                     THEN out = ''
            WHEN wapuro == 'na'                     THEN out = ''
            WHEN wapuro == 'ni'                     THEN out = ''
            WHEN wapuro == 'nu'                     THEN out = ''
            WHEN wapuro == 'ne'                     THEN out = ''
            WHEN wapuro == 'no'                     THEN out = ''
            WHEN wapuro == 'ha'                     THEN out = ''
            WHEN wapuro == 'hi'                     THEN out = ''
            WHEN wapuro == 'fu'                     THEN out = ''
            WHEN wapuro == 'he'                     THEN out = ''
            WHEN wapuro == 'ho'                     THEN out = ''
            WHEN wapuro == 'ba'                     THEN out = ''
            WHEN wapuro == 'bi'                     THEN out = ''
            WHEN wapuro == 'bu'                     THEN out = ''
            WHEN wapuro == 'be'                     THEN out = ''
            WHEN wapuro == 'bo'                     THEN out = ''
            WHEN wapuro == 'pa'                     THEN out = ''
            WHEN wapuro == 'pi'                     THEN out = ''
            WHEN wapuro == 'pu'                     THEN out = ''
            WHEN wapuro == 'pe'                     THEN out = ''
            WHEN wapuro == 'po'                     THEN out = ''
            WHEN wapuro == 'ma'                     THEN out = ''
            WHEN wapuro == 'mi'                     THEN out = ''
            WHEN wapuro == 'mu'                     THEN out = ''
            WHEN wapuro == 'me'                     THEN out = ''
            WHEN wapuro == 'mo'                     THEN out = ''
            WHEN wapuro == 'ya'                     THEN DO 
                                                        IF smallkana == 1 THEN out = '' 
                                                        ELSE                   out = ''
                                                    END
            WHEN wapuro == 'yu'                     THEN DO 
                                                        IF smallkana == 1 THEN out = '' 
                                                        ELSE                   out = ''
                                                    END
            WHEN wapuro == 'yo'                     THEN DO 
                                                        IF smallkana == 1 THEN out = '' 
                                                        ELSE                   out = ''
                                                    END
            WHEN wapuro == 'ra' | wapuro == 'la'    THEN out = ''
            WHEN wapuro == 'ri' | wapuro == 'li'    THEN out = ''
            WHEN wapuro == 'ru' | wapuro == 'lu'    THEN out = ''
            WHEN wapuro == 're' | wapuro == 'le'    THEN out = ''
            WHEN wapuro == 'ro' | wapuro == 'lo'    THEN out = ''
            WHEN wapuro == 'wa'                     THEN DO 
                                                        IF smallkana == 1 THEN out = '' 
                                                        ELSE                   out = ''
                                                    END
            WHEN wapuro == 'wo'                     THEN out = ''
            WHEN wapuro == 'n'  | wapuro == 'm'     THEN out = ''
            WHEN wapuro == 'kya'                    THEN out = ''
            WHEN wapuro == 'kyu'                    THEN out = ''
            WHEN wapuro == 'kyo'                    THEN out = ''
            WHEN wapuro == 'gya'                    THEN out = ''
            WHEN wapuro == 'gyu'                    THEN out = ''
            WHEN wapuro == 'gyo'                    THEN out = ''
            WHEN wapuro == 'sha' | wapuro == 'sya'  THEN out = ''
            WHEN wapuro == 'shu' | wapuro == 'syu'  THEN out = ''
            WHEN wapuro == 'sho' | wapuro == 'syo'  THEN out = ''
            WHEN wapuro == 'ja'  | wapuro == 'zya'  THEN out = ''
            WHEN wapuro == 'ju'  | wapuro == 'zyu'  THEN out = ''
            WHEN wapuro == 'jo'  | wapuro == 'zyo'  THEN out = ''
            WHEN wapuro == 'cha'                    THEN out = ''
            WHEN wapuro == 'chu'                    THEN out = ''
            WHEN wapuro == 'cho'                    THEN out = ''
            WHEN wapuro == 'nya'                    THEN out = 'ɂ'
            WHEN wapuro == 'nyu'                    THEN out = 'ɂ'
            WHEN wapuro == 'nyo'                    THEN out = 'ɂ'
            WHEN wapuro == 'hya'                    THEN out = 'Ђ'
            WHEN wapuro == 'hyu'                    THEN out = 'Ђ'
            WHEN wapuro == 'hyo'                    THEN out = 'Ђ'
            WHEN wapuro == 'bya'                    THEN out = 'т'
            WHEN wapuro == 'byu'                    THEN out = 'т'
            WHEN wapuro == 'byo'                    THEN out = 'т'
            WHEN wapuro == 'pya'                    THEN out = '҂'
            WHEN wapuro == 'pyu'                    THEN out = '҂'
            WHEN wapuro == 'pyo'                    THEN out = '҂'
            WHEN wapuro == 'mya'                    THEN out = '݂'
            WHEN wapuro == 'myu'                    THEN out = '݂'
            WHEN wapuro == 'myo'                    THEN out = '݂'
            WHEN wapuro == 'rya'                    THEN out = ''
            WHEN wapuro == 'ryu'                    THEN out = ''
            WHEN wapuro == 'ryo'                    THEN out = ''

        /* katakana */
            WHEN wapuro == 'A'                      THEN DO 
                                                        IF smallkana == 1 THEN out = '@' 
                                                        ELSE out = 'A'
                                                    END
            WHEN wapuro == 'I'                      THEN DO 
                                                        IF smallkana == 1 THEN out = 'B' 
                                                        ELSE out = 'C'
                                                    END
            WHEN wapuro == 'U'                      THEN DO 
                                                        IF smallkana == 1 THEN out = 'D' 
                                                        ELSE out = 'E'
                                                    END
            WHEN wapuro == 'E'                      THEN DO 
                                                        IF smallkana == 1 THEN out = 'F' 
                                                        ELSE out = 'G'
                                                    END
            WHEN wapuro == 'O'                      THEN DO 
                                                        IF smallkana == 1 THEN out = 'H' 
                                                        ELSE out = 'I'
                                                    END
            WHEN wapuro == 'KA'                     THEN DO 
                                                        IF smallkana == 1 THEN out = '' 
                                                        ELSE out = 'J'
                                                    END
            WHEN wapuro == 'KI'                     THEN out = 'L'
            WHEN wapuro == 'KU'                     THEN out = 'N'
            WHEN wapuro == 'KE'                     THEN DO 
                                                        IF smallkana == 1 THEN out = '' 
                                                        ELSE out = 'P'
                                                    END
            WHEN wapuro == 'KO'                     THEN out = 'R'
            WHEN wapuro == 'GA'                     THEN out = 'K'
            WHEN wapuro == 'GI'                     THEN out = 'M'
            WHEN wapuro == 'GU'                     THEN out = 'O'
            WHEN wapuro == 'GE'                     THEN out = 'Q'
            WHEN wapuro == 'GO'                     THEN out = 'S'
            WHEN wapuro == 'SA'                     THEN out = 'T'
            WHEN wapuro == 'SHI' | wapuro == 'SI'   THEN out = 'V'
            WHEN wapuro == 'SU'                     THEN out = 'X'
            WHEN wapuro == 'SE'                     THEN out = 'Z'
            WHEN wapuro == 'SO'                     THEN out = '\'
            WHEN wapuro == 'ZA'                     THEN out = 'U'
            WHEN wapuro == 'JI' | wapuro == 'ZI'    THEN out = 'W'
            WHEN wapuro == 'ZU'                     THEN out = 'Y'
            WHEN wapuro == 'ZE'                     THEN out = '['
            WHEN wapuro == 'ZO'                     THEN out = ']'
            WHEN wapuro == 'TA'                     THEN out = '^'
            WHEN wapuro == 'CHI'                    THEN out = '`'
            WHEN wapuro == 'TSU' | wapuro == 'TU'   THEN DO 
                                                        IF smallkana == 1 THEN out = 'b' 
                                                        ELSE                   out = 'c'
                                                    END
            WHEN wapuro == 'TE'                     THEN out = 'e'
            WHEN wapuro == 'TO'                     THEN out = 'g'
            WHEN wapuro == 'DA'                     THEN out = '_'
            WHEN wapuro == 'DZI'                    THEN out = 'a'
            WHEN wapuro == 'DU' | wapuro == 'DZU'   THEN out = 'd'
            WHEN wapuro == 'DE'                     THEN out = 'f'
            WHEN wapuro == 'DO'                     THEN out = 'h'
            WHEN wapuro == 'NA'                     THEN out = 'i'
            WHEN wapuro == 'NI'                     THEN out = 'j'
            WHEN wapuro == 'NU'                     THEN out = 'k'
            WHEN wapuro == 'NE'                     THEN out = 'l'
            WHEN wapuro == 'NO'                     THEN out = 'm'
            WHEN wapuro == 'HA'                     THEN out = 'n'
            WHEN wapuro == 'HI'                     THEN out = 'q'
            WHEN wapuro == 'FU' | wapuro == 'HU'    THEN out = 't'
            WHEN wapuro == 'HE'                     THEN out = 'w'
            WHEN wapuro == 'HO'                     THEN out = 'z'
            WHEN wapuro == 'BA'                     THEN out = 'o'
            WHEN wapuro == 'BI'                     THEN out = 'r'
            WHEN wapuro == 'BU'                     THEN out = 'u'
            WHEN wapuro == 'BE'                     THEN out = 'x'
            WHEN wapuro == 'BO'                     THEN out = '{'
            WHEN wapuro == 'PA'                     THEN out = 'p'
            WHEN wapuro == 'PI'                     THEN out = 's'
            WHEN wapuro == 'PU'                     THEN out = 'v'
            WHEN wapuro == 'PE'                     THEN out = 'y'
            WHEN wapuro == 'PO'                     THEN out = '|'
            WHEN wapuro == 'MA'                     THEN out = '}'
            WHEN wapuro == 'MI'                     THEN out = '~'
            WHEN wapuro == 'MU'                     THEN out = ''
            WHEN wapuro == 'ME'                     THEN out = ''
            WHEN wapuro == 'MO'                     THEN out = ''
            WHEN wapuro == 'YA'                     THEN DO 
                                                        IF smallkana == 1 THEN out = '' 
                                                        ELSE                   out = ''
                                                    END
            WHEN wapuro == 'YU'                     THEN DO 
                                                        IF smallkana == 1 THEN out = '' 
                                                        ELSE                   out = ''
                                                    END
            WHEN wapuro == 'YO'                     THEN DO 
                                                        IF smallkana == 1 THEN out = '' 
                                                        ELSE                   out = ''
                                                    END
            WHEN wapuro == 'RA' | wapuro == 'LA'    THEN out = ''
            WHEN wapuro == 'RI' | wapuro == 'LI'    THEN out = ''
            WHEN wapuro == 'RU' | wapuro == 'LU'    THEN out = ''
            WHEN wapuro == 'RE' | wapuro == 'LE'    THEN out = ''
            WHEN wapuro == 'RO' | wapuro == 'LO'    THEN out = ''
            WHEN wapuro == 'WA'                     THEN DO 
                                                        IF smallkana == 1 THEN out = '' 
                                                        ELSE                   out = ''
                                                    END
            WHEN wapuro == 'WO'                     THEN out = ''
            WHEN wapuro == 'N'  | wapuro == 'M'     THEN out = ''
            WHEN wapuro == 'KYA'                    THEN out = 'L'
            WHEN wapuro == 'KYU'                    THEN out = 'L'
            WHEN wapuro == 'KYO'                    THEN out = 'L'
            WHEN wapuro == 'GYA'                    THEN out = 'M'
            WHEN wapuro == 'GYU'                    THEN out = 'M'
            WHEN wapuro == 'GYO'                    THEN out = 'M'
            WHEN wapuro == 'SHA' | wapuro == 'SYA'  THEN out = 'V'
            WHEN wapuro == 'SHU' | wapuro == 'SYU'  THEN out = 'V'
            WHEN wapuro == 'SHO' | wapuro == 'SYO'  THEN out = 'V'
            WHEN wapuro == 'JA'  | wapuro == 'ZYA'  THEN out = 'W'
            WHEN wapuro == 'JU'  | wapuro == 'ZYU'  THEN out = 'W'
            WHEN wapuro == 'JO'  | wapuro == 'ZYO'  THEN out = 'W'
            WHEN wapuro == 'CHA'                    THEN out = '`'
            WHEN wapuro == 'CHU'                    THEN out = '`'
            WHEN wapuro == 'CHO'                    THEN out = '`'
            WHEN wapuro == 'NYA'                    THEN out = 'j'
            WHEN wapuro == 'NYU'                    THEN out = 'j'
            WHEN wapuro == 'NYO'                    THEN out = 'j'
            WHEN wapuro == 'HYA'                    THEN out = 'q'
            WHEN wapuro == 'HYU'                    THEN out = 'q'
            WHEN wapuro == 'HYO'                    THEN out = 'q'
            WHEN wapuro == 'BYA'                    THEN out = 'r'
            WHEN wapuro == 'BYU'                    THEN out = 'r'
            WHEN wapuro == 'BYO'                    THEN out = 'r'
            WHEN wapuro == 'PYA'                    THEN out = 's'
            WHEN wapuro == 'PYU'                    THEN out = 's'
            WHEN wapuro == 'PYO'                    THEN out = 's'
            WHEN wapuro == 'MYA'                    THEN out = '~'
            WHEN wapuro == 'MYU'                    THEN out = '~'
            WHEN wapuro == 'MYO'                    THEN out = '~'
            WHEN wapuro == 'RYA'                    THEN out = ''
            WHEN wapuro == 'RYU'                    THEN out = ''
            WHEN wapuro == 'RYO'                    THEN out = ''

        /* special katakana forms */
            WHEN wapuro == 'KWA' THEN out = 'N'
            WHEN wapuro == 'KWO' THEN out = 'NH'
            WHEN wapuro == 'GWA' THEN out = 'O'
            WHEN wapuro == 'SHE' THEN out = 'VF'
            WHEN wapuro == 'JE'  THEN out = 'WF'
            WHEN wapuro == 'CHE' THEN out = '`F'
            WHEN wapuro == 'TSA' THEN out = 'c'
            WHEN wapuro == 'TSE' THEN out = 'cF'
            WHEN wapuro == 'TSO' THEN out = 'cH'
            WHEN wapuro == 'TI'  THEN out = 'eB'
            WHEN wapuro == 'DI'  THEN out = 'fB'
            WHEN wapuro == 'DYU' THEN out = 'f'
            WHEN wapuro == 'FA'  THEN out = 't'
            WHEN wapuro == 'FI'  THEN out = 'tB'
            WHEN wapuro == 'FE'  THEN out = 'tF'
            WHEN wapuro == 'FO'  THEN out = 'tH'
            WHEN wapuro == 'WI'  THEN out = 'EB'
            WHEN wapuro == 'WE'  THEN out = 'EF'
            WHEN wapuro == 'WO'  THEN out = 'EH'
            WHEN wapuro == 'YE'  THEN out = 'CF'
            WHEN wapuro == 'VA'  THEN out = ''
            WHEN wapuro == 'VI'  THEN out = 'B'
            WHEN wapuro == 'VU'  THEN out = ''
            WHEN wapuro == 'VE'  THEN out = 'F'
            WHEN wapuro == 'VO'  THEN out = 'H'

            WHEN wapuro == '' THEN out = ''
            OTHERWISE              out = ConvertFullwidth( wapuro )
        END
    END

    ELSE DO
        /* When fullwidth mode is off, all kana will be converted to halfwidth 
         * katakana.
         */
        wapuro = TRANSLATE( wapuro )
        SELECT
            WHEN wapuro == ','                      THEN out = ''
            WHEN wapuro == '.'                      THEN out = ''
            WHEN wapuro == '-'                      THEN out = ''
            WHEN wapuro == '|'                      THEN out = ''
            WHEN wapuro == "'"                      THEN out = ''
            WHEN wapuro == '"'                      THEN out = ''

            WHEN wapuro == 'A'                      THEN DO 
                                                        IF smallkana == 1 THEN out = ''
                                                        ELSE                   out = ''
                                                    END
            WHEN wapuro == 'I'                      THEN DO 
                                                        IF smallkana == 1 THEN out = ''
                                                        ELSE                   out = ''
                                                    END
            WHEN wapuro == 'U'                      THEN DO 
                                                        IF smallkana == 1 THEN out = ''
                                                        ELSE                   out = ''
                                                    END
            WHEN wapuro == 'E'                      THEN DO 
                                                        IF smallkana == 1 THEN out = ''
                                                        ELSE                   out = ''
                                                    END
            WHEN wapuro == 'O'                      THEN DO 
                                                        IF smallkana == 1 THEN out = ''
                                                        ELSE                   out = ''
                                                    END
            WHEN wapuro == 'KA'                     THEN out = ''
            WHEN wapuro == 'KI'                     THEN out = ''
            WHEN wapuro == 'KU'                     THEN out = ''
            WHEN wapuro == 'KE'                     THEN out = ''
            WHEN wapuro == 'KO'                     THEN out = ''
            WHEN wapuro == 'GA'                     THEN out = ''
            WHEN wapuro == 'GI'                     THEN out = ''
            WHEN wapuro == 'GU'                     THEN out = ''
            WHEN wapuro == 'GE'                     THEN out = ''
            WHEN wapuro == 'GO'                     THEN out = ''
            WHEN wapuro == 'SA'                     THEN out = ''
            WHEN wapuro == 'SHI' | wapuro == 'SI'   THEN out = ''
            WHEN wapuro == 'SU'                     THEN out = ''
            WHEN wapuro == 'SE'                     THEN out = ''
            WHEN wapuro == 'SO'                     THEN out = ''
            WHEN wapuro == 'ZA'                     THEN out = ''
            WHEN wapuro == 'JI' | wapuro == 'ZI'    THEN out = ''
            WHEN wapuro == 'ZU'                     THEN out = ''
            WHEN wapuro == 'ZE'                     THEN out = ''
            WHEN wapuro == 'ZO'                     THEN out = ''
            WHEN wapuro == 'TA'                     THEN out = ''
            WHEN wapuro == 'CHI'                    THEN out = ''
            WHEN wapuro == 'TSU' | wapuro == 'TU'   THEN DO 
                                                        IF smallkana == 1 THEN out = ''
                                                        ELSE                   out = ''
                                                    END
            WHEN wapuro == 'TE'                     THEN out = ''
            WHEN wapuro == 'TO'                     THEN out = ''
            WHEN wapuro == 'DA'                     THEN out = ''
            WHEN wapuro == 'DZI'                    THEN out = ''
            WHEN wapuro == 'DU' | wapuro == 'DZU'   THEN out = ''
            WHEN wapuro == 'DE'                     THEN out = ''
            WHEN wapuro == 'DO'                     THEN out = ''
            WHEN wapuro == 'NA'                     THEN out = ''
            WHEN wapuro == 'NI'                     THEN out = ''
            WHEN wapuro == 'NU'                     THEN out = ''
            WHEN wapuro == 'NE'                     THEN out = ''
            WHEN wapuro == 'NO'                     THEN out = ''
            WHEN wapuro == 'HA'                     THEN out = ''
            WHEN wapuro == 'HI'                     THEN out = ''
            WHEN wapuro == 'FU' | wapuro == 'HU'    THEN out = ''
            WHEN wapuro == 'HE'                     THEN out = ''
            WHEN wapuro == 'HO'                     THEN out = ''
            WHEN wapuro == 'BA'                     THEN out = ''
            WHEN wapuro == 'BI'                     THEN out = ''
            WHEN wapuro == 'BU'                     THEN out = ''
            WHEN wapuro == 'BE'                     THEN out = ''
            WHEN wapuro == 'BO'                     THEN out = ''
            WHEN wapuro == 'PA'                     THEN out = ''
            WHEN wapuro == 'PI'                     THEN out = ''
            WHEN wapuro == 'PU'                     THEN out = ''
            WHEN wapuro == 'PE'                     THEN out = ''
            WHEN wapuro == 'PO'                     THEN out = ''
            WHEN wapuro == 'MA'                     THEN out = ''
            WHEN wapuro == 'MI'                     THEN out = ''
            WHEN wapuro == 'MU'                     THEN out = ''
            WHEN wapuro == 'ME'                     THEN out = ''
            WHEN wapuro == 'MO'                     THEN out = ''
            WHEN wapuro == 'YA'                     THEN DO 
                                                        IF smallkana == 1 THEN out = ''
                                                        ELSE                   out = ''
                                                    END
            WHEN wapuro == 'YU'                     THEN DO 
                                                        IF smallkana == 1 THEN out = ''
                                                        ELSE                   out = ''
                                                    END
            WHEN wapuro == 'YO'                     THEN DO 
                                                        IF smallkana == 1 THEN out = ''
                                                        ELSE                   out = ''
                                                    END
            WHEN wapuro == 'RA' | wapuro == 'LA'    THEN out = ''
            WHEN wapuro == 'RI' | wapuro == 'LI'    THEN out = ''
            WHEN wapuro == 'RU' | wapuro == 'LU'    THEN out = ''
            WHEN wapuro == 'RE' | wapuro == 'LE'    THEN out = ''
            WHEN wapuro == 'RO' | wapuro == 'LO'    THEN out = ''
            WHEN wapuro == 'WA'                     THEN out = ''
            WHEN wapuro == 'WO'                     THEN out = ''
            WHEN wapuro == 'N'  | wapuro == 'M'     THEN out = ''
            WHEN wapuro == 'KYA'                    THEN out = ''
            WHEN wapuro == 'KYU'                    THEN out = ''
            WHEN wapuro == 'KYO'                    THEN out = ''
            WHEN wapuro == 'GYA'                    THEN out = 'ެ'
            WHEN wapuro == 'GYU'                    THEN out = 'ޭ'
            WHEN wapuro == 'GYO'                    THEN out = 'ޮ'
            WHEN wapuro == 'SHA' | wapuro == 'SYA'  THEN out = ''
            WHEN wapuro == 'SHU' | wapuro == 'SYU'  THEN out = ''
            WHEN wapuro == 'SHO' | wapuro == 'SYO'  THEN out = ''
            WHEN wapuro == 'JA'  | wapuro == 'ZYA'  THEN out = 'ެ'
            WHEN wapuro == 'JU'  | wapuro == 'ZYU'  THEN out = 'ޭ'
            WHEN wapuro == 'JO'  | wapuro == 'ZYO'  THEN out = 'ޮ'
            WHEN wapuro == 'CHA'                    THEN out = ''
            WHEN wapuro == 'CHU'                    THEN out = ''
            WHEN wapuro == 'CHO'                    THEN out = ''
            WHEN wapuro == 'NYA'                    THEN out = 'Ƭ'
            WHEN wapuro == 'NYU'                    THEN out = 'ƭ'
            WHEN wapuro == 'NYO'                    THEN out = 'Ʈ'
            WHEN wapuro == 'HYA'                    THEN out = 'ˬ'
            WHEN wapuro == 'HYU'                    THEN out = '˭'
            WHEN wapuro == 'HYO'                    THEN out = 'ˮ'
            WHEN wapuro == 'BYA'                    THEN out = 'ެ'
            WHEN wapuro == 'BYU'                    THEN out = 'ޭ'
            WHEN wapuro == 'BYO'                    THEN out = 'ޮ'
            WHEN wapuro == 'PYA'                    THEN out = '߬'
            WHEN wapuro == 'PYU'                    THEN out = '߭'
            WHEN wapuro == 'PYO'                    THEN out = '߮'
            WHEN wapuro == 'MYA'                    THEN out = 'Ь'
            WHEN wapuro == 'MYU'                    THEN out = 'Э'
            WHEN wapuro == 'MYO'                    THEN out = 'Ю'
            WHEN wapuro == 'RYA'                    THEN out = 'ج'
            WHEN wapuro == 'RYU'                    THEN out = 'ح'
            WHEN wapuro == 'RYO'                    THEN out = 'خ'
            WHEN wapuro == 'KWA'                    THEN out = ''
            WHEN wapuro == 'KWO'                    THEN out = ''
            WHEN wapuro == 'GWA'                    THEN out = 'ާ'
            WHEN wapuro == 'SHE'                    THEN out = 'ޫ'
            WHEN wapuro == 'JE'                     THEN out = 'ު'
            WHEN wapuro == 'CHE'                    THEN out = ''
            WHEN wapuro == 'TSA'                    THEN out = '§'
            WHEN wapuro == 'TSE'                    THEN out = 'ª'
            WHEN wapuro == 'TSO'                    THEN out = '«'
            WHEN wapuro == 'TI'                     THEN out = 'è'
            WHEN wapuro == 'DI'                     THEN out = 'ި'
            WHEN wapuro == 'DYU'                    THEN out = 'ޭ'
            WHEN wapuro == 'FA'                     THEN out = '̧'
            WHEN wapuro == 'FI'                     THEN out = '̨'
            WHEN wapuro == 'FE'                     THEN out = '̪'
            WHEN wapuro == 'FO'                     THEN out = '̫'
            WHEN wapuro == 'WI'                     THEN out = ''
            WHEN wapuro == 'WE'                     THEN out = ''
            WHEN wapuro == 'WO'                     THEN out = ''
            WHEN wapuro == 'YE'                     THEN out = ''
            WHEN wapuro == 'VA'                     THEN out = 'ާ'
            WHEN wapuro == 'VI'                     THEN out = 'ި'
            WHEN wapuro == 'VU'                     THEN out = ''
            WHEN wapuro == 'VE'                     THEN out = 'ު'
            WHEN wapuro == 'VO'                     THEN out = 'ޫ'
            OTHERWISE
                out = wapuro
        END
    END
    smallkana = 0

    ok = VRMethod( "MLE_INPUT", "Insert", out )

RETURN 1

/*:VRX         DoCopy
*/
DoCopy: PROCEDURE EXPOSE rxuls
    PARSE ARG cliptext

    CALL VRMethod 'Application', 'PutClipboard', cliptext
    IF rxuls THEN DO
        CALL ULSPutUnicodeClipboard cliptext, 932 
/*
        IF ULSERR \= '0' THEN SAY ULSERR 
        CALL BEEP 262, 10
        CALL BEEP 440, 10
*/
    END

RETURN

/*:VRX         DoPaste
*/
DoPaste: PROCEDURE EXPOSE rxuls

    IF rxuls THEN DO
        cliptext = ULSGetUnicodeClipboard( 932 ) 
        /* IF ULSERR \= '0' THEN SAY ULSERR */
        IF cliptext == '' THEN 
            cliptext = VRMethod('Application', 'GetClipboard')
/*
        ELSE DO
            CALL BEEP 440, 10
            CALL BEEP 262, 10
        END
*/
    END
    ELSE
        cliptext = VRMethod('Application', 'GetClipboard')

    /* Only accept the first line of clipboard text, because linebreaks play 
     * havoc with the boundary parsing logic.
     */
    cliptext = TRANSLATE( cliptext, '0d'x, '0a'x )
    PARSE VAR cliptext pastetext '0d'x .
    CALL VRMethod 'MLE_INPUT', 'Insert', pastetext 

RETURN

/*:VRX         Fini
*/
Fini:
    window = VRWindow()
    call VRSet window, "Visible", 0
    drop window
return 0

/*:VRX         Halt
*/
Halt:
    signal _VREHalt
return

/*:VRX         Init
*/
Init:
    CALL RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
    CALL SysLoadFuncs

    /* Attempt to load RXULS library (used for Unicode clipboard support).
     */
    rxuls = 0
    CALL RxFuncAdd 'ULSLoadFuncs', 'RXULS', 'ULSLoadFuncs'
    CALL ULSLoadFuncs
    IF RxFuncQuery('ULSGetUnicodeClipboard') == 0 THEN rxuls = 1

    /* Hide the VX-REXX console window. 
     */
    CALL VRSet 'Console', 'WindowListTitle', '' 

    /* Set up the user interface defaults.
     */
    CALL LoadPrefs
    CALL UpdateStatus

    window = VRWindow()
    call VRSet window, "Visible", 1
    call VRMethod window, "Activate"
    drop window

    kana  = ''
    state = 0
    smallkana = 0

RETURN

/*:VRX         LoadPrefs
*/
LoadPrefs: PROCEDURE EXPOSE settings.

    os2_ini = VALUE('USER_INI',,'OS2ENVIRONMENT')
    inipath = VRParseFilePath( os2_ini, 'DP')
    IF inipath == '' THEN inipath = SysBootDrive() || '\OS2'

    settings.!ini = inipath'\imerj.ini'
    IF STREAM( settings.!ini, 'C', 'QUERY EXISTS') == '' THEN DO
        CALL VRMethod VRWindow(), 'CenterWindow'
        RETURN
    END

    /* Load position and size settings
     */
    settings.!x      = VRGetIni('Window', 'Left',   settings.!ini, 'NoClose')
    settings.!y      = VRGetIni('Window', 'Top',    settings.!ini, 'NoClose')
    settings.!width  = VRGetIni('Window', 'Width',  settings.!ini, 'NoClose')
    settings.!height = VRGetIni('Window', 'Height', settings.!ini, 'NoClose')
    IF settings.!x      == '' THEN settings.!x      = -1
    IF settings.!y      == '' THEN settings.!y      = -1
    IF settings.!width  == '' THEN settings.!width  = 0
    IF settings.!height == '' THEN settings.!height = 0

    /* Load font and colour settings
     */
    settings.!bgclr   = VRGetIni('Style', 'Background', settings.!ini, 'NoClose')
    settings.!fgclr   = VRGetIni('Style', 'Foreground', settings.!ini, 'NoClose')
    settings.!font    = VRGetIni('Style', 'Font',       settings.!ini )
    IF settings.!bgclr == '' THEN settings.!bgclr = 'EntryField'
    IF settings.!fgclr == '' THEN settings.!fgclr = 'OutputText'
    IF settings.!font  == '' THEN settings.!font  = '10.Times New Roman MT 30'

    /*
     * Now apply the settings
     */
    IF ( settings.!width > 0 ) & ( settings.!height > 0 ) THEN DO
        CALL VRSet VRWindow(), 'Width',  settings.!width
        CALL VRSet VRWindow(), 'Height', settings.!height
    END
    IF ( settings.!x >= 0 ) & ( settings.!y >= 0 ) THEN DO
        CALL VRSet VRWindow(), 'Left', settings.!x
        CALL VRSet VRWindow(), 'Top',  settings.!y
    END
    ELSE 
        CALL VRMethod VRWindow(), 'CenterWindow'

    CALL VRSet 'MLE_INPUT', 'Font',      settings.!font
    CALL VRSet 'MLE_INPUT', 'BackColor', settings.!bgclr
    CALL VRSet 'MLE_INPUT', 'ForeColor', settings.!fgclr

RETURN

/*:VRX         MI_ABOUT_Click
*/
MI_ABOUT_Click: 
    CALL VRLoadSecondary 'SW_ABOUT', 'W'
return

/*:VRX         MI_EXIT_Click
*/
MI_EXIT_Click: 
    CALL Quit
return

/*:VRX         MI_FULLWIDTH_Click
*/
MI_FULLWIDTH_Click: 
    mode = VRGet('MI_FULLWIDTH', 'Checked')
    mode = \mode
    CALL VRSet 'MI_FULLWIDTH', 'Checked', mode
    CALL UpdateStatus
RETURN

/*:VRX         MI_ROMAJI_Click
*/
MI_ROMAJI_Click: 
    CALL ToggleConversion
    CALL UpdateStatus
RETURN

/*:VRX         MLE_INPUT_KeyPress
*/
MLE_INPUT_KeyPress: 

    /* Get the current contents, cursor position and selection attributes.
     * (1 represents the first character; the cursor position is measured
     * from the preceding character boundary.  Note that SetSel and QuerySel
     * actually start from 0, so we have to adjust by one when using either.)
     */
    inputchar  = VRGet('MLE_INPUT', 'KeyString')
    contents   = VRGet('MLE_INPUT', 'Value')
    cursor     = VRMethod('MLE_INPUT', 'QuerySel', 'cursor')  + 1
    markleft   = VRMethod('MLE_INPUT', 'QuerySel', 'minimum') + 1
    markright  = VRMethod('MLE_INPUT', 'QuerySel', 'maximum') + 1
    marklength = markright - markleft

    /* For some reason, alphabetic keyboard accelerators aren't processed
     * when CapsLock is on.  
     */
    IF inputchar == '{Ctrl}F' THEN DO
        CALL MI_FULLWIDTH_Click
        RETURN 
    END

    /* A couple of special characters that require Alt as a modifier.
     */
    IF inputchar == '{Alt}0' THEN inputchar = '~'
    IF inputchar == '{Alt}/' THEN inputchar = '\'

    /* Locate all the character boundaries (since this is variable-width text).
     */
    flags = CharAttr( contents )

    /* Now locate the "correct" cursor position (on a character boundary).
     */
    cursor = AdjustPos( flags, cursor, 0 )

    /* Here we handle control keys that change the text contents.  (The MLE 
     * would normally handle most of these itself, except that we had to make it
     * read-only in order to override the text input behaviour.  So we have to
     * handle all update actions ourselves.)
     */
    IF LEFT( inputchar, 1 ) == '{' THEN DO

        SELECT

            /* Handle cut and paste events.  
             */
            WHEN inputchar == '{Shift}{Ins}' THEN DO
                state = 0
                kana = ''
                CALL DoPaste
            END

            WHEN inputchar == '{Ctrl}{Ins}' THEN DO
                state = 0
                kana = ''

                /* Adjust text selection to match character boundaries.
                 */
                markleft  = AdjustPos( flags, markleft,  0 )
                markright = AdjustPos( flags, markright, 1 )
                IF marklength > 0 THEN 
                    marklength = markright - markleft
                IF marklength > 0 THEN  DO        
                    /* Copy selected text. 
                     */
                    cliptext  = SUBSTR( contents, markleft, marklength )
                    CALL DoCopy cliptext
                END
                ELSE 
                    CALL VRMethod 'Application', 'PutClipboard', ''

                /* Clear the key event to prevent the MLE from doing its default
                 * copy (which would erase the Unicode clipboard contents).
                 */
                CALL VRSet 'MLE_INPUT', 'KeyString', ''
            END

            WHEN inputchar == '{Shift}{Del}' THEN DO
                state = 0
                kana = ''

                /* Adjust text selection to match character boundaries.
                 */
                markleft  = AdjustPos( flags, markleft,  0 )
                markright = AdjustPos( flags, markright, 1 )
                IF marklength > 0 THEN 
                    marklength = markright - markleft
                IF marklength > 0 THEN  DO        
                    /* Cut selected text. 
                     */
                    cliptext  = SUBSTR( contents, markleft, marklength )
                    contents  = DELSTR( contents, markleft, marklength )
                    cursornew = markleft
                    CALL VRSet 'MLE_INPUT', 'Value', contents
                    CALL VRMethod 'MLE_INPUT', 'SetSel', cursornew - 1, cursornew - 1
                    CALL DoCopy cliptext
                END
                ELSE 
                    CALL VRMethod 'Application', 'PutClipboard', ''
            END

            WHEN inputchar == '{Backspace}' THEN DO
                state = 0
                kana = ''

                /* Adjust text selection to match character boundaries.
                 */
                markleft   = AdjustPos( flags, markleft,  0 )
                markright  = AdjustPos( flags, markright, 1 )
                IF marklength > 0 THEN 
                    marklength = markright - markleft
                prior  = AdjustPos( flags, cursor - 1, 0 )
                IF marklength > 0 THEN DO       
                    /* Delete selected text only.
                     */
                    contents  = DELSTR( contents, markleft, marklength )
                    cursornew = markleft
                END
                ELSE IF cursor > cwidth THEN DO 
                    /* Delete single character ahead of cursor position (unless
                     * there isn't a full character in front of it, i.e. we're
                     * at the beginning of the text).
                     */
                    contents  = DELSTR( contents, cursor - cwidth, cwidth )
                    cursornew = prior
                END
                CALL VRSet 'MLE_INPUT', 'Value', contents
                CALL VRMethod 'MLE_INPUT', 'SetSel', cursornew - 1, cursornew - 1
            END

            WHEN inputchar == '{Del}' THEN DO
                state = 0
                kana = ''

                /* Adjust text selection to match character boundaries.
                 */
                markleft   = AdjustPos( flags, markleft,  0 )
                markright  = AdjustPos( flags, markright, 1 )
                IF marklength > 0 THEN 
                    marklength = markright - markleft
                IF marklength > 0 THEN  DO        
                    /* Delete selected text. 
                     */
                    contents  = DELSTR( contents, markleft, marklength )
                    cursornew = markleft
                END
                ELSE DO
                    /* Delete single character at cursor position.
                     */
                    contents  = DELSTR( contents, cursor, cwidth )
                    cursornew = cursor
                END
                CALL VRSet 'MLE_INPUT', 'Value', contents
                CALL VRMethod 'MLE_INPUT', 'SetSel', cursornew - 1, cursornew - 1
            END

            WHEN ( inputchar == '{Enter}') | ( inputchar == '{Newline}') THEN 
                CALL ConvertKana kana

/* Disabled: allowing line breaks seems to cause weird problems.
 *              CALL VRMethod 'MLE_INPUT', 'Insert', '0D'x
 */

            OTHERWISE DO
                state = 0
                kana = ''
            END

        END
        RETURN 0

    END


    /* When entering text, move the the cursor position to the correct character
     * boundary before anything else.
     */
    CALL VRMethod 'MLE_INPUT', 'SetSel', cursor - 1, cursor - 1

    /* If we're not in romaji-to-kana conversion mode...
     */
    IF VRGet('MI_ROMAJI', 'Checked') == 0 THEN DO

        /* Handle fullwidth ASCII characters.
         */
        IF VRGet('MI_FULLWIDTH', 'Checked') THEN 
            CALL VRMethod 'MLE_INPUT', 'Insert', ConvertFullwidth( inputchar )
            
        /* Otherwise, simply output the character verbatim and return. 
         */
        ELSE 
            CALL VRMethod 'MLE_INPUT', 'Insert', inputchar
        RETURN 0
    END

    /* Now handle displayable characters.
     */
    IF ( VERIFY( inputchar, 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz') > 0 ) THEN DO
        /* If it's not an alphabetic character, it can't be romaji input.  So
         * try and convert it immediately.  (Some punctuation marks do have 
         * ideographic versions.)
         */
        IF kana \= '' THEN DO
            CALL ConvertKana kana
        END
        /* IF C2X( inputchar ) == '0D' THEN SAY */
        IF ( TRANSLATE( kana ) == 'N' & inputchar == "'") THEN 
            /* (This allows use of ' to force the standalone N syllable.) */
            NOP
        ELSE 
            CALL ConvertKana inputchar
        state = 0
        kana = ''
    END
    ELSE IF state == 0 THEN DO
        /* We're not in the middle of a syllable, so start entering a new one. 
         */
        IF ( VERIFY( inputchar, 'AEIOUaeiou') == 0 ) THEN DO
            CALL ConvertKana inputchar
            kana = ''
        END
        ELSE IF TRANSLATE( inputchar ) == 'X' THEN 
            smallkana = 1
        ELSE DO
            state = 1
            kana = inputchar
        END
    END
    ELSE DO
        /* There's a syllable already in progress, so attempt to continue it.
         */
        IF inputchar == LEFT( kana, 1 ) THEN DO
            /* First, handle the case of "double" consonants.
             */
            IF TRANSLATE( kana ) == 'N' THEN DO
                /* Double N is a special case. 
                 */
                CALL ConvertKana kana
                kana = inputchar
            END
            ELSE DO
                /* Other double consonants must be indicated by prepending the
                 * "small tsu" kana mark.
                 */
                IF VRGet('MI_FULLWIDTH', 'Checked') THEN DO
                    IF VERIFY( inputchar, 'ABCDEFGHIJKLMOPQRSTUVWXYZ') == 0 THEN
                        CALL VRMethod 'MLE_INPUT', 'Insert', 'b'
                    ELSE
                        CALL VRMethod 'MLE_INPUT', 'Insert', ''
                END
                ELSE
                    CALL VRMethod 'MLE_INPUT', 'Insert', ''
            END
        END
        ELSE DO

            /* First, if the "in progress" kana contains only N/M, and the new
             * character is not a valid second character for N- or M-, then we
             * assume we're dealing with the standalone N syllable.  So convert 
             * it and then start a new "in progress" kana using the new letter.
             */
            IF ( TRANSLATE( kana ) == 'N' | TRANSLATE( kana ) == 'M') & ( VERIFY( inputchar, 'AEIOUYaeiouy') > 0 ) THEN DO
                CALL ConvertKana kana
                IF VERIFY( inputchar, 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz') == 0 THEN
                    kana = inputchar
                ELSE DO
                    kana = ''
                    state = 0
                END
            END

            /* Otherwise, if this is a valid trailing character, append it to 
             * the current "in progress" kana.
             */
            ELSE IF ( VERIFY( inputchar, 'AEIOUHYSZWaeiouhyszw') == 0 ) THEN DO
                kana = kana || inputchar
                IF ( VERIFY( inputchar, 'HYSZWhyszw') > 0 ) THEN DO
                    CALL ConvertKana kana
                    kana = ''
                    state = 0
                END
            END
        END
    END

RETURN 0

/*:VRX         PB_ABOUTOK_Click
*/
PB_ABOUTOK_Click: 
    CALL SW_ABOUT_Close
return

/*:VRX         Quit
*/
Quit:

    clip = VRMethod('Application', 'GetClipboard')
    text = VRGet('MLE_INPUT', 'Value')
    IF ( text \= '' & text \= clip ) THEN DO
        buttons.0 = 2
        buttons.1 = '~Yes' 
        buttons.2 = '~No'
        id = VRMessage('WN_MAIN',, 
                       'The current text will be lost if you close this window without copying it to the clipboard first.  Close anyway?',,
                       'Confirm Close', 'W', 'buttons.', 2 )
        IF id \= 1 THEN RETURN
    END

    CALL SavePrefs

    window = VRWindow()
    call VRSet window, "Shutdown", 1
    drop window

    IF rxuls THEN CALL ULSDropFuncs

RETURN

/*:VRX         SavePrefs
*/
SavePrefs: PROCEDURE EXPOSE settings.

    bgclr = VRGet('MLE_INPUT', 'BackColor')
    fgclr = VRGet('MLE_INPUT', 'ForeColor')
    font  = VRGet('MLE_INPUT', 'Font')

    xpos   = VRGet( VRWindow(), 'Left')
    ypos   = VRGet( VRWindow(), 'Top')
    width  = VRGet( VRWindow(), 'Width')
    height = VRGet( VRWindow(), 'Height')

    CALL VRSetIni 'Window', 'Left',   xpos,   settings.!ini, 'NoClose'
    CALL VRSetIni 'Window', 'Top',    ypos,   settings.!ini, 'NoClose'
    CALL VRSetIni 'Window', 'Width',  width,  settings.!ini, 'NoClose'
    CALL VRSetIni 'Window', 'Height', height, settings.!ini, 'NoClose'

    CALL VRSetIni 'Style', 'Background', bgclr, settings.!ini, 'NoClose'
    CALL VRSetIni 'Style', 'Foreground', fgclr, settings.!ini, 'NoClose'
    CALL VRSetIni 'Style', 'Font',       font,  settings.!ini

RETURN

/*:VRX         SW_ABOUT_Close
*/
SW_ABOUT_Close: 
    call SW_ABOUT_Fini
return

/*:VRX         SW_ABOUT_Create
*/
SW_ABOUT_Create: 
    call SW_ABOUT_Init
return

/*:VRX         SW_ABOUT_Fini
*/
SW_ABOUT_Fini: 
    window = VRInfo( "Window" )
    call VRDestroy window
    drop window
return
/*:VRX         SW_ABOUT_Init
*/
SW_ABOUT_Init: 

    CALL VRMethod 'MLE_TERMS', 'Insert', 'This program is free software; you can redistribute it and/or modify' ,
                                         'it under the terms of the GNU General Public License as published by' ,
                                         'the Free Software Foundation; either version 2 of the License, or' ,
                                         '(at your option) any later version.'
    CALL VRMethod 'MLE_TERMS', 'Insert', '0d0a0d0a'x
    CALL VRMethod 'MLE_TERMS', 'Insert', 'This program is distributed in the hope that it will be' ,
                                         'useful, but WITHOUT ANY WARRANTY; without even the implied warranty' ,
                                         'of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU' ,
                                         'General Public License for more details.'
    CALL VRMethod 'MLE_TERMS', 'Insert', '0d0a0d0a'x
    CALL VRMethod 'MLE_TERMS', 'Insert', 'You should have received a copy of the GNU General Public' ,
                                         'License along with this program; if not, write to the Free Software' ,
                                         'Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.'
    CALL VRMethod 'MLE_TERMS', 'SetSel', 0, 0

    window = VRInfo( "Object" )
    if( \VRIsChildOf( window, "Notebook" ) ) then do
        call VRMethod window, "CenterWindow"
        call VRSet window, "Visible", 1
        call VRMethod window, "Activate"
    end
    drop window
return

/*:VRX         ToggleConversion
*/
ToggleConversion: 
    mode = VRGet('MI_ROMAJI', 'Checked')
    mode = \mode
    CALL VRSet 'MI_ROMAJI', 'Checked', mode
RETURN

/*:VRX         UpdateStatus
*/
UpdateStatus: 
    IF VRGet('MI_ROMAJI', 'Checked') THEN 
        modetext = 'Kana Conversion'
    ELSE
        modetext = 'ASCII/Direct Input'

    IF VRGet('MI_FULLWIDTH', 'Checked') THEN
        widthtext = 'Fullwidth'
    ELSE
        widthtext = 'Halfwidth'

    CALL VRSet 'DT_STATUS', 'Caption', modetext '-' widthtext
RETURN

/*:VRX         WN_MAIN_Close
*/
WN_MAIN_Close:
    call Quit
return

