/*
 * font.c - manages font setting
 */

#define INCL_PM
#include <os2.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "tablet.h"
#include "resource.h"

/*
 * parse pt.name string
 */

static  BOOL    parseFontNameSize(PUCHAR ptn, PUCHAR fn, PSHORT pt)
{
    PUCHAR  p, pPt, pFn ;
    UCHAR   buff[256] ;
    
    strcpy((p = buff), ptn) ;

    for (pPt = p ; *p != '\0' && *p != '.' ; p++) ;
    if (p == pPt || *p != '.') {
        pPt = NULL ;
    } else {
        *p++ = '\0' ;
    }
    for (pFn = p ; *p != '\0' && *p != '.' ; p++) ;
    if (p == pFn) {
        pFn = NULL ;
    } else {
        *p++ = '\0' ;
    }
    if (pPt == NULL || pFn == NULL) {
        return FALSE ;
    }
#ifdef  DEBUG
    printf("PresFont Name <%s>, Point <%s>\n", pFn, pPt) ;
#endif
    strcpy(fn, pFn) ;
    *pt = atoi(pPt) ;
    return TRUE ;
}

/*
 * look for font of specified face and point
 */

static  BOOL    lookForFont(HPS hps, PUCHAR fn, SHORT pt, PFONTMETRICS met)
{
    ULONG   nReq, nCnt, nRem, i, delta, dd ;
    PFONTMETRICS    afm, pfm ;
    BOOL    found = FALSE ;

    /*
     * list up avaiable font, with given name
     */
     
    nReq = 0 ;
    nCnt = GpiQueryFonts(hps, QF_PUBLIC, fn, &nReq, sizeof(FONTMETRICS), NULL) ;
    if (nCnt == 0) {
#ifdef  DEBUG
        printf("no font for <%s>\n", fn) ;
#endif
        return FALSE ;
    }   
    if ((afm = (PFONTMETRICS) malloc(sizeof(FONTMETRICS) * nCnt)) == NULL) {
#ifdef  DEBUG
        printf("cannot allocate for buffer %d\n", nCnt) ;
#endif
        return FALSE ;
    }
    nRem = GpiQueryFonts(hps, QF_PUBLIC,
                fn, &nCnt, sizeof(FONTMETRICS), afm) ;
#ifdef  DEBUG
    printf("found %d of <%s>\n", nCnt, fn) ;
#endif

    /*
     * select font of given point size
     */

    pt *= 10 ;
    delta = 0xffffffff ;
    
    for (i = 0, pfm = afm ; i < nCnt ; i++, pfm++) {
        if (pt < pfm->sMinimumPointSize) {
	    continue ;
	} else if (pt > pfm->sMaximumPointSize) {
	    continue ;
	}
	dd = (pt - pfm->sMinimumPointSize) + (pfm->sMaximumPointSize - pt) ;
	if (dd <= delta) {
	    memcpy(met, pfm, sizeof(FONTMETRICS)) ;
	    delta = dd   ;
	    found = TRUE ;
        }            
    }
    free(afm) ;
    return found ;
}

/*
 * set font
 */
 
BOOL    fontSetFont(HPS hps, PUCHAR fnt)
{
    UCHAR       fname[64] ;
    SHORT       point     ;
    FONTMETRICS metrics   ;
    FATTRS      fattrs    ;
    LONG        ret ;    
    SHORT       cx, cy ;
    SIZEF       sizef  ;
    
    if (parseFontNameSize(fnt, fname, &point) != TRUE) {
#ifdef  DEBUG
        printf("failed to parse %s\n", fnt) ;
#endif
        return FALSE ;
    }

    if (lookForFont(hps, fname, point, &metrics) != TRUE) {
#ifdef  DEBUG
        printf("no font for %d.%s\n", point, fname) ;
#endif
        return FALSE ;
    }
    
    /*
     * create logical font
     */
    
    memset(&fattrs, 0, sizeof(FATTRS)) ;
    fattrs.usRecordLength = sizeof(FATTRS) ;
    strcpy(fattrs.szFacename, metrics.szFacename) ;
    fattrs.lMatch          = metrics.lMatch          ;
    fattrs.idRegistry      = metrics.idRegistry      ;
    fattrs.usCodePage      = metrics.usCodePage      ;
    if ((metrics.fsDefn & FM_DEFN_OUTLINE) == 0) {
        fattrs.lMaxBaselineExt = metrics.lMaxBaselineExt ;
        fattrs.lAveCharWidth   = metrics.lAveCharWidth   ;
    }
    ret = GpiCreateLogFont(hps, (PSTR8) NULL, 1, &fattrs) ;
    
#ifdef  DEBUG
    if (ret == GPI_ERROR) {
        printf("setFont GPI_ERROR\n") ;
    } else if (ret == FONT_DEFAULT) {
        printf("setFont no matching font\n") ;
    } else {
        printf("setFont - found\n") ;
    }
#endif

    if (ret != FONT_MATCH) {
        return FALSE ;
    }
    GpiSetCharSet(hps, 1) ;
    
    if (metrics.fsDefn & FM_DEFN_OUTLINE) {
        cx = cy = point * 100 / 72  ;
        sizef.cx = MAKEFIXED(cx, 0) ;
        sizef.cy = MAKEFIXED(cy, 0) ;
        GpiSetCharBox(hps, &sizef) ;
    }

    return TRUE ;
}
