/*
 * color.c - manages color setting
 */

#define INCL_PM
#include <os2.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "tablet.h"
#include "resource.h"

#define BOOLSTR(b)  ((b) ? "OK" : "NG")

/*
 * start color management
 */

BOOL    colorInit(HPS hps)
{
    BOOL    stat ;

    stat = GpiCreateLogColorTable(hps, 0, LCOLF_RGB, 0, 0, NULL) ;
#ifdef   DEBUG
    printf("colorInit %s\n", BOOLSTR(stat)) ;
#endif
    return stat ;
}    

/*
 * set presentation color
 */

BOOL    colorSetForeIndex(HPS hps, PULONG clr)
{
    LONG    rgb = GpiQueryRGBColor(hps, 0, *clr) ;
    BOOL    stat = FALSE ;

    if (rgb != GPI_ALTERROR) {
        stat = GpiSetColor(hps, rgb) ;
    }
#ifdef  DEBUG
    printf("colorSetForeIndex %d/%08x (%s)\n", *clr, rgb, BOOLSTR(stat)) ;
#endif
    return stat ;
}

BOOL    colorSetBackIndex(HPS hps, PULONG clr)
{
    LONG    rgb = GpiQueryRGBColor(hps, 0, *clr) ;
    BOOL    stat = FALSE ;

    if (rgb != GPI_ALTERROR) {
        stat = GpiSetBackColor(hps, rgb) ;
    }
#ifdef  DEBUG
    printf("colorSetBackIndex %d/%08x (%s)\n", *clr, rgb, BOOLSTR(stat)) ;
#endif
    return stat ;
}

BOOL    colorSetForeColor(HPS hps, PULONG clr)
{
    BOOL    stat = GpiSetColor(hps, *clr) ;
#ifdef  DEBUG
    printf("colorSetForeColor %08x (%s)\n", *clr, BOOLSTR(stat)) ;
#endif
    return stat ;
}

BOOL    colorSetBackColor(HPS hps, PULONG clr)
{
    BOOL    stat = GpiSetBackColor(hps, *clr) ;
#ifdef  DEBUG
    printf("colorSetBackColor %08x (%s)\n", *clr, BOOLSTR(stat)) ; 
#endif
    return stat ;
}


