/* Script for upload Phone Book to Phone, Using AT+CPBx ETSI Command */

Call RxFuncAdd 'SysSleep', 'RexxUtil', 'SysSleep'
Call RxFuncAdd 'SysGetKey', 'RexxUtil', 'SysGetKey'
Call RxFuncAdd 'SysCls', 'RexxUtil', 'SysCls'
Call RxFuncAdd 'SysTempFileName', 'RexxUtil', 'SysTempFileName'
Call RxFuncAdd 'SysFileDelete', 'RexxUtil', 'SysFileDelete'
Call RxFuncAdd 'SysFileTree', 'RexxUtil', 'SysFileTree'
Call RxFuncAdd 'RxAsyncRead', 'RXASYNC', 'RxAsyncRead'
Call RxFuncAdd 'RxAsyncWait', 'RXASYNC', 'RxAsyncWait'
Call RxFuncAdd 'RxAsyncSetMdmOutput', 'RXASYNC', 'RxAsyncSetMdmOutput'
call RxFuncAdd 'RxAsyncLoadFuncs', 'RXASYNC', 'RxAsyncLoadFuncs'
call RxAsyncLoadFuncs

signal on halt

/* [Global] */
comport="com1"
init="ATE0"
portspeed=115200
command_delay=0.5    /* delay between AT commands (sec) */
phonevol=7

/* [Internal] Don't modify w/o necessity !!! */
PortHandle=''
remaining=''
debug=1
mainlog=1
crlf=d2c(13)d2c(10)

/* ------------- Entry Point -------------- */

parse arg pbook wish

if pbook="" | wish <> "I WANT" then
  do
  say "Filename required..."
  exit
  end


Call SysFileTree pbook, rc
if rc.0 = 0 then
do
say pbook "file not found, Please create according to documentation."
signal term
end


Call SysCls

rc=crlf "    Automatic Ericsson Pbook Changer v 1.01 (c) By Alek Winner." crlf
say rc
if mainlog then call charout rclog,rc

call comport_check


patrol:

rc = RxAsyncWrite( PortHandle, 0, init||crlf, 'Remaining' )
if rc <> 0 then signal err1

call check_string "Init", "OK", "  Modem not ready... Exitting... ;("


rc=" "date()"  " time() "  Phone Modem Initialized OK" crlf
say rc
if mainlog then call charout rclog,rc

rc = RxAsyncWrite( PortHandle, 0, 'AT+CPBS="SM"'||crlf, 'Remaining' )
if rc <> 0 then signal err1

call check_string "AT*CPBS", "OK", "  Modem not ready... Exitting... ;("

rc = RxAsyncWrite( PortHandle, 0, 'AT+CPBR=?'||crlf, 'Remaining' )
if rc <> 0 then signal err1

do 2
rc = RxAsyncRead( PortHandle, 0, 3000, 'InpStr' )
end

parse value inpstr with id_1 '(' beg_el '-' end_el '),' pl ',' nl
if id_1 <> '+CPBR: ' then signal err1

call check_string "AT+CPBR=?", "OK", "  Modem not ready... Exitting... ;("


say "Detected SIM Card with capasity   " end_el 
say "Phone Number length is            " pl     
say "Abonent Name length is            " nl     

say "Writing Begins..." crlf

do while lines(pbook) \= "0"
rc=linein(pbook,,1)
say rc
parse value rc with poz number unc name

target='AT+CPBW='||poz||',"'||number||'",'||unc||',"'||name||'"'
rc = RxAsyncWrite( PortHandle, 0, target||crlf, 'Remaining' )
if rc <> 0 then signal err1

call check_string "AT+CPBW", "OK", "  Modem not ready... Exitting... ;("
end
call stream pbook,'c','close'


call RxAsyncClose PortHandle
exit


/* --- Check Port State --------*/
comport_check:
if stream(comport,'c','open') = 'NOTREADY:32' then signal err0

call stream comport,'c','close'
rc = RxAsyncOpen( Comport, 'PortHandle' )

com_init:

rc = RxAsyncSetLnCtrl( PortHandle, portspeed, 8, 'N', 1 )
if rc <> 0 then signal err0

rc=RxAsyncSetDcbInfo(PortHandle,400,50,'00001001','10000000','','','','','' )
return

err0:
rc=" "date()"  " time() "  Comport is not respond... ;(" crlf
say rc
if mainlog then call charout rclog,rc
/* call beep 262,250 */
exit
/* -----------------------------*/



/* -- Check Modem String --------- */
check_string:
PARSE ARG deb_str, ok_str, err_str

InpStr = ""
do until InpStr=ok_str||crlf | InpStr='ERROR'||crlf
rc = RxAsyncRead( PortHandle, 0, 3000, 'InpStr' )
if rc <> 0 then signal err1
db=deb_str InpStr crlf
if debug then call charout debug.log,db
end

if InpStr = ok_str||crlf then return

err1:
rc=" "date()"  " time() err_str crlf
say rc
if mainlog then call charout rclog,rc
/* call beep 262,250 */
signal term
/* -- Check Modem String - Ends -- */



/* ----- Close All Files -------*/
close_all:
call stream rclog,'c','close'
call stream debug.log,'c','close'
return
/* -----------------------------*/

term:
