/* REXX */

call rxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

Call SysCls
'@ECHO OFF'

/* Sprache */
FEHLER = SysIni('USER', 'Shield', 'Schrif~tartgre...')
IF FEHLER = 'ERROR:' THEN
  SPRACHE = 'E'
ELSE
  SPRACHE = 'D'

/* you could also use VIOTBL.ISO */
VIOTBL_NAME = 'VIOTBL.DCP'
BOOTPATH = LEFT( VALUE( 'COMSPEC' , , 'OS2ENVIRONMENT' ) , 2 )'\OS2\BOOT\'

'@SET BPATH='BOOTPATH
IF SysSearchPath( 'BPATH' , VIOTBL_NAME ) = '' THEN
  DO
    IF SPRACHE = 'D' THEN SAY BOOTPATH||VIOTBL_NAME' nicht gefunden * bitte per Hand kopieren ...'
    IF SPRACHE = 'E' THEN SAY BOOTPATH||VIOTBL_NAME' not found * please copy by hand ...'
    PULL TASTE
    EXIT
  END

/*****************************************************************************/  
IF SPRACHE = 'D' THEN SAY 'entpacke 'BOOTPATH||VIOTBL_NAME' ...'
IF SPRACHE = 'E' THEN SAY 'extracting 'BOOTPATH||VIOTBL_NAME' ...'
'@DCP_X.EXE 'BOOTPATH||VIOTBL_NAME' .\'

/*****************************************************************************/
IF SPRACHE = 'D' THEN SAY 'entpacke System.VIO Schriften ...'
IF SPRACHE = 'E' THEN SAY 'extracting System.VIO fonts ...'

'MD SYSTEM.VIO 2>NUL'
'CD SYSTEM.VIO'

/* get OS/2 fonts from DSPRES.DLL */
'..\DSPRESX.EXE'

/* convert to raw fonts */ 
'@FOR %%D IN ( 08 10 12 14 16 18 ) DO ..\OS2FNT_X VIO_8_%%D.FON 00437_%%D.FN8 437'
'@FOR %%D IN ( 08 10 12 14 16 18 ) DO ..\OS2FNT_X VIO_8_%%D.FON 00850_%%D.FN8 850'

/* temp files */
'@FOR %%D IN ( 08 10 12 14 16 18 ) DO DEL VIO_8_%%D.FON'

'@CD ..'

'@DEL VIOTBL.DIR'

/*****************************************************************************/
IF SPRACHE = 'D' THEN SAY 'erstelle neue *.DCP-Dateien im Verzeichnis 'BOOTPATH' ...'
IF SPRACHE = 'E' THEN SAY 'building new *.DCP-files in directory 'BOOTPATH' ...'
CALL CREATEDCP '437','437','VT437'
CALL CREATEDCP '437','850','VT437850'
CALL CREATEDCP '850','850','VT850'
CALL CREATEDCP '850','437','VT850437'

EXIT

/*****************************************************************************/

CREATEDCP:
                CP1=ARG(1)
                CP2=ARG(2)
                DCPNAME=ARG(3)

                TEMP='DCP.TMP'
                '@ECHO O 'BOOTPATH||DCPNAME'.DCP>'TEMP

                IF CP1 = CP2 THEN
                  DO
                    IF SPRACHE = 'D' THEN SAY 'fr "CODEPAGE='CP1'" in der config.sys ...'
                    IF SPRACHE = 'E' THEN SAY 'for "CODEPAGE='CP1'" in config.sys ...'
                    '@ECHO T Version 0.00 * DCP.CMD ('CP1') >>'TEMP''

                    '@ECHO F .\VIOTBL.EXT\00'CP1'_08.FN8 'CP1' 8 >>'TEMP
                    '@ECHO F .\SYSTEM.VIO\00'CP1'_10.FN8 'CP1' 8 >>'TEMP
                    '@ECHO F .\SYSTEM.VIO\00'CP1'_12.FN8 'CP1' 8 >> 'TEMP
                    '@ECHO F .\VIOTBL.EXT\00'CP1'_14.FN8 'CP1' 8 >> 'TEMP
                    '@ECHO F .\VIOTBL.EXT\00'CP1'_16.FN8 'CP1' 8 >> 'TEMP
                    '@ECHO F .\SYSTEM.VIO\00'CP1'_18.FN8 'CP1' 8 >> 'TEMP
                    '@ECHO F .\CP'CP1'_20.FNT            'CP1' 8 >> 'TEMP
                    '@ECHO F .\VIOTBL.EXT\00'CP1'_14.FN9 'CP1' 9 >> 'TEMP
                    '@ECHO F .\VIOTBL.EXT\00'CP1'_16.FN9 'CP1' 9 >> 'TEMP
                    '@ECHO F .\CP'CP1'_20.FNT            'CP1' 9 >> 'TEMP

                  END
                ELSE
                  DO
                    IF SPRACHE = 'D' THEN SAY 'fr "CODEPAGE='CP1','CP2'" in der config.sys ...'
                    IF SPRACHE = 'E' THEN SAY 'for "CODEPAGE='CP1'" in config.sys ...'
                    '@ECHO O 'BOOTPATH||DCPNAME'.DCP>'TEMP''
                    '@ECHO T Version 0.00 * DCP.CMD ('CP1','CP2') >>'TEMP

                    '@ECHO F .\VIOTBL.EXT\00'CP1'_08.FN8 'CP1' 8 >>'TEMP
                    '@ECHO F .\SYSTEM.VIO\00'CP1'_10.FN8 'CP1' 8 >>'TEMP
                    '@ECHO F .\VIOTBL.EXT\00'CP1'_14.FN8 'CP1' 8 >>'TEMP
                    '@ECHO F .\VIOTBL.EXT\00'CP1'_16.FN8 'CP1' 8 >>'TEMP
                    '@ECHO F .\CP'CP1'_20.FNT            'CP1' 8 >>'TEMP
                    '@ECHO F .\VIOTBL.EXT\00'CP1'_14.FN9 'CP1' 9 >>'TEMP
                    '@ECHO F .\VIOTBL.EXT\00'CP1'_16.FN9 'CP1' 9 >>'TEMP
                    '@ECHO F .\CP'CP1'_20.FNT            'CP1' 9 >>'TEMP

                    '@ECHO F .\VIOTBL.EXT\00'CP2'_08.FN8 'CP2' 8 >>'TEMP
                    '@ECHO F .\VIOTBL.EXT\00'CP2'_14.FN8 'CP2' 8 >>'TEMP
                    '@ECHO F .\VIOTBL.EXT\00'CP2'_16.FN8 'CP2' 8 >>'TEMP
                    '@ECHO F .\CP'CP2'_20.FNT            'CP2' 8 >>'TEMP
                    '@ECHO F .\VIOTBL.EXT\00'CP2'_14.FN9 'CP2' 9 >>'TEMP
                    '@ECHO F .\VIOTBL.EXT\00'CP2'_16.FN9 'CP2' 9 >>'TEMP
                    '@ECHO F .\CP'CP2'_20.FNT            'CP2' 9 >>'TEMP

                  END

                'DCP_A 'TEMP
                '@DEL 'TEMP
                RETURN

/*****************************************************************************/
