! funcload.for -- Defines the two functions 'RxGdiffLoad' and 'RxGdiffDrop',
!                 which load/drop all the functions defined in this DLL.

c$define INCL_REXXSAA
c$include rexxsaa.fap

! Declare our functions.  Make sure to export these in the .LNK file!

c$pragma aux (RexxFunctionHandler) RxGdiffLoad "RxGdiffLoad"
c$pragma aux (RexxFunctionHandler) RxGdiffDrop "RxGdiffDrop"

! Define the table that lists REXX function names and the corresponding
! DLL entry point.  You must change this table whenever you add/remove
! a function or entry point.

	blockdata
	include 'funcload.fi'
	data RxFncTable/
		! function	entry point
     &		'RxGdiffLoad'c,  'RxGdiffLoad'c,
     &		'RxGdiffDrop'c,  'RxGdiffDrop'c,
     &		'RXGDIFF'c,      'RXGDIFF'c/
	end

! RxGdiffLoad -- Register all the functions with REXX.

c$noreference
	integer function RxGdiffLoad( name, numargs, args,
     &				      queuename, retstr )
c$reference
	integer numargs, name, queuename
	record /RXSTRING/ args(numargs), retstr
	
	include 'rxsutils.fi'
	include 'funcload.fi'
	
    	integer j
	character*9 DLLNAME ! Change this if you're changing the DLL name...
	parameter (DLLNAME = 'RXGDIFF'c)
	
	retstr.strlength = 0

	if( numargs .gt. 0 )then
	    RxGdiffLoad = INVALID_ROUTINE
	    return
	endif

	do j = 1, ENTRIES
	    call RexxRegisterFunctionDll( RxFncTable(j).rxName, DLLNAME,
     &					  RxFncTable(j).cName )
	enddo

	RxGdiffLoad = VALID_ROUTINE

	end

* RxGdiffDrop -- Deregister all the functions with REXX.

c$noreference
	integer function RxGdiffDrop( name, numargs, args,
     &				      queuename, retstr )
c$reference
	integer numargs, name, queuename
	record /RXSTRING/ args(numargs), retstr
	
	include 'rxsutils.fi'
	include 'funcload.fi'
	
	integer j

	retstr.strlength = 0

	if( numargs .gt. 0 )then
	    RxGdiffDrop = INVALID_ROUTINE
	    return
	endif

	do j = 1, ENTRIES
	    call RexxDeregisterFunction( RxFncTable(j).rxName )
	enddo

	RxGdiffDrop = VALID_ROUTINE

	end
