/* ShowSub.EA */

CALL RxFuncAdd 'SysFileTree','RexxUtil','SysFileTree'
CALL RxFuncAdd 'SysGetEA','RexxUtil','SysGetEA'

PARSE ARG file

file=Strip(file) 
IF file='' | file='/?' | file='-?' THEN DO
   SAY
   SAY 'ShowSub shows the ".SUBJECT" Extended Attribute of a file. Usage:'
   SAY
   SAY '   SHOWSUB.CMD <file>'
   SAY
   SAY '<file>: name of a single file, <file> may include wildcard characters'
   SAY
   EXIT
END

IF Left(file,1)='"' THEN PARSE VAR file '"' file '"' .

retval=SysFileTree(file,'list.','FO')
IF retval=2 THEN DO
   SAY
   SAY 'Error: not enough memory available to query a list of files'
   SAY
   EXIT
END
IF list.0=0 THEN DO
   SAY
   SAY 'Error: file "'||file||'"' "doesn't exist"
   SAY
   EXIT
END
IF list.0>1 THEN DO
   SAY
   SAY 'Error: more than one file matches the pattern "'||file||'"'
   SAY
   EXIT
END

retval=SysGetEA(list.1,'.SUBJECT','ea')
IF retval=0 THEN DO
   message='No ".SUBJECT" Extended Attribute found.'
   IF Length(ea)>0 THEN message='Extended Attribute ".SUBJECT" is empty.'.
   PARSE VAR ea 1 . 5 ea
   IF Length(ea)>0 THEN message='Extended Attribute ".SUBJECT" of file "'||list.1||'":'||D2C(13)||D2C(10)||D2C(13)||D2C(10)||ea
   SAY
   SAY message
   SAY
   EXIT
END

IF retval>0 THEN DO
   retval=Translate(Format(retval,4,0),'0',' ')
   SAY
   SAY 'Error (SYS'||retval||'): cannot query Extended Attributes of file "'||list.1||'"'
   SAY
   EXIT
END

EXIT
