/* cssmon.cmd   -- CSSDIR monitor program */
/* CopyRight (C) 2003-2004 Curtis Systems Software P.C. All Rights Reserved */
/* www.curtisSystemSoftware.com */

/* simply enter cssmon.cmd [procId | NAME=\\...]                      */  
/*   if no CSSDIR active process are found -- you are told            */
/*   if only one CSSDIR active process is found it starts to monitor  */
/*      it every 'queryInterval' seconds                              */
/*   if more than one you choose interactively which one              */
/*   if you wish to monitor one over netbios, you must know the       */
/*       full pipename preceded by \\servername, prepended by         */
/*       NAME=  i.e.  NAME=\\server1\pipe\CSSDIR3001   will monitor   */
/*          CSSDIR with a processID 3001 on server1                   */
/*   if you wish to monitor processID n to avoid searching for active */
/*        CSSDIR processes simply use cssmon n                        */
/* PLEASE NOTE: this querying mechanism is provided as a convienient  */
/*  and its usages with CSSDIR is subject to change in the future     */
/* Also it is not recommended to change 'queryInterval' to a value of */
/* less than 1; This could impact the system and slow the CSSDIR      */
/* process.                                                           */


version = 1.16

parse UPPER arg processId

say "cssmon version" version "Copyright 2003-04 Curtis Systems Software P.C."
/* make sure sysSleep is available */
if rxfuncquery('sysloadfuncs') then
   do
   if rxfuncadd('sysloadfuncs', 'rexxutil', 'sysloadfuncs') then
      do
      rc = outErr("error: couldn't load rexxutil library.")
      return 1
      end
   call sysloadfuncs
   end

"@echo off"
"rxqueue /clear"

procIDs.        = ""
procIDs.0       = 0
procPCPLs.0     = 0

base          = "CSSDIR.EXE"
root          = "\PIPE\CSSDIR"
queryInterval = 1
retryIntervalA= 2
retryLimitA   = 3
scrlines      = 12

retryIntervalB= 3
retryLimitB   = 3
retry         = 0

name = ""
if (processId <> "") then do
   if (left(processId,5) == "NAME=") then do
      name=substr(processId,6)
   end
   else do
      name=root||processId
   end
   ans       = 1
   say "querying Basic info for:"name
   procpcpls.ans = queryPipe(name, "getPCPL"    , retryIntervalA, 2) 
   procIDs.1 = processId
   procIds.0 = 1
   signal gotProcId
end

do forever
   do forever                                                                         
      "pstat /c | rxqueue"                                                            
                                                                                      
      do while(queued() <> 0)                                                         
         pull line                                                                    
         in =pos(base,line)                                                           
         if (in > 0) then do                                                          
            procIDs.0 = procIDs.0 + 1                                                 
            cnt = procIDs.0                                                           
            procIDs.cnt = format(x2d(strip(left(strip(line),4))),5)                             
            line = substr(line,in+length(base))
            parse var line . PCPL . .
            procPCPLs.cnt = "0x"PCPL
            say "Found CSSDIR process"format(cnt,2)": PID:"procids.cnt "(0x"||d2x(procids.cnt)") pri:"procPcpls.cnt
         end                                                                          
      end                                                                             
      if (procIDs.0 <> 0) then leave                                                  
      retry = retry + 1                                                               
      if (retry > retrylimitB) then do                                                
         rc = outErr("NO active CSSDIR processes detected; exiting")                          
         exit 1                                                                       
      end                                                                             
      rc=sysSleep(retryIntervalB)                                                      
      rc = outErr(" reAttempt#"retry "to Find active CSSDIR processes")                        
   end                                                                                
                                                                                      
   if (procIDs.0 == 1) then do                                                        
      ans = 1                                                                         
      signal gotProcId
   end                                                                                
   else do                                                                            
     rc = outErr("Building active CSSDIR processes list to select from:")
     do i = 1 to procIDs.0                                                        
        name = root||strip(procIDs.i)     
        tmpProcpcpl= queryPipe(name, "getPCPL", retryIntervalA, 0)
        if (left(tmpProcpcpl,1) == "*") then do
           procpcpl = procpcpls.i
           cmdargs = tmpProcpcpl
        end
        else do
          procpcpl = tmpProcpcpl
          cmdargs = queryPipe(name,"args", retryIntervalA,0);                       
        end
        rc=outErr(format(i,2)"=PID "format(procIDs.i,5) "(0x"d2x(procIDs.i,4)") pri:"procpcpl)
        if (left(cmdargs,1) == "*") then rc=outErr("    "cmdargs)      
        else                             rc=outErr("   CSSDIR" cmdargs)
        rc = lineout(name)
     end                                                      
     rc = outErr("Which one do you wish to monitor?")
     pull ans                                                                     
     if ((ans > 0) & (ans <= procIDs.0)) then signal gotProcId
   end       
   procIDs.0 = 0
end

gotProcId:
if (left(processId,5) == "NAME=") then do
   procId = strip(substr(processId,6))
   name   = procId
   procpcpl = ""
   procpcpl    = queryPipe(name, "getPCPL"    , retryIntervalA, 2)
   monout = "Monitoring "processId  "pri:"procPCPL 
end
else do
   procid      = procIDs.ans
   procpcpl    = "pri:"procpcpls.ans
   name        = root||strip(procid)
   monout = "Monitoring PID="procid "(0x"right(d2x(procid),4,0)")" procPCPL 
end
cmdargs     = queryPipe(name, "args"       , retryIntervalA, 2); 
query1title = queryPipe(name, "query1title", retryIntervalA, 2); 
curline = scrlines

do forever
   curline = curline + 1
   if (curline  > scrlines) then do
      say
      say  monout
      say  "'CSSDIR"cmdargs"'"
      say
      say  query1title
      curline = 1
   end
   rc = sysSleep(queryInterval)
   res = queryPipe(name, "query", retryIntervalA, 2);
   say res
end
exit 0

queryPipe: procedure expose retryIntervalA
   parse arg pipe, query, retries, abortCode
   do retry = 0 to retries
      err = ""
      count = charout(pipe,query)
      if (count <> 0  ) then do
         rc = lineout(pipe)
         rc = sysSleep(retryIntervalA)
         err = "*1:error writing ..to:"pipe " may be busy or finished"
         iterate
      end
      retstr = linein(pipe)
      if (retstr == "") then do
         rc = lineout(pipe)
         err = "*2:error reading from:"pipe " may be busy or finished"
         iterate
      end
      if (left(retstr,1) == 0) then do
         retstr = substr(retstr,2)
         leave
      end

      multiline = substr(retstr,2)
      do while(left(retstr,1) <> "0") 
         retstr = linein(pipe)
         if (retstr == "") then do
            rc = lineout(pipe)
            err = "*2:error reading from "pipe " may be busy or finished"
            iterate retry
         end
         multiline = multiline || x2c("0d0a") || substr(retstr,2)
      end
      retstr = multiline
      leave
   end
   if (err <> "") then do
      if (abortCode <> 0) then do
         rc = outErr("aborting due to "err)
         rc = outErr("probaby THIS CSSDIR process has finished")
         if (left(pipe,2) == "\\") then do
            rc= outErr("Make sure you are logined to this server and have the needed privileges!")
         end
         exit abortCode
      end
      return(err)
   end
   return(retstr)

outErr: procedure
   parse arg out
   x = lineout("stderr:",out)
   return 0
