#define INCL_BASE
#define INCL_SUB
#define INCL_DOSFILEMGR

#include <os2.h>
#include <stdio.h>
#include <string.h>

#define F_ALL_TYPES  FILE_NORMAL | FILE_READONLY | FILE_HIDDEN | FILE_SYSTEM | FILE_DIRECTORY | FILE_ARCHIVED

/* I like to rename the string comparison functions */
#define STREQUAL(  x, y    )    ( !strcmp(  (x), (y)      ) )
#define STRNEQUAL( x, y, z )    ( !strncmp( (x), (y), (z) ) )


/* a little bit of global data. */
ULONG       NumOfSubs;
ULONG       NumOfFiles;
USHORT      SearchCount = 1;


/* function prototypes */
BOOL  RemoveBranches( PCHAR root, PCHAR DirName );
PCHAR MakeFullFileName( PCHAR path, PCHAR filename );




VOID main( int argc, PCHAR argv[] )
{
   HDIR        hdir = HDIR_SYSTEM;
   FILEFINDBUF findbuf;
   USHORT      RetCode;
   KBDKEYINFO  kbci;
 
   if ( argc == 1 ) {
      printf( "NUKE ver. 2.1, by Gene Williams, Jr., CPA\n" );
      printf( "NUKE removes entire subdirectory trees, and the files in them.\n\n" );
      printf( "usage is:  NUKE subdirectory\n" );
      printf( "where 'subdirectory' is directly under the current subdirectory.\n\n" );
      printf( "This program is bound; it works under both DOS and OS/2.\n" );
      DosExit( EXIT_PROCESS, 0 );
   }

   RetCode = DosFindFirst( argv[1], &hdir, FILE_DIRECTORY, &findbuf, sizeof(findbuf), &SearchCount, 0L );
   if ( RetCode || ( !RetCode && (findbuf.attrFile != FILE_DIRECTORY) ) ) {
      printf( "\tCould not find subdirectory %s\n\a", argv[1] );
      DosExit( EXIT_PROCESS, 0 );
   }

   NumOfSubs = NumOfFiles = 0;

   printf( "Pay close attention.  You are about to destroy %s.\n", argv[1] );
   printf( "If you are intent upon doing this, press '!'\n\a" );
   KbdCharIn( &kbci, IO_WAIT, 0 );
   printf( "\n" );

   if ( kbci.chChar != '!' ) {
      printf( "Wise decision.  Aborting...\n" );
   } else {
      if ( RemoveBranches( argv[1], (PCHAR) NULL ) && !DosRmDir( argv[1], 0L ) ) {
         printf( "\tComplete!   " );
         NumOfSubs++;
      } else {
         printf( "Could not delete entire subdirectory tree.\n" );
         printf( "Look for hidden files, or (in OS/2) another process that is using this tree.\n\a" );
      }

      printf( "Removed %ld director%s, %ld file%s.\n", NumOfSubs, NumOfSubs == 1 ? "y" : "ies", NumOfFiles, NumOfFiles == 1 ? "" : "s" );
      DosFindClose( hdir );
   }

   DosExit( EXIT_PROCESS, 0 );
}


BOOL RemoveBranches( PCHAR root, PCHAR DirName )
{
   char        path[CCHMAXPATH];
   char        fullFilename[CCHMAXPATH];
   HDIR        hdir = HDIR_SYSTEM;
   FILEFINDBUF findbuf;
   BOOL        result;
   BOOL        done = FALSE;

   strcpy( path, MakeFullFileName( root, DirName ) );
   strcpy( fullFilename, MakeFullFileName( path, "*.*" ) );

   SearchCount = 1;
   if ( !(DosFindFirst( fullFilename, &hdir, F_ALL_TYPES, &findbuf, sizeof(findbuf), &SearchCount, 0L ) ) ) {
      do {
         if ( findbuf.attrFile == FILE_DIRECTORY ) {
            if ( !STREQUAL( findbuf.achName, "." ) && !STREQUAL( findbuf.achName, ".." ) ) {
               RemoveBranches( path, findbuf.achName );
               if ( DosRmDir( MakeFullFileName( path, findbuf.achName ), 0L ) ) {
                  DosFindClose( hdir );
                  return FALSE;
               } else
                  NumOfSubs++;
               /* DosFindFirst doesn't accept recursion, so we */
               /* have to call it again after a recursive call.*/
               strcpy( fullFilename, MakeFullFileName( path, "*.*" ) );
               SearchCount = 1;
               hdir = HDIR_SYSTEM;
               if ( DosFindFirst( fullFilename, &hdir, F_ALL_TYPES, &findbuf, sizeof(findbuf), &SearchCount, 0L ) ) {
                  done = TRUE;
               }
            }
         } else {
            strcpy( fullFilename, MakeFullFileName( path, findbuf.achName ) );
            if ( (findbuf.attrFile != FILE_NORMAL) && (findbuf.attrFile != (FILE_NORMAL | FILE_ARCHIVED )) )
               DosSetFileMode( fullFilename, FILE_NORMAL, 0L );
            if ( DosDelete( fullFilename, 0L ) ) {
               DosFindClose( hdir );
               return FALSE;
            } else
               NumOfFiles++;
         }
      }
      while ( !done && !(DosFindNext( hdir, &findbuf, sizeof(findbuf), &SearchCount) ) );

      result = TRUE;
   } else
      result = FALSE;

   DosFindClose( hdir );
   return result;
}


PCHAR MakeFullFileName( PCHAR path, PCHAR filename )
{
   static char far fullname[CCHMAXPATH];

   strcpy( fullname, path );
   if ( filename != NULL ) {
      if ( fullname[strlen( fullname )-1] != '\\' ) {
         strcat( fullname, "\\" );
      }
      strcat( fullname, filename );
   }
   return fullname;
}
