/* Install.cmd for WSSFill
 */

ProgName = "WSSFill"
Version = "1.0"

InstFile.0 = 5
InstFile.1 = "wssfill.exe"
InstFile.2 = "wssfill.htm"
InstFile.3 = "wssfill.ico"
InstFile.4 = "wssfill.ord"
InstFile.5 = "wssfill.res"

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

say
say 'This will install' ProgName 'version' Version 'and create an icon on the desktop'

parse arg instdir

if "" = instdir then do
	say
	say "Please specify the installation directory.  It will be created if it"
	say "doesn't already exist (but top level must exist).  Example: C:\utils\wssfill"
	say "is ok, but only if C:\utils already exists."
	say 'Enter "Q" to quit or just enter to use current directory.'
	say
	call charout ,"Install directory: "
	pull instdir
	instdir = strip(instdir)
	instdir = strip(instdir, "trailing", "\")
	if ('Q' = instdir) | ('q' = instdir) then
		exit
	end

if "" = instdir then do
	instdir = directory()
	copyfiles = 'f'
	end
else
	copyfiles = 't'

if 't' = copyfiles then do
	rc = SysMkDir(instdir)
	if rc>0 & rc !=5 then do
		say 'Unable to create target directory' instdir
		exit
		end
	do i = 1 to InstFile.0
		if "" = stream(InstFile.i, 'C', 'Query exists') then do
			say InstFile.i 'not found, installation cannot continue'
			exit
		end
	end
	do i = 1 to InstFile.0
		if "" = stream(instdir || "\" || InstFile.i, 'C', 'Query exists') then
			iterate
		call charout ,'One or more files to be installed already exists, ok to overwrite?: '
		action = translate(SysGetKey())
		say
		if 'Y' = action then
			leave
		else
			exit
	end

	do i = 1 to InstFile.0
		'@copy' InstFile.i instdir
	end
end

title = ProgName || " " || Version
setupstring = "EXENAME=" || instdir || "\" || ProgName || ".exe;STARTUPDIR=" || instdir
rc = SysCreateObject("WPProgram", title, "<WP_DESKTOP>", SetupString, "Replace")

say

if 0 = rc then
	say 'Unable to create desktop object for' ProgName
else
	say 'Installation complete'
