/* Copyright GPL */
/* Resource script constants */
#define AppName   "PM Disk Monitor"
#define Author "Trevor-Hemsley@dsl.pipex.com"
#define Thanks "Portions of code by Daniela Engert and Bjrn Mork"

#define VERSION "0.70"
#define COMPILEDATE __DATE__
#define COMPILETIME __TIME__

/* dialogues */
#define ID_PMDSKMON      1
#define ID_SETUP         2
#define ID_ABOUT         3
#define ID_PMDSKMENU     4

/* option flags */
#define OPT_SMART        0x0001
#define OPT_ONTOP        0x0002
#define OPT_TITLEBAR     0x0004
#define OPT_SMARTLOG     0x0008
#define OPT_TEMPCHECK    0x0010

/* menu items */
#define IDM_ONTOP        1
#define IDM_TITLEBAR     2
#define IDM_SETUP        3
#define IDM_ABOUT        4
#define IDM_EXIT         5

/* main dialogue items */
#define IDD_DISK_GROUP 200
#define IDD_DEV_NAME  201
#define IDD_NO_READS  202
#define IDD_NO_WRITES 203
#define IDD_KB_READ   204
#define IDD_KB_WRITE  205
#define IDD_NO_ERRORS 206
#define IDD_SMART     207
#define IDD_TEMP      208

/* About dialog items */
#define IDD_VERSION   298

/* setup dialogue items */
#define IDD_SMART_ON     250
#define IDD_SMART_OFF    251
#define IDD_REFRESH      252
#define IDD_REFRESH_TEXT 253
#define IDD_SMART_LOG    254
#define IDD_TEMP_ON      255
#define IDD_TEMP_INT     256
#define IDD_TEMP_STATIC  257
#define IDD_TEMPCHK      258
#define IDD_TEMP_DISP    259
#define IDD_TEMP_C       260
#define IDD_TEMP_F       261

#define IDD_TITLE1    301
#define IDD_TITLE2    302
#define IDD_TITLE3    303
#define IDD_TITLE4    304
#define IDD_TITLE5    305
#define IDD_TITLE6    306
#define IDD_TITLE7    307
#define IDD_TITLE8    308

#define IDD_FHELP     500


#define UPDATE_MAX_VALUE 10000

#define WM_TEMPNOTSUPPORTED WM_USER+1

#ifndef WS_TOPMOST
#define WS_TOPMOST  0x00200000
#endif

void sigme(int);
void GetValidUnits(void);
void GetUnitStats(void);
MRESULT EXPENTRY ClientWndProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);
void InitWindow(HWND hwnd);
void Setup(HWND hwnd);
void ShowTitleBar(HWND hwnd, BOOL show, BOOL resize);
MRESULT EXPENTRY SetupDlgProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);
void UpdateDisplay(HWND hwnd);
void ResizeWindow(HWND hwnd);
MRESULT EXPENTRY AboutProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);
void _Optlink FloatWindow(void* arg);
MRESULT APIENTRY fnFloatHelp      (HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);
void Logit(char *text);
void _Optlink SmartMonitor(void* arg);
void ProcessMessage(char*, ULONG);
void StartSMThread(void);
void StopSMThread(void);
void _Optlink QueueReader(void *args);
