/* Copyright GPL */
/* Resource script constants */
#define AppName   "PM Disk Monitor"
#define Author "Trevor-Hemsley@dsl.pipex.com"
#define Thanks "Portions of code by Daniela Engert and Bjrn Mork"

#define VERSION "0.50"
#define COMPILEDATE __DATE__
#define COMPILETIME __TIME__

/* dialogues */
#define ID_PMDSKMON      1
#define ID_SETUP         2
#define ID_ABOUT         3
#define ID_PMDSKMENU     4

/* option flags */
#define OPT_SMART        0x0001
#define OPT_ONTOP        0x0002
#define OPT_TITLEBAR     0x0004

/* menu items */
#define IDM_ONTOP        1
#define IDM_TITLEBAR     2
#define IDM_SETUP        3
#define IDM_ABOUT        4
#define IDM_EXIT         5

/* main dialogue items */
#define IDD_DISK_GROUP 200
#define IDD_DEV_NAME  201
#define IDD_NO_READS  202
#define IDD_NO_WRITES 203
#define IDD_KB_READ   204
#define IDD_KB_WRITE  205
#define IDD_NO_ERRORS 206
#define IDD_SMART     207
#define IDD_VERSION   208

#define IDD_TITLE1    301
#define IDD_TITLE2    302
#define IDD_TITLE3    303
#define IDD_TITLE4    304
#define IDD_TITLE5    305
#define IDD_TITLE6    306
#define IDD_TITLE7    307

#define IDD_SMART_ON  250
#define IDD_SMART_OFF 251

/* setup dialogue items */
#define IDD_REFRESH      211
#define IDD_REFRESH_TEXT 212

#define UPDATE_MAX_VALUE 10000

#ifndef WS_TOPMOST
#define WS_TOPMOST  0x00200000
#endif

void sigme(int);
void GetValidUnits(void);
void GetUnitStats(void);
MRESULT EXPENTRY ClientWndProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);
void InitWindow(HWND hwnd);
void Setup(HWND hwnd);
void ShowTitleBar(HWND hwnd, BOOL show, BOOL resize);
MRESULT EXPENTRY SetupDlgProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);
void UpdateDisplay(HWND hwnd);
void ResizeWindow(HWND hwnd);
MRESULT EXPENTRY AboutProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);

