/* This REXX script creates folder and objects for DFSee on the desktop */
/* Script must reside in the DFSee (ecs)BIN folder from there it should */
/* be  started from a commandline, or by clicking its icon in the WPS   */
/*                                                                      */
/* 03-15-2006, Script has been created by Karl Steinsky (Germany).      */
/* 07-20-2013, Modified folder name, contents to match WPI script;      */
/*             added conditional creation of PDF shadows when installed */
/*             Lewis Rosenthal (USA).                                   */
/* 07-21-2013, Created sub-folders for Docs and Samples; created        */
/*             objects for txt files and sample scripts                 */
/*             Lewis Rosenthal (USA).                                   */
/* 03-15-2014, Minor textual updates, integrated into release 11.7      */
/*             Fix for 'chaining attempted' errors and open objects     */
/*             Jan van Wijk                                             */
/* 07-08-2017, Update for new BROWSE-IMZ and HEX-EDIT release 14.7      */
/*             Jan van Wijk                                             */
/* 11-11-2020, Update for new DFSee FORUM URL at groups.io    16.7      */
/*             Jan van Wijk                                             */

"cls"

say;say " DFSeeOS2 WP-Object Creation.";say

/* - - - - - init RexxUtil - - - - - */

if rxfuncquery('SysLoadFuncs') then do
 call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
 call SysLoadFuncs
end

/* - - - - - Get install directory - - - - - */
InstDir = directory()
DocDir = directory('..\doc')
SamDir = directory('..\samples')

Call CreateObjects
Exit

/* - - - - - Procedure to check for additional files - - - - - */
FileExists: procedure
    Parse Arg Filename
    Call SysFileTree Filename, filelist, 'F'
    IF filelist.0 = 1 THEN
        rc = 1
    ELSE
        rc = 0
    RETURN rc

/* - - - - - object creation - - - - - */
CreateObjects:
say " Creating WPS objects..."

/* - - - - - folders - - - - - */
Call SysCreateObject 'WPFolder', 'DFSee',
   '<WP_DESKTOP>', 'OBJECTID=<DFSEE_FOLDER>;ICONFILE='||InstDir||'\dfsclose.ico;ICONNFILE=1,'||InstDir||'\dfsopen.ico;BACKGROUND='||InstDir||'\backdfs.bmp,T,1,I,DEFAULT', 'UPDATE'
Call SysCreateObject 'WPFolder', 'DFSee Docs',
   '<DFSEE_FOLDER>', 'OBJECTID=<DFSEE_DOCS_FOLDER>;BACKGROUND='||InstDir||'\backdfs.bmp,T,1,I,DEFAULT', 'UPDATE'
Call SysCreateObject 'WPShadow', 'Samples',
   '<DFSEE_FOLDER>', 'OBJECTID=<DFSEE_SAMPLES_FOLDER>;SHADOWID='SamDir, 'UPDATE'

/* - - - - - programs - - - - - */
Call SysCreateObject 'WPProgram', 'DFSOS2',
   '<DFSEE_FOLDER>', 'OBJECTID=<DFSEE_OS2EXE>;EXENAME=CMD.EXE;STARTUPDIR='||InstDir||';PROGTYPE=WINDOWABLEVIO;PARAMETERS=/c '||InstDir||'\DFSOS2.exe;ICONFILE='||InstDir||'\dfsee.ICO;', 'REPLACE'
Call SysCreateObject 'WPProgram', 'DFSee^Interactive',
   '<DFSEE_FOLDER>', 'OBJECTID=<DFSEE_INTERACTIVE>;EXENAME='||InstDir||'\DFSEE.CMD;STARTUPDIR='||InstDir||';PROGTYPE=WINDOWABLEVIO;ICONFILE='||InstDir||'\dfseeblk.ico;', 'REPLACE'
Call SysCreateObject 'WPProgram', 'DFSee^Large Window',
   '<DFSEE_FOLDER>', 'OBJECTID=<DFSEE_LARGEWINDOW>;EXENAME='||InstDir||'\DFSEE.CMD;STARTUPDIR='||InstDir||';PARAMETERS=92 39;PROGTYPE=WINDOWABLEVIO;ICONFILE='||InstDir||'\dfseewht.ico;', 'REPLACE'
Call SysCreateObject 'WPProgram', 'DFSee^Huge Window',
   '<DFSEE_FOLDER>', 'OBJECTID=<DFSEE_HUGEWINDOW>;EXENAME='||InstDir||'\DFSEE.CMD;STARTUPDIR='||InstDir||';PARAMETERS=128 44;PROGTYPE=WINDOWABLEVIO;ICONFILE='||InstDir||'\dfseewht.ico;', 'REPLACE'
Call SysCreateObject 'WPProgram', 'Browse IMZ^imagefile',
   '<DFSEE_FOLDER>', 'OBJECTID=<DFSEE_BROWSEIMZ>;EXENAME='||InstDir||'\DFSEE.CMD;STARTUPDIR='||InstDir||';PARAMETERS=92 39 -d- -l- imz;PROGTYPE=WINDOWABLEVIO;ICONFILE='||InstDir||'\dfseeblk.ico;', 'REPLACE'
Call SysCreateObject 'WPProgram', 'HEX edit^binary file',
   '<DFSEE_FOLDER>', 'OBJECTID=<DFSEE_HEXEDIT>;EXENAME='||InstDir||'\DFSEE.CMD;STARTUPDIR='||InstDir||';PARAMETERS=92 39 -d- -l- -w -Q edit -dir -screen;PROGTYPE=WINDOWABLEVIO;ICONFILE='||InstDir||'\dfseeblk.ico;', 'REPLACE'
Call SysCreateObject 'WPProgram', 'DFSdisk^Analysis',
   '<DFSEE_FOLDER>', 'OBJECTID=<DFSEE_DFSDISK>;EXENAME='||InstDir||'\DFSDISK.CMD;STARTUPDIR='||InstDir||';PARAMETERS=[Disk number, or * for ALL disks];PROGTYPE=WINDOWABLEVIO;ICONFILE='||InstDir||'\dfseelog.ico;', 'REPLACE'
Call SysCreateObject 'WPProgram', 'Run a DFSee^(recovery) script',
   '<DFSEE_FOLDER>', 'OBJECTID=<DFSEE_RUNSCRIPT>;EXENAME='||InstDir||'\DFSOS2.exe;STARTUPDIR='||InstDir||';PARAMETERS=run;PROGTYPE=WINDOWABLEVIO;ICONFILE='||InstDir||'\dfsinfo.ico;', 'REPLACE'
Call SysCreateObject 'WPProgram', 'DFScheck^Partitions',
   '<DFSEE_FOLDER>', 'OBJECTID=<DFSEE_DFSCHECK>;EXENAME='||InstDir||'\DFSCHECK.CMD;STARTUPDIR='||InstDir||';PARAMETERS=[Partition-ID, or * for ALL];NOAUTOCLOSE=YES;PROGTYPE=WINDOWABLEVIO;ICONFILE='||In stDir||'\dfsdisk.ico;', 'REPLACE'
Call SysCreateObject 'WPProgram', 'Image a^Partition',
   '<DFSEE_FOLDER>', 'OBJECTID=<DFSEE_IMAGEPART>;EXENAME='||InstDir||'\DFSOS2.exe;STARTUPDIR='||InstDir||';PARAMETERS=image -P;PROGTYPE=WINDOWABLEVIO;ICONFILE='||InstDir||'\drives.ico;', 'REPLACE'
Call SysCreateObject 'WPProgram', 'Restore^Partition',
   '<DFSEE_FOLDER>', 'OBJECTID=<DFSEE_RESTOREPART>;EXENAME='||InstDir||'\DFSOS2.exe;STARTUPDIR='||InstDir||';PARAMETERS=restore -P;PROGTYPE=WINDOWABLEVIO;ICONFILE='||InstDir||'\drives.ico;', 'REPLACE'
Call SysCreateObject 'WPProgram', 'Clone^Partition',
   '<DFSEE_FOLDER>', 'OBJECTID=<DFSEE_CLONEPART>;EXENAME='||InstDir||'\DFSOS2.exe;STARTUPDIR='||InstDir||';PARAMETERS=clone -p -P;PROGTYPE=WINDOWABLEVIO;ICONFILE='||InstDir||'\Hardisk.ico;', 'REPLACE'
Call SysCreateObject 'WPProgram', 'Clone^Disk',
   '<DFSEE_FOLDER>', 'OBJECTID=<DFSEE_CLONEDISK>;EXENAME='||InstDir||'\DFSOS2.exe;STARTUPDIR='||InstDir||';PARAMETERS=clone -d -D;PROGTYPE=WINDOWABLEVIO;ICONFILE='||InstDir||'\Hardisk.ico;', 'REPLACE'
Call SysCreateObject 'WPProgram', 'Create^Bootable^Diskette',
   '<DFSEE_FOLDER>', 'OBJECTID=<DFSEE_BOOTDSK>;EXENAME='||InstDir||'\Bootdsk.exe;NOAUTOCLOSE=YES;PROGTYPE=WINDOWABLEVIO;ICONFILE='||InstDir||'\bootdsk.ico;', 'REPLACE'

/* - - - - - urls - - - - - */
Call SysCreateObject 'WPUrl', 'Fsys Software^Homepage',
   '<DFSEE_FOLDER>', 'OBJECTID=<DFSEEHome>;URL=http://www.dfsee.com', 'REPLACE'
Call SysCreateObject 'WPUrl', 'DFSee^Support^Yahoo Group',
   '<DFSEE_FOLDER>', 'OBJECTID=<DFSEESupport>;URL=http://www.yahoo.com/group/dfsee-support', 'REPLACE'

/* - - - - - Allow some time for the objects to be 'stable' ? JvW ? */
Call SysSleep .1

/* - - - - - txt doc shadows - - - - - */
if FileExists(DocDir'\dfscmds.txt') then do
    Address CMD '@Call' InstDir || '\setlnea.cmd' DocDir'\dfscmds.txt' 'DFSee Command Reference' '> nul'
    Call SysCreateObject 'WPShadow', 'DFSee Command Reference', '<DFSEE_DOCS_FOLDER>', 'OBJECTID=<DFSEE_CMDS_TXT>;SHADOWID='||DocDir||'\dfscmds.txt', 'REPLACE'
end

if FileExists(DocDir'\dfscript.txt') then do
    Address CMD '@Call' InstDir || '\setlnea.cmd' DocDir'\dfscript.txt' 'DFSee Scripting Reference' '>nul'
    Call SysCreateObject 'WPShadow', 'DFSee Scripting Reference', '<DFSEE_DOCS_FOLDER>', 'OBJECTID=<DFSEE_SCRIPT_TXT>;SHADOWID='||DocDir||'\dfscript.txt', 'REPLACE'
end

if FileExists(DocDir'\dfsdisk.txt') then do
    Address CMD '@Call' InstDir || '\setlnea.cmd' DocDir'\dfsdisk.txt' 'DFSDISK Introduction and Examples' '>nul'
    Call SysCreateObject 'WPShadow', 'DFSDISK Introduction and Examples', '<DFSEE_DOCS_FOLDER>', 'OBJECTID=<DFSEE_DISK_TXT>;SHADOWID='||DocDir||'\dfsdisk.txt', 'REPLACE'
end

if FileExists(DocDir'\dfsdlls.txt') then do
    Address CMD '@Call' InstDir || '\setlnea.cmd' DocDir'\dfsdlls.txt' 'Overview of OS/2 DLL requirements for DFSee' '>nul'
    Call SysCreateObject 'WPShadow', 'Overview of OS/2 DLL requirements for DFSee', '<DFSEE_DOCS_FOLDER>', 'OBJECTID=<DFSEE_DLLS_TXT>;SHADOWID='||DocDir||'\dfsdlls.txt', 'REPLACE'
end

if FileExists(DocDir'\dfsee.txt') then do
    Address CMD '@Call' InstDir || '\setlnea.cmd' DocDir'\dfsee.txt' 'DFSee Overview' '>nul'
    Call SysCreateObject 'WPShadow', 'DFSee Overview', '<DFSEE_DOCS_FOLDER>', 'OBJECTID=<DFSEE_OVERVIEW_TXT>;SHADOWID='||DocDir||'\dfsee.txt', 'REPLACE'
end

if FileExists(DocDir'\dfsext.txt') then do
    Address CMD '@Call' InstDir || '\setlnea.cmd' DocDir'\dfsext.txt' 'DFSee EXT2/3 Specific Commands' '>nul'
    Call SysCreateObject 'WPShadow', 'DFSee EXT2/3 Specific Commands', '<DFSEE_DOCS_FOLDER>', 'OBJECTID=<DFSEE_EXT_TXT>;SHADOWID='||DocDir||'\dfsext.txt', 'REPLACE'
end

if FileExists(DocDir'\dfsfat.txt') then do
    Address CMD '@Call' InstDir || '\setlnea.cmd' DocDir'\dfsfat.txt' 'DFSee FAT Specific Commands' '>nul'
    Call SysCreateObject 'WPShadow', 'DFSee FAT Specific Commands', '<DFSEE_DOCS_FOLDER>', 'OBJECTID=<DFSEE_FAT_TXT>;SHADOWID='||DocDir||'\dfsfat.txt', 'REPLACE'
end

if FileExists(DocDir'\dfsfdisk.txt') then do
    Address CMD '@Call' InstDir || '\setlnea.cmd' DocDir'\dfsfdisk.txt' 'DFSee FDISK Specific Commands' '>nul'
    Call SysCreateObject 'WPShadow', 'DFSee FDISK Specific Commands', '<DFSEE_DOCS_FOLDER>', 'OBJECTID=<DFSEE_FDISK_TXT>;SHADOWID='||DocDir||'\dfsfdisk.txt', 'REPLACE'
end

if FileExists(DocDir'\dfsfdusb.txt') then do
    Address CMD '@Call' InstDir || '\setlnea.cmd' DocDir'\dfsfdusb.txt' 'DFSee usage with USB-attached storage' '>nul'
    Call SysCreateObject 'WPShadow', 'DFSee usage with USB-attached storage', '<DFSEE_DOCS_FOLDER>', 'OBJECTID=<DFSEE_USB_TXT>;SHADOWID='||DocDir||'\dfsfdusb.txt', 'REPLACE'
end

if FileExists(DocDir'\dfshfs.txt') then do
    Address CMD '@Call' InstDir || '\setlnea.cmd' DocDir'\dfshfs.txt' 'DFSee HFS Specific Commands' '>nul'
    Call SysCreateObject 'WPShadow', 'DFSee HFS Specific Commands', '<DFSEE_DOCS_FOLDER>', 'OBJECTID=<DFSEE_HFS_TXT>;SHADOWID='||DocDir||'\dfshfs.txt', 'REPLACE'
end

if FileExists(DocDir'\dfshist.txt') then do
    Address CMD '@Call' InstDir || '\setlnea.cmd' DocDir'\dfshist.txt' 'DFSee History/Changelog' '>nul'
    Call SysCreateObject 'WPShadow', 'DFSee History/Changelog', '<DFSEE_DOCS_FOLDER>', 'OBJECTID=<DFSEE_HISTORY_TXT>;SHADOWID='||DocDir||'\dfshist.txt', 'REPLACE'
end

if FileExists(DocDir'\dfshowto.txt') then do
    Address CMD '@Call' InstDir || '\setlnea.cmd' DocDir'\dfshowto.txt' 'DFSee Examples' '>nul'
    Call SysCreateObject 'WPShadow', 'DFSee Examples', '<DFSEE_DOCS_FOLDER>', 'OBJECTID=<DFSEE_HOWTO_TXT>;SHADOWID='||DocDir||'\dfshowto.txt', 'REPLACE'
end

if FileExists(DocDir'\dfshpfs.txt') then do
    Address CMD '@Call' InstDir || '\setlnea.cmd' DocDir'\dfshpfs.txt' 'DFSee HPFS Specific Commands' '>nul'
    Call SysCreateObject 'WPShadow', 'DFSee HPFS Specific Commands', '<DFSEE_DOCS_FOLDER>', 'OBJECTID=<DFSEE_HPFS_TXT>;SHADOWID='||DocDir||'\dfshpfs.txt', 'REPLACE'
end

if FileExists(DocDir'\dfsinst.txt') then do
    Address CMD '@Call' InstDir || '\setlnea.cmd' DocDir'\dfsinst.txt' 'DFSee Installation' '>nul'
    Call SysCreateObject 'WPShadow', 'DFSee Installation', '<DFSEE_DOCS_FOLDER>', 'OBJECTID=<DFSEE_INST_TXT>;SHADOWID='||DocDir||'\dfsinst.txt', 'REPLACE'
end

if FileExists(DocDir'\dfsjfs.txt') then do
    Address CMD '@Call' InstDir || '\setlnea.cmd' DocDir'\dfsjfs.txt' 'DFSee JFS Specific Commands' '>nul'
    Call SysCreateObject 'WPShadow', 'DFSee JFS Specific Commands', '<DFSEE_DOCS_FOLDER>', 'OBJECTID=<DFSEE_JFS_TXT>;SHADOWID='||DocDir||'\dfsjfs.txt', 'REPLACE'
end

if FileExists(DocDir'\dfsntfs.txt') then do
    Address CMD '@Call' InstDir || '\setlnea.cmd' DocDir'\dfsntfs.txt' 'DFSee NTFS Specific Commands' '>nul'
    Call SysCreateObject 'WPShadow', 'DFSee NTFS Specific Commands', '<DFSEE_DOCS_FOLDER>', 'OBJECTID=<DFSEE_NTFS_TXT>;SHADOWID='||DocDir||'\dfsntfs.txt', 'REPLACE'
end

if FileExists(DocDir'\dfspromo.txt') then do
    Address CMD '@Call' InstDir || '\setlnea.cmd' DocDir'\dfspromo.txt' 'DFSee Promo' '>nul'
    Call SysCreateObject 'WPShadow', 'DFSee Promo', '<DFSEE_DOCS_FOLDER>', 'OBJECTID=<DFSEE_PROMO_TXT>;SHADOWID='||DocDir||'\dfspromo.txt', 'REPLACE'
end

if FileExists(DocDir'\dfsrsr.txt') then do
    Address CMD '@Call' InstDir || '\setlnea.cmd' DocDir'\dfsrsr.txt' 'DFSee REISER Specific Commands' '>nul'
    Call SysCreateObject 'WPShadow', 'DFSee REISER Specific Commands', '<DFSEE_DOCS_FOLDER>', 'OBJECTID=<DFSEE_REISER_TXT>;SHADOWID='||DocDir||'\dfsrsr.txt', 'REPLACE'
end

if FileExists(DocDir'\dfsterms.txt') then do
    Address CMD '@Call' InstDir || '\setlnea.cmd' DocDir'\dfsterms.txt' 'DFSee Terminology' '>nul'
    Call SysCreateObject 'WPShadow', 'DFSee Terminology', '<DFSEE_DOCS_FOLDER>', 'OBJECTID=<DFSEE_TERMS_TXT>;SHADOWID='||DocDir||'\dfsterms.txt', 'REPLACE'
end

if FileExists(DocDir'\dfsusb32.txt') then do
    Address CMD '@Call' InstDir || '\setlnea.cmd' DocDir'\dfsusb32.txt' 'DFSee Bootable USB Stick' '>nul'
    Call SysCreateObject 'WPShadow', 'DFSee Bootable USB Stick', '<DFSEE_DOCS_FOLDER>', 'OBJECTID=<DFSEE_USBSTICK_TXT>;SHADOWID='||DocDir||'\dfsusb32.txt', 'REPLACE'
end

if FileExists(DocDir'\dfsxfs.txt') then do
    Address CMD '@Call' InstDir || '\setlnea.cmd' DocDir'\dfsxfs.txt' 'DFSee XFS Specific Commands' '>nul'
    Call SysCreateObject 'WPShadow', 'DFSee XFS Specific Commands', '<DFSEE_DOCS_FOLDER>', 'OBJECTID=<DFSEE_XFS_TXT>;SHADOWID='||DocDir||'\dfsxfs.txt', 'REPLACE'
end

if FileExists(DocDir'\dfsyntax.txt') then do
    Address CMD '@Call' InstDir || '\setlnea.cmd' DocDir'\dfsyntax.txt' 'DFSee Command Syntax' '>nul'
    Call SysCreateObject 'WPShadow', 'DFSee Command Syntax', '<DFSEE_DOCS_FOLDER>', 'OBJECTID=<DFSEE_SYNTAX_TXT>;SHADOWID='||DocDir||'\dfsyntax.txt', 'REPLACE'
end

/* - - - - - pdf shadows - - - - - */
if FileExists(DocDir'\dfseehow.pdf') then do
    Address CMD '@Call' InstDir || '\setlnea.cmd' DocDir'\dfseehow.pdf' 'DFSee HOWTO usage and tips' '>nul'
    Call SysCreateObject 'WPShadow', 'DFSee HOWTO usage and tips', '<DFSEE_DOCS_FOLDER>', 'OBJECTID=<DFSEE_HOWTO>;SHADOWID='||DocDir||'\dfseehow.pdf', 'REPLACE'
end

if FileExists(DocDir'\dfseenew.pdf') then do
    Address CMD '@Call' InstDir || '\setlnea.cmd' DocDir'\dfseenew.pdf' 'DFSee new featuress' '>nul'
    Call SysCreateObject 'WPShadow', 'DFSee new featuress', '<DFSEE_DOCS_FOLDER>', 'OBJECTID=<DFSEE_DFSEENEW>;SHADOWID='||DocDir||'\dfseenew.pdf', 'REPLACE'
end

if FileExists(DocDir'\dfseecon.pdf') then do
    Address CMD '@Call' InstDir || '\setlnea.cmd' DocDir'\dfseecon.pdf' 'DFSee concepts and internals' '>nul'
    Call SysCreateObject 'WPShadow', 'DFSee concepts and internals', '<DFSEE_DOCS_FOLDER>', 'OBJECTID=<DFSEE_CON>;SHADOWID='||DocDir||'\dfseecon.pdf', 'REPLACE'
end

if FileExists(DocDir'\pcpartit.pdf') then do
    Address CMD '@Call' InstDir || '\setlnea.cmd' DocDir'\pcpartit.pdf' 'Partitioning disk layout' '>nul'
    Call SysCreateObject 'WPShadow', 'Partitioning disk layout', '<DFSEE_DOCS_FOLDER>', 'OBJECTID=<DFSEE_PCPARTIT>;SHADOWID='||DocDir||'\pcpartit.pdf', 'REPLACE'
end

if FileExists(DocDir'\fsystems.pdf') then do
    Address CMD '@Call' InstDir || '\setlnea.cmd' DocDir'\fsystems.pdf' 'Filesystems disk structures' '>nul'
    Call SysCreateObject 'WPShadow', 'Filesystems disk structures', '<DFSEE_DOCS_FOLDER>', 'OBJECTID=<DFSEE_FSYSTEMS>;SHADOWID='||DocDir||'\fsystems.pdf', 'REPLACE'
end

if FileExists(DocDir'\txscript.pdf') then do
    Address CMD '@Call' InstDir || '\setlnea.cmd' DocDir'\txscript.pdf' 'TX advanced scripting' '> nul'
    Call SysCreateObject 'WPShadow', 'TX advanced scripting', '<DFSEE_DOCS_FOLDER>', 'OBJECTID=<DFSEE_TXSCRIPT>;SHADOWID='||DocDir||'\txscript.pdf', 'REPLACE'
end

/* - - - - - cleanup - - - - - */
call directory InstDir
say "...done."
say
say "Installation of the DFSee desktop objects done. Hit ENTER to continue."
pull dummy
call SysOpenObject "<DFSEE_FOLDER>", 0, "TRUE"

return
