@echo off
rem 30-04-2002 JvW Initial version
rem 24-07-2007 JvW Added 'raw' as optional 3rd parameter in creating an image
rem 16-08-2016 JvW Remove the Windows/DOS code, CMD is used for OS/2 only
echo.

if "%0"=="IMGETEST"     echo on
if "%0"=="imgetest"     echo on

set dfsexe=dfsos2.exe

if "%1" == "?"   goto usage
if "%1" == "/?"  goto usage
if "%1" == "-?"  goto usage

%dfsexe% -b -q query RValid
if not errorlevel 1 goto work
echo.
echo NOTE: Your DFSee version is not properly registred, this will cause
echo       some extra delays and reminder messages to be displayed  ...
echo.

:work
set volume=A:
if "%2" == "*"   goto auto
if "%2" == "."   goto auto
if "%2" == ""    goto auto
set volume=%2
:auto
set imgcmd=restore
set imfile=%1
if exist %1      goto checkvol
if exist %1.img  goto checkvol
if exist %1.imz  goto checkvol

if "%2" == ""    goto autosim

:trysim
set volume=%1
set imfile=%2
:autosim
set imgcmd=image

:checkvol
if "%volume%" == "a:" goto validvol
if "%volume%" == "b:" goto validvol
if "%volume%" == "c:" goto validvol
if "%volume%" == "d:" goto validvol
if "%volume%" == "e:" goto validvol
if "%volume%" == "f:" goto validvol
if "%volume%" == "g:" goto validvol
if "%volume%" == "h:" goto validvol
if "%volume%" == "i:" goto validvol
if "%volume%" == "j:" goto validvol
if "%volume%" == "k:" goto validvol
if "%volume%" == "l:" goto validvol
if "%volume%" == "m:" goto validvol
if "%volume%" == "n:" goto validvol
if "%volume%" == "o:" goto validvol
if "%volume%" == "p:" goto validvol
if "%volume%" == "q:" goto validvol
if "%volume%" == "r:" goto validvol
if "%volume%" == "s:" goto validvol
if "%volume%" == "t:" goto validvol
if "%volume%" == "u:" goto validvol
if "%volume%" == "v:" goto validvol
if "%volume%" == "w:" goto validvol
if "%volume%" == "x:" goto validvol
if "%volume%" == "y:" goto validvol
if "%volume%" == "z:" goto validvol
if "%volume%" == "A:" goto validvol
if "%volume%" == "B:" goto validvol
if "%volume%" == "C:" goto validvol
if "%volume%" == "D:" goto validvol
if "%volume%" == "E:" goto validvol
if "%volume%" == "F:" goto validvol
if "%volume%" == "G:" goto validvol
if "%volume%" == "H:" goto validvol
if "%volume%" == "I:" goto validvol
if "%volume%" == "J:" goto validvol
if "%volume%" == "K:" goto validvol
if "%volume%" == "L:" goto validvol
if "%volume%" == "M:" goto validvol
if "%volume%" == "N:" goto validvol
if "%volume%" == "O:" goto validvol
if "%volume%" == "P:" goto validvol
if "%volume%" == "Q:" goto validvol
if "%volume%" == "R:" goto validvol
if "%volume%" == "S:" goto validvol
if "%volume%" == "T:" goto validvol
if "%volume%" == "U:" goto validvol
if "%volume%" == "V:" goto validvol
if "%volume%" == "W:" goto validvol
if "%volume%" == "X:" goto validvol
if "%volume%" == "Y:" goto validvol
if "%volume%" == "Z:" goto validvol
echo.

if %imgcmd% == image goto badparam
if not "%2" == ""  goto trysim

echo The specified parameter %volume% is not a valid driveletter! Use A: .. Z:
goto end

:badparam
echo The specified parameter %volume% is not a valid driveletter,
echo and it is not an existing imagefile either!
goto usage2

:validvol
echo.
if %imgcmd% == restore goto wrimcmd


if "%3" == "raw"  goto rawsim
echo Create an image of volume %volume% to compressed imagefile %imfile%
set compress=-zip
goto doimage

:rawsim
echo Create an image of volume %volume% to RAW imagefile %imfile%
set compress=

:doimage
echo.
%dfsexe% %4 %5 %6 %7 %8 %9 vol %volume%#image %compress% %imfile%#q
goto end

:wrimcmd
echo Restore imagefile %imfile% to volume %volume%
echo.
%dfsexe% %3 %4 %5 %6 %7 %8 %9 vol %volume%#restore %imfile%#q
goto end

:usage
echo Create a compressed or RAW imagefile from diskette (or any other driveletter)
echo or (uncompress and) write an imagefile back to diskette     (or other volume)
:usage2
echo.
echo Usage:  %0 imagefile X: [raw]  /  X: imagefile  /  imagefile [switches]
echo.
echo         imagefile =  Name of the imagefile, default extention is .IMZ
echo.                     for compressed, and .IMG for RAW imagefiles
echo.
echo.                     When only an imagefile is specified (no 2nd param)
echo.                     and the file exists, it will be restored to the
echo                      diskette in the A: drive, otherwise the imagefile
echo                      will be created as an image of the diskette in A:
echo.
echo         raw       =  Create an uncompressed imagefile  (RAW)
echo.
echo         X:        =  Drive-letter of the volume to use (often diskette)
echo.
echo         switches  =  Any valid DFSee switch  (as shown by DFSxx.exe -?)
echo.
echo                      Useful switches for imaging are:
echo                      -l:logfile  = create a logfile
echo                      -b          = batch option, no confirmations
echo                      -w          = use windowed user interface
echo Examples:
echo  %0 A: floppy      Create imagefile 'floppy.imz' from diskette in A:
echo  %0 A: floppy -b   Create 'floppy.imz' from A:, no confirmations
echo  %0 A: floppy raw  Create 'floppy.img' from A:, as a RAW imagefile
echo  %0 floppy A:      Restore imagefile 'floppy.imz' to diskette in A:
echo  %0 floppy         Restore imagefile 'floppy.imz' to diskette in A:
echo                          file must exist, otherwise it is created from A:
:end
